/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader;

import com.github.kiulian.downloader.downloader.proxy.ProxyAuthenticator;
import com.github.kiulian.downloader.downloader.proxy.ProxyCredentials;
import com.github.kiulian.downloader.downloader.proxy.ProxyCredentialsImpl;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class Config {
    private static final ThreadFactory threadFactory = new ThreadFactory(){
        private static final String NAME_PREFIX = "yt-downloader-";
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable runnable) {
            SecurityManager securityManager = System.getSecurityManager();
            ThreadGroup threadGroup = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
            Thread thread = new Thread(threadGroup, runnable, NAME_PREFIX + this.threadNumber.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    };
    private static final String DEFAULT_USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36";
    private static final String DEFAULT_ACCEPT_LANG = "en-US,en;";
    private static final int DEFAULT_RETRY_ON_FAILURE = 0;
    private Map<String, String> headers;
    private int maxRetries;
    private boolean compressionEnabled;
    private ExecutorService executorService;
    private Proxy proxy;

    private Config(Builder builder) {
        this.headers = builder.headers;
        this.maxRetries = builder.maxRetries;
        this.compressionEnabled = builder.compressionEnabled;
        this.executorService = builder.executorService;
        this.proxy = builder.proxy;
    }

    private Config() {
        this.headers = new HashMap<String, String>();
        this.maxRetries = 0;
        this.compressionEnabled = true;
        this.executorService = Executors.newCachedThreadPool(threadFactory);
        this.setHeader("User-Agent", DEFAULT_USER_AGENT);
        this.setHeader("Accept-language", DEFAULT_ACCEPT_LANG);
    }

    static Config buildDefault() {
        return new Config();
    }

    public void setMaxRetries(int n) {
        this.maxRetries = n;
    }

    public void setCompressionEnabled(boolean bl) {
        this.compressionEnabled = bl;
    }

    public void setHeader(String string, String string2) {
        this.headers.put(string, string2);
    }

    public void setProxy(String string, int n) {
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string, n));
    }

    public void setProxy(String string, int n, String string2, String string3) {
        if (ProxyAuthenticator.getDefault() == null) {
            ProxyAuthenticator.setDefault(new ProxyAuthenticator(new ProxyCredentialsImpl()));
        }
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string, n));
        ProxyAuthenticator.addAuthentication(string, n, string2, string3);
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setProxyAuthenticator(ProxyCredentials proxyCredentials) {
        ProxyAuthenticator.setDefault(new ProxyAuthenticator(proxyCredentials));
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public static class Builder {
        private Map<String, String> headers = new HashMap<String, String>();
        private int maxRetries = 0;
        private boolean compressionEnabled = true;
        private ExecutorService executorService;
        private Proxy proxy;

        public Builder maxRetries(int n) {
            this.maxRetries = n;
            return this;
        }

        public Builder enableCompression(boolean bl) {
            this.compressionEnabled = bl;
            return this;
        }

        public Builder header(String string, String string2) {
            this.headers.put(string, string2);
            return this;
        }

        public Builder proxy(String string, int n) {
            this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string, n));
            return this;
        }

        public Builder proxy(String string, int n, String string2, String string3) {
            if (ProxyAuthenticator.getDefault() == null) {
                ProxyAuthenticator.setDefault(new ProxyAuthenticator(new ProxyCredentialsImpl()));
            }
            this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string, n));
            ProxyAuthenticator.addAuthentication(string, n, string2, string3);
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder proxyCredentialsManager(ProxyCredentials proxyCredentials) {
            ProxyAuthenticator.setDefault(new ProxyAuthenticator(proxyCredentials));
            return this;
        }

        public Config build() {
            if (this.executorService == null) {
                this.executorService = Executors.newCachedThreadPool(threadFactory);
            }
            return new Config(this);
        }
    }
}

