/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager;

import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.TmmOsUtils;

public final class Globals {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("tmm.debug", "false"));
    private static final boolean READ_ONLY;
    public static final String CONTENT_FOLDER;
    public static final String DATA_FOLDER;
    public static final String CACHE_FOLDER;
    public static final String BACKUP_FOLDER;
    public static final String LOG_FOLDER;

    private Globals() {
        throw new IllegalAccessError();
    }

    private static boolean isTmmDirWritable() {
        try {
            RandomAccessFile f = new RandomAccessFile("access.test", "rw");
            f.close();
            Files.deleteIfExists(Paths.get("access.test", new String[0]));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isDebug() {
        return DEBUG;
    }

    public static boolean isReadOnly() {
        return READ_ONLY;
    }

    public static boolean isDocker() {
        return Files.exists(Paths.get("/.dockerenv", new String[0]), new LinkOption[0]);
    }

    public static boolean isRunningJavaWebStart() {
        boolean hasJNLP = false;
        try {
            Class.forName("javax.jnlp.ServiceManager");
            hasJNLP = true;
        }
        catch (ClassNotFoundException ex) {
            hasJNLP = false;
        }
        return hasJNLP;
    }

    public static boolean isRunningWebSwing() {
        return System.getProperty("webswing.classPath") != null;
    }

    public static boolean isSelfUpdatable() {
        if (Boolean.parseBoolean(System.getProperty("tmm.noupdate"))) {
            return false;
        }
        if (SystemUtils.IS_OS_MAC) {
            return false;
        }
        if (Globals.isDocker() || Files.exists(Paths.get(".managed", new String[0]), new LinkOption[0])) {
            return false;
        }
        return !Globals.isReadOnly();
    }

    public static boolean canCheckForUpdates() {
        if (ReleaseInfo.isGitBuild()) {
            return false;
        }
        return !Boolean.parseBoolean(System.getProperty("tmm.noupdate"));
    }

    static {
        String dataFolder = System.getProperty("tmm.datafolder");
        String cacheFolder = System.getProperty("tmm.cachefolder");
        String backupFolder = System.getProperty("tmm.backupfolder");
        String logFolder = System.getProperty("tmm.logfolder");
        READ_ONLY = !Globals.isTmmDirWritable();
        String contentFolder = System.getProperty("tmm.contentfolder");
        if (StringUtils.isBlank((CharSequence)contentFolder)) {
            contentFolder = Files.exists(Paths.get(".userdir", new String[0]), new LinkOption[0]) && Files.notExists(Paths.get("data", new String[0]), new LinkOption[0]) || Globals.isReadOnly() ? TmmOsUtils.getUserDir().toString() : ".";
        }
        CONTENT_FOLDER = Paths.get(contentFolder, new String[0]).toAbsolutePath().normalize().toString();
        DATA_FOLDER = StringUtils.isNotBlank((CharSequence)dataFolder) ? dataFolder : Paths.get(contentFolder, "data").toAbsolutePath().normalize().toString();
        CACHE_FOLDER = StringUtils.isNotBlank((CharSequence)cacheFolder) ? cacheFolder : Paths.get(contentFolder, "cache").toAbsolutePath().normalize().toString();
        BACKUP_FOLDER = StringUtils.isNotBlank((CharSequence)backupFolder) ? backupFolder : Paths.get(contentFolder, "backup").toAbsolutePath().normalize().toString();
        LOG_FOLDER = StringUtils.isNotBlank((CharSequence)logFolder) ? logFolder : Paths.get(contentFolder, "logs").toAbsolutePath().normalize().toString();
    }
}

