/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ReleaseInfo {
    private static String version;
    private static String humanVersion;
    private static String build;
    private static String buildDate;

    private ReleaseInfo() {
    }

    public static String getVersion() {
        String v = version;
        if (v.isEmpty()) {
            v = ReleaseInfo.isNightly() ? "NIGHTLY" : (ReleaseInfo.isPreRelease() ? "PRE-RELEASE" : "GIT");
        }
        return v;
    }

    public static String getBuild() {
        return build;
    }

    public static String getHumanVersion() {
        return humanVersion;
    }

    public static String getBuildDate() {
        return buildDate;
    }

    public static boolean isNightly() {
        return ReleaseInfo.getBuild().equalsIgnoreCase("nightly") || humanVersion.toUpperCase(Locale.ROOT).contains("NIGHTLY");
    }

    public static boolean isPreRelease() {
        return ReleaseInfo.getBuild().equalsIgnoreCase("prerelease") || humanVersion.toUpperCase(Locale.ROOT).contains("PRERELEASE");
    }

    public static boolean isGitBuild() {
        return ReleaseInfo.getBuild().equalsIgnoreCase("git") || humanVersion.toUpperCase(Locale.ROOT).contains("SNAPSHOT");
    }

    public static boolean isReleaseBuild() {
        return !ReleaseInfo.isNightly() && !ReleaseInfo.isPreRelease() && !ReleaseInfo.isGitBuild();
    }

    public static String getRealVersion() {
        Object v = ReleaseInfo.getManifestEntry(ReleaseInfo.class, "Implementation-Version");
        if (((String)v).isEmpty()) {
            v = ReleaseInfo.getVersion() + " - GIT";
        }
        v = ((String)v).replace("-SNAPSHOT", "");
        if (ReleaseInfo.isNightly()) {
            v = (String)v + " - NIGHTLY";
        } else if (ReleaseInfo.isPreRelease()) {
            v = (String)v + " - PRE-RELEASE";
        }
        return v;
    }

    public static String getRealBuildDate() {
        String b = ReleaseInfo.getManifestEntry(ReleaseInfo.class, "Build-Date");
        if (b.isEmpty()) {
            b = ReleaseInfo.getBuildDate();
        }
        return b;
    }

    public static Manifest getManifest(Class<?> c) {
        Manifest mf = null;
        try {
            String classname = "/" + c.getName().replaceAll("\\.", "/") + ".class";
            URL jarURL = c.getResource(classname);
            if (jarURL.getProtocol().equals("jar")) {
                JarURLConnection jurlConn = (JarURLConnection)jarURL.openConnection();
                mf = jurlConn.getManifest();
            } else if (jarURL.getProtocol().equals("file")) {
                String basepath = jarURL.getPath().substring(0, jarURL.getPath().indexOf(classname));
                mf = new Manifest(Files.newInputStream(Paths.get(basepath, "/META-INF/MANIFEST.MF"), new OpenOption[0]));
            }
        }
        catch (Exception e) {
            mf = null;
        }
        return mf;
    }

    private static String getManifestEntry(Class c, String entry) {
        String s = "";
        try {
            Manifest mf = ReleaseInfo.getManifest(c);
            if (mf != null) {
                Attributes attr = mf.getMainAttributes();
                s = attr.getValue(entry);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    static {
        try (InputStream inputStream = Files.newInputStream(Paths.get("version", new String[0]), new OpenOption[0]);){
            Properties releaseInfoProp = new Properties();
            releaseInfoProp.load(inputStream);
            version = releaseInfoProp.getProperty("version");
            humanVersion = releaseInfoProp.getProperty("human.version");
            build = releaseInfoProp.getProperty("build");
            buildDate = releaseInfoProp.getProperty("date");
        }
        catch (IOException e) {
            try (InputStream inputStream2 = Files.newInputStream(Paths.get("target/classes/eclipse.properties", new String[0]), new OpenOption[0]);){
                Properties releaseInfoProp = new Properties();
                releaseInfoProp.load(inputStream2);
                version = releaseInfoProp.getProperty("version");
                humanVersion = releaseInfoProp.getProperty("human.version");
                build = "git";
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                buildDate = formatter.format((Object)new Date());
            }
            catch (IOException e2) {
                version = "";
                humanVersion = "";
                build = "git";
                buildDate = "";
            }
        }
    }
}

