/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.filter.Filter;
import com.sun.jna.Platform;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Date;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.jdesktop.beansbinding.ELProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.Log4jBackstop;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.ThresholdLoggerFilter;
import org.tinymediamanager.TmmOsUtils;
import org.tinymediamanager.UpgradeTasks;
import org.tinymediamanager.cli.TinyMediaManagerCLI;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.TmmModuleManager;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.http.TmmHttpServer;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettingsDefaults;
import org.tinymediamanager.core.movie.MovieUpgradeTasks;
import org.tinymediamanager.core.movie.tasks.MovieUpdateDatasourceTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettingsDefaults;
import org.tinymediamanager.core.tvshow.TvShowUpgradeTasks;
import org.tinymediamanager.core.tvshow.tasks.TvShowUpdateDatasourceTask;
import org.tinymediamanager.license.License;
import org.tinymediamanager.scraper.MediaProviders;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.thirdparty.KodiRPC;
import org.tinymediamanager.thirdparty.upnp.Upnp;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmTaskbar;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.TmmUILogCollector;
import org.tinymediamanager.ui.dialogs.AboutDialog;
import org.tinymediamanager.ui.dialogs.MessageDialog;
import org.tinymediamanager.ui.dialogs.SettingsDialog;
import org.tinymediamanager.ui.dialogs.TmmSplashScreen;
import org.tinymediamanager.ui.dialogs.WhatsNewDialog;
import org.tinymediamanager.ui.images.LogoCircle;
import org.tinymediamanager.ui.wizard.TinyMediaManagerWizard;

public final class TinyMediaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TinyMediaManager.class);
    private TmmSplashScreen splashScreen = null;
    private final boolean headless = GraphicsEnvironment.isHeadless();
    private boolean newVersion = false;

    private TinyMediaManager() {
    }

    private void launch(String[] args) {
        Path license = Paths.get(Globals.DATA_FOLDER, "tmm.lic");
        if (Files.exists(license, new LinkOption[0])) {
            try {
                License.getInstance().setLicenseCode(Utils.readFileToString(license));
            }
            catch (Exception e) {
                LOGGER.debug("unable to decode license file - {}", (Object)e.getMessage());
            }
        }
        Locale.setDefault(Utils.getLocaleFromLanguage(Settings.getInstance().getLanguage()));
        this.newVersion = !Settings.getInstance().isCurrentVersion();
        this.printLogHeader();
        if (!this.headless) {
            EventQueue.invokeLater(() -> {
                try {
                    this.splashScreen = new TmmSplashScreen();
                    this.splashScreen.setVersion(ReleaseInfo.getHumanVersion());
                    this.splashScreen.setVisible(true);
                }
                catch (Exception e) {
                    LOGGER.error("could not initialize splash - {}", (Object)e.getMessage());
                }
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() {
                        try {
                            Thread.currentThread().setName("main");
                            TmmTaskbar.setImage(new LogoCircle(512).getImage());
                            TmmUIHelper.setLookAndFeel();
                            TmmUILogCollector.init();
                            TinyMediaManager.this.startup();
                            TinyMediaManager.this.updateProgress("splash.ui", 90);
                            SwingUtilities.invokeLater(() -> {
                                LocalDate validUntil;
                                TmmThreadPool task;
                                boolean wizardRun = false;
                                if (Settings.getInstance().isNewConfig()) {
                                    TinyMediaManagerWizard wizard = new TinyMediaManagerWizard();
                                    wizard.setLocationRelativeTo(null);
                                    wizard.setVisible(true);
                                    wizardRun = true;
                                }
                                TinyMediaManager.this.systemUiInit();
                                MainWindow window = MainWindow.getInstance();
                                TinyMediaManager.this.updateProgress("finished starting :)", 100);
                                TinyMediaManager.this.stopStartupAppender();
                                TinyMediaManager.this.splashScreen.setVisible(false);
                                TmmUILayoutStore.getInstance().loadSettings(window);
                                window.setVisible(true);
                                LOGGER.info("UI loaded");
                                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                                    LOGGER.info("received shutdown signal");
                                    if (!GraphicsEnvironment.isHeadless()) {
                                        MainWindow.getInstance().saveWindowLayout();
                                    }
                                    TinyMediaManager.shutdown();
                                    TinyMediaManager.shutdownLogger();
                                }));
                                if (wizardRun) {
                                    if (!MovieModuleManager.getInstance().getSettings().getMovieDataSource().isEmpty()) {
                                        task = new MovieUpdateDatasourceTask();
                                        TmmTaskManager.getInstance().addMainTask(task);
                                    }
                                    if (!TvShowModuleManager.getInstance().getSettings().getTvShowDataSource().isEmpty()) {
                                        task = new TvShowUpdateDatasourceTask();
                                        TmmTaskManager.getInstance().addMainTask(task);
                                    }
                                }
                                if (TinyMediaManager.this.newVersion && !ReleaseInfo.getVersion().equals(UpgradeTasks.getOldVersion())) {
                                    SwingUtilities.invokeLater(WhatsNewDialog::showChangelog);
                                }
                                if (License.getInstance().isValidLicense() && (validUntil = License.getInstance().validUntil()) != null && validUntil.minus(7L, ChronoUnit.DAYS).isBefore(LocalDate.now())) {
                                    SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(window, TmmResourceBundle.getString("tmm.renewlicense").replace("{}", TmmDateFormat.MEDIUM_DATE_FORMAT.format(Date.valueOf(validUntil)))));
                                }
                                if (MovieModuleManager.getInstance().getSettings().isUpdateOnStart()) {
                                    task = new MovieUpdateDatasourceTask();
                                    TmmTaskManager.getInstance().addMainTask(task);
                                }
                                if (TvShowModuleManager.getInstance().getSettings().isUpdateOnStart()) {
                                    task = new TvShowUpdateDatasourceTask();
                                    TmmTaskManager.getInstance().addMainTask(task);
                                }
                            });
                        }
                        catch (IllegalStateException e) {
                            LOGGER.error("IllegalStateException", (Throwable)e);
                            if (e.getMessage().contains("file is locked")) {
                                JOptionPane.showMessageDialog(null, TmmResourceBundle.getString("tmm.nostart") + "\n" + TmmResourceBundle.getString("tmm.nostart.instancerunning"), TmmResourceBundle.getString("tmm.nostart"), 0, new LogoCircle());
                            }
                            TinyMediaManager.shutdownLogger();
                            System.exit(1);
                        }
                        catch (Exception e) {
                            LOGGER.error("Exception while start of tmm", (Throwable)e);
                            MessageDialog.showExceptionWindow(e);
                            TinyMediaManager.shutdownLogger();
                            System.exit(1);
                        }
                        return null;
                    }
                };
                worker.execute();
            });
        } else {
            Thread.currentThread().setName("headless");
            LOGGER.debug("starting without GUI...");
            try {
                this.startup();
            }
            catch (IllegalStateException e) {
                LOGGER.error("IllegalStateException", (Throwable)e);
                TinyMediaManager.shutdownLogger();
                System.exit(1);
            }
            catch (Exception e) {
                LOGGER.error("Exception while start of tmm", (Throwable)e);
                TinyMediaManager.shutdownLogger();
                System.exit(1);
            }
            TinyMediaManager.setConsoleLogLevel();
            TinyMediaManagerCLI.start(args);
            while (TmmTaskManager.getInstance().isPoolRunning()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
            LOGGER.info("bye bye");
            try {
                TinyMediaManager.shutdown();
                TinyMediaManager.shutdownLogger();
            }
            catch (Exception ex) {
                LOGGER.warn(ex.getMessage());
            }
            System.exit(0);
        }
    }

    private void systemUiInit() {
        if (!Desktop.isDesktopSupported()) {
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        if (desktop.isSupported(Desktop.Action.APP_ABOUT)) {
            desktop.setAboutHandler(e -> {
                AboutDialog about = new AboutDialog();
                ((Dialog)about).setVisible(true);
            });
        }
        if (desktop.isSupported(Desktop.Action.APP_PREFERENCES)) {
            desktop.setPreferencesHandler(e -> {
                JDialog settings = SettingsDialog.getInstance();
                settings.setVisible(true);
            });
        }
        if (desktop.isSupported(Desktop.Action.APP_QUIT_HANDLER)) {
            desktop.setQuitHandler((e, response) -> {
                TinyMediaManager.shutdown();
                TinyMediaManager.shutdownLogger();
                System.exit(0);
            });
        }
    }

    private void printLogHeader() {
        LOGGER.info("=======================================================");
        LOGGER.info("=== tinyMediaManager (c) 2012 - 2024 Manuel Laggner ===");
        LOGGER.info("=======================================================");
        LOGGER.info("tmm.version      : {}", (Object)ReleaseInfo.getRealVersion());
        if (!ReleaseInfo.isGitBuild()) {
            LOGGER.info("tmm.build        : {}", (Object)ReleaseInfo.getRealBuildDate());
        }
        if (Globals.isDocker()) {
            LOGGER.info("tmm.docker       : true");
        }
        LOGGER.info("os.name          : {}", (Object)System.getProperty("os.name"));
        LOGGER.info("os.version       : {}", (Object)System.getProperty("os.version"));
        LOGGER.info("os.arch          : {}", (Object)System.getProperty("os.arch"));
        LOGGER.info("java.version     : {}", (Object)System.getProperty("java.version"));
        LOGGER.info("java.maxMem      : {} MiB", (Object)(Runtime.getRuntime().maxMemory() / 1024L / 1024L));
        if (Globals.isRunningJavaWebStart()) {
            LOGGER.info("java.webstart    : true");
        }
        if (Globals.isRunningWebSwing()) {
            LOGGER.info("java.webswing    : true");
        }
        byte[] bArray = new byte[]{119};
        LOGGER.info("current encoding : {} | {} | {}", new Object[]{System.getProperty("file.encoding"), new InputStreamReader(new ByteArrayInputStream(bArray)).getEncoding(), Charset.defaultCharset()});
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        LOGGER.info("JVM parameters   : {}", (Object)String.join((CharSequence)" ", runtimeMXBean.getInputArguments()));
        LOGGER.info("System language  : {}_{}", (Object)System.getProperty("user.language"), (Object)System.getProperty("user.country"));
        LOGGER.info("GUI language     : {}", (Object)Locale.getDefault().toLanguageTag());
        LOGGER.info("tmm.datafolder   : {} ", (Object)Globals.DATA_FOLDER);
        LOGGER.info("tmm.cachefolder  : {} ", (Object)Globals.CACHE_FOLDER);
        LOGGER.info("tmm.backupfolder : {} ", (Object)Globals.BACKUP_FOLDER);
        LOGGER.info("tmm.logfolder    : {} ", (Object)Globals.LOG_FOLDER);
        LOGGER.info("=====================================================");
        LOGGER.info("starting tinyMediaManager");
    }

    private void startup() throws Exception {
        this.doPreStartupTasks();
        org.jdesktop.beansbinding.util.logging.Logger.getLogger((String)ELProperty.class.getName()).setLevel(java.util.logging.Level.SEVERE);
        this.doUpgradeTasks();
        this.loadInternals();
        this.loadModules();
        this.loadPlugins();
        this.loadServices();
        this.doPostStartupTasks();
    }

    private void doUpgradeTasks() {
        UpgradeTasks.setOldVersion();
        if (this.newVersion) {
            LOGGER.info("Upgrade from '{}' to '{}'", (Object)UpgradeTasks.getOldVersion(), (Object)ReleaseInfo.getVersion());
            this.updateProgress("splash.upgrade", 10);
            UpgradeTasks.performUpgradeTasksBeforeDatabaseLoading();
            Settings.getInstance().setCurrentVersion();
            Settings.getInstance().saveSettings();
        }
    }

    private void loadInternals() {
        this.updateProgress("splash.internals", 20);
        TmmOsUtils.loadNativeLibs();
        if (License.getInstance().validUntil() != null) {
            LOGGER.info("{}", (Object)License.getInstance().sig());
            LOGGER.info("{}", (Object)License.getInstance().dat());
        }
        MediaGenres.init();
        LanguageUtils.init();
        if (Settings.getInstance().isEnableHttpServer()) {
            try {
                TmmHttpServer.getInstance();
            }
            catch (Exception e) {
                LOGGER.error("could not start webserver: {}", (Object)e.getMessage());
            }
        }
    }

    private void loadModules() throws Exception {
        this.updateProgress("splash.movie", 30);
        TmmModuleManager.getInstance().startUp();
        TmmModuleManager.getInstance().registerModule(MovieModuleManager.getInstance());
        TmmModuleManager.getInstance().enableModule(MovieModuleManager.getInstance());
        this.updateProgress("splash.tvshow", 50);
        TmmModuleManager.getInstance().registerModule(TvShowModuleManager.getInstance());
        TmmModuleManager.getInstance().enableModule(TvShowModuleManager.getInstance());
    }

    private void loadPlugins() {
        this.updateProgress("splash.plugins", 60);
        MediaProviders.loadMediaProviders();
        if (MovieModuleManager.getInstance().getSettings().isNewConfig()) {
            MovieSettingsDefaults.setDefaultScrapers();
        }
        if (TvShowModuleManager.getInstance().getSettings().isNewConfig()) {
            TvShowSettingsDefaults.setDefaultScrapers();
        }
    }

    private void loadServices() {
        Upnp u;
        this.updateProgress("splash.services", 70);
        try {
            if (Settings.getInstance().isUpnpShareLibrary()) {
                u = Upnp.getInstance();
                u.startWebServer();
                u.createUpnpService();
                u.startMediaServer();
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not start UPNP - '{}'", (Object)e.getMessage());
        }
        try {
            if (Settings.getInstance().isUpnpRemotePlay()) {
                u = Upnp.getInstance();
                u.createUpnpService();
                u.sendPlayerSearchRequest();
                u.startWebServer();
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not start UPNP - '{}'", (Object)e.getMessage());
        }
        try {
            KodiRPC.getInstance().connect();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    private void doPreStartupTasks() {
        Utils.cleanOldLogs();
        Path db = Paths.get(Settings.getInstance().getSettingsFolder(), new String[0]);
        Utils.createBackupFile(db);
        Utils.deleteOldBackupFile(db, 5);
        if (Platform.isLinux() && !TmmOsUtils.existsDesktopFileForLinux()) {
            Path desktopFile = Paths.get(System.getProperty("user.home"), ".local", "share", "applications", "tinyMediaManager.desktop").toAbsolutePath();
            if (Files.isWritable(desktopFile.getParent())) {
                TmmOsUtils.createDesktopFileForLinux(desktopFile.toFile());
            } else {
                TmmOsUtils.createDesktopFileForLinux(new File("tinyMediaManager.desktop"));
            }
        }
    }

    private void doPostStartupTasks() {
        this.updateProgress("splash.upgrade2", 80);
        new MovieUpgradeTasks().performDbUpgrades();
        new TvShowUpgradeTasks().performDbUpgrades();
    }

    private void updateProgress(String text, int progress) {
        if (this.splashScreen == null) {
            return;
        }
        this.splashScreen.setProgress(progress, text);
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(new Log4jBackstop());
        try {
            License.getInstance().init2121();
        }
        catch (Exception e) {
            LOGGER.error("Could not initialize license module!");
        }
        if (args != null && args.length > 0) {
            LOGGER.debug("TMM started with: {}", (Object)Arrays.toString(args));
            if (!TinyMediaManagerCLI.checkArgs(args)) {
                TinyMediaManager.shutdownLogger();
                System.exit(1);
            }
            System.setProperty("java.awt.headless", "true");
        } else {
            String head = System.getProperty("java.awt.headless");
            if (head != null && head.equals("true")) {
                LOGGER.info("TMM started 'headless', and without params -> displaying syntax ");
                TinyMediaManagerCLI.printHelp();
                TinyMediaManager.shutdownLogger();
                System.exit(1);
            }
            TinyMediaManager.setConsoleLogLevel();
        }
        TinyMediaManager tinyMediaManager = new TinyMediaManager();
        tinyMediaManager.launch(args);
    }

    public static void shutdown() {
        try {
            TmmProperties.getInstance().writeProperties();
            TmmTaskManager.getInstance().shutdown();
            TmmModuleManager.getInstance().saveSettings();
            TmmTaskManager.getInstance().shutdownNow();
            TmmModuleManager.getInstance().shutDown();
        }
        catch (Exception ex) {
            LOGGER.warn("Problem in shutdown", (Throwable)ex);
        }
    }

    public static void shutdownLogger() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerContext.stop();
    }

    public static void setConsoleLogLevel() {
        Level level;
        String loglevelAsString;
        switch (loglevelAsString = System.getProperty("tmm.consoleloglevel", "")) {
            case "OFF": {
                level = null;
                break;
            }
            case "ERROR": {
                level = Level.ERROR;
                break;
            }
            case "WARN": {
                level = Level.WARN;
                break;
            }
            case "INFO": {
                level = Level.INFO;
                break;
            }
            case "DEBUG": {
                level = Level.DEBUG;
                break;
            }
            case "TRACE": {
                level = Level.TRACE;
                break;
            }
            default: {
                return;
            }
        }
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        Appender consoleAppender = lc.getLogger("ROOT").getAppender("CONSOLE");
        if (consoleAppender instanceof ConsoleAppender) {
            if (level == null) {
                consoleAppender.stop();
            } else {
                ThresholdLoggerFilter filter = new ThresholdLoggerFilter(level);
                filter.start();
                consoleAppender.clearAllFilters();
                consoleAppender.addFilter((Filter)filter);
            }
        }
    }

    private void stopStartupAppender() {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        Appender appender = lc.getLogger("ROOT").getAppender("STARTUP");
        if (appender != null) {
            appender.stop();
        }
    }
}

