/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.TinyMediaManager;
import org.tinymediamanager.TmmOsUtils;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;
import org.tinymediamanager.scraper.entities.MediaEpisodeNumber;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.TmmUILayoutStore;

public abstract class UpgradeTasks {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeTasks.class);
    private static String oldVersion;
    protected Set<MediaEntity> entitiesToSave = new HashSet<MediaEntity>();

    protected UpgradeTasks() {
    }

    public abstract void performDbUpgrades();

    protected void registerForSaving(MediaEntity mediaEntity) {
        this.entitiesToSave.add(mediaEntity);
    }

    protected abstract void saveAll();

    public static void setOldVersion() {
        oldVersion = Settings.getInstance().getVersion();
    }

    public static String getOldVersion() {
        return oldVersion;
    }

    public static boolean isNewVersion() {
        return StrgUtils.compareVersion(oldVersion, ReleaseInfo.getVersion()) == 0;
    }

    public static void performUpgradeTasksBeforeDatabaseLoading() {
        Object v = oldVersion;
        if (StringUtils.isBlank((CharSequence)v)) {
            v = "5.0";
        }
        if (StrgUtils.compareVersion((String)v, "5.0") < 0) {
            LOGGER.info("Performing upgrade tasks to version 5.0");
            Path wrongExtra = Paths.get(Globals.DATA_FOLDER, "launcher-extra.yml");
            if (Files.exists(wrongExtra, new LinkOption[0])) {
                Path correctExtra = Paths.get(Globals.CONTENT_FOLDER, "launcher-extra.yml");
                try {
                    Files.move(wrongExtra, correctExtra, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    LOGGER.warn("Could not move launcher-extra.yml from {} to {}", (Object)wrongExtra, (Object)correctExtra);
                }
            }
            MovieModuleManager.getInstance().getSettings().removeMovieCheckArtwork(MovieScraperMetadataConfig.LOGO);
            TvShowModuleManager.getInstance().getSettings().removeTvShowCheckArtwork(TvShowScraperMetadataConfig.LOGO);
        }
    }

    protected static boolean fixRatings(MediaEntity me) {
        boolean changed = false;
        for (MediaRating rat : me.getRatings().values()) {
            if (rat.getMaxValue() == 10 && rat.getRating() > 10.0f) {
                rat.setMaxValue(100);
                changed = true;
            }
            if (rat.getMaxValue() == 10 && rat.getId().equals("letterboxd")) {
                rat.setMaxValue(5);
                changed = true;
            }
            if (rat.getMaxValue() != 10 || !rat.getId().equals("rogerebert")) continue;
            rat.setMaxValue(4);
            changed = true;
        }
        Iterator<String> it = me.getRatings().keySet().iterator();
        while (it.hasNext()) {
            MediaRating rat;
            rat = me.getRatings().get(it.next());
            if (rat.getRating() < 0.0f) {
                LOGGER.trace("Remove invalid rating: [{}] from {}", (Object)rat, (Object)me.getTitle());
                it.remove();
                changed = true;
                continue;
            }
            if (rat.getRating() != 0.0f || rat.getId().equals("rogerebert")) continue;
            LOGGER.trace("Remove invalid rating: [{}] from {}", (Object)rat, (Object)me.getTitle());
            it.remove();
            changed = true;
        }
        return changed;
    }

    protected static boolean fixHDR(MediaEntity me) {
        boolean changed = false;
        for (MediaFile mf : me.getMediaFiles()) {
            ArrayList<String> hdrs;
            if (!mf.isHDR() || !(hdrs = new ArrayList<String>(Arrays.asList(mf.getHdrFormat().split(", ")))).contains("HDR10+") || !hdrs.contains("HDR10")) continue;
            hdrs.remove("HDR10");
            mf.setHdrFormat(String.join((CharSequence)", ", hdrs));
            changed = true;
        }
        return changed;
    }

    public static void upgradeEpisodeNumbers(TvShowEpisode episode) {
        if (!episode.additionalProperties.isEmpty() && episode.getEpisodeNumbers().isEmpty()) {
            int s = MetadataUtil.parseInt(episode.additionalProperties.get("season"), -2);
            int e = MetadataUtil.parseInt(episode.additionalProperties.get("episode"), -2);
            if (s > -2 && e > -2) {
                episode.setEpisode(new MediaEpisodeNumber(MediaEpisodeGroup.DEFAULT_AIRED, s, e));
            }
            s = MetadataUtil.parseInt(episode.additionalProperties.get("dvdSeason"), -1);
            e = MetadataUtil.parseInt(episode.additionalProperties.get("dvdEpisode"), -1);
            if (s > -1 && e > -1) {
                episode.setEpisode(new MediaEpisodeNumber(MediaEpisodeGroup.DEFAULT_DVD, s, e));
            }
            s = MetadataUtil.parseInt(episode.additionalProperties.get("displaySeason"), -1);
            e = MetadataUtil.parseInt(episode.additionalProperties.get("displayEpisode"), -1);
            if (s > -1 && e > -1) {
                episode.setEpisode(new MediaEpisodeNumber(MediaEpisodeGroup.DEFAULT_DISPLAY, s, e));
            }
        }
    }

    public static void copyV4Data(Path path) {
        Path launcherExtra;
        Path cache;
        TinyMediaManager.shutdown();
        TmmUILayoutStore.getInstance().setSkipSaving(true);
        File[] files = path.toFile().listFiles();
        if (files != null) {
            for (File file : files) {
                try {
                    Utils.copyFileSafe(file.toPath(), Paths.get(Globals.DATA_FOLDER, file.getName()), true);
                }
                catch (Exception e) {
                    LOGGER.warn("could not copy file '{}' from v4 - '{}'", (Object)file.getName(), (Object)e.getMessage());
                }
            }
        }
        if ((cache = path.getParent().resolve("cache")).toFile().exists() && cache.toFile().isDirectory() && (files = cache.toFile().listFiles()) != null) {
            for (File file : files) {
                try {
                    if (file.isFile()) {
                        Utils.copyFileSafe(file.toPath(), Paths.get(Globals.CACHE_FOLDER, file.getName()), true);
                        continue;
                    }
                    if (!file.isDirectory()) continue;
                    Utils.copyDirectoryRecursive(file.toPath(), Paths.get(Globals.CACHE_FOLDER, file.getName()));
                }
                catch (Exception e) {
                    LOGGER.warn("could not copy file '{}' from v4 - '{}'", (Object)file.getName(), (Object)e.getMessage());
                }
            }
        }
        if ((launcherExtra = path.getParent().resolve("launcher-extra.yml")).toFile().exists() && launcherExtra.toFile().isFile()) {
            try {
                Utils.copyFileSafe(launcherExtra, Paths.get(Globals.CONTENT_FOLDER, launcherExtra.toFile().getName()), true);
            }
            catch (Exception e) {
                LOGGER.warn("could not copy file '{}' from v4 - '{}'", (Object)launcherExtra.toFile().getName(), (Object)e.getMessage());
            }
        }
        ProcessBuilder pb = TmmOsUtils.getPBforTMMrestart();
        try {
            LOGGER.info("Going to execute: {}", pb.command());
            pb.start();
        }
        catch (Exception e) {
            LOGGER.error("Cannot spawn process:", (Throwable)e);
        }
        TinyMediaManager.shutdownLogger();
        System.exit(0);
    }
}

