/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileVisitor
implements FileVisitor<Path> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFileVisitor.class);

    @Override
    @NotNull
    public FileVisitResult preVisitDirectory(Path var1, @NotNull BasicFileAttributes var2) throws IOException {
        Objects.requireNonNull(var1);
        Objects.requireNonNull(var2);
        return FileVisitResult.CONTINUE;
    }

    @Override
    @NotNull
    public FileVisitResult postVisitDirectory(Path var1, IOException var2) throws IOException {
        Objects.requireNonNull(var1);
        if (var2 != null) {
            throw var2;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    @NotNull
    public FileVisitResult visitFileFailed(Path path, @NotNull IOException e) {
        if (e instanceof FileSystemLoopException) {
            LOGGER.trace("FileSystemLoopException detected: {}", (Object)path);
            LOGGER.trace("Problematic path: {} - isDir: {} - isFile: {}", new Object[]{path, path.toFile().isDirectory(), path.toFile().isFile()});
            if (path.toFile().isDirectory()) {
                this.traverseTreeAlternate(path);
            } else {
                this.traverseTreeAlternate(path.getParent());
            }
            return FileVisitResult.SKIP_SUBTREE;
        }
        if (e instanceof NoSuchFileException) {
            LOGGER.error("visit file failed (not found): {}", (Object)e.getMessage());
            return FileVisitResult.SKIP_SUBTREE;
        }
        LOGGER.error("visit file failed: {}", (Object)e.getMessage());
        LOGGER.trace("visit file failed", (Throwable)e);
        return FileVisitResult.CONTINUE;
    }

    protected void traverseTreeAlternate(Path parent) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(parent);){
            BasicFileAttributes pathAttr = Files.readAttributes(parent, BasicFileAttributes.class, new LinkOption[0]);
            this.preVisitDirectory(parent, pathAttr);
            for (Path path : directoryStream) {
                if (path.toFile().isDirectory()) {
                    this.traverseTreeAlternate(path);
                    continue;
                }
                BasicFileAttributes fileAttr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                this.visitFile(path, fileAttr);
            }
            this.postVisitDirectory(parent, (IOException)null);
        }
        catch (IOException e) {
            LOGGER.error("error on traverseTreeAlternate: {}", (Object)e.getMessage());
        }
    }
}

