/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.TmmToStringStyle;
import org.tinymediamanager.scraper.util.StrgUtils;

public class MediaTrailer
extends AbstractModelObject
implements Comparable<MediaTrailer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTrailer.class);
    @JsonProperty
    private String id = "";
    @JsonProperty
    private String name = "";
    @JsonProperty
    private String url = "";
    @JsonProperty
    private String quality = "";
    @JsonProperty
    private String provider = "";
    @JsonProperty
    private Boolean inNfo = Boolean.FALSE;
    @JsonProperty
    private Date date = null;
    @JsonProperty
    private String scrapedBy = "";

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newValue) {
        String oldValue = this.name;
        this.name = StrgUtils.getNonNullString(newValue);
        this.firePropertyChange("name", oldValue, newValue);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String newValue) {
        String oldValue = this.url;
        this.url = StrgUtils.getNonNullString(newValue);
        this.firePropertyChange("url", oldValue, newValue);
    }

    public String getQuality() {
        return this.quality;
    }

    public void setQuality(String newValue) {
        String oldValue = this.quality;
        this.quality = StrgUtils.getNonNullString(newValue);
        this.firePropertyChange("quality", oldValue, newValue);
    }

    public String getScrapedBy() {
        return this.scrapedBy;
    }

    public void setScrapedBy(String newValue) {
        String oldValue = this.scrapedBy;
        this.scrapedBy = StrgUtils.getNonNullString(newValue);
        this.firePropertyChange("scrapedBy", oldValue, newValue);
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String newValue) {
        String oldValue = this.provider;
        this.provider = StrgUtils.getNonNullString(newValue);
        this.firePropertyChange("provider", oldValue, newValue);
    }

    public Boolean getInNfo() {
        return this.inNfo;
    }

    public void setInNfo(Boolean newValue) {
        if (!this.url.startsWith("http")) {
            newValue = false;
        }
        Boolean oldValue = this.inNfo;
        this.inNfo = newValue;
        this.firePropertyChange("inNfo", oldValue, newValue);
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(String newValue) {
        try {
            this.setDate(StrgUtils.parseDate(newValue));
        }
        catch (ParseException e) {
            LOGGER.trace("could not parse date: {}", (Object)e.getMessage());
        }
    }

    public void setDate(Date newValue) {
        Date oldValue = this.date;
        this.date = newValue;
        this.firePropertyChange("date", oldValue, newValue);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)TmmToStringStyle.TMM_STYLE, (boolean)false, MediaTrailer.class);
    }

    public boolean equals(Object mt2) {
        if (mt2 instanceof MediaTrailer) {
            return this.compareTo((MediaTrailer)mt2) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(MediaTrailer mt2) {
        return this.getUrl().compareTo(mt2.getUrl());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 31 * result + (this.quality == null ? 0 : this.quality.hashCode());
        return result;
    }

    public static class QualityComparator
    implements Comparator<MediaTrailer> {
        @Override
        public int compare(MediaTrailer o1, MediaTrailer o2) {
            int quality1 = 0;
            int quality2 = 0;
            try {
                quality1 = Integer.parseInt(o1.quality.replace("p", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                quality2 = Integer.parseInt(o2.quality.replace("p", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return quality2 - quality1;
        }
    }
}

