/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.IFileNaming;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.filenaming.MovieBannerNaming;
import org.tinymediamanager.core.movie.filenaming.MovieClearartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieClearlogoNaming;
import org.tinymediamanager.core.movie.filenaming.MovieDiscartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieExtraFanartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieFanartNaming;
import org.tinymediamanager.core.movie.filenaming.MovieKeyartNaming;
import org.tinymediamanager.core.movie.filenaming.MoviePosterNaming;
import org.tinymediamanager.core.movie.filenaming.MovieThumbNaming;
import org.tinymediamanager.core.movie.tasks.MovieExtraImageFetcherTask;
import org.tinymediamanager.core.tasks.MediaEntityImageFetcherTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.thirdparty.VSMeta;

public class MovieArtworkHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieArtworkHelper.class);
    private static final Pattern INDEX_PATTERN = Pattern.compile(".*?(\\d+)$");

    private MovieArtworkHelper() {
        throw new IllegalAccessError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadArtwork(Movie movie, MediaFileType type) {
        if (type == MediaFileType.EXTRAFANART || type == MediaFileType.EXTRATHUMB) {
            MovieArtworkHelper.downloadExtraArtwork(movie, type);
            return;
        }
        String url = movie.getArtworkUrl(type);
        try {
            if (StringUtils.isBlank((CharSequence)url)) {
                return;
            }
            List<IFileNaming> fileNamings = MovieArtworkHelper.getFileNamingsForMediaFileType(movie, type);
            if (fileNamings.isEmpty()) {
                return;
            }
            ArrayList<String> filenames = new ArrayList<String>();
            for (IFileNaming fileNaming : fileNamings) {
                String filename = MovieArtworkHelper.getArtworkFilename(movie, fileNaming, Utils.getArtworkExtensionFromUrl(url));
                if (StringUtils.isBlank((CharSequence)filename)) continue;
                filenames.add(filename);
            }
            if (!filenames.isEmpty()) {
                MediaEntityImageFetcherTask task = new MediaEntityImageFetcherTask(movie, url, MediaFileType.getMediaArtworkType(type), filenames);
                TmmTaskManager.getInstance().addImageDownloadTask(task);
            }
        }
        finally {
            if (url.startsWith("file:")) {
                movie.removeArtworkUrl(type);
            }
        }
    }

    public static void downloadMissingArtwork(Movie movie) {
        MovieArtworkHelper.downloadMissingArtwork(movie, false);
    }

    public static void downloadMissingArtwork(Movie movie, boolean force) {
        MediaFileType[] mfts;
        for (MediaFileType mft : mfts = MediaFileType.getGraphicMediaFileTypes()) {
            List<MediaFile> mfs = movie.getMediaFiles(mft);
            if (!mfs.isEmpty()) continue;
            boolean download = false;
            switch (mft) {
                case FANART: {
                    if (MovieModuleManager.getInstance().getSettings().getFanartFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case POSTER: {
                    if (MovieModuleManager.getInstance().getSettings().getPosterFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case BANNER: {
                    if (MovieModuleManager.getInstance().getSettings().getBannerFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case CLEARART: {
                    if (MovieModuleManager.getInstance().getSettings().getClearartFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case DISC: {
                    if (MovieModuleManager.getInstance().getSettings().getDiscartFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case CLEARLOGO: 
                case LOGO: {
                    if (MovieModuleManager.getInstance().getSettings().getClearlogoFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case THUMB: {
                    if (MovieModuleManager.getInstance().getSettings().getThumbFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case KEYART: {
                    if (MovieModuleManager.getInstance().getSettings().getKeyartFilenames().isEmpty() && !force) break;
                    download = true;
                    break;
                }
                case EXTRAFANART: {
                    if (!MovieModuleManager.getInstance().getSettings().isImageExtraFanart() && !force) break;
                    download = true;
                    break;
                }
                case EXTRATHUMB: {
                    if (!MovieModuleManager.getInstance().getSettings().isImageExtraThumbs() && !force) break;
                    download = true;
                    break;
                }
            }
            if (!download) continue;
            MovieArtworkHelper.downloadArtwork(movie, mft);
        }
    }

    public static void downloadMissingArtwork(Movie movie, List<MediaArtwork> artwork, List<MovieScraperMetadataConfig> metadataConfig) {
        if (metadataConfig.contains(MovieScraperMetadataConfig.POSTER) && movie.getMediaFiles(MediaFileType.POSTER).isEmpty()) {
            MovieArtworkHelper.setBestPoster(movie, artwork, false);
        }
        if (metadataConfig.contains(MovieScraperMetadataConfig.FANART) && movie.getMediaFiles(MediaFileType.FANART).isEmpty()) {
            MovieArtworkHelper.setBestFanart(movie, artwork, false);
        }
        if (metadataConfig.contains(MovieScraperMetadataConfig.CLEARLOGO) && movie.getMediaFiles(MediaFileType.CLEARLOGO).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.CLEARLOGO, !MovieModuleManager.getInstance().getSettings().getClearlogoFilenames().isEmpty(), false);
        }
        if (metadataConfig.contains(MovieScraperMetadataConfig.CLEARART) && movie.getMediaFiles(MediaFileType.CLEARART).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.CLEARART, !MovieModuleManager.getInstance().getSettings().getClearartFilenames().isEmpty(), false);
        }
        if (metadataConfig.contains(MovieScraperMetadataConfig.BANNER) && movie.getMediaFiles(MediaFileType.BANNER).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.BANNER, !MovieModuleManager.getInstance().getSettings().getBannerFilenames().isEmpty(), false);
        }
        if (metadataConfig.contains(MovieScraperMetadataConfig.THUMB) && movie.getMediaFiles(MediaFileType.THUMB).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.THUMB, !MovieModuleManager.getInstance().getSettings().getThumbFilenames().isEmpty(), false);
        }
        if (metadataConfig.contains(MovieScraperMetadataConfig.DISCART) && movie.getMediaFiles(MediaFileType.DISC).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.DISC, !MovieModuleManager.getInstance().getSettings().getDiscartFilenames().isEmpty(), false);
        }
        if (metadataConfig.contains(MovieScraperMetadataConfig.KEYART) && movie.getMediaFiles(MediaFileType.KEYART).isEmpty()) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.KEYART, !MovieModuleManager.getInstance().getSettings().getKeyartFilenames().isEmpty(), false);
        }
        ArrayList<String> extrathumbs = new ArrayList<String>();
        if (metadataConfig.contains(MovieScraperMetadataConfig.EXTRATHUMB) && movie.getMediaFiles(MediaFileType.EXTRATHUMB).isEmpty() && MovieModuleManager.getInstance().getSettings().isImageExtraThumbs() && MovieModuleManager.getInstance().getSettings().getImageExtraThumbsCount() > 0) {
            for (MediaArtwork art : artwork.stream().filter(mediaArtwork -> mediaArtwork.getType() == MediaArtwork.MediaArtworkType.BACKGROUND).toList()) {
                for (MediaArtwork.ImageSizeAndUrl imageSizeAndUrl : art.getImageSizes()) {
                    if (imageSizeAndUrl.getSizeOrder() != MovieModuleManager.getInstance().getSettings().getImageFanartSize().getOrder()) continue;
                    extrathumbs.add(imageSizeAndUrl.getUrl());
                    break;
                }
                if (extrathumbs.size() < MovieModuleManager.getInstance().getSettings().getImageExtraThumbsCount()) continue;
                break;
            }
            movie.setExtraThumbs(extrathumbs);
            if (!extrathumbs.isEmpty() && !movie.isMultiMovieDir()) {
                MovieArtworkHelper.downloadArtwork(movie, MediaFileType.EXTRATHUMB);
            }
        }
        ArrayList<String> extrafanarts = new ArrayList<String>();
        if (metadataConfig.contains(MovieScraperMetadataConfig.EXTRAFANART) && MovieModuleManager.getInstance().getSettings().isImageExtraFanart() && MovieModuleManager.getInstance().getSettings().getImageExtraFanartCount() > 0) {
            for (MediaArtwork art : artwork.stream().filter(mediaArtwork -> mediaArtwork.getType() == MediaArtwork.MediaArtworkType.BACKGROUND).toList()) {
                for (MediaArtwork.ImageSizeAndUrl imageSizeAndUrl : art.getImageSizes()) {
                    if (imageSizeAndUrl.getSizeOrder() != MovieModuleManager.getInstance().getSettings().getImageFanartSize().getOrder()) continue;
                    extrafanarts.add(imageSizeAndUrl.getUrl());
                    break;
                }
                if (extrafanarts.size() < MovieModuleManager.getInstance().getSettings().getImageExtraFanartCount()) continue;
                break;
            }
            movie.setExtraFanarts(extrafanarts);
            if (!extrafanarts.isEmpty() && !movie.isMultiMovieDir()) {
                MovieArtworkHelper.downloadArtwork(movie, MediaFileType.EXTRAFANART);
            }
        }
        movie.saveToDb();
        movie.writeNFO();
    }

    public static boolean hasMissingArtwork(Movie movie, List<MovieScraperMetadataConfig> config) {
        if (config.contains(MovieScraperMetadataConfig.POSTER) && !MovieModuleManager.getInstance().getSettings().getPosterFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.POSTER).isEmpty()) {
            return true;
        }
        if (config.contains(MovieScraperMetadataConfig.FANART) && !MovieModuleManager.getInstance().getSettings().getFanartFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.FANART).isEmpty()) {
            return true;
        }
        if (config.contains(MovieScraperMetadataConfig.BANNER) && !MovieModuleManager.getInstance().getSettings().getBannerFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.BANNER).isEmpty()) {
            return true;
        }
        if (config.contains(MovieScraperMetadataConfig.DISCART) && !MovieModuleManager.getInstance().getSettings().getDiscartFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.DISC).isEmpty()) {
            return true;
        }
        if (config.contains(MovieScraperMetadataConfig.CLEARLOGO) && !MovieModuleManager.getInstance().getSettings().getClearlogoFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.CLEARLOGO).isEmpty()) {
            return true;
        }
        if (config.contains(MovieScraperMetadataConfig.CLEARART) && !MovieModuleManager.getInstance().getSettings().getClearartFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.CLEARART).isEmpty()) {
            return true;
        }
        if (config.contains(MovieScraperMetadataConfig.THUMB) && !MovieModuleManager.getInstance().getSettings().getThumbFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.THUMB).isEmpty()) {
            return true;
        }
        if (config.contains(MovieScraperMetadataConfig.KEYART) && !MovieModuleManager.getInstance().getSettings().getKeyartFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.KEYART).isEmpty()) {
            return true;
        }
        if (config.contains(MovieScraperMetadataConfig.EXTRAFANART) && MovieModuleManager.getInstance().getSettings().isImageExtraFanart() && !MovieModuleManager.getInstance().getSettings().getExtraFanartFilenames().isEmpty() && movie.getMediaFiles(MediaFileType.EXTRAFANART).isEmpty()) {
            return true;
        }
        return config.contains(MovieScraperMetadataConfig.EXTRATHUMB) && MovieModuleManager.getInstance().getSettings().isImageExtraThumbs() && movie.getMediaFiles(MediaFileType.EXTRATHUMB).isEmpty();
    }

    public static String getArtworkFilename(Movie movie, IFileNaming fileNaming, String extension) {
        List<MediaFile> mfs = movie.getMediaFiles(MediaFileType.VIDEO);
        if (mfs != null && !mfs.isEmpty()) {
            return fileNaming.getFilename(movie.getVideoBasenameWithoutStacking(), extension);
        }
        return fileNaming.getFilename("", extension);
    }

    public static List<MovieFanartNaming> getFanartNamesForMovie(Movie movie) {
        List<MovieFanartNaming> fanartnames = new ArrayList<MovieFanartNaming>();
        if (MovieModuleManager.getInstance().getSettings().getFanartFilenames().isEmpty()) {
            return fanartnames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.getInstance().getSettings().getFanartFilenames().contains(MovieFanartNaming.FILENAME_FANART)) {
                fanartnames.add(MovieFanartNaming.FILENAME_FANART);
            }
            if (MovieModuleManager.getInstance().getSettings().getFanartFilenames().contains(MovieFanartNaming.FILENAME_FANART2)) {
                fanartnames.add(MovieFanartNaming.FILENAME_FANART2);
            }
            if (fanartnames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getFanartFilenames().isEmpty()) {
                fanartnames.add(MovieFanartNaming.FILENAME_FANART);
            }
        } else if (movie.isDisc()) {
            fanartnames.add(MovieFanartNaming.FANART);
        } else {
            fanartnames = MovieModuleManager.getInstance().getSettings().getFanartFilenames();
        }
        return fanartnames;
    }

    public static List<MoviePosterNaming> getPosterNamesForMovie(Movie movie) {
        ArrayList<MoviePosterNaming> posternames = new ArrayList<MoviePosterNaming>();
        if (MovieModuleManager.getInstance().getSettings().getPosterFilenames().isEmpty()) {
            return posternames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.getInstance().getSettings().getPosterFilenames().contains(MoviePosterNaming.FILENAME_POSTER)) {
                posternames.add(MoviePosterNaming.FILENAME_POSTER);
            }
            if (MovieModuleManager.getInstance().getSettings().getPosterFilenames().contains(MoviePosterNaming.FILENAME)) {
                posternames.add(MoviePosterNaming.FILENAME);
            }
            if (posternames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getPosterFilenames().isEmpty()) {
                posternames.add(MoviePosterNaming.FILENAME_POSTER);
            }
        } else if (movie.isDisc()) {
            if (MovieModuleManager.getInstance().getSettings().getPosterFilenames().contains(MoviePosterNaming.FOLDER)) {
                posternames.add(MoviePosterNaming.FOLDER);
            }
            if (MovieModuleManager.getInstance().getSettings().getPosterFilenames().contains(MoviePosterNaming.POSTER) || posternames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getPosterFilenames().isEmpty()) {
                posternames.add(MoviePosterNaming.POSTER);
            }
        } else {
            posternames.addAll(MovieModuleManager.getInstance().getSettings().getPosterFilenames());
        }
        return posternames;
    }

    public static List<MovieBannerNaming> getBannerNamesForMovie(Movie movie) {
        ArrayList<MovieBannerNaming> bannernames = new ArrayList<MovieBannerNaming>();
        if (MovieModuleManager.getInstance().getSettings().getBannerFilenames().isEmpty()) {
            return bannernames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.getInstance().getSettings().getBannerFilenames().contains(MovieBannerNaming.FILENAME_BANNER)) {
                bannernames.add(MovieBannerNaming.FILENAME_BANNER);
            }
            if (bannernames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getBannerFilenames().isEmpty()) {
                bannernames.add(MovieBannerNaming.FILENAME_BANNER);
            }
        } else if (movie.isDisc()) {
            if (MovieModuleManager.getInstance().getSettings().getBannerFilenames().contains(MovieBannerNaming.BANNER)) {
                bannernames.add(MovieBannerNaming.BANNER);
            }
            if (bannernames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getBannerFilenames().isEmpty()) {
                bannernames.add(MovieBannerNaming.BANNER);
            }
        } else {
            bannernames.addAll(MovieModuleManager.getInstance().getSettings().getBannerFilenames());
        }
        return bannernames;
    }

    public static List<MovieClearartNaming> getClearartNamesForMovie(Movie movie) {
        ArrayList<MovieClearartNaming> clearartnames = new ArrayList<MovieClearartNaming>();
        if (MovieModuleManager.getInstance().getSettings().getClearartFilenames().isEmpty()) {
            return clearartnames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.getInstance().getSettings().getClearartFilenames().contains(MovieClearartNaming.FILENAME_CLEARART)) {
                clearartnames.add(MovieClearartNaming.FILENAME_CLEARART);
            }
            if (clearartnames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getClearartFilenames().isEmpty()) {
                clearartnames.add(MovieClearartNaming.FILENAME_CLEARART);
            }
        } else if (movie.isDisc()) {
            if (MovieModuleManager.getInstance().getSettings().getClearartFilenames().contains(MovieClearartNaming.CLEARART)) {
                clearartnames.add(MovieClearartNaming.CLEARART);
            }
            if (clearartnames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getClearartFilenames().isEmpty()) {
                clearartnames.add(MovieClearartNaming.CLEARART);
            }
        } else {
            clearartnames.addAll(MovieModuleManager.getInstance().getSettings().getClearartFilenames());
        }
        return clearartnames;
    }

    public static List<MovieDiscartNaming> getDiscartNamesForMovie(Movie movie) {
        ArrayList<MovieDiscartNaming> discartnames = new ArrayList<MovieDiscartNaming>();
        if (MovieModuleManager.getInstance().getSettings().getDiscartFilenames().isEmpty()) {
            return discartnames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.getInstance().getSettings().getDiscartFilenames().contains(MovieDiscartNaming.FILENAME_DISC) || MovieModuleManager.getInstance().getSettings().getDiscartFilenames().contains(MovieDiscartNaming.DISC)) {
                discartnames.add(MovieDiscartNaming.FILENAME_DISC);
            }
            if (MovieModuleManager.getInstance().getSettings().getDiscartFilenames().contains(MovieDiscartNaming.FILENAME_DISCART) || MovieModuleManager.getInstance().getSettings().getDiscartFilenames().contains(MovieDiscartNaming.DISCART)) {
                discartnames.add(MovieDiscartNaming.FILENAME_DISCART);
            }
        } else if (movie.isDisc()) {
            if (MovieModuleManager.getInstance().getSettings().getDiscartFilenames().contains(MovieDiscartNaming.FILENAME_DISC) || MovieModuleManager.getInstance().getSettings().getDiscartFilenames().contains(MovieDiscartNaming.DISC)) {
                discartnames.add(MovieDiscartNaming.DISC);
            }
            if (MovieModuleManager.getInstance().getSettings().getDiscartFilenames().contains(MovieDiscartNaming.FILENAME_DISCART) || MovieModuleManager.getInstance().getSettings().getDiscartFilenames().contains(MovieDiscartNaming.DISCART)) {
                discartnames.add(MovieDiscartNaming.DISCART);
            }
        } else {
            discartnames.addAll(MovieModuleManager.getInstance().getSettings().getDiscartFilenames());
        }
        return discartnames;
    }

    public static List<MovieKeyartNaming> getKeyartNamesForMovie(Movie movie) {
        ArrayList<MovieKeyartNaming> keyartnames = new ArrayList<MovieKeyartNaming>();
        if (MovieModuleManager.getInstance().getSettings().getKeyartFilenames().isEmpty()) {
            return keyartnames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.getInstance().getSettings().getKeyartFilenames().contains(MovieKeyartNaming.FILENAME_KEYART)) {
                keyartnames.add(MovieKeyartNaming.FILENAME_KEYART);
            }
            if (keyartnames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getKeyartFilenames().isEmpty()) {
                keyartnames.add(MovieKeyartNaming.FILENAME_KEYART);
            }
        } else if (movie.isDisc()) {
            if (MovieModuleManager.getInstance().getSettings().getKeyartFilenames().contains(MovieKeyartNaming.KEYART)) {
                keyartnames.add(MovieKeyartNaming.KEYART);
            }
            if (keyartnames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getKeyartFilenames().isEmpty()) {
                keyartnames.add(MovieKeyartNaming.KEYART);
            }
        } else {
            keyartnames.addAll(MovieModuleManager.getInstance().getSettings().getKeyartFilenames());
        }
        return keyartnames;
    }

    public static List<MovieClearlogoNaming> getClearlogoNamesForMovie(Movie movie) {
        ArrayList<MovieClearlogoNaming> clearlogonames = new ArrayList<MovieClearlogoNaming>();
        if (MovieModuleManager.getInstance().getSettings().getClearlogoFilenames().isEmpty()) {
            return clearlogonames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.getInstance().getSettings().getClearlogoFilenames().contains(MovieClearlogoNaming.FILENAME_CLEARLOGO)) {
                clearlogonames.add(MovieClearlogoNaming.FILENAME_CLEARLOGO);
            } else if (MovieModuleManager.getInstance().getSettings().getClearlogoFilenames().contains(MovieClearlogoNaming.FILENAME_LOGO)) {
                clearlogonames.add(MovieClearlogoNaming.FILENAME_LOGO);
            }
            if (clearlogonames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getClearlogoFilenames().isEmpty()) {
                clearlogonames.add(MovieClearlogoNaming.FILENAME_CLEARLOGO);
            }
        } else if (movie.isDisc()) {
            if (MovieModuleManager.getInstance().getSettings().getClearlogoFilenames().contains(MovieClearlogoNaming.CLEARLOGO)) {
                clearlogonames.add(MovieClearlogoNaming.CLEARLOGO);
            } else if (MovieModuleManager.getInstance().getSettings().getClearlogoFilenames().contains(MovieClearlogoNaming.LOGO)) {
                clearlogonames.add(MovieClearlogoNaming.LOGO);
            }
            if (clearlogonames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getClearlogoFilenames().isEmpty()) {
                clearlogonames.add(MovieClearlogoNaming.CLEARLOGO);
            }
        } else {
            clearlogonames.addAll(MovieModuleManager.getInstance().getSettings().getClearlogoFilenames());
        }
        return clearlogonames;
    }

    public static List<MovieThumbNaming> getThumbNamesForMovie(Movie movie) {
        ArrayList<MovieThumbNaming> thumbnames = new ArrayList<MovieThumbNaming>();
        if (MovieModuleManager.getInstance().getSettings().getThumbFilenames().isEmpty()) {
            return thumbnames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.getInstance().getSettings().getThumbFilenames().contains(MovieThumbNaming.FILENAME_THUMB)) {
                thumbnames.add(MovieThumbNaming.FILENAME_THUMB);
            }
            if (MovieModuleManager.getInstance().getSettings().getThumbFilenames().contains(MovieThumbNaming.FILENAME_LANDSCAPE)) {
                thumbnames.add(MovieThumbNaming.FILENAME_LANDSCAPE);
            }
            if (thumbnames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getThumbFilenames().isEmpty() && MovieModuleManager.getInstance().getSettings().getThumbFilenames().contains(MovieThumbNaming.THUMB)) {
                thumbnames.add(MovieThumbNaming.FILENAME_THUMB);
            }
            if (thumbnames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getThumbFilenames().isEmpty()) {
                thumbnames.add(MovieThumbNaming.FILENAME_LANDSCAPE);
            }
        } else if (movie.isDisc()) {
            if (MovieModuleManager.getInstance().getSettings().getThumbFilenames().contains(MovieThumbNaming.THUMB)) {
                thumbnames.add(MovieThumbNaming.THUMB);
            }
            if (MovieModuleManager.getInstance().getSettings().getThumbFilenames().contains(MovieThumbNaming.LANDSCAPE)) {
                thumbnames.add(MovieThumbNaming.LANDSCAPE);
            }
            if (thumbnames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getThumbFilenames().isEmpty() && MovieModuleManager.getInstance().getSettings().getThumbFilenames().contains(MovieThumbNaming.FILENAME_THUMB)) {
                thumbnames.add(MovieThumbNaming.THUMB);
            }
            if (thumbnames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getThumbFilenames().isEmpty()) {
                thumbnames.add(MovieThumbNaming.LANDSCAPE);
            }
        } else {
            thumbnames.addAll(MovieModuleManager.getInstance().getSettings().getThumbFilenames());
        }
        return thumbnames;
    }

    public static List<MovieExtraFanartNaming> getExtraFanartNamesForMovie(Movie movie) {
        List<MovieExtraFanartNaming> fanartnames = new ArrayList<MovieExtraFanartNaming>();
        if (MovieModuleManager.getInstance().getSettings().getExtraFanartFilenames().isEmpty()) {
            return fanartnames;
        }
        if (movie.isMultiMovieDir()) {
            if (MovieModuleManager.getInstance().getSettings().getExtraFanartFilenames().contains(MovieExtraFanartNaming.FILENAME_EXTRAFANART)) {
                fanartnames.add(MovieExtraFanartNaming.FILENAME_EXTRAFANART);
            }
            if (MovieModuleManager.getInstance().getSettings().getExtraFanartFilenames().contains(MovieExtraFanartNaming.FILENAME_EXTRAFANART2)) {
                fanartnames.add(MovieExtraFanartNaming.FILENAME_EXTRAFANART2);
            }
            if (fanartnames.isEmpty() && !MovieModuleManager.getInstance().getSettings().getExtraFanartFilenames().isEmpty()) {
                fanartnames.add(MovieExtraFanartNaming.FILENAME_EXTRAFANART);
            }
        } else if (movie.isDisc()) {
            fanartnames.add(MovieExtraFanartNaming.EXTRAFANART);
        } else {
            fanartnames = MovieModuleManager.getInstance().getSettings().getExtraFanartFilenames();
        }
        return fanartnames;
    }

    private static void downloadExtraArtwork(Movie movie, MediaFileType type) {
        MovieExtraImageFetcherTask task = new MovieExtraImageFetcherTask(movie, type);
        TmmTaskManager.getInstance().addImageDownloadTask(task);
    }

    public static void setArtwork(Movie movie, List<MediaArtwork> artwork, List<MovieScraperMetadataConfig> config, boolean overwrite) {
        List<MediaArtwork.ImageSizeAndUrl> sortedFanarts;
        if (!ScraperMetadataConfig.containsAnyArtwork(config)) {
            return;
        }
        if (config.contains(MovieScraperMetadataConfig.POSTER) && (overwrite || StringUtils.isBlank((CharSequence)movie.getArtworkFilename(MediaFileType.POSTER)))) {
            MovieArtworkHelper.setBestPoster(movie, artwork, overwrite);
        }
        if (config.contains(MovieScraperMetadataConfig.FANART) && (overwrite || StringUtils.isBlank((CharSequence)movie.getArtworkFilename(MediaFileType.FANART)))) {
            MovieArtworkHelper.setBestFanart(movie, artwork, overwrite);
        }
        if (config.contains(MovieScraperMetadataConfig.CLEARLOGO) && (overwrite || StringUtils.isBlank((CharSequence)movie.getArtworkFilename(MediaFileType.CLEARLOGO)))) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.CLEARLOGO, !MovieModuleManager.getInstance().getSettings().getClearlogoFilenames().isEmpty(), overwrite);
        }
        if (config.contains(MovieScraperMetadataConfig.CLEARART) && (overwrite || StringUtils.isBlank((CharSequence)movie.getArtworkFilename(MediaFileType.CLEARART)))) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.CLEARART, !MovieModuleManager.getInstance().getSettings().getClearartFilenames().isEmpty(), overwrite);
        }
        if (config.contains(MovieScraperMetadataConfig.BANNER) && (overwrite || StringUtils.isBlank((CharSequence)movie.getArtworkFilename(MediaFileType.BANNER)))) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.BANNER, !MovieModuleManager.getInstance().getSettings().getBannerFilenames().isEmpty(), overwrite);
        }
        if (config.contains(MovieScraperMetadataConfig.THUMB) && (overwrite || StringUtils.isBlank((CharSequence)movie.getArtworkFilename(MediaFileType.THUMB)))) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.THUMB, !MovieModuleManager.getInstance().getSettings().getThumbFilenames().isEmpty(), overwrite);
        }
        if (config.contains(MovieScraperMetadataConfig.DISCART) && (overwrite || StringUtils.isBlank((CharSequence)movie.getArtworkFilename(MediaFileType.DISC)))) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.DISC, !MovieModuleManager.getInstance().getSettings().getDiscartFilenames().isEmpty(), overwrite);
        }
        if (config.contains(MovieScraperMetadataConfig.KEYART) && (overwrite || StringUtils.isBlank((CharSequence)movie.getArtworkFilename(MediaFileType.KEYART)))) {
            MovieArtworkHelper.setBestArtwork(movie, artwork, MediaArtwork.MediaArtworkType.KEYART, !MovieModuleManager.getInstance().getSettings().getKeyartFilenames().isEmpty(), overwrite);
        }
        if (config.contains(MovieScraperMetadataConfig.EXTRATHUMB) && (overwrite || StringUtils.isBlank((CharSequence)movie.getArtworkFilename(MediaFileType.EXTRATHUMB)))) {
            ArrayList<String> extrathumbs = new ArrayList<String>();
            if (MovieModuleManager.getInstance().getSettings().isImageExtraThumbs() && MovieModuleManager.getInstance().getSettings().getImageExtraThumbsCount() > 0) {
                sortedFanarts = MovieArtworkHelper.sortArtworkUrls(artwork, MediaArtwork.MediaArtworkType.BACKGROUND, MovieModuleManager.getInstance().getSettings().getImageFanartSize().getOrder());
                for (MediaArtwork.ImageSizeAndUrl art : sortedFanarts) {
                    if (MovieModuleManager.getInstance().getSettings().getImageFanartSize() != MediaArtwork.FanartSizes.SMALL && art.getHeight() < 720 || art.getUrl().equals(movie.getArtworkUrl(MediaFileType.THUMB))) continue;
                    extrathumbs.add(art.getUrl());
                    if (extrathumbs.size() < MovieModuleManager.getInstance().getSettings().getImageExtraThumbsCount()) continue;
                    break;
                }
                movie.setExtraThumbs(extrathumbs);
                if (!extrathumbs.isEmpty() && !movie.isMultiMovieDir()) {
                    MovieArtworkHelper.downloadArtwork(movie, MediaFileType.EXTRATHUMB);
                }
            }
        }
        if (config.contains(MovieScraperMetadataConfig.EXTRAFANART) && (overwrite || StringUtils.isBlank((CharSequence)movie.getArtworkFilename(MediaFileType.EXTRAFANART)))) {
            ArrayList<String> extrafanarts = new ArrayList<String>();
            if (MovieModuleManager.getInstance().getSettings().isImageExtraFanart() && MovieModuleManager.getInstance().getSettings().getImageExtraFanartCount() > 0) {
                sortedFanarts = MovieArtworkHelper.sortArtworkUrls(artwork, MediaArtwork.MediaArtworkType.BACKGROUND, MovieModuleManager.getInstance().getSettings().getImageFanartSize().getOrder());
                for (MediaArtwork.ImageSizeAndUrl art : sortedFanarts) {
                    if (MovieModuleManager.getInstance().getSettings().getImageFanartSize() != MediaArtwork.FanartSizes.SMALL && art.getHeight() < 720 || art.getUrl().equals(movie.getArtworkUrl(MediaFileType.FANART))) continue;
                    extrafanarts.add(art.getUrl());
                    if (extrafanarts.size() < MovieModuleManager.getInstance().getSettings().getImageExtraFanartCount()) continue;
                    break;
                }
                movie.setExtraFanarts(extrafanarts);
                if (!extrafanarts.isEmpty() && !movie.isMultiMovieDir()) {
                    MovieArtworkHelper.downloadArtwork(movie, MediaFileType.EXTRAFANART);
                }
            }
        }
        movie.saveToDb();
        movie.writeNFO();
    }

    private static void setBestPoster(Movie movie, List<MediaArtwork> artwork, boolean overwrite) {
        boolean posterFound = false;
        if (!overwrite && StringUtils.isNotBlank((CharSequence)movie.getArtworkUrl(MediaFileType.POSTER))) {
            posterFound = true;
        } else {
            int preferredSizeOrder = MovieModuleManager.getInstance().getSettings().getImagePosterSize().getOrder();
            List<MediaArtwork.ImageSizeAndUrl> sortedPosters = MovieArtworkHelper.sortArtworkUrls(artwork, MediaArtwork.MediaArtworkType.POSTER, preferredSizeOrder);
            if (!sortedPosters.isEmpty()) {
                MediaArtwork.ImageSizeAndUrl foundPoster = sortedPosters.get(0);
                movie.setArtworkUrl(foundPoster.getUrl(), MediaFileType.POSTER);
                posterFound = true;
            }
        }
        if (posterFound && !MovieModuleManager.getInstance().getSettings().getPosterFilenames().isEmpty()) {
            MovieArtworkHelper.downloadArtwork(movie, MediaFileType.POSTER);
        }
    }

    private static void setBestFanart(Movie movie, List<MediaArtwork> artwork, boolean overwrite) {
        boolean fanartFound = false;
        if (!overwrite && StringUtils.isNotBlank((CharSequence)movie.getArtworkUrl(MediaFileType.POSTER))) {
            fanartFound = true;
        } else {
            int preferredSizeOrder = MovieModuleManager.getInstance().getSettings().getImageFanartSize().getOrder();
            MediaArtwork.ImageSizeAndUrl fanartWoText = null;
            if (MovieModuleManager.getInstance().getSettings().isImageScraperPreferFanartWoText()) {
                block0: for (MediaArtwork art : artwork) {
                    if (art.getType() != MediaArtwork.MediaArtworkType.BACKGROUND || !StringUtils.isBlank((CharSequence)art.getLanguage())) continue;
                    for (MediaArtwork.ImageSizeAndUrl imageSizeAndUrl : art.getImageSizes()) {
                        if (imageSizeAndUrl.getSizeOrder() != preferredSizeOrder) continue;
                        fanartWoText = imageSizeAndUrl;
                        continue block0;
                    }
                }
            }
            List<MediaArtwork.ImageSizeAndUrl> sortedFanarts = MovieArtworkHelper.sortArtworkUrls(artwork, MediaArtwork.MediaArtworkType.BACKGROUND, preferredSizeOrder);
            if (fanartWoText != null) {
                sortedFanarts.add(0, fanartWoText);
            }
            if (!sortedFanarts.isEmpty()) {
                MediaArtwork.ImageSizeAndUrl foundfanart = sortedFanarts.get(0);
                movie.setArtworkUrl(foundfanart.getUrl(), MediaFileType.FANART);
                fanartFound = true;
            }
        }
        if (fanartFound && !MovieModuleManager.getInstance().getSettings().getFanartFilenames().isEmpty()) {
            MovieArtworkHelper.downloadArtwork(movie, MediaFileType.FANART);
        }
    }

    public static List<MediaArtwork.ImageSizeAndUrl> sortArtworkUrls(List<MediaArtwork> artwork, MediaArtwork.MediaArtworkType type, int sizeOrder) {
        ArrayList<MediaArtwork> artworkForType = new ArrayList<MediaArtwork>(artwork.stream().filter(art -> !"ffmpeg".equalsIgnoreCase(art.getProviderId()) && art.getType() == type).sorted((o1, o2) -> o2.getLikes() - o1.getLikes()).toList());
        ArrayList<MediaArtwork> artworkFromFfmpeg = new ArrayList<MediaArtwork>(artwork.stream().filter(art -> "ffmpeg".equalsIgnoreCase(art.getProviderId()) && art.getType() == type).sorted((o1, o2) -> o2.getLikes() - o1.getLikes()).toList());
        MediaArtwork ffmpegArtwork = null;
        if (!artworkFromFfmpeg.isEmpty()) {
            ffmpegArtwork = (MediaArtwork)artworkFromFfmpeg.get(artworkFromFfmpeg.size() / 2 + 1);
        }
        if (artworkForType.isEmpty() && ffmpegArtwork == null) {
            return Collections.emptyList();
        }
        ArrayList<MediaArtwork.ImageSizeAndUrl> sortedArtwork = new ArrayList<MediaArtwork.ImageSizeAndUrl>();
        if (sizeOrder == 0) {
            artworkForType.sort((o1, o2) -> {
                int result = Integer.compare(o2.getBiggestArtwork().getWidth(), o1.getBiggestArtwork().getWidth());
                if (result == 0) {
                    result = o2.getLikes() - o1.getLikes();
                }
                return result;
            });
        }
        List<MediaLanguages> languages = MovieSettings.getInstance().getImageScraperLanguages();
        for (MediaLanguages mediaLanguages : languages) {
            for (MediaArtwork mediaArtwork : artworkForType.stream().filter(art -> art.getLanguage().equals(language.getLanguage())).toList()) {
                for (MediaArtwork.ImageSizeAndUrl imageSizeAndUrl : mediaArtwork.getImageSizes()) {
                    if (imageSizeAndUrl.getSizeOrder() != sizeOrder || sortedArtwork.contains(imageSizeAndUrl)) continue;
                    sortedArtwork.add(imageSizeAndUrl);
                }
            }
        }
        if (sortedArtwork.isEmpty()) {
            for (MediaArtwork mediaArtwork : artworkForType.stream().filter(art -> art.getLanguage().isEmpty()).toList()) {
                for (MediaArtwork.ImageSizeAndUrl imageSizeAndUrl : mediaArtwork.getImageSizes()) {
                    if (imageSizeAndUrl.getSizeOrder() != sizeOrder || sortedArtwork.contains(imageSizeAndUrl)) continue;
                    sortedArtwork.add(imageSizeAndUrl);
                }
            }
        }
        if (sortedArtwork.isEmpty() && ffmpegArtwork != null) {
            for (MediaArtwork.ImageSizeAndUrl imageSizeAndUrl : ffmpegArtwork.getImageSizes()) {
                if (imageSizeAndUrl.getSizeOrder() != sizeOrder || sortedArtwork.contains(imageSizeAndUrl)) continue;
                sortedArtwork.add(imageSizeAndUrl);
            }
        }
        if (sortedArtwork.isEmpty() && MovieModuleManager.getInstance().getSettings().isImageScraperOtherResolutions()) {
            int newOrder = 32;
            while (newOrder > 1) {
                newOrder /= 2;
                for (MediaLanguages language : languages) {
                    for (MediaArtwork art4 : artworkForType.stream().filter(art -> art.getLanguage().equals(language.getLanguage())).toList()) {
                        for (MediaArtwork.ImageSizeAndUrl imageSizeAndUrl : art4.getImageSizes()) {
                            if (imageSizeAndUrl.getSizeOrder() != newOrder || sortedArtwork.contains(imageSizeAndUrl)) continue;
                            sortedArtwork.add(imageSizeAndUrl);
                        }
                    }
                }
            }
        }
        if (sortedArtwork.isEmpty() && MovieModuleManager.getInstance().getSettings().isImageScraperOtherResolutions()) {
            int newOrder = 32;
            while (newOrder > 1) {
                newOrder /= 2;
                if (ffmpegArtwork == null) continue;
                for (MediaArtwork.ImageSizeAndUrl imageSizeAndUrl : ffmpegArtwork.getImageSizes()) {
                    if (imageSizeAndUrl.getSizeOrder() != newOrder || sortedArtwork.contains(imageSizeAndUrl)) continue;
                    sortedArtwork.add(imageSizeAndUrl);
                }
            }
        }
        if (sortedArtwork.isEmpty() && ffmpegArtwork != null) {
            sortedArtwork.addAll(ffmpegArtwork.getImageSizes());
        }
        if (MovieModuleManager.getInstance().getSettings().isImageScraperFallback()) {
            for (MediaArtwork mediaArtwork : artworkForType) {
                for (MediaArtwork.ImageSizeAndUrl imageSizeAndUrl : mediaArtwork.getImageSizes()) {
                    if (sortedArtwork.contains(imageSizeAndUrl)) continue;
                    sortedArtwork.add(imageSizeAndUrl);
                }
            }
        }
        return sortedArtwork;
    }

    public static int getMatchingScoreAccordingPreferences(MediaArtwork ma) {
        List<MediaLanguages> languages = MovieModuleManager.getInstance().getSettings().getImageScraperLanguages();
        int size = 0;
        switch (ma.getType()) {
            case POSTER: 
            case KEYART: {
                size = MovieModuleManager.getInstance().getSettings().getImagePosterSize().getOrder();
                break;
            }
            default: {
                size = MovieModuleManager.getInstance().getSettings().getImageFanartSize().getOrder();
            }
        }
        boolean preferFanartWoText = MovieModuleManager.getInstance().getSettings().isImageScraperPreferFanartWoText();
        int score = ma.getMatchingScoreAccordingPreferences(size, languages, preferFanartWoText);
        return score;
    }

    private static void setBestArtwork(Movie movie, List<MediaArtwork> artwork, MediaArtwork.MediaArtworkType type, boolean download, boolean overwrite) {
        boolean artworkFound = false;
        if (!overwrite && StringUtils.isNotBlank((CharSequence)movie.getArtworkUrl(MediaFileType.getMediaFileType(type)))) {
            artworkFound = true;
        } else {
            int preferredSizeOrder = 32;
            List<MediaArtwork.ImageSizeAndUrl> sortedArtworks = MovieArtworkHelper.sortArtworkUrls(artwork, type, preferredSizeOrder);
            if (!sortedArtworks.isEmpty()) {
                MediaArtwork.ImageSizeAndUrl bestArtwork = sortedArtworks.get(0);
                movie.setArtworkUrl(bestArtwork.getUrl(), MediaFileType.getMediaFileType(type));
                artworkFound = true;
            }
        }
        if (download && artworkFound) {
            MovieArtworkHelper.downloadArtwork(movie, MediaFileType.getMediaFileType(type));
        }
    }

    public static void cleanupArtwork(Movie movie, List<MovieScraperMetadataConfig> metadataConfig) {
        if (!ScraperMetadataConfig.containsAnyArtwork(metadataConfig)) {
            return;
        }
        for (MovieScraperMetadataConfig config : metadataConfig) {
            List<MediaFile> mediaFiles;
            MediaFileType type = MovieArtworkHelper.getMediaFileTypeForConfig(config);
            if (type == null || (mediaFiles = movie.getMediaFiles(type)).isEmpty()) continue;
            List<IFileNaming> fileNamings = MovieArtworkHelper.getFileNamingsForMediaFileType(movie, type);
            MediaFile baseArtwork = mediaFiles.get(0);
            for (IFileNaming fileNaming : fileNamings) {
                boolean ok;
                MediaFile otherArtwork;
                String filename = MovieArtworkHelper.getArtworkFilename(movie, fileNaming, baseArtwork.getExtension());
                if (!StringUtils.isNotBlank((CharSequence)filename) || mediaFiles.contains(otherArtwork = new MediaFile(movie.getPathNIO().resolve(filename))) || !(ok = MovieRenamer.copyFile(baseArtwork.getFileAsPath(), otherArtwork.getFileAsPath()))) continue;
                movie.addToMediaFiles(otherArtwork);
            }
        }
    }

    private static MediaFileType getMediaFileTypeForConfig(MovieScraperMetadataConfig config) {
        MediaFileType type;
        block3: {
            if (!config.isArtwork()) {
                return null;
            }
            type = null;
            try {
                type = MediaFileType.valueOf(config.name());
            }
            catch (Exception ignored) {
                if (config != MovieScraperMetadataConfig.DISCART) break block3;
                type = MediaFileType.DISC;
            }
        }
        return type;
    }

    private static List<IFileNaming> getFileNamingsForMediaFileType(Movie movie, MediaFileType type) {
        ArrayList<IFileNaming> fileNamings = new ArrayList<IFileNaming>(0);
        switch (type) {
            case FANART: {
                fileNamings.addAll(MovieArtworkHelper.getFanartNamesForMovie(movie));
                break;
            }
            case POSTER: {
                fileNamings.addAll(MovieArtworkHelper.getPosterNamesForMovie(movie));
                break;
            }
            case CLEARLOGO: {
                fileNamings.addAll(MovieArtworkHelper.getClearlogoNamesForMovie(movie));
                break;
            }
            case BANNER: {
                fileNamings.addAll(MovieArtworkHelper.getBannerNamesForMovie(movie));
                break;
            }
            case CLEARART: {
                fileNamings.addAll(MovieArtworkHelper.getClearartNamesForMovie(movie));
                break;
            }
            case THUMB: {
                fileNamings.addAll(MovieArtworkHelper.getThumbNamesForMovie(movie));
                break;
            }
            case DISC: {
                fileNamings.addAll(MovieArtworkHelper.getDiscartNamesForMovie(movie));
                break;
            }
            case KEYART: {
                fileNamings.addAll(MovieArtworkHelper.getKeyartNamesForMovie(movie));
                break;
            }
        }
        return fileNamings;
    }

    public static boolean extractBlurayPosters(Movie movie) {
        Path dlFolder = movie.getPathNIO().resolve("BDMV/META/DL/");
        if (Files.exists(dlFolder, new LinkOption[0])) {
            List<Path> files = Utils.listFiles(dlFolder);
            MediaFile largestPoster = null;
            for (Path file : files) {
                MediaFile mf = new MediaFile(file);
                if (!mf.isGraphic()) continue;
                MediaFileHelper.gatherFileInformation(mf);
                if (largestPoster != null && largestPoster.getFilesize() >= mf.getFilesize()) continue;
                largestPoster = mf;
            }
            if (largestPoster != null && MovieModuleManager.getInstance().getSettings().isExtractArtworkFromVsmeta()) {
                try {
                    Path newFile = movie.getPathNIO().resolve("BDMV-poster." + largestPoster.getExtension());
                    Utils.copyFileSafe(largestPoster.getFileAsPath(), newFile);
                    MediaFile poster = new MediaFile(newFile);
                    movie.addToMediaFiles(poster);
                }
                catch (IOException e) {
                    LOGGER.trace("Could not extract Bluray poster: {}", (Object)e.getMessage());
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean extractArtworkFromVsmeta(Movie movie, MediaFile vsMetaFile, MediaArtwork.MediaArtworkType artworkType) {
        byte[] bytes;
        List<Enum> fileNamings;
        VSMeta vsmeta = new VSMeta(vsMetaFile.getFileAsPath());
        vsmeta.parseFile();
        switch (artworkType) {
            case POSTER: {
                fileNamings = MovieModuleManager.getInstance().getSettings().getPosterFilenames();
                bytes = vsmeta.getPosterBytes();
                break;
            }
            case BACKGROUND: {
                fileNamings = MovieModuleManager.getInstance().getSettings().getFanartFilenames();
                bytes = vsmeta.getBackdropBytes();
                break;
            }
            default: {
                return false;
            }
        }
        if (fileNamings.isEmpty() || bytes.length == 0) {
            return false;
        }
        String basename = FilenameUtils.getBaseName((String)FilenameUtils.getBaseName((String)vsMetaFile.getFilename()));
        for (IFileNaming iFileNaming : fileNamings) {
            try {
                String filename = iFileNaming.getFilename(basename, "jpg");
                MediaFile mf = new MediaFile(vsMetaFile.getFileAsPath().getParent().resolve(filename), MediaFileType.getMediaFileType(artworkType));
                Files.write(mf.getFileAsPath(), bytes, new OpenOption[0]);
                movie.addToMediaFiles(mf);
            }
            catch (Exception e) {
                LOGGER.warn("could not extract VSMETA artwork: {}", (Object)e.getMessage());
            }
        }
        return true;
    }

    public static int getIndexOfArtwork(String filename) {
        String basename = FilenameUtils.getBaseName((String)filename);
        Matcher matcher = INDEX_PATTERN.matcher(basename);
        if (matcher.find() && matcher.groupCount() == 1) {
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (Exception e) {
                LOGGER.debug("could not parse index of '{}'- {}", (Object)filename, (Object)e.getMessage());
            }
        }
        return -1;
    }
}

