/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;

public class MovieRenamerPreviewContainer {
    final Movie movie;
    final Path oldPath;
    final List<MediaFile> oldMediaFiles;
    final List<MediaFile> newMediaFiles;
    Path newPath;
    boolean needsRename = false;

    public MovieRenamerPreviewContainer(Movie movie) {
        this.movie = movie;
        this.oldMediaFiles = new ArrayList<MediaFile>();
        this.newMediaFiles = new ArrayList<MediaFile>();
        this.oldPath = movie != null && !movie.getDataSource().isEmpty() ? Paths.get(movie.getDataSource(), new String[0]).relativize(movie.getPathNIO()) : null;
    }

    public Movie getMovie() {
        return this.movie;
    }

    public Path getOldPath() {
        return this.oldPath;
    }

    public Path getOldPathRelative() {
        return Paths.get(this.movie.getDataSource(), new String[0]).relativize(this.movie.getPathNIO());
    }

    public Path getNewPath() {
        return this.newPath;
    }

    public Path getNewPathRelative() {
        return Paths.get(this.movie.getDataSource(), new String[0]).relativize(this.newPath);
    }

    public List<MediaFile> getOldMediaFiles() {
        return this.oldMediaFiles;
    }

    public List<MediaFile> getNewMediaFiles() {
        return this.newMediaFiles;
    }

    public boolean isNeedsRename() {
        return this.needsRename;
    }
}

