/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.UpgradeTasks;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;

public class MovieUpgradeTasks
extends UpgradeTasks {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieUpgradeTasks.class);

    @Override
    public void performDbUpgrades() {
        MovieModuleManager module = MovieModuleManager.getInstance();
        MovieList movieList = module.getMovieList();
        if (module.getDbVersion() == 0) {
            module.setDbVersion(5000);
        }
        LOGGER.info("Current movie DB version: {}", (Object)module.getDbVersion());
        if (module.getDbVersion() < 5001) {
            LOGGER.info("performing upgrade to ver: {}", (Object)5001);
            for (Movie movie : movieList.getMovies()) {
                for (MediaFile mf : movie.getMediaFiles(MediaFileType.LOGO)) {
                    movie.removeFromMediaFiles(mf);
                    mf.setType(MediaFileType.CLEARLOGO);
                    movie.addToMediaFiles(mf);
                }
                String logoUrl = movie.getArtworkUrl(MediaFileType.LOGO);
                if (StringUtils.isNotBlank((CharSequence)logoUrl)) {
                    movie.removeArtworkUrl(MediaFileType.LOGO);
                    String clearlogoUrl = movie.getArtworkUrl(MediaFileType.CLEARLOGO);
                    if (StringUtils.isBlank((CharSequence)clearlogoUrl)) {
                        movie.setArtworkUrl(logoUrl, MediaFileType.CLEARLOGO);
                    }
                }
                this.registerForSaving(movie);
            }
            module.setDbVersion(5001);
        }
        if (module.getDbVersion() < 5003) {
            LOGGER.info("performing upgrade to ver: {}", (Object)5003);
            for (Movie movie : movieList.getMovies()) {
                if (!MovieUpgradeTasks.fixRatings(movie)) continue;
                this.registerForSaving(movie);
            }
            module.setDbVersion(5003);
        }
        if (module.getDbVersion() < 5004) {
            LOGGER.info("performing upgrade to ver: {}", (Object)5004);
            for (Movie movie : movieList.getMovies()) {
                if (!MovieUpgradeTasks.fixHDR(movie)) continue;
                this.registerForSaving(movie);
            }
            module.setDbVersion(5004);
        }
        this.saveAll();
    }

    @Override
    protected void saveAll() {
        for (MediaEntity mediaEntity : this.entitiesToSave) {
            if (mediaEntity instanceof Movie) {
                Movie movie = (Movie)mediaEntity;
                MovieModuleManager.getInstance().persistMovie(movie);
                continue;
            }
            if (!(mediaEntity instanceof MovieSet)) continue;
            MovieSet movieSet = (MovieSet)mediaEntity;
            MovieModuleManager.getInstance().persistMovieSet(movieSet);
        }
    }
}

