/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.connector;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaSource;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieEdition;
import org.tinymediamanager.core.movie.MovieHelpers;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.ParserUtils;
import org.tinymediamanager.scraper.util.StrgUtils;

public class MovieNfoParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieNfoParser.class);
    private Element root;
    private final List<String> supportedElements = new ArrayList<String>();
    public String title = "";
    public String originaltitle = "";
    public String sorttitle = "";
    public int year = -1;
    public int top250 = 0;
    public String plot = "";
    public String outline = "";
    public String tagline = "";
    public int runtime = 0;
    public MediaCertification certification = MediaCertification.UNKNOWN;
    public Date releaseDate = null;
    public boolean watched = false;
    public int playcount = 0;
    public String languages = "";
    public MediaSource source = MediaSource.UNKNOWN;
    public MovieEdition edition = MovieEdition.NONE;
    public String originalFilename = "";
    public String userNote = "";
    public Map<String, Object> ids = new HashMap<String, Object>();
    public Map<String, Rating> ratings = new HashMap<String, Rating>();
    public List<Set> sets = new ArrayList<Set>();
    public List<String> posters = new ArrayList<String>();
    public List<String> banners = new ArrayList<String>();
    public List<String> cleararts = new ArrayList<String>();
    public List<String> clearlogos = new ArrayList<String>();
    public List<String> discarts = new ArrayList<String>();
    public List<String> thumbs = new ArrayList<String>();
    public List<String> keyarts = new ArrayList<String>();
    public List<String> logos = new ArrayList<String>();
    public List<String> fanarts = new ArrayList<String>();
    public List<MediaGenres> genres = new ArrayList<MediaGenres>();
    public List<String> countries = new ArrayList<String>();
    public List<String> studios = new ArrayList<String>();
    public List<String> tags = new ArrayList<String>();
    public List<Person> actors = new ArrayList<Person>();
    public List<Person> producers = new ArrayList<Person>();
    public List<Person> directors = new ArrayList<Person>();
    public List<Person> credits = new ArrayList<Person>();
    public List<String> showlinks = new ArrayList<String>();
    public List<String> trailers = new ArrayList<String>();
    public List<String> unsupportedElements = new ArrayList<String>();
    public Fileinfo fileinfo = null;
    public String epbookmark = "";
    public Date lastplayed = null;
    public String status = "";
    public String code = "";
    public Date dateadded = null;

    private MovieNfoParser(Document document) {
        document.outputSettings().prettyPrint(false);
        Elements elements = document.select("movie");
        if (!elements.isEmpty()) {
            this.parseKodiNfo((Element)elements.get(0));
            return;
        }
        elements = document.select("recording");
        if (!elements.isEmpty()) {
            this.parseNextpvrXml((Element)elements.get(0));
            return;
        }
    }

    private void parseKodiNfo(Element root) {
        this.root = root;
        this.parseTag(MovieNfoParser::parseTitle);
        this.parseTag(MovieNfoParser::parseOriginalTitle);
        this.parseTag(MovieNfoParser::parseSorttitle);
        this.parseTag(MovieNfoParser::parseRatingAndVotes);
        this.parseTag(MovieNfoParser::parseSet);
        this.parseTag(MovieNfoParser::parseYear);
        this.parseTag(MovieNfoParser::parseTop250);
        this.parseTag(MovieNfoParser::parsePlot);
        this.parseTag(MovieNfoParser::parseOutline);
        this.parseTag(MovieNfoParser::parseTagline);
        this.parseTag(MovieNfoParser::parseRuntime);
        this.parseTag(MovieNfoParser::parseThumbs);
        this.parseTag(MovieNfoParser::parseFanarts);
        this.parseTag(MovieNfoParser::parseCertification);
        this.parseTag(MovieNfoParser::parseIds);
        this.parseTag(MovieNfoParser::parseCountry);
        this.parseTag(MovieNfoParser::parseReleaseDate);
        this.parseTag(MovieNfoParser::parseWatchedAndPlaycount);
        this.parseTag(MovieNfoParser::parseGenres);
        this.parseTag(MovieNfoParser::parseStudios);
        this.parseTag(MovieNfoParser::parseCredits);
        this.parseTag(MovieNfoParser::parseDirectors);
        this.parseTag(MovieNfoParser::parseTags);
        this.parseTag(MovieNfoParser::parseActors);
        this.parseTag(MovieNfoParser::parseProducers);
        this.parseTag(MovieNfoParser::parseFileinfo);
        this.parseTag(MovieNfoParser::parseLanguages);
        this.parseTag(MovieNfoParser::parseSource);
        this.parseTag(MovieNfoParser::parseEdition);
        this.parseTag(MovieNfoParser::parseTrailer);
        this.parseTag(MovieNfoParser::parseShowlink);
        this.parseTag(MovieNfoParser::parseEpbookmark);
        this.parseTag(MovieNfoParser::parseLastplayed);
        this.parseTag(MovieNfoParser::parseStatus);
        this.parseTag(MovieNfoParser::parseCode);
        this.parseTag(MovieNfoParser::parseDateadded);
        this.parseTag(MovieNfoParser::parseOriginalFilename);
        this.parseTag(MovieNfoParser::parseUserNote);
        this.parseTag(MovieNfoParser::findUnsupportedElements);
    }

    private void parseNextpvrXml(Element root) {
        this.root = root;
        this.parseTag(MovieNfoParser::parseTitle);
        this.parseTag(MovieNfoParser::parseDescription);
        this.parseTag(MovieNfoParser::parseCertificationInRating);
        this.parseTag(MovieNfoParser::parseGenres);
    }

    private void parseTag(Function<MovieNfoParser, Void> function) {
        try {
            function.apply(this);
        }
        catch (Exception e) {
            LOGGER.warn("problem parsing tag (line {}): {}", (Object)e.getStackTrace()[0].getLineNumber(), (Object)e.getMessage());
        }
    }

    public static MovieNfoParser parseNfo(Path path) throws Exception {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            MovieNfoParser movieNfoParser = new MovieNfoParser(Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"", (Parser)Parser.xmlParser()));
            return movieNfoParser;
        }
    }

    public static MovieNfoParser parseNfo(String content) {
        return new MovieNfoParser(Jsoup.parse((String)content, (String)"", (Parser)Parser.xmlParser()));
    }

    public boolean isValidNfo() {
        return StringUtils.isNotBlank((CharSequence)this.title);
    }

    private Element getSingleElement(Element parent, String tag) {
        Elements elements = parent.select(parent.tagName() + " > " + tag);
        if (elements.size() != 1) {
            return null;
        }
        return (Element)elements.get(0);
    }

    private Elements getMultipleElements(Element parent, String tag) {
        return parent.select(parent.tagName() + " > " + tag);
    }

    private Void parseTitle() {
        this.supportedElements.add("title");
        Element element = this.getSingleElement(this.root, "title");
        if (element != null) {
            this.title = element.ownText();
        }
        return null;
    }

    private Void parseOriginalTitle() {
        this.supportedElements.add("originaltitle");
        Element element = this.getSingleElement(this.root, "originaltitle");
        if (element != null) {
            this.originaltitle = element.ownText();
        }
        return null;
    }

    private Void parseSorttitle() {
        this.supportedElements.add("sorttitle");
        Element element = this.getSingleElement(this.root, "sorttitle");
        if (element != null) {
            this.sorttitle = element.ownText();
        }
        return null;
    }

    private Void parseRatingAndVotes() {
        Object r;
        this.supportedElements.add("rating");
        this.supportedElements.add("userrating");
        this.supportedElements.add("ratings");
        this.supportedElements.add("votes");
        this.supportedElements.add("criticrating");
        Element element = this.getSingleElement(this.root, "rating");
        if (element != null) {
            r = new Rating();
            ((Rating)r).id = "NFO";
            try {
                ((Rating)r).rating = Float.parseFloat(element.ownText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            element = this.getSingleElement(this.root, "votes");
            if (element != null) {
                try {
                    ((Rating)r).votes = MetadataUtil.parseInt(element.ownText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (((Rating)r).rating > 0.0f) {
                this.ratings.put(((Rating)r).id, (Rating)r);
            }
        }
        if ((element = this.getSingleElement(this.root, "userrating")) != null) {
            try {
                r = new Rating();
                ((Rating)r).id = "user";
                ((Rating)r).rating = Float.parseFloat(element.ownText());
                if (((Rating)r).rating > 0.0f) {
                    this.ratings.put(((Rating)r).id, (Rating)r);
                }
            }
            catch (Exception r2) {
                // empty catch block
            }
        }
        if ((element = this.getSingleElement(this.root, "ratings")) != null) {
            for (Element ratingChild : element.select(element.tagName() + " > rating")) {
                Rating r3 = new Rating();
                r3.id = ratingChild.attr("name");
                if ("themoviedb".equals(r3.id)) {
                    r3.id = "tmdb";
                } else if ("rottenTomatoes".equals(r3.id)) {
                    r3.id = "tomatometerallcritics";
                } else if ("metascore".equals(r3.id)) {
                    r3.id = "metacritic";
                }
                try {
                    r3.maxValue = MetadataUtil.parseInt(ratingChild.attr("max"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                for (Element child : ratingChild.children()) {
                    switch (child.tagName()) {
                        case "value": {
                            try {
                                r3.rating = Float.parseFloat(child.ownText());
                            }
                            catch (NumberFormatException numberFormatException) {}
                            break;
                        }
                        case "votes": {
                            try {
                                r3.votes = MetadataUtil.parseInt(child.ownText());
                            }
                            catch (Exception exception) {}
                            break;
                        }
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)r3.id) || !(r3.rating > 0.0f)) continue;
                this.ratings.put(r3.id, r3);
            }
        }
        if ((element = this.getSingleElement(this.root, "criticrating")) != null) {
            r = new Rating();
            ((Rating)r).id = "tomatometerallcritics";
            ((Rating)r).rating = MetadataUtil.parseInt(element.ownText(), 0);
            ((Rating)r).maxValue = 100;
            if (StringUtils.isNotBlank((CharSequence)((Rating)r).id) && ((Rating)r).rating > 0.0f) {
                this.ratings.put(((Rating)r).id, (Rating)r);
            }
        }
        return null;
    }

    private Void parseSet() {
        this.supportedElements.add("sets");
        this.supportedElements.add("set");
        Element element = this.getSingleElement(this.root, "sets");
        if (element != null) {
            for (Element child : this.getMultipleElements(element, "set")) {
                if (!StringUtils.isNotBlank((CharSequence)child.ownText())) continue;
                Set set = new Set();
                set.name = child.ownText();
                this.sets.add(set);
            }
        } else {
            for (Element child : this.getMultipleElements(this.root, "set")) {
                if (!child.children().isEmpty()) {
                    Set tmp = new Set();
                    if (StringUtils.isNotBlank((CharSequence)child.attr("tmdbcolid"))) {
                        tmp.tmdbId = MetadataUtil.parseInt(child.attr("tmdbcolid"), 0);
                    }
                    for (Element setChild : child.children()) {
                        switch (setChild.tagName()) {
                            case "name": 
                            case "setname": {
                                tmp.name = setChild.ownText();
                                break;
                            }
                            case "overview": 
                            case "setdescription": {
                                tmp.overview = setChild.ownText();
                                break;
                            }
                        }
                    }
                    if (!StringUtils.isNotBlank((CharSequence)tmp.name)) continue;
                    this.sets.add(tmp);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)child.ownText())) continue;
                Set set = new Set();
                set.name = child.ownText();
                set.overview = "";
                if (StringUtils.isNotBlank((CharSequence)child.attr("tmdbcolid"))) {
                    set.tmdbId = MetadataUtil.parseInt(child.attr("tmdbcolid"), 0);
                }
                this.sets.add(set);
            }
        }
        return null;
    }

    private Void parseYear() {
        this.supportedElements.add("year");
        Element element = this.getSingleElement(this.root, "year");
        if (element != null) {
            try {
                this.year = MetadataUtil.parseInt(element.ownText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Void parseTop250() {
        this.supportedElements.add("top250");
        Element element = this.getSingleElement(this.root, "top250");
        if (element != null) {
            try {
                this.top250 = MetadataUtil.parseInt(element.ownText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Void parsePlot() {
        this.supportedElements.add("plot");
        Element element = this.getSingleElement(this.root, "plot");
        if (element != null) {
            this.plot = element.wholeText();
        }
        return null;
    }

    private Void parseDescription() {
        this.supportedElements.add("description");
        Element element = this.getSingleElement(this.root, "description");
        if (element != null) {
            this.plot = element.wholeText();
        }
        return null;
    }

    private Void parseOutline() {
        this.supportedElements.add("outline");
        Element element = this.getSingleElement(this.root, "outline");
        if (element != null) {
            this.outline = element.wholeText();
        }
        return null;
    }

    private Void parseTagline() {
        this.supportedElements.add("tagline");
        Element element = this.getSingleElement(this.root, "tagline");
        if (element != null) {
            this.tagline = element.wholeText();
        }
        return null;
    }

    private Void parseRuntime() {
        this.supportedElements.add("runtime");
        Element element = this.getSingleElement(this.root, "runtime");
        if (element != null) {
            try {
                this.runtime = MetadataUtil.parseInt(element.ownText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Void parseThumbs() {
        this.supportedElements.add("thumb");
        Elements thumb = this.root.select(this.root.tagName() + " > thumb");
        for (Element element : thumb) {
            String aspect = element.attr("aspect");
            String url = element.ownText();
            if (StringUtils.isBlank((CharSequence)url) || !url.matches("https?://.*")) continue;
            if (StringUtils.isBlank((CharSequence)aspect)) {
                this.posters.add(element.ownText());
                continue;
            }
            switch (aspect) {
                case "poster": {
                    this.posters.add(element.ownText());
                    break;
                }
                case "banner": {
                    this.banners.add(element.ownText());
                    break;
                }
                case "clearart": {
                    this.cleararts.add(element.ownText());
                    break;
                }
                case "clearlogo": {
                    this.clearlogos.add(element.ownText());
                    break;
                }
                case "discart": {
                    this.discarts.add(element.ownText());
                    break;
                }
                case "landscape": {
                    this.thumbs.add(element.ownText());
                    break;
                }
                case "keyart": {
                    this.keyarts.add(element.ownText());
                    break;
                }
                case "logo": {
                    this.logos.add(element.ownText());
                    break;
                }
            }
        }
        return null;
    }

    private Void parseFanarts() {
        this.supportedElements.add("fanart");
        Element fanart = this.getSingleElement(this.root, "fanart");
        if (fanart != null) {
            Elements thumb = fanart.select(fanart.tagName() + " > thumb");
            if (!thumb.isEmpty()) {
                for (Element element : thumb) {
                    if (!StringUtils.isNotBlank((CharSequence)element.ownText()) || !element.ownText().matches("https?://.*")) continue;
                    this.fanarts.add(element.ownText());
                }
            } else if (StringUtils.isNotBlank((CharSequence)fanart.ownText()) && fanart.ownText().matches("https?://.*")) {
                this.fanarts.add(fanart.ownText());
            }
        }
        return null;
    }

    private Void parseCertification() {
        this.supportedElements.add("certification");
        this.supportedElements.add("mpaa");
        Element element = this.getSingleElement(this.root, "certification");
        if (element == null || StringUtils.isBlank((CharSequence)element.ownText())) {
            element = this.getSingleElement(this.root, "mpaa");
        }
        if (element != null) {
            this.certification = MovieHelpers.parseCertificationStringForMovieSetupCountry(element.ownText());
        }
        return null;
    }

    private Void parseCertificationInRating() {
        this.supportedElements.add("rating");
        Element element = this.getSingleElement(this.root, "rating");
        if (element != null) {
            this.certification = MovieHelpers.parseCertificationStringForMovieSetupCountry(element.ownText());
        }
        return null;
    }

    private Void parseIds() {
        Elements children;
        this.supportedElements.add("id");
        this.supportedElements.add("imdb");
        this.supportedElements.add("imdbid");
        this.supportedElements.add("tmdbid");
        this.supportedElements.add("ids");
        this.supportedElements.add("tmdbcollectionid");
        this.supportedElements.add("tmdbCollectionId");
        this.supportedElements.add("uniqueid");
        Element element = this.getSingleElement(this.root, "id");
        if (element != null && MediaIdUtil.isValidImdbId(element.ownText())) {
            this.ids.put("imdb", element.ownText());
        }
        if ((element = this.getSingleElement(this.root, "imdb")) != null && MediaIdUtil.isValidImdbId(element.ownText())) {
            this.ids.putIfAbsent("imdb", element.ownText());
        }
        if ((element = this.getSingleElement(this.root, "imdbid")) != null && MediaIdUtil.isValidImdbId(element.ownText())) {
            this.ids.putIfAbsent("imdb", element.ownText());
        }
        if ((element = this.getSingleElement(this.root, "tmdbId")) != null) {
            try {
                this.ids.put("tmdb", MetadataUtil.parseInt(element.ownText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Elements elements = this.root.select(this.root.tagName() + " > uniqueid");
        for (Element id : elements) {
            try {
                String value;
                String key = id.attr("type");
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key, value = id.ownText()})) continue;
                try {
                    this.ids.put(key, MetadataUtil.parseInt(value));
                }
                catch (Exception e) {
                    this.ids.put(key, value);
                }
            }
            catch (Exception key) {}
        }
        element = this.getSingleElement(this.root, "ids");
        if (element != null) {
            children = element.select(element.tagName() + " > entry");
            for (Element entry : children) {
                Element key = this.getSingleElement(entry, "key");
                Element value = this.getSingleElement(entry, "value");
                if (key == null || value == null || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key.ownText(), value.ownText()})) continue;
                try {
                    this.ids.put(key.ownText(), MetadataUtil.parseInt(value.ownText()));
                }
                catch (Exception e) {
                    this.ids.put(key.ownText(), value.ownText());
                }
            }
        }
        if ((element = this.getSingleElement(this.root, "ids")) != null) {
            children = element.children();
            for (Element entry : children) {
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{entry.tagName(), entry.ownText()})) continue;
                try {
                    this.ids.put(entry.tagName(), MetadataUtil.parseInt(entry.ownText()));
                }
                catch (Exception e) {
                    this.ids.put(entry.tagName(), entry.ownText());
                }
            }
        }
        if ((element = this.getSingleElement(this.root, "tmdbCollectionId")) != null) {
            try {
                this.ids.put("tmdbSet", MetadataUtil.parseInt(element.ownText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private Void parseCountry() {
        this.supportedElements.add("country");
        Elements elements = this.root.select(this.root.tagName() + " > country");
        if (elements.size() == 1) {
            try {
                this.countries.addAll(ParserUtils.split(((Element)elements.get(0)).ownText()));
            }
            catch (Exception exception) {}
        } else {
            for (Element element : elements) {
                if (!StringUtils.isNotBlank((CharSequence)element.ownText())) continue;
                this.countries.add(element.ownText());
            }
        }
        return null;
    }

    private Void parseReleaseDate() {
        Date date2;
        this.supportedElements.add("premiered");
        this.supportedElements.add("aired");
        this.supportedElements.add("releasedate");
        Element element = this.getSingleElement(this.root, "premiered");
        if (element != null) {
            try {
                date2 = StrgUtils.parseDate(element.ownText());
                if (date2 != null) {
                    this.releaseDate = date2;
                }
            }
            catch (ParseException date2) {
                // empty catch block
            }
        }
        if (this.releaseDate == null && (element = this.getSingleElement(this.root, "aired")) != null) {
            try {
                date2 = StrgUtils.parseDate(element.ownText());
                if (date2 != null) {
                    this.releaseDate = date2;
                }
            }
            catch (ParseException date3) {
                // empty catch block
            }
        }
        if (this.releaseDate == null && (element = this.getSingleElement(this.root, "releasedate")) != null) {
            try {
                date2 = StrgUtils.parseDate(element.ownText());
                if (date2 != null) {
                    this.releaseDate = date2;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    private Void parseWatchedAndPlaycount() {
        this.supportedElements.add("watched");
        this.supportedElements.add("playcount");
        Element element = this.getSingleElement(this.root, "watched");
        if (element != null) {
            try {
                this.watched = Boolean.parseBoolean(element.ownText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((element = this.getSingleElement(this.root, "playcount")) != null) {
            try {
                this.playcount = MetadataUtil.parseInt(element.ownText());
                if (this.playcount > 0) {
                    this.watched = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Void parseGenres() {
        this.supportedElements.add("genres");
        this.supportedElements.add("genre");
        Elements elements = null;
        Element element = this.getSingleElement(this.root, "genres");
        elements = element != null ? element.select(element.tagName() + " > genre") : this.root.select(this.root.tagName() + " > genre");
        if (elements != null && !elements.isEmpty()) {
            for (Element genre : elements) {
                if (!StringUtils.isNotBlank((CharSequence)genre.ownText())) continue;
                for (String sp : ParserUtils.split(genre.ownText())) {
                    this.genres.add(MediaGenres.getGenre(sp.strip()));
                }
            }
        }
        return null;
    }

    private Void parseStudios() {
        this.supportedElements.add("studio");
        Elements elements = this.root.select(this.root.tagName() + " > studio");
        if (elements.size() == 1) {
            try {
                this.studios.addAll(ParserUtils.split(((Element)elements.get(0)).ownText()));
            }
            catch (Exception exception) {}
        } else {
            for (Element element : elements) {
                if (!StringUtils.isNotBlank((CharSequence)element.ownText())) continue;
                this.studios.add(element.ownText());
            }
        }
        return null;
    }

    private Void parseCredits() {
        this.supportedElements.add("credits");
        Elements elements = this.root.select(this.root.tagName() + " > credits");
        if (elements.size() == 1) {
            try {
                Element element = (Element)elements.get(0);
                List<String> creditsNames = ParserUtils.split(element.ownText());
                for (String credit : creditsNames) {
                    Person person = new Person();
                    person.name = credit;
                    if (creditsNames.size() == 1) {
                        if (StringUtils.isNotBlank((CharSequence)element.attr("tmdbid"))) {
                            person.tmdbId = element.attr("tmdbid");
                        }
                        if (StringUtils.isNotBlank((CharSequence)element.attr("imdbid"))) {
                            person.imdbId = element.attr("imdbid");
                        }
                        if (StringUtils.isNotBlank((CharSequence)element.attr("tvdbid"))) {
                            person.tvdbId = element.attr("tvdbid");
                        }
                    }
                    this.credits.add(person);
                }
            }
            catch (Exception exception) {}
        } else {
            for (Element element : elements) {
                if (!StringUtils.isNotBlank((CharSequence)element.ownText())) continue;
                Person person = new Person();
                person.name = element.ownText();
                if (StringUtils.isNotBlank((CharSequence)element.attr("tmdbid"))) {
                    person.tmdbId = element.attr("tmdbid");
                }
                if (StringUtils.isNotBlank((CharSequence)element.attr("imdbid"))) {
                    person.imdbId = element.attr("imdbid");
                }
                if (StringUtils.isNotBlank((CharSequence)element.attr("tvdbid"))) {
                    person.tvdbId = element.attr("tvdbid");
                }
                this.credits.add(person);
            }
        }
        return null;
    }

    private Void parseDirectors() {
        this.supportedElements.add("director");
        Elements elements = this.root.select(this.root.tagName() + " > director");
        if (elements.size() == 1) {
            try {
                Element element = (Element)elements.get(0);
                List<String> directorNames = ParserUtils.split(element.ownText());
                for (String director : directorNames) {
                    Person person = new Person();
                    person.name = director;
                    if (directorNames.size() == 1) {
                        if (StringUtils.isNotBlank((CharSequence)element.attr("tmdbid"))) {
                            person.tmdbId = element.attr("tmdbid");
                        }
                        if (StringUtils.isNotBlank((CharSequence)element.attr("imdbid"))) {
                            person.imdbId = element.attr("imdbid");
                        }
                        if (StringUtils.isNotBlank((CharSequence)element.attr("tvdbid"))) {
                            person.tvdbId = element.attr("tvdbid");
                        }
                    }
                    this.directors.add(person);
                }
            }
            catch (Exception exception) {}
        } else {
            for (Element element : elements) {
                if (!StringUtils.isNotBlank((CharSequence)element.ownText())) continue;
                Person person = new Person();
                person.name = element.ownText();
                if (StringUtils.isNotBlank((CharSequence)element.attr("tmdbid"))) {
                    person.tmdbId = element.attr("tmdbid");
                }
                if (StringUtils.isNotBlank((CharSequence)element.attr("imdbid"))) {
                    person.imdbId = element.attr("imdbid");
                }
                if (StringUtils.isNotBlank((CharSequence)element.attr("tvdbid"))) {
                    person.tvdbId = element.attr("tvdbid");
                }
                this.directors.add(person);
            }
        }
        return null;
    }

    private Void parseTags() {
        this.supportedElements.add("tag");
        Elements elements = this.root.select(this.root.tagName() + " > tag");
        for (Element element : elements) {
            if (!StringUtils.isNotBlank((CharSequence)element.ownText())) continue;
            this.tags.add(element.ownText());
        }
        return null;
    }

    private Void parseActors() {
        this.supportedElements.add("actor");
        Elements elements = this.root.select(this.root.tagName() + " > actor");
        for (Element element : elements) {
            Person actor = new Person();
            for (Element child : element.children()) {
                switch (child.tagName()) {
                    case "name": {
                        actor.name = child.ownText();
                        break;
                    }
                    case "role": {
                        actor.role = child.ownText();
                        break;
                    }
                    case "thumb": {
                        actor.thumb = child.ownText();
                        break;
                    }
                    case "profile": {
                        actor.profile = child.ownText();
                        break;
                    }
                    case "tmdbid": {
                        actor.tmdbId = child.ownText();
                        break;
                    }
                    case "tvdbid": {
                        actor.tvdbId = child.ownText();
                        break;
                    }
                    case "imdbid": {
                        actor.imdbId = child.ownText();
                        break;
                    }
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)actor.name)) continue;
            this.actors.add(actor);
        }
        return null;
    }

    private Void parseProducers() {
        this.supportedElements.add("producer");
        Elements elements = this.root.select(this.root.tagName() + " > producer");
        for (Element element : elements) {
            Person producer = new Person();
            for (Element child : element.children()) {
                switch (child.tagName().toLowerCase(Locale.ROOT)) {
                    case "name": {
                        producer.name = child.ownText();
                        break;
                    }
                    case "role": {
                        producer.role = child.ownText();
                        break;
                    }
                    case "thumb": {
                        producer.thumb = child.ownText();
                        break;
                    }
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)producer.name)) continue;
            this.producers.add(producer);
        }
        return null;
    }

    private Void parseFileinfo() {
        this.supportedElements.add("fileinfo");
        Element element = this.getSingleElement(this.root, "fileinfo");
        if (element != null && (element = this.getSingleElement(element, "streamdetails")) != null) {
            this.fileinfo = new Fileinfo();
            for (Element child : element.children()) {
                switch (child.tagName().toLowerCase(Locale.ROOT)) {
                    case "video": {
                        Video video = this.parseVideo(child);
                        if (video == null) break;
                        this.fileinfo.videos.add(video);
                        break;
                    }
                    case "audio": {
                        Audio audio = this.parseAudio(child);
                        if (audio == null) break;
                        this.fileinfo.audios.add(audio);
                        break;
                    }
                    case "subtitle": {
                        Subtitle subtitle = this.parseSubtitle(child);
                        if (subtitle == null) break;
                        this.fileinfo.subtitles.add(subtitle);
                        break;
                    }
                }
            }
        }
        return null;
    }

    private Video parseVideo(Element element) {
        Video video = new Video();
        for (Element child : element.children()) {
            switch (child.tagName().toLowerCase(Locale.ROOT)) {
                case "codec": {
                    video.codec = child.ownText();
                    break;
                }
                case "aspect": {
                    try {
                        video.aspect = Float.parseFloat(child.ownText());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "width": {
                    try {
                        video.width = MetadataUtil.parseInt(child.ownText());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "height": {
                    try {
                        video.height = MetadataUtil.parseInt(child.ownText());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "durationinseconds": {
                    try {
                        video.durationinseconds = MetadataUtil.parseInt(child.ownText());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "hdrtype": {
                    video.hdrtype = child.ownText();
                    break;
                }
                case "stereomode": {
                    video.stereomode = child.ownText();
                    break;
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)video.codec)) {
            return video;
        }
        return null;
    }

    private Audio parseAudio(Element element) {
        Audio audio = new Audio();
        for (Element child : element.children()) {
            switch (child.tagName().toLowerCase(Locale.ROOT)) {
                case "codec": {
                    audio.codec = child.ownText();
                    break;
                }
                case "language": {
                    audio.language = child.ownText();
                    break;
                }
                case "channels": {
                    try {
                        audio.channels = MetadataUtil.parseInt(child.ownText());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)audio.codec)) {
            return audio;
        }
        return null;
    }

    private Subtitle parseSubtitle(Element element) {
        Subtitle subtitle = new Subtitle();
        for (Element child : element.children()) {
            switch (child.tagName().toLowerCase(Locale.ROOT)) {
                case "language": {
                    subtitle.language = child.ownText();
                    break;
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)subtitle.language)) {
            return subtitle;
        }
        return null;
    }

    private Void parseLanguages() {
        this.supportedElements.add("languages");
        this.supportedElements.add("language");
        Element element = this.getSingleElement(this.root, "languages");
        if (element == null) {
            element = this.getSingleElement(this.root, "language");
        }
        if (element != null) {
            this.languages = element.ownText();
        }
        if (StringUtils.isNotBlank((CharSequence)this.languages)) {
            ArrayList<String> languages = new ArrayList<String>();
            for (String langu : ParserUtils.split(this.languages)) {
                String languIso = LanguageUtils.getIso2LanguageFromLocalizedString(langu = langu.strip());
                if (StringUtils.isNotBlank((CharSequence)languIso)) {
                    languages.add(languIso);
                    continue;
                }
                languages.add(langu);
            }
            this.languages = StringUtils.join((Object[])languages.toArray(), (String)", ");
        }
        return null;
    }

    private Void parseSource() {
        this.supportedElements.add("source");
        Element element = this.getSingleElement(this.root, "source");
        if (element != null) {
            try {
                this.source = MediaSource.getMediaSource(element.ownText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Void parseEdition() {
        this.supportedElements.add("edition");
        Element element = this.getSingleElement(this.root, "edition");
        if (element != null && StringUtils.isNotBlank((CharSequence)element.ownText())) {
            this.edition = MovieEdition.getMovieEditionStrict(element.ownText());
        }
        return null;
    }

    private Void parseOriginalFilename() {
        this.supportedElements.add("original_filename");
        Element element = this.getSingleElement(this.root, "original_filename");
        if (element != null) {
            this.originalFilename = element.ownText();
        }
        return null;
    }

    private Void parseUserNote() {
        this.supportedElements.add("user_note");
        Element element = this.getSingleElement(this.root, "user_note");
        if (element != null) {
            this.userNote = element.ownText();
        }
        return null;
    }

    private Void parseTrailer() {
        this.supportedElements.add("trailer");
        for (Element element : this.getMultipleElements(this.root, "trailer")) {
            Object trailer = "";
            Pattern pattern = Pattern.compile("plugin://plugin.video.youtube/play/\\?video_id=(.*)$");
            Matcher matcher = pattern.matcher(element.ownText());
            if (matcher.matches()) {
                trailer = "https://www.youtube.com/watch?v=" + matcher.group(1);
            } else {
                pattern = Pattern.compile("plugin://plugin.video.youtube/\\?action=play_video&videoid=(.*)$");
                matcher = pattern.matcher(element.ownText());
                if (matcher.matches()) {
                    trailer = "https://www.youtube.com/watch?v=" + matcher.group(1);
                } else {
                    pattern = Pattern.compile("plugin://plugin.video.hdtrailers_net/video/.*\\?/(.*)$");
                    matcher = pattern.matcher(element.ownText());
                    if (matcher.matches()) {
                        try {
                            trailer = URLDecoder.decode(matcher.group(1), "UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)element.ownText()) && element.ownText().matches("https?://.*")) {
                trailer = element.ownText();
            }
            if (!StringUtils.isNotBlank((CharSequence)trailer)) continue;
            this.trailers.add((String)trailer);
        }
        return null;
    }

    private Void parseShowlink() {
        this.supportedElements.add("showlink");
        Elements elements = this.root.select(this.root.tagName() + " > showlink");
        for (Element element : elements) {
            this.showlinks.add(element.ownText());
        }
        return null;
    }

    private Void parseEpbookmark() {
        this.supportedElements.add("epbookmark");
        Element element = this.getSingleElement(this.root, "epbookmark");
        if (element != null) {
            this.epbookmark = element.ownText();
        }
        return null;
    }

    private Void parseLastplayed() {
        this.supportedElements.add("lastplayed");
        Element element = this.getSingleElement(this.root, "lastplayed");
        if (element != null) {
            try {
                Date date = StrgUtils.parseDate(element.ownText());
                if (date != null) {
                    this.lastplayed = date;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    private Void parseStatus() {
        this.supportedElements.add("status");
        Element element = this.getSingleElement(this.root, "status");
        if (element != null) {
            this.status = element.ownText();
        }
        return null;
    }

    private Void parseCode() {
        this.supportedElements.add("code");
        Element element = this.getSingleElement(this.root, "code");
        if (element != null) {
            this.code = element.ownText();
        }
        return null;
    }

    private Void parseDateadded() {
        this.supportedElements.add("dateadded");
        Element element = this.getSingleElement(this.root, "dateadded");
        if (element != null) {
            try {
                Date date = StrgUtils.parseDate(element.ownText());
                if (date != null) {
                    this.dateadded = date;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    private Void findUnsupportedElements() {
        this.supportedElements.add("lockdata");
        for (Element element : this.root.children()) {
            if (this.supportedElements.contains(element.tagName().toLowerCase(Locale.ROOT))) continue;
            String elementText = element.toString().replaceAll(">\\r?\\n\\s*<", "><");
            this.unsupportedElements.add(elementText);
        }
        return null;
    }

    public Movie toMovie() {
        Movie movie = new Movie();
        movie.setTitle(this.title);
        movie.setOriginalTitle(this.originaltitle);
        for (Map.Entry<String, Rating> entry2 : this.ratings.entrySet()) {
            Rating r = entry2.getValue();
            movie.setRating(new MediaRating(r.id, r.rating, r.votes, r.maxValue));
        }
        if (this.year > -1) {
            movie.setYear(this.year);
        }
        movie.setTop250(this.top250);
        movie.setReleaseDate(this.releaseDate);
        if (this.dateadded != null) {
            movie.setDateAdded(this.dateadded);
        }
        movie.setPlot(this.plot);
        movie.setTagline(this.tagline);
        movie.setRuntime(this.runtime);
        if (!this.posters.isEmpty()) {
            movie.setArtworkUrl(this.posters.get(0), MediaFileType.POSTER);
        }
        if (!this.banners.isEmpty()) {
            movie.setArtworkUrl(this.banners.get(0), MediaFileType.BANNER);
        }
        if (!this.cleararts.isEmpty()) {
            movie.setArtworkUrl(this.cleararts.get(0), MediaFileType.CLEARART);
        }
        if (!this.clearlogos.isEmpty()) {
            movie.setArtworkUrl(this.clearlogos.get(0), MediaFileType.CLEARLOGO);
        }
        if (!this.discarts.isEmpty()) {
            movie.setArtworkUrl(this.discarts.get(0), MediaFileType.DISC);
        }
        if (!this.thumbs.isEmpty()) {
            movie.setArtworkUrl(this.thumbs.get(0), MediaFileType.THUMB);
        }
        if (!this.keyarts.isEmpty()) {
            movie.setArtworkUrl(this.keyarts.get(0), MediaFileType.KEYART);
        }
        if (!this.logos.isEmpty()) {
            movie.setArtworkUrl(this.logos.get(0), MediaFileType.LOGO);
        }
        if (!this.fanarts.isEmpty()) {
            movie.setArtworkUrl(this.fanarts.get(0), MediaFileType.FANART);
        }
        for (Map.Entry<String, Object> entry3 : this.ids.entrySet()) {
            movie.setId(entry3.getKey(), entry3.getValue());
        }
        movie.setProductionCompany(StringUtils.join(this.studios, (String)" / "));
        movie.setCountry(StringUtils.join(this.countries, (String)"/"));
        movie.setCertification(this.certification);
        movie.setWatched(this.watched);
        movie.setPlaycount(this.playcount);
        movie.setLastWatched(this.lastplayed);
        movie.setSpokenLanguages(this.languages);
        movie.setMediaSource(this.source);
        movie.setEdition(this.edition);
        Set set = this.sets.stream().filter(entry -> entry.tmdbId > 0).findFirst().orElse(null);
        if (set == null) {
            set = this.sets.stream().findFirst().orElse(null);
        }
        if (set != null && StringUtils.isNotEmpty((CharSequence)set.name)) {
            MovieSet movieSet;
            MovieList movieList = MovieModuleManager.getInstance().getMovieList();
            int tmdbSetId = 0;
            if (set.tmdbId > 0) {
                tmdbSetId = set.tmdbId;
            }
            if (tmdbSetId == 0) {
                Object object = this.ids.get("tmdbSet");
                int n = tmdbSetId = object != null ? MetadataUtil.parseInt(String.valueOf(object), 0) : 0;
            }
            if (tmdbSetId == 0) {
                Object object = this.ids.get("tmdbset");
                int n = tmdbSetId = object != null ? MetadataUtil.parseInt(String.valueOf(object), 0) : 0;
            }
            if ((movieSet = movieList.getMovieSet(set.name, tmdbSetId)) != null) {
                if (StringUtils.isBlank((CharSequence)movieSet.getPlot())) {
                    movieSet.setPlot(set.overview);
                }
                movie.setMovieSet(movieSet);
            }
        }
        movie.setSortTitle(this.sorttitle);
        ArrayList<org.tinymediamanager.core.entities.Person> arrayList = new ArrayList<org.tinymediamanager.core.entities.Person>();
        for (Person person : this.actors) {
            arrayList.add(this.morphPerson(Person.Type.ACTOR, person));
        }
        movie.addToActors(arrayList);
        ArrayList<org.tinymediamanager.core.entities.Person> newProducers = new ArrayList<org.tinymediamanager.core.entities.Person>();
        for (Person person : this.producers) {
            newProducers.add(this.morphPerson(Person.Type.PRODUCER, person));
        }
        movie.addToProducers(newProducers);
        ArrayList<org.tinymediamanager.core.entities.Person> arrayList2 = new ArrayList<org.tinymediamanager.core.entities.Person>();
        for (Person director : this.directors) {
            if (StringUtils.isBlank((CharSequence)director.role)) {
                director.role = "Director";
            }
            arrayList2.add(this.morphPerson(Person.Type.DIRECTOR, director));
        }
        movie.addToDirectors(arrayList2);
        ArrayList<org.tinymediamanager.core.entities.Person> arrayList3 = new ArrayList<org.tinymediamanager.core.entities.Person>();
        for (Person writer : this.credits) {
            if (StringUtils.isBlank((CharSequence)writer.role)) {
                writer.role = "Writer";
            }
            arrayList3.add(this.morphPerson(Person.Type.WRITER, writer));
        }
        movie.addToWriters(arrayList3);
        movie.addToGenres(this.genres);
        for (String trailerUrl : this.trailers) {
            if (!trailerUrl.startsWith("http")) continue;
            MediaTrailer trailer = new MediaTrailer();
            trailer.setName("fromNFO");
            trailer.setProvider("from NFO");
            trailer.setQuality("unknown");
            trailer.setUrl(trailerUrl);
            trailer.setInNfo(true);
            movie.addToTrailer(Collections.singletonList(trailer));
        }
        movie.addToTags(this.tags);
        movie.addShowlinks(this.showlinks);
        movie.setOriginalFilename(this.originalFilename);
        movie.setNote(this.userNote);
        return movie;
    }

    private org.tinymediamanager.core.entities.Person morphPerson(Person.Type type, Person nfoPerson) {
        int tvdbId;
        org.tinymediamanager.core.entities.Person person = new org.tinymediamanager.core.entities.Person(type);
        person.setName(nfoPerson.name);
        person.setRole(nfoPerson.role);
        person.setThumbUrl(nfoPerson.thumb);
        person.setProfileUrl(nfoPerson.profile);
        int tmdbId = MetadataUtil.parseInt(nfoPerson.tmdbId, 0);
        if (tmdbId > 0) {
            person.setId("tmdb", tmdbId);
        }
        if (StringUtils.isNotBlank((CharSequence)nfoPerson.imdbId)) {
            person.setId("imdb", nfoPerson.imdbId);
        }
        if ((tvdbId = MetadataUtil.parseInt(nfoPerson.tvdbId, 0)) > 0) {
            person.setId("tvdb", tvdbId);
        }
        return person;
    }

    static class Fileinfo {
        List<Video> videos = new ArrayList<Video>();
        List<Audio> audios = new ArrayList<Audio>();
        List<Subtitle> subtitles = new ArrayList<Subtitle>();

        Fileinfo() {
        }
    }

    static class Rating {
        String id = "";
        float rating = 0.0f;
        int votes = 0;
        int maxValue = 10;

        Rating() {
        }
    }

    static class Set {
        String name = "";
        String overview = "";
        int tmdbId = 0;

        Set() {
        }
    }

    static class Person {
        String name = "";
        String role = "";
        String thumb = "";
        String profile = "";
        String tmdbId = "";
        String imdbId = "";
        String tvdbId = "";

        Person() {
        }
    }

    static class Video {
        String codec = "";
        float aspect = 0.0f;
        int width = 0;
        int height = 0;
        int durationinseconds;
        String hdrtype = "";
        String stereomode = "";

        Video() {
        }
    }

    static class Audio {
        String codec = "";
        String language = "";
        int channels = 0;

        Audio() {
        }
    }

    static class Subtitle {
        String language;

        Subtitle() {
        }
    }
}

