/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.connector;

import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.connector.MovieToKodiConnector;
import org.tinymediamanager.core.movie.entities.Movie;
import org.w3c.dom.Element;

public class MovieToJellyfinConnector
extends MovieToKodiConnector {
    public MovieToJellyfinConnector(Movie movie) {
        super(movie);
    }

    @Override
    protected void addThumb() {
    }

    @Override
    protected void addThumb(MediaFileType type, String aspect) {
    }

    @Override
    protected void addFanart() {
    }

    @Override
    protected void addActors() {
        for (Person movieActor : this.movie.getActors()) {
            Element actor = this.document.createElement("actor");
            Element name = this.document.createElement("name");
            name.setTextContent(movieActor.getName());
            actor.appendChild(name);
            if (StringUtils.isNotBlank((CharSequence)movieActor.getRole())) {
                Element role = this.document.createElement("role");
                role.setTextContent(movieActor.getRole());
                actor.appendChild(role);
            }
            if (StringUtils.isNotBlank((CharSequence)movieActor.getProfileUrl())) {
                Element profile = this.document.createElement("profile");
                profile.setTextContent(movieActor.getProfileUrl());
                actor.appendChild(profile);
            }
            this.addPersonIdsAsChildren(actor, movieActor);
            this.root.appendChild(actor);
        }
    }

    @Override
    protected void addProducers() {
        for (Person movieProducer : this.movie.getProducers()) {
            Element producer = this.document.createElement("producer");
            Element name = this.document.createElement("name");
            name.setTextContent(movieProducer.getName());
            producer.appendChild(name);
            if (StringUtils.isNotBlank((CharSequence)movieProducer.getRole())) {
                Element role = this.document.createElement("role");
                role.setTextContent(movieProducer.getRole());
                producer.appendChild(role);
            }
            if (StringUtils.isNotBlank((CharSequence)movieProducer.getProfileUrl())) {
                Element profile = this.document.createElement("profile");
                profile.setTextContent(movieProducer.getProfileUrl());
                producer.appendChild(profile);
            }
            this.addPersonIdsAsAttributes(producer, movieProducer);
            this.root.appendChild(producer);
        }
    }
}

