/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.connector;

import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.connector.MovieGenericXmlConnector;
import org.tinymediamanager.core.movie.entities.Movie;
import org.w3c.dom.Element;

public class MovieToKodiConnector
extends MovieGenericXmlConnector {
    protected static final Logger LOGGER = LoggerFactory.getLogger(MovieToKodiConnector.class);
    protected static final Pattern HD_TRAILERS_PATTERN = Pattern.compile("https?://.*(apple.com|yahoo-redir|yahoo.com|youtube.com|moviefone.com|ign.com|hd-trailers.net|aol.com).*");

    public MovieToKodiConnector(Movie movie) {
        super(movie);
    }

    @Override
    protected void addOwnTags() {
        this.addEpbookmark();
        this.addTop250();
        this.addLastplayed();
        this.addStatusAndCode();
        this.addFileinfo();
    }

    @Override
    protected void addSet() {
        Element set = this.document.createElement("set");
        if (this.movie.getMovieSet() != null) {
            Element name = this.document.createElement("name");
            name.setTextContent(this.movie.getMovieSet().getTitle());
            set.appendChild(name);
            Element overview = this.document.createElement("overview");
            overview.setTextContent(this.movie.getMovieSet().getPlot());
            set.appendChild(overview);
        }
        this.root.appendChild(set);
    }

    @Override
    protected void addThumb() {
        this.addThumb(MediaFileType.POSTER, "poster");
        this.addThumb(MediaFileType.BANNER, "banner");
        this.addThumb(MediaFileType.CLEARART, "clearart");
        this.addThumb(MediaFileType.CLEARLOGO, "clearlogo");
        this.addThumb(MediaFileType.DISC, "discart");
        this.addThumb(MediaFileType.THUMB, "landscape");
        this.addThumb(MediaFileType.KEYART, "keyart");
        this.addThumb(MediaFileType.LOGO, "logo");
    }

    protected void addThumb(MediaFileType type, String aspect) {
        Element thumb = this.document.createElement("thumb");
        String artworkUrl = this.movie.getArtworkUrl(type);
        if (StringUtils.isNotBlank((CharSequence)artworkUrl)) {
            thumb.setAttribute("aspect", aspect);
            thumb.setTextContent(artworkUrl);
            this.root.appendChild(thumb);
        }
    }

    @Override
    protected void addFanart() {
        Element fanart = this.document.createElement("fanart");
        LinkedHashSet<String> fanartUrls = new LinkedHashSet<String>();
        String fanartUrl = this.movie.getArtworkUrl(MediaFileType.FANART);
        if (StringUtils.isNotBlank((CharSequence)fanartUrl)) {
            fanartUrls.add(fanartUrl);
        }
        fanartUrls.addAll(this.movie.getExtraFanarts());
        for (String url : fanartUrls) {
            Element thumb = this.document.createElement("thumb");
            thumb.setTextContent(url);
            fanart.appendChild(thumb);
        }
        if (!fanartUrls.isEmpty()) {
            this.root.appendChild(fanart);
        }
    }

    @Override
    protected void addTrailer() {
        if (MovieModuleManager.getInstance().getSettings().isNfoWriteTrailer()) {
            Element trailer = this.document.createElement("trailer");
            if (this.movie.getMediaFiles(MediaFileType.TRAILER).isEmpty()) {
                for (MediaTrailer mediaTrailer : new ArrayList<MediaTrailer>(this.movie.getTrailer())) {
                    if (!mediaTrailer.getInNfo().booleanValue() || !mediaTrailer.getUrl().startsWith("http")) continue;
                    trailer.setTextContent(this.prepareTrailerForKodi(mediaTrailer));
                    break;
                }
            }
            this.root.appendChild(trailer);
        }
    }

    protected String prepareTrailerForKodi(MediaTrailer trailer) {
        Matcher matcher = Utils.YOUTUBE_PATTERN.matcher(trailer.getUrl());
        if (matcher.matches()) {
            return "plugin://plugin.video.youtube/play/?video_id=" + matcher.group(5);
        }
        matcher = HD_TRAILERS_PATTERN.matcher(trailer.getUrl());
        if (matcher.matches()) {
            try {
                return "plugin://plugin.video.hdtrailers_net/video/" + matcher.group(1) + "/" + URLEncoder.encode(trailer.getUrl(), "UTF-8");
            }
            catch (Exception e) {
                LOGGER.debug("failed to escape {} - {}", (Object)trailer.getUrl(), (Object)e.getMessage());
            }
        }
        return trailer.getUrl();
    }

    @Override
    protected void addRating() {
        Element ratings = this.document.createElement("ratings");
        MediaRating mainMediaRating = this.movie.getRating();
        for (MediaRating r : this.movie.getRatings().values()) {
            if ("user".equals(r.getId())) continue;
            Element rating = this.document.createElement("rating");
            if ("tmdb".equals(r.getId())) {
                rating.setAttribute("name", "themoviedb");
            } else {
                rating.setAttribute("name", r.getId());
            }
            rating.setAttribute("max", String.valueOf(r.getMaxValue()));
            rating.setAttribute("default", r == mainMediaRating ? "true" : "false");
            Element value = this.document.createElement("value");
            value.setTextContent(String.format(Locale.US, "%.1f", Float.valueOf(r.getRating())));
            rating.appendChild(value);
            Element votes = this.document.createElement("votes");
            votes.setTextContent(Integer.toString(r.getVotes()));
            rating.appendChild(votes);
            ratings.appendChild(rating);
        }
        this.root.appendChild(ratings);
    }

    @Override
    protected void addVotes() {
    }

    protected void addEpbookmark() {
        Element epbookmark = this.document.createElement("epbookmark");
        Element year = this.getSingleElementByTag("year");
        if (this.parser != null) {
            epbookmark.setTextContent(this.parser.epbookmark);
        }
        this.root.insertBefore(epbookmark, year);
    }

    protected void addTop250() {
        Element top250 = this.document.createElement("top250");
        top250.setTextContent(Integer.toString(this.movie.getTop250()));
        Element set = this.getSingleElementByTag("set");
        this.root.insertBefore(top250, set);
    }

    protected void addLastplayed() {
        Element lastplayed = this.document.createElement("lastplayed");
        Element genre = this.getSingleElementByTag("genre");
        if (this.movie.isWatched()) {
            if (this.movie.getLastWatched() != null) {
                lastplayed.setTextContent(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.movie.getLastWatched()));
                this.root.insertBefore(lastplayed, genre);
            } else if (this.parser != null && this.parser.lastplayed != null) {
                lastplayed.setTextContent(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.parser.lastplayed));
                this.root.insertBefore(lastplayed, genre);
            }
        }
    }

    protected void addStatusAndCode() {
        Element status = this.document.createElement("status");
        Element code = this.document.createElement("code");
        Element premiered = this.getSingleElementByTag("premiered");
        if (this.parser != null) {
            status.setTextContent(this.parser.status);
            code.setTextContent(this.parser.code);
        }
        this.root.insertBefore(status, premiered);
        this.root.insertBefore(code, premiered);
    }

    protected void addFileinfo() {
        if (MovieModuleManager.getInstance().getSettings().isNfoWriteFileinfo()) {
            Element fileinfo = this.document.createElement("fileinfo");
            Element streamdetails = this.document.createElement("streamdetails");
            MediaFile vid = this.movie.getMainVideoFile();
            if (vid != null) {
                Element video = this.document.createElement("video");
                Element codec = this.document.createElement("codec");
                if ("h265".equalsIgnoreCase(vid.getVideoCodec())) {
                    codec.setTextContent("HEVC");
                } else {
                    codec.setTextContent(vid.getVideoCodec());
                }
                video.appendChild(codec);
                Element aspect = this.document.createElement("aspect");
                aspect.setTextContent(Float.toString(vid.getAspectRatio().floatValue()));
                video.appendChild(aspect);
                Element width = this.document.createElement("width");
                width.setTextContent(Integer.toString(vid.getVideoWidth()));
                video.appendChild(width);
                Element height = this.document.createElement("height");
                height.setTextContent(Integer.toString(vid.getVideoHeight()));
                video.appendChild(height);
                if (this.movie.isVideoInHDR().booleanValue()) {
                    Element hdr = this.document.createElement("hdrtype");
                    if (vid.getHdrFormat().contains("Dolby Vision")) {
                        hdr.setTextContent("dolbyvision");
                    } else if (vid.getHdrFormat().contains("HLG")) {
                        hdr.setTextContent("hlg");
                    } else if (vid.getHdrFormat().contains("HDR10")) {
                        hdr.setTextContent("hdr10");
                    }
                    video.appendChild(hdr);
                }
                if (!this.movie.isDisc() && !this.movie.getMainVideoFile().getExtension().equalsIgnoreCase("iso")) {
                    Element durationinseconds = this.document.createElement("durationinseconds");
                    durationinseconds.setTextContent(Integer.toString(this.movie.getRuntimeFromMediaFilesInSeconds()));
                    video.appendChild(durationinseconds);
                }
                Element stereomode = this.document.createElement("stereomode");
                switch (vid.getVideo3DFormat()) {
                    case "3D SBS": 
                    case "3D HSBS": {
                        stereomode.setTextContent("left_right");
                        break;
                    }
                    case "3D TAB": 
                    case "3D HTAB": {
                        stereomode.setTextContent("top_bottom");
                        break;
                    }
                }
                video.appendChild(stereomode);
                streamdetails.appendChild(video);
                for (MediaFileAudioStream audioStream : vid.getAudioStreams()) {
                    Element audio = this.document.createElement("audio");
                    Element codec2 = this.document.createElement("codec");
                    codec2.setTextContent(audioStream.getCodec().replaceAll("-", "_"));
                    audio.appendChild(codec2);
                    Element language = this.document.createElement("language");
                    language.setTextContent(audioStream.getLanguage());
                    audio.appendChild(language);
                    Element channels = this.document.createElement("channels");
                    channels.setTextContent(Integer.toString(audioStream.getAudioChannels()));
                    audio.appendChild(channels);
                    streamdetails.appendChild(audio);
                }
                if (MovieModuleManager.getInstance().getSettings().isIncludeExternalAudioStreams()) {
                    for (MediaFile audioFile : this.movie.getMediaFiles(MediaFileType.AUDIO)) {
                        for (MediaFileAudioStream audioStream : vid.getAudioStreams()) {
                            Element audio = this.document.createElement("audio");
                            Element codec3 = this.document.createElement("codec");
                            codec3.setTextContent(audioStream.getCodec());
                            audio.appendChild(codec3);
                            Element language = this.document.createElement("language");
                            language.setTextContent(audioStream.getLanguage());
                            audio.appendChild(language);
                            Element channels = this.document.createElement("channels");
                            channels.setTextContent(Integer.toString(audioStream.getAudioChannels()));
                            audio.appendChild(channels);
                            streamdetails.appendChild(audio);
                        }
                    }
                }
                for (MediaFileSubtitle sub : vid.getSubtitles()) {
                    Element subtitle = this.document.createElement("subtitle");
                    Element language = this.document.createElement("language");
                    language.setTextContent(sub.getLanguage());
                    subtitle.appendChild(language);
                    streamdetails.appendChild(subtitle);
                }
            }
            for (MediaFile mediaFile : this.movie.getMediaFiles(MediaFileType.SUBTITLE)) {
                for (MediaFileSubtitle sub : mediaFile.getSubtitles()) {
                    Element subtitle = this.document.createElement("subtitle");
                    Element language = this.document.createElement("language");
                    language.setTextContent(sub.getLanguage());
                    subtitle.appendChild(language);
                    streamdetails.appendChild(subtitle);
                }
            }
            fileinfo.appendChild(streamdetails);
            this.root.appendChild(fileinfo);
        }
    }
}

