/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tasks;

import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import okhttp3.Headers;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.scraper.http.StreamingUrl;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.UrlUtil;

public abstract class DownloadTask
extends TmmTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadTask.class);
    protected String url;
    protected Path tempFile;
    protected String fileType = "";

    protected DownloadTask(String description, String url) {
        super(description, 100, TmmTaskHandle.TaskType.BACKGROUND_TASK);
        this.url = url;
    }

    protected String getUrl() {
        return this.url;
    }

    protected String getSpecialUserAgent() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doInBackground() {
        String url = this.getUrl();
        String userAgent = this.getSpecialUserAgent();
        Path destination = this.getDestinationWoExtension();
        try {
            if (StringUtils.isBlank((CharSequence)url) || !url.toLowerCase(Locale.ROOT).startsWith("http")) {
                return;
            }
            String fileExtension = FilenameUtils.getExtension((String)destination.getFileName().toString()).toLowerCase(Locale.ROOT);
            if (StringUtils.isNotBlank((CharSequence)fileExtension) && fileExtension.length() > 4 || !Settings.getInstance().getAllSupportedFileTypes().contains("." + fileExtension)) {
                fileExtension = "";
            }
            if (StringUtils.isBlank((CharSequence)fileExtension) && !(fileExtension = UrlUtil.getExtension(url).toLowerCase(Locale.ROOT)).isEmpty()) {
                if (Settings.getInstance().getAllSupportedFileTypes().contains("." + fileExtension)) {
                    destination = destination.getParent().resolve(destination.getFileName() + "." + fileExtension);
                } else {
                    fileExtension = "";
                }
            }
            LOGGER.info("Downloading '{}'", (Object)url);
            StreamingUrl u = new StreamingUrl(UrlUtil.getURIEncoded(url).toASCIIString());
            if (StringUtils.isNotBlank((CharSequence)userAgent)) {
                u.setUserAgent(userAgent);
            }
            long timestamp = System.currentTimeMillis();
            try {
                Path tempFolder = Paths.get(Utils.getTempFolder(), new String[0]);
                if (!Files.exists(tempFolder, new LinkOption[0])) {
                    Files.createDirectory(tempFolder, new FileAttribute[0]);
                }
                this.tempFile = tempFolder.resolve(this.getDestinationWoExtension().getFileName() + "." + timestamp + ".part");
            }
            catch (Exception e) {
                LOGGER.warn("could not write to temp folder - {}", (Object)e.getMessage());
                this.tempFile = destination.resolveSibling(destination.getFileName() + "." + timestamp + ".part");
            }
            boolean resume = false;
            if (Files.exists(this.tempFile, new LinkOption[0])) {
                resume = true;
                u.addHeader("Range", "bytes=" + this.tempFile.toFile().length() + "-");
            }
            try (InputStream is = u.getInputStream();){
                LOGGER.trace("Server returned: {}", (Object)u.getStatusLine());
                Headers headers = u.getHeadersResponse();
                if (headers != null) {
                    for (String name : ListUtils.nullSafe(headers.names())) {
                        LOGGER.trace(" < {} : {}", (Object)name, (Object)headers.get(name));
                    }
                }
                if (u.isFault()) {
                    this.handleDownloadProblem(u);
                    this.setState(TmmTaskHandle.TaskState.FAILED);
                    return;
                }
                String type = u.getContentEncoding();
                if (StringUtils.isBlank((CharSequence)fileExtension)) {
                    if (type.startsWith("video/") || type.startsWith("audio/") || type.startsWith("image/")) {
                        fileExtension = type.split("/")[1];
                        fileExtension = fileExtension.replace("x-", "");
                    }
                    if ("application/zip".equals(type)) {
                        fileExtension = "zip";
                    }
                }
                if (StringUtils.isEmpty((CharSequence)fileExtension)) {
                    fileExtension = "dat";
                }
                this.fileType = fileExtension.toLowerCase(Locale.ROOT);
                LOGGER.debug("Downloading to '{}'", (Object)this.tempFile);
                this.download(u, is, resume);
            }
            this.checkDownloadedFile();
            if (this.cancel) {
                Utils.deleteFileSafely(this.tempFile);
            } else {
                if (fileExtension.isEmpty()) {
                    MediaFile mf = new MediaFile(this.tempFile);
                    mf.setContainerFormatDirect();
                    fileExtension = mf.getContainerFormat();
                }
                this.moveDownloadedFile(fileExtension);
                this.downloadFinished();
            }
        }
        catch (InterruptedIOException | InterruptedException e) {
            LOGGER.info("download of {} aborted", (Object)url);
            this.setState(TmmTaskHandle.TaskState.CANCELLED);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "DownloadTask", e.getMessage()));
            LOGGER.error("problem downloading: ", (Throwable)e);
            this.setState(TmmTaskHandle.TaskState.FAILED);
        }
        finally {
            if (this.tempFile != null && Files.exists(this.tempFile, new LinkOption[0])) {
                Utils.deleteFileSafely(this.tempFile);
            }
        }
    }

    protected void download(StreamingUrl url, InputStream is, boolean resume) throws IOException, InterruptedException {
        long length = url.getContentLength();
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(is);
             FileOutputStream outputStream = new FileOutputStream(this.tempFile.toFile(), resume);){
            int count;
            byte[] buffer = new byte[2048];
            Long timestamp1 = System.nanoTime();
            long bytesDone = 0L;
            long bytesDonePrevious = 0L;
            double speed = 0.0;
            while ((count = bufferedInputStream.read(buffer, 0, buffer.length)) != -1) {
                if (this.cancel) {
                    Thread.currentThread().interrupt();
                }
                outputStream.write(buffer, 0, count);
                bytesDone += (long)count;
                Long timestamp2 = System.nanoTime();
                if (timestamp2 - timestamp1 <= 250000000L) continue;
                speed = (speed + (double)(bytesDone - bytesDonePrevious) / ((double)(timestamp2 - timestamp1) / 1.0E9)) / 2.0;
                timestamp1 = timestamp2;
                bytesDonePrevious = bytesDone;
                if (length > 0L) {
                    this.publishState(this.formatBytesForOutput(bytesDone) + "/" + this.formatBytesForOutput(length) + " @" + this.formatSpeedForOutput(speed), (int)(bytesDone * 100L / length));
                    continue;
                }
                this.setWorkUnits(0);
                this.publishState(this.formatBytesForOutput(bytesDone) + " @" + this.formatSpeedForOutput(speed), 0);
            }
        }
        catch (AccessDeniedException e) {
            LOGGER.error("ACCESS DENIED (trailer download) - '{}'", (Object)e.getMessage());
            throw e;
        }
        if (!this.cancel) {
            is.close();
        }
    }

    protected void moveDownloadedFile(String fileExtension) throws IOException {
        boolean ok;
        Path destination = this.getDestinationWoExtension();
        if (!fileExtension.isEmpty()) {
            destination = destination.getParent().resolve(destination.getFileName() + "." + fileExtension);
        }
        Utils.deleteFileSafely(destination);
        if (!Files.exists(destination.getParent(), new LinkOption[0])) {
            Files.createDirectory(destination.getParent(), new FileAttribute[0]);
        }
        if (ok = Utils.moveFileSafe(this.tempFile, destination)) {
            Utils.deleteFileSafely(this.tempFile);
            MediaEntity mediaEntity = this.getMediaEntityToAdd();
            if (mediaEntity != null) {
                MediaFile mf = new MediaFile(destination);
                mf.gatherMediaInformation();
                mediaEntity.removeFromMediaFiles(mf);
                mediaEntity.addToMediaFiles(mf);
                mediaEntity.saveToDb();
            }
        } else {
            LOGGER.warn("Download to '{}' was ok, but couldn't move to '{}'", (Object)this.tempFile, (Object)destination);
            this.setState(TmmTaskHandle.TaskState.FAILED);
        }
    }

    protected void checkDownloadedFile() throws IOException {
    }

    protected void downloadFinished() {
    }

    protected void handleDownloadProblem(Url url) {
        LOGGER.error("Could not download the url '{}' - HTTP '{}' - '{}'", new Object[]{url.getUrlAsString(), url.getStatusCode(), url.getStatusLine()});
        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, url.getUrlAsString(), url.getStatusLine()));
    }

    protected abstract Path getDestinationWoExtension();

    protected abstract MediaEntity getMediaEntityToAdd();

    private String formatBytesForOutput(long bytes) {
        return String.format("%.2fM", (double)bytes / 1000000.0);
    }

    private String formatSpeedForOutput(double speed) {
        return String.format("%.2fkB/s", speed / 1000.0);
    }
}

