/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tasks;

import java.io.FileNotFoundException;
import java.io.InterruptedIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.EmptyFileException;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.entities.MediaFile;

public class ImageCacheTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageCacheTask.class);
    private final MediaFile mediaFile;

    public ImageCacheTask(MediaFile mediaFile) {
        this.mediaFile = mediaFile;
    }

    @Override
    public void run() {
        try {
            ImageCache.cacheImage(this.mediaFile);
        }
        catch (EmptyFileException e) {
            LOGGER.debug("failed to cache file (file is empty): {}", (Object)this.mediaFile);
        }
        catch (FileNotFoundException e) {
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.warn("failed to cache file: {} - {}", (Object)this.mediaFile.getFile(), (Object)e.getMessage());
        }
    }
}

