/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.threading;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskListener;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;

public class TmmTaskChain
implements TmmTaskListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmTaskChain.class);
    private static final Map<MediaEntity, TmmTaskChain> ACTIVE_TASK_CHAINS = new HashMap<MediaEntity, TmmTaskChain>();
    private final MediaEntity mediaEntity;
    private final Queue<TmmTask> tasks = new LinkedList<TmmTask>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean running = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TmmTaskChain getInstance(MediaEntity mediaEntity) {
        Map<MediaEntity, TmmTaskChain> map = ACTIVE_TASK_CHAINS;
        synchronized (map) {
            return ACTIVE_TASK_CHAINS.computeIfAbsent(mediaEntity, TmmTaskChain::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void abortAllOpenTasks() {
        Map<MediaEntity, TmmTaskChain> map = ACTIVE_TASK_CHAINS;
        synchronized (map) {
            ACTIVE_TASK_CHAINS.forEach((mediaEntity1, tmmTaskChain) -> tmmTaskChain.abort());
            ACTIVE_TASK_CHAINS.clear();
        }
    }

    private TmmTaskChain(MediaEntity mediaEntity) {
        this.mediaEntity = mediaEntity;
    }

    public TmmTaskChain add(TmmTask task) {
        this.lock.writeLock().lock();
        task.addListener(this);
        this.tasks.add(task);
        this.lock.writeLock().unlock();
        if (!this.running) {
            this.running = true;
            this.startNextTask();
        }
        return this;
    }

    public void abort() {
        this.lock.writeLock().lock();
        this.tasks.clear();
        this.lock.writeLock().unlock();
    }

    @Override
    public void processTaskEvent(TmmTaskHandle task) {
        switch (task.getState()) {
            case FAILED: {
                LOGGER.debug("Task '{}' {} - continue with next", (Object)task.getClass().getName(), (Object)task.getState());
                this.startNextTask();
                break;
            }
            case FINISHED: {
                this.startNextTask();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNextTask() {
        this.lock.writeLock().lock();
        TmmTask nextTask = this.tasks.poll();
        this.lock.writeLock().unlock();
        if (nextTask != null) {
            if (nextTask instanceof TmmThreadPool) {
                TmmThreadPool threadPool = (TmmThreadPool)nextTask;
                TmmTaskManager.getInstance().addMainTask(threadPool);
            } else {
                TmmTaskManager.getInstance().addUnnamedTask(nextTask);
            }
        } else {
            Map<MediaEntity, TmmTaskChain> map = ACTIVE_TASK_CHAINS;
            synchronized (map) {
                ACTIVE_TASK_CHAINS.remove(this.mediaEntity);
            }
        }
    }
}

