/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.core.tasks.TrailerDownloadTask;
import org.tinymediamanager.core.tasks.YTDownloadTask;
import org.tinymediamanager.core.threading.TmmTaskChain;
import org.tinymediamanager.core.tvshow.TvShowEpisodeAndSeasonParser;
import org.tinymediamanager.core.tvshow.TvShowEpisodeType;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.filenaming.TvShowTrailerNaming;
import org.tinymediamanager.core.tvshow.tasks.TvShowTrailerDownloadTask;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;
import org.tinymediamanager.scraper.entities.MediaEpisodeNumber;
import org.tinymediamanager.scraper.imdb.ImdbTvShowTrailerProvider;
import org.tinymediamanager.scraper.util.MetadataUtil;

public class TvShowHelpers {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowHelpers.class);
    private static final Pattern SEASON_NUMBER = Pattern.compile("(?i)season\\s?(\\d+).*");
    private static final Pattern SEASON_FOLDER_NUMBER = Pattern.compile("(?i).*?(\\d+).*");

    private TvShowHelpers() {
        throw new IllegalAccessError();
    }

    public static MediaCertification parseCertificationStringForTvShowSetupCountry(String name) {
        MediaCertification cert = MediaCertification.UNKNOWN;
        if ((name = name.strip()).contains("/")) {
            String[] cs;
            String[] countries;
            for (String c : countries = name.split("/")) {
                if ((c = c.strip()).contains(":")) {
                    cs = c.split(":");
                    cert = MediaCertification.getCertification(TvShowModuleManager.getInstance().getSettings().getCertificationCountry(), cs[1]);
                    if (cert == MediaCertification.UNKNOWN) continue;
                    return cert;
                }
                cert = MediaCertification.getCertification(TvShowModuleManager.getInstance().getSettings().getCertificationCountry(), c);
                if (cert == MediaCertification.UNKNOWN) continue;
                return cert;
            }
            for (String c : countries) {
                if (!((c = c.strip()).contains(":") ? (cert = MediaCertification.findCertification((cs = c.split(":"))[1])) != MediaCertification.UNKNOWN : (cert = MediaCertification.findCertification(c)) != MediaCertification.UNKNOWN)) continue;
                return cert;
            }
        } else if (name.contains(":")) {
            String[] cs = name.split(":");
            cert = MediaCertification.getCertification(TvShowModuleManager.getInstance().getSettings().getCertificationCountry(), cs[1].strip());
            if (cert == MediaCertification.UNKNOWN) {
                cert = MediaCertification.findCertification(cs[1].strip());
            }
        } else {
            cert = MediaCertification.getCertification(TvShowModuleManager.getInstance().getSettings().getCertificationCountry(), name.strip());
        }
        if (cert == MediaCertification.UNKNOWN) {
            cert = MediaCertification.findCertification(name);
        }
        return cert;
    }

    public static String detectSeasonFolder(TvShow tvShow, int season) {
        if (season == -1) {
            return "";
        }
        ArrayList<String> subPaths = new ArrayList<String>();
        Path tvShowPath = tvShow.getPathNIO();
        List<TvShowEpisode> episodes = tvShow.getEpisodesForSeason(season);
        try {
            for (TvShowEpisode episode : episodes) {
                Path videoFilePath = episode.getMainVideoFile().getFileAsPath().getParent();
                if (!videoFilePath.startsWith(tvShowPath)) {
                    LOGGER.debug("episode MF path does not match TV show root!!");
                    continue;
                }
                Path relativePath = tvShowPath.relativize(videoFilePath);
                int subfolders = relativePath.getNameCount();
                for (int i = 1; i <= subfolders; ++i) {
                    subPaths.add(relativePath.subpath(0, i).toString());
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("could not extract season folder: {}", (Object)e.getMessage());
        }
        if (subPaths.isEmpty()) {
            return "";
        }
        Map<String, Long> subPathCounts = subPaths.stream().collect(Collectors.groupingBy(s -> s, Collectors.counting()));
        Map.Entry entry = subPathCounts.entrySet().stream().max(Map.Entry.comparingByValue()).get();
        if ((double)((Long)entry.getValue()).longValue() >= 0.8 * (double)episodes.size()) {
            return (String)entry.getKey();
        }
        return "";
    }

    public static void startAutomaticTrailerDownload(TvShow tvShow) {
        if (TvShowModuleManager.getInstance().getSettings().isUseTrailerPreference() && TvShowModuleManager.getInstance().getSettings().isAutomaticTrailerDownload() && tvShow.getMediaFiles(MediaFileType.TRAILER).isEmpty() && !tvShow.getTrailer().isEmpty()) {
            TvShowHelpers.downloadBestTrailer(tvShow);
        }
    }

    public static void downloadBestTrailer(TvShow tvShow) {
        if (!tvShow.getTrailer().isEmpty()) {
            TvShowTrailerDownloadTask task = new TvShowTrailerDownloadTask(tvShow);
            TmmTaskChain.getInstance(tvShow).add(task);
        }
    }

    public static void downloadTrailer(final TvShow tvshow, MediaTrailer trailer) {
        List<TvShowTrailerNaming> trailernames;
        if (StringUtils.isBlank((CharSequence)trailer.getUrl()) || !trailer.getUrl().startsWith("http")) {
            if (StringUtils.isBlank((CharSequence)trailer.getId())) {
                LOGGER.debug("Could not download trailer: no url/id {}", (Object)trailer);
                return;
            }
            String id = trailer.getId();
            if (!id.matches("vi\\d+")) {
                LOGGER.debug("Could not download trailer: id not known {}", (Object)trailer);
                return;
            }
            ImdbTvShowTrailerProvider tp = new ImdbTvShowTrailerProvider();
            String url = tp.getUrlForId(trailer);
            if (url.isEmpty()) {
                LOGGER.debug("Could not download trailer: could not construct url from id {}", (Object)trailer);
                return;
            }
            trailer.setUrl(url);
        }
        final String filename = !(trailernames = TvShowModuleManager.getInstance().getSettings().getTrailerFilenames()).isEmpty() ? tvshow.getTrailerFilename(trailernames.get(0)) : tvshow.getTrailerFilename(TvShowTrailerNaming.TVSHOW_TRAILER);
        try {
            Matcher matcher = Utils.YOUTUBE_PATTERN.matcher(trailer.getUrl());
            if (matcher.matches()) {
                YTDownloadTask task = new YTDownloadTask(trailer, TvShowModuleManager.getInstance().getSettings().getTrailerQuality(), TvShowModuleManager.getInstance().getSettings().isUseYtDlp()){

                    @Override
                    protected Path getDestinationWoExtension() {
                        return tvshow.getPathNIO().resolve(filename);
                    }

                    @Override
                    protected MediaEntity getMediaEntityToAdd() {
                        return tvshow;
                    }
                };
                TmmTaskChain.getInstance(tvshow).add(task);
            } else {
                TrailerDownloadTask task = new TrailerDownloadTask(trailer){

                    @Override
                    protected Path getDestinationWoExtension() {
                        return tvshow.getPathNIO().resolve(filename);
                    }

                    @Override
                    protected MediaEntity getMediaEntityToAdd() {
                        return tvshow;
                    }
                };
                TmmTaskChain.getInstance(tvshow).add(task);
            }
        }
        catch (Exception e) {
            LOGGER.error("could not start trailer download: {}", (Object)e.getMessage());
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)tvshow, "message.scrape.trailerfailed", new String[]{":", e.getLocalizedMessage()}));
        }
    }

    public static int detectSeasonFromFileAndFolder(String filename, String foldername) {
        int season = Integer.MIN_VALUE;
        if (filename.startsWith("season-specials") || foldername.equalsIgnoreCase("specials")) {
            season = 0;
        } else if (filename.startsWith("season-all")) {
            season = -1;
        } else {
            Matcher matcher = SEASON_NUMBER.matcher(filename);
            if (matcher.matches()) {
                season = Integer.parseInt(matcher.group(1));
            }
            if (season == Integer.MIN_VALUE && (matcher = SEASON_NUMBER.matcher(foldername)).matches()) {
                season = Integer.parseInt(matcher.group(1));
            }
            if (season == Integer.MIN_VALUE && (matcher = SEASON_FOLDER_NUMBER.matcher(foldername)).matches()) {
                season = Integer.parseInt(matcher.group(1));
            }
        }
        if (season == Integer.MAX_VALUE) {
            season = Integer.MIN_VALUE;
        }
        return season;
    }

    public static MediaEpisodeGroup findBestMatchingEpisodeGroup(TvShow tvShow, List<MediaEpisodeGroup> episodeGroups, List<MediaMetadata> episodeList) {
        float matchedEpisodes = 0.0f;
        float score = 0.0f;
        MediaEpisodeGroup episodeGroup = null;
        for (MediaEpisodeGroup eg : episodeGroups) {
            int episodeCount = 0;
            float scoreSum = 0.0f;
            block1: for (TvShowEpisode episode : tvShow.getEpisodes()) {
                for (MediaMetadata md : episodeList) {
                    MediaEpisodeNumber episodeNumber = md.getEpisodeNumber(eg);
                    if (episodeNumber == null || episode.getSeason() != episodeNumber.season() || episode.getEpisode() != episodeNumber.episode()) continue;
                    float titleScore = MetadataUtil.calculateScore(md.getTitle(), episode.getTitle());
                    String cleanedFilename = TvShowEpisodeAndSeasonParser.cleanEpisodeTitle(episode.getMainVideoFile().getBasename(), episode.getTvShow().getTitle());
                    float filenameScore = MetadataUtil.calculateScore(md.getTitle(), cleanedFilename);
                    scoreSum += Math.max(titleScore, filenameScore);
                    ++episodeCount;
                    continue block1;
                }
            }
            if (episodeCount <= 0 || !((float)episodeCount > matchedEpisodes) && ((float)episodeCount != matchedEpisodes || !(score < scoreSum / (float)episodeCount))) continue;
            episodeGroup = eg;
            score = scoreSum / (float)episodeCount;
            matchedEpisodes = episodeCount;
        }
        return episodeGroup;
    }

    public static boolean shouldAddDummyEpisode(TvShowEpisode episode) {
        if (episode.getEpisode() == -1 || episode.getSeason() == -1) {
            return false;
        }
        TvShowEpisodeType episodeType = TvShowEpisodeType.getTypeForEpisode(episode);
        return switch (episodeType) {
            case TvShowEpisodeType.DUMMY_NORMAL -> TvShowModuleManager.getInstance().getSettings().isDisplayMissingEpisodes();
            case TvShowEpisodeType.DUMMY_SPECIAL -> TvShowModuleManager.getInstance().getSettings().isDisplayMissingSpecials();
            case TvShowEpisodeType.DUMMY_NOT_AIRED -> TvShowModuleManager.getInstance().getSettings().isDisplayMissingNotAired();
            default -> false;
        };
    }

    public static List<TvShowEpisode> getEpisodesForDisplay(List<TvShowEpisode> existingEpisodes, List<TvShowEpisode> dummyEpisodes) {
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>(existingEpisodes);
        if (TvShowModuleManager.getInstance().getSettings().isDisplayMissingEpisodes()) {
            HashSet<CallSite> availableEpisodes = new HashSet<CallSite>();
            for (TvShowEpisode episode : episodes) {
                if (episode.getSeason() <= -1 || episode.getEpisode() <= -1) continue;
                availableEpisodes.add((CallSite)((Object)("A" + episode.getSeason() + "." + episode.getEpisode())));
            }
            for (TvShowEpisode episode : dummyEpisodes) {
                if (!TvShowHelpers.shouldAddDummyEpisode(episode) || availableEpisodes.contains("A" + episode.getSeason() + "." + episode.getEpisode())) continue;
                episodes.add(episode);
            }
        }
        episodes.sort(Comparator.comparingInt(TvShowEpisode::getEpisode));
        return episodes;
    }
}

