/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.ModelAdaptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.PostProcess;
import org.tinymediamanager.core.PostProcessExecutor;
import org.tinymediamanager.core.jmte.JmteUtils;
import org.tinymediamanager.core.jmte.TmmModelAdaptor;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowPostProcessExecutor
extends PostProcessExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowPostProcessExecutor.class);

    public TvShowPostProcessExecutor(PostProcess postProcess) {
        super(postProcess);
    }

    @Override
    public void execute() {
        List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShows();
        for (TvShow tvs : selectedTvShows) {
            LOGGER.info("PostProcessing: START {}", (Object)this.postProcess);
            HashMap<String, Object> mappings = new HashMap<String, Object>();
            mappings.put("tvShow", tvs);
            String[] command = this.substituteTokens(mappings);
            try {
                this.executeCommand(command, tvs);
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Exception e) {
                LOGGER.error("Problem executing post process", (Throwable)e);
            }
        }
    }

    private String[] substituteTokens(Map<String, Object> mappings) {
        Engine engine = TvShowRenamer.createEngine();
        engine.setModelAdaptor((ModelAdaptor)new TmmModelAdaptor());
        if (this.postProcess.getPath() == null || this.postProcess.getPath().isEmpty()) {
            String transformed = engine.transform(JmteUtils.morphTemplate(this.postProcess.getCommand(), TvShowRenamer.getTokenMap()), mappings);
            return new String[]{transformed};
        }
        String[] splitted = this.postProcess.getCommand().split("\\n");
        for (int i = 0; i < splitted.length; ++i) {
            splitted[i] = engine.transform(JmteUtils.morphTemplate(splitted[i], TvShowRenamer.getTokenMap()), mappings);
        }
        return splitted;
    }
}

