/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.TvShowRenamerPreviewContainer;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonBannerNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonFanartNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonNfoNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonPosterNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonThumbNaming;

public class TvShowRenamerPreview {
    private final TvShow tvShow;
    private final TvShow clone;
    private final TvShowRenamerPreviewContainer container;
    private final Map<String, MediaFile> oldFiles;
    private final Set<MediaFile> newFiles;

    public TvShowRenamerPreview(TvShow tvShow) {
        this.tvShow = tvShow;
        this.clone = new TvShow();
        this.clone.merge(tvShow);
        this.clone.setDataSource(tvShow.getDataSource());
        this.container = new TvShowRenamerPreviewContainer(tvShow);
        this.oldFiles = new LinkedHashMap<String, MediaFile>();
        this.newFiles = new LinkedHashSet<MediaFile>();
    }

    public TvShowRenamerPreviewContainer generatePreview() {
        this.container.newPath = Paths.get(TvShowRenamer.getTvShowFoldername(TvShowModuleManager.getInstance().getSettings().getRenamerTvShowFoldername(), this.tvShow), new String[0]);
        this.clone.setPath(this.container.newPath.toString());
        this.processTvShow();
        this.processSeasons();
        this.processEpisodes();
        Path oldShowFolder = this.tvShow.getPathNIO();
        if (!oldShowFolder.equals(this.container.newPath)) {
            this.container.needsRename = true;
            for (MediaFile omf : this.oldFiles.values()) {
                omf.replacePathForRenamedFolder(oldShowFolder, this.container.newPath);
            }
            this.newFiles.forEach(mf -> mf.replacePathForRenamedFolder(oldShowFolder, this.container.newPath));
        }
        for (MediaFile mf2 : this.newFiles) {
            if (this.oldFiles.containsKey(mf2.getFileAsPath().toString())) continue;
            this.container.needsRename = true;
            break;
        }
        for (MediaFile mf2 : this.oldFiles.values()) {
            if (this.newFiles.contains(mf2)) continue;
            this.container.needsRename = true;
            break;
        }
        this.container.oldMediaFiles.addAll(this.oldFiles.values());
        this.container.newMediaFiles.addAll(this.newFiles);
        return this.container;
    }

    private void processTvShow() {
        for (MediaFile mf : this.tvShow.getMediaFiles()) {
            MediaFile oldMf = new MediaFile(mf);
            this.oldFiles.put(oldMf.getFileAsPath().toString(), oldMf);
            this.newFiles.addAll(TvShowRenamer.generateFilename(this.clone, new MediaFile(mf)));
        }
    }

    private void processSeasons() {
        ArrayList<TvShowSeason> seasons = new ArrayList<TvShowSeason>(this.tvShow.getSeasons());
        Collections.sort(seasons);
        for (TvShowSeason season : seasons) {
            MediaFile nfo = MediaFile.EMPTY_MEDIAFILE;
            for (MediaFile oldMf : season.getMediaFiles(MediaFileType.NFO)) {
                this.oldFiles.put(oldMf.getFileAsPath().toString(), oldMf);
                if (oldMf.getFiledate() < nfo.getFiledate()) continue;
                nfo = new MediaFile(oldMf);
            }
            if (nfo != MediaFile.EMPTY_MEDIAFILE && (!season.getEpisodes().isEmpty() || TvShowModuleManager.getInstance().getSettings().isCreateMissingSeasonItems())) {
                for (TvShowSeasonNfoNaming naming : TvShowModuleManager.getInstance().getSettings().getSeasonNfoFilenames()) {
                    String filename = naming.getFilename(season, "nfo");
                    if (!StringUtils.isNotBlank((CharSequence)filename)) continue;
                    MediaFile newMf = new MediaFile(nfo);
                    newMf.setFile(Paths.get(this.tvShow.getPath(), filename));
                    this.newFiles.add(newMf);
                }
            }
            List<MediaFileType> types = Arrays.asList(MediaFileType.SEASON_POSTER, MediaFileType.SEASON_FANART, MediaFileType.SEASON_BANNER, MediaFileType.SEASON_THUMB);
            for (MediaFileType type : types) {
                block10: for (TvShowSeason tvShowSeason : this.tvShow.getSeasons()) {
                    MediaFile artworkFile = null;
                    for (MediaFile mf : tvShowSeason.getMediaFiles(type)) {
                        this.oldFiles.put(mf.getFileAsPath().toString(), mf);
                        if (artworkFile != null) continue;
                        artworkFile = mf;
                    }
                    if (artworkFile == null || tvShowSeason.getEpisodes().isEmpty() && !TvShowModuleManager.getInstance().getSettings().isCreateMissingSeasonItems()) continue;
                    switch (type) {
                        case SEASON_POSTER: {
                            MediaFile newMf;
                            String filename;
                            for (TvShowSeasonPosterNaming tvShowSeasonPosterNaming : TvShowModuleManager.getInstance().getSettings().getSeasonPosterFilenames()) {
                                filename = tvShowSeasonPosterNaming.getFilename(tvShowSeason, artworkFile.getExtension(), true);
                                if (!StringUtils.isNotBlank((CharSequence)filename)) continue;
                                newMf = new MediaFile(artworkFile);
                                newMf.setFile(Paths.get(this.tvShow.getPath(), filename));
                                this.newFiles.add(newMf);
                            }
                            continue block10;
                        }
                        case SEASON_FANART: {
                            MediaFile newMf;
                            String filename;
                            for (TvShowSeasonFanartNaming tvShowSeasonFanartNaming : TvShowModuleManager.getInstance().getSettings().getSeasonFanartFilenames()) {
                                filename = tvShowSeasonFanartNaming.getFilename(tvShowSeason, artworkFile.getExtension());
                                if (!StringUtils.isNotBlank((CharSequence)filename)) continue;
                                newMf = new MediaFile(artworkFile);
                                newMf.setFile(Paths.get(this.tvShow.getPath(), filename));
                                this.newFiles.add(newMf);
                            }
                            continue block10;
                        }
                        case SEASON_BANNER: {
                            MediaFile newMf;
                            String filename;
                            for (TvShowSeasonBannerNaming tvShowSeasonBannerNaming : TvShowModuleManager.getInstance().getSettings().getSeasonBannerFilenames()) {
                                filename = tvShowSeasonBannerNaming.getFilename(tvShowSeason, artworkFile.getExtension());
                                if (!StringUtils.isNotBlank((CharSequence)filename)) continue;
                                newMf = new MediaFile(artworkFile);
                                newMf.setFile(Paths.get(this.tvShow.getPath(), filename));
                                this.newFiles.add(newMf);
                            }
                            continue block10;
                        }
                        case SEASON_THUMB: {
                            MediaFile newMf;
                            String filename;
                            for (TvShowSeasonThumbNaming tvShowSeasonThumbNaming : TvShowModuleManager.getInstance().getSettings().getSeasonThumbFilenames()) {
                                filename = tvShowSeasonThumbNaming.getFilename(tvShowSeason, artworkFile.getExtension());
                                if (!StringUtils.isNotBlank((CharSequence)filename)) continue;
                                newMf = new MediaFile(artworkFile);
                                newMf.setFile(Paths.get(this.tvShow.getPath(), filename));
                                this.newFiles.add(newMf);
                            }
                            continue block10;
                        }
                    }
                }
            }
        }
    }

    private void processEpisodes() {
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>(this.tvShow.getEpisodes());
        Collections.sort(episodes);
        for (TvShowEpisode episode : episodes) {
            MediaFile oldMf;
            MediaFile mainVideoFile = episode.getMainVideoFile();
            String oldVideoBasename = episode.getVideoBasenameWithoutStacking();
            if (episode.getSeason() < 0 || episode.getEpisode() < 0) {
                for (MediaFile mf : episode.getMediaFiles()) {
                    oldMf = new MediaFile(mf);
                    this.oldFiles.put(oldMf.getFileAsPath().toString(), oldMf);
                    MediaFile newMf = new MediaFile(mf);
                    this.newFiles.add(newMf);
                }
                continue;
            }
            if (episode.isDisc()) {
                String seasonFoldername = TvShowRenamer.getSeasonFoldername(episode.getTvShow(), episode);
                Path seasonFolder = this.container.newPath;
                if (StringUtils.isNotBlank((CharSequence)seasonFoldername)) {
                    seasonFolder = this.container.newPath.resolve(seasonFoldername);
                }
                String newFoldername = FilenameUtils.getBaseName((String)TvShowRenamer.generateFoldername(episode.getTvShow(), mainVideoFile));
                Path newEpFolder = seasonFolder.resolve(newFoldername);
                for (MediaFile mf : episode.getMediaFiles()) {
                    MediaFile oldMf2 = new MediaFile(mf);
                    this.oldFiles.put(oldMf2.getFileAsPath().toString(), oldMf2);
                    MediaFile newMf = new MediaFile(mf);
                    String newMfFolder = newMf.getPath().replace(mainVideoFile.getPath(), newEpFolder.toString());
                    newMf.replacePathForRenamedFolder(mf.getFileAsPath().getParent(), Paths.get(newMfFolder, new String[0]));
                    this.newFiles.add(newMf);
                }
                continue;
            }
            for (MediaFile mf : episode.getMediaFiles()) {
                oldMf = new MediaFile(mf);
                this.oldFiles.put(oldMf.getFileAsPath().toString(), oldMf);
                this.newFiles.addAll(TvShowRenamer.generateEpisodeFilenames(this.clone, new MediaFile(mf), oldVideoBasename));
            }
        }
    }
}

