/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.connector;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeNfoParser;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeToKodiConnector;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.w3c.dom.Element;

public class TvShowEpisodeToJellyfinConnector
extends TvShowEpisodeToKodiConnector {
    public TvShowEpisodeToJellyfinConnector(List<TvShowEpisode> episodes) {
        super(episodes);
    }

    @Override
    protected void addThumb(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
    }

    @Override
    protected void addActors(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        for (Person tvShowActor : episode.getActors()) {
            Element profile;
            Element actor = this.document.createElement("actor");
            Element name = this.document.createElement("name");
            name.setTextContent(tvShowActor.getName());
            actor.appendChild(name);
            if (StringUtils.isNotBlank((CharSequence)tvShowActor.getRole())) {
                Element role = this.document.createElement("role");
                role.setTextContent(tvShowActor.getRole());
                actor.appendChild(role);
            }
            if (StringUtils.isNotBlank((CharSequence)tvShowActor.getProfileUrl())) {
                profile = this.document.createElement("profile");
                profile.setTextContent(tvShowActor.getProfileUrl());
                actor.appendChild(profile);
            }
            if (tvShowActor.getType() == Person.Type.GUEST) {
                profile = this.document.createElement("type");
                profile.setTextContent("GuestStar");
                actor.appendChild(profile);
            }
            this.addPersonIdsAsChildren(actor, tvShowActor);
            this.root.appendChild(actor);
        }
    }
}

