/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.connector;

import java.util.List;
import java.util.Locale;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeGenericXmlConnector;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeNfoParser;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.w3c.dom.Element;

public class TvShowEpisodeToKodiConnector
extends TvShowEpisodeGenericXmlConnector {
    public TvShowEpisodeToKodiConnector(List<TvShowEpisode> episodes) {
        super(episodes);
    }

    @Override
    protected void addRating(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element ratings = this.document.createElement("ratings");
        for (MediaRating r : episode.getRatings().values()) {
            if ("user".equals(r.getId())) continue;
            Element rating = this.document.createElement("rating");
            if ("tmdb".equals(r.getId())) {
                rating.setAttribute("name", "themoviedb");
            } else {
                rating.setAttribute("name", r.getId());
            }
            rating.setAttribute("max", String.valueOf(r.getMaxValue()));
            MediaRating mainMediaRating = episode.getRating();
            rating.setAttribute("default", r == mainMediaRating ? "true" : "false");
            Element value = this.document.createElement("value");
            value.setTextContent(String.format(Locale.US, "%.1f", Float.valueOf(r.getRating())));
            rating.appendChild(value);
            Element votes = this.document.createElement("votes");
            votes.setTextContent(Integer.toString(r.getVotes()));
            rating.appendChild(votes);
            ratings.appendChild(rating);
        }
        this.root.appendChild(ratings);
    }

    @Override
    protected void addVotes(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
    }

    @Override
    protected void addOwnTags(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        this.addEpbookmark(episode, parser);
        this.addCode(episode, parser);
        this.addFileinfo(episode, parser);
    }

    protected void addEpbookmark(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element epbookmark = this.document.createElement("epbookmark");
        if (parser != null) {
            epbookmark.setTextContent(parser.epbookmark);
        }
        this.root.appendChild(epbookmark);
    }

    protected void addCode(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element code = this.document.createElement("code");
        if (parser != null) {
            code.setTextContent(parser.code);
        }
        this.root.appendChild(code);
    }

    protected void addFileinfo(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        if (TvShowModuleManager.getInstance().getSettings().isNfoWriteFileinfo()) {
            Element fileinfo = this.document.createElement("fileinfo");
            Element streamdetails = this.document.createElement("streamdetails");
            List<MediaFile> videos = episode.getMediaFiles(MediaFileType.VIDEO);
            if (!videos.isEmpty()) {
                MediaFile videoFile = videos.get(0);
                Element video = this.document.createElement("video");
                Element codec = this.document.createElement("codec");
                if ("h265".equalsIgnoreCase(videoFile.getVideoCodec())) {
                    codec.setTextContent("HEVC");
                } else {
                    codec.setTextContent(videoFile.getVideoCodec());
                }
                video.appendChild(codec);
                Element aspect = this.document.createElement("aspect");
                aspect.setTextContent(String.valueOf(videoFile.getAspectRatio()));
                video.appendChild(aspect);
                Element width = this.document.createElement("width");
                width.setTextContent(String.valueOf(videoFile.getVideoWidth()));
                video.appendChild(width);
                Element height = this.document.createElement("height");
                height.setTextContent(String.valueOf(videoFile.getVideoHeight()));
                video.appendChild(height);
                if (episode.isVideoInHDR().booleanValue()) {
                    Element hdr = this.document.createElement("hdrtype");
                    if (videoFile.getHdrFormat().contains("Dolby Vision")) {
                        hdr.setTextContent("dolbyvision");
                    } else if (videoFile.getHdrFormat().contains("HLG")) {
                        hdr.setTextContent("hlg");
                    } else if (videoFile.getHdrFormat().contains("HDR10")) {
                        hdr.setTextContent("hdr10");
                    }
                    video.appendChild(hdr);
                }
                if (!episode.isDisc() && !episode.getMainVideoFile().getExtension().equalsIgnoreCase("iso")) {
                    Element durationinseconds = this.document.createElement("durationinseconds");
                    durationinseconds.setTextContent(String.valueOf(episode.getRuntimeFromMediaFiles()));
                    video.appendChild(durationinseconds);
                }
                Element stereomode = this.document.createElement("stereomode");
                switch (videoFile.getVideo3DFormat()) {
                    case "3D SBS": 
                    case "3D HSBS": {
                        stereomode.setTextContent("left_right");
                        break;
                    }
                    case "3D TAB": 
                    case "3D HTAB": {
                        stereomode.setTextContent("top_bottom");
                        break;
                    }
                }
                video.appendChild(stereomode);
                streamdetails.appendChild(video);
                for (MediaFileAudioStream as : videoFile.getAudioStreams()) {
                    Element audio = this.document.createElement("audio");
                    Element audioCodec = this.document.createElement("codec");
                    audioCodec.setTextContent(as.getCodec().replaceAll("-", "_"));
                    audio.appendChild(audioCodec);
                    Element language = this.document.createElement("language");
                    language.setTextContent(as.getLanguage());
                    audio.appendChild(language);
                    Element channels = this.document.createElement("channels");
                    channels.setTextContent(String.valueOf(as.getAudioChannels()));
                    audio.appendChild(channels);
                    streamdetails.appendChild(audio);
                }
                for (MediaFileSubtitle ss : videoFile.getSubtitles()) {
                    Element subtitle = this.document.createElement("subtitle");
                    Element language = this.document.createElement("language");
                    language.setTextContent(ss.getLanguage());
                    subtitle.appendChild(language);
                    streamdetails.appendChild(subtitle);
                }
                for (MediaFile sub : episode.getMediaFiles(MediaFileType.SUBTITLE)) {
                    for (MediaFileSubtitle ss : sub.getSubtitles()) {
                        Element subtitle = this.document.createElement("subtitle");
                        Element language = this.document.createElement("language");
                        language.setTextContent(ss.getLanguage());
                        subtitle.appendChild(language);
                        streamdetails.appendChild(subtitle);
                    }
                }
            }
            fileinfo.appendChild(streamdetails);
            this.root.appendChild(fileinfo);
        }
    }
}

