/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.connector;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.connector.ITvShowSeasonConnector;
import org.tinymediamanager.core.tvshow.connector.TvShowConnectors;
import org.tinymediamanager.core.tvshow.connector.TvShowSeasonNfoParser;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.core.tvshow.filenaming.TvShowSeasonNfoNaming;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class TvShowSeasonGenericXmlConnector
implements ITvShowSeasonConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowSeasonGenericXmlConnector.class);
    protected static final String ORACLE_IS_STANDALONE = "http://www.oracle.com/xml/is-standalone";
    protected final TvShowSeason tvShowSeason;
    protected TvShowSeasonNfoParser parser = null;
    protected Document document;
    protected Element root;

    protected TvShowSeasonGenericXmlConnector(TvShowSeason tvShowSeason) {
        this.tvShowSeason = tvShowSeason;
    }

    protected abstract void addOwnTags();

    @Override
    public void write(List<TvShowSeasonNfoNaming> nfoNames) {
        if (!TvShowModuleManager.getInstance().getSettings().isWriteCleanNfo()) {
            for (MediaFile mediaFile : this.tvShowSeason.getMediaFiles(MediaFileType.NFO)) {
                try {
                    this.parser = TvShowSeasonNfoParser.parseNfo(mediaFile.getFileAsPath());
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        ArrayList<MediaFile> newNfos = new ArrayList<MediaFile>(1);
        for (TvShowSeasonNfoNaming nfoNaming : nfoNames) {
            String nfoFilename = nfoNaming.getFilename(this.tvShowSeason, "nfo", false);
            if (StringUtils.isBlank((CharSequence)nfoFilename)) continue;
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                this.document = factory.newDocumentBuilder().newDocument();
                this.document.setXmlStandalone(true);
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String dat = formatter.format((Object)new Date());
                this.document.appendChild(this.document.createComment("created on " + dat + " - tinyMediaManager " + Settings.getInstance().getVersion()));
                this.root = this.document.createElement("season");
                this.document.appendChild(this.root);
                this.addSeasonNumber();
                this.addTitle();
                this.addShowTitle();
                this.addSortTitle();
                this.addYear();
                this.addPlot();
                this.addThumb();
                this.addFanart();
                this.addTvdbId();
                this.addImdbid();
                this.addTmdbid();
                this.addIds();
                this.addPremiered();
                this.addLockdata();
                this.addOwnTags();
                this.addUnsupportedTags();
                this.addTinyMediaManagerTags();
                StringWriter out = new StringWriter();
                this.getTransformer().transform(new DOMSource(this.document), new StreamResult(out));
                String xml = ((Object)out).toString().replaceAll("(?<!\r)\n", "\r\n");
                Path f = this.tvShowSeason.getTvShow().getPathNIO().resolve(nfoFilename);
                boolean changed = true;
                try {
                    String xmlOld = Utils.readFileToString(f).replaceAll("\\<\\!\\-\\-.*\\-\\-\\>", "");
                    String xmlNew = xml.replaceAll("\\<\\!\\-\\-.*\\-\\-\\>", "");
                    if (xmlOld.equals(xmlNew)) {
                        changed = false;
                    }
                }
                catch (Exception xmlOld) {
                    // empty catch block
                }
                if (changed) {
                    Utils.writeStringToFile(f, xml);
                } else {
                    LOGGER.debug("NFO {} did not change - do not write it!", (Object)f);
                }
                MediaFile mf = new MediaFile(f);
                mf.gatherMediaInformation(true);
                newNfos.add(mf);
            }
            catch (Exception e) {
                LOGGER.error("write '" + this.tvShowSeason.getTvShow().getPathNIO().resolve(nfoFilename) + "'", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.tvShowSeason, "message.nfo.writeerror", new String[]{":", e.getLocalizedMessage()}));
            }
        }
        if (!newNfos.isEmpty()) {
            List<MediaFile> list = this.tvShowSeason.getMediaFiles(MediaFileType.NFO);
            for (MediaFile nfo : list) {
                if (!TvShowConnectors.isValidTvShowSeasonNFO(nfo.getFileAsPath())) {
                    newNfos.add(nfo);
                    continue;
                }
                if (newNfos.contains(nfo)) continue;
                try {
                    Utils.deleteFileWithBackup(nfo.getFileAsPath(), this.tvShowSeason.getTvShow().getDataSource());
                }
                catch (Exception e) {
                    LOGGER.debug("Could not remove orphaned NFO - '{}'", (Object)e.getMessage());
                }
            }
            this.tvShowSeason.removeAllMediaFiles(MediaFileType.NFO);
            this.tvShowSeason.addToMediaFiles(newNfos);
        }
    }

    protected void addSeasonNumber() {
        Element seasonNumber = this.document.createElement("seasonnumber");
        seasonNumber.setTextContent(String.valueOf(this.tvShowSeason.getSeason()));
        this.root.appendChild(seasonNumber);
    }

    protected void addTitle() {
        Element title = this.document.createElement("title");
        if (StringUtils.isNotBlank((CharSequence)this.tvShowSeason.getTitle())) {
            title.setTextContent(this.tvShowSeason.getTitle());
        } else {
            title.setTextContent(String.format("%s %d", TmmResourceBundle.getString("metatag.season"), this.tvShowSeason.getSeason()));
        }
        this.root.appendChild(title);
    }

    protected void addShowTitle() {
        Element title = this.document.createElement("showtitle");
        title.setTextContent(this.tvShowSeason.getTvShow().getTitle());
        this.root.appendChild(title);
    }

    protected void addSortTitle() {
        Element sorttitle = this.document.createElement("sorttitle");
        if (StringUtils.isNotBlank((CharSequence)this.tvShowSeason.getTitle())) {
            sorttitle.setTextContent(this.tvShowSeason.getTitle());
        } else {
            sorttitle.setTextContent(String.format("%s %02d", TmmResourceBundle.getString("metatag.season"), this.tvShowSeason.getSeason()));
        }
        this.root.appendChild(sorttitle);
    }

    protected void addYear() {
        Element year = this.document.createElement("year");
        int lowestYear = 0;
        for (TvShowEpisode episode : this.tvShowSeason.getEpisodesForDisplay()) {
            if (episode.getYear() >= lowestYear) continue;
            lowestYear = episode.getYear();
        }
        if (lowestYear > 0) {
            year.setTextContent(Integer.toString(lowestYear));
        }
        this.root.appendChild(year);
    }

    protected void addPlot() {
        Element plot = this.document.createElement("plot");
        plot.setTextContent(this.tvShowSeason.getPlot());
        this.root.appendChild(plot);
    }

    protected void addThumb() {
        this.addThumb(MediaFileType.SEASON_POSTER, "poster");
        this.addThumb(MediaFileType.SEASON_BANNER, "banner");
        this.addThumb(MediaFileType.SEASON_THUMB, "landscape");
    }

    private void addThumb(MediaFileType type, String aspect) {
        Element thumb = this.document.createElement("thumb");
        String artworkUrl = this.tvShowSeason.getArtworkUrl(type);
        if (StringUtils.isNotBlank((CharSequence)artworkUrl)) {
            thumb.setAttribute("aspect", aspect);
            thumb.setTextContent(artworkUrl);
            this.root.appendChild(thumb);
        }
    }

    protected void addFanart() {
        Element fanart = this.document.createElement("fanart");
        LinkedHashSet<String> fanartUrls = new LinkedHashSet<String>();
        String fanartUrl = this.tvShowSeason.getArtworkUrl(MediaFileType.SEASON_FANART);
        if (StringUtils.isNotBlank((CharSequence)fanartUrl)) {
            fanartUrls.add(fanartUrl);
        }
        for (String url : fanartUrls) {
            Element thumb = this.document.createElement("thumb");
            thumb.setTextContent(url);
            fanart.appendChild(thumb);
        }
        if (!fanartUrls.isEmpty()) {
            this.root.appendChild(fanart);
        }
    }

    protected void addTvdbId() {
        Element id = this.document.createElement("tvdbid");
        id.setTextContent(this.tvShowSeason.getTvShow().getTvdbId());
        this.root.appendChild(id);
    }

    protected void addImdbid() {
        Element imdbid = this.document.createElement("imdbid");
        imdbid.setTextContent(this.tvShowSeason.getTvShow().getImdbId());
        this.root.appendChild(imdbid);
    }

    protected void addTmdbid() {
        Element tmdbid = this.document.createElement("tmdbid");
        if (this.tvShowSeason.getTvShow().getTmdbId() > 0) {
            tmdbid.setTextContent(Integer.toString(this.tvShowSeason.getTvShow().getTmdbId()));
        }
        this.root.appendChild(tmdbid);
    }

    protected void addIds() {
        for (Map.Entry<String, Object> entry : this.tvShowSeason.getTvShow().getIds().entrySet()) {
            Element uniqueid = this.document.createElement("uniqueid");
            uniqueid.setAttribute("type", entry.getKey());
            uniqueid.setTextContent(entry.getValue().toString());
            this.root.appendChild(uniqueid);
        }
    }

    protected void addPremiered() {
        Element premiered = this.document.createElement("premiered");
        if (this.tvShowSeason.getFirstAired() != null) {
            premiered.setTextContent(new SimpleDateFormat("yyyy-MM-dd").format(this.tvShowSeason.getFirstAired()));
        }
        this.root.appendChild(premiered);
    }

    protected void addLockdata() {
        if (TvShowModuleManager.getInstance().getSettings().isNfoWriteLockdata()) {
            Element lockdata = this.document.createElement("lockdata");
            lockdata.setTextContent("true");
            this.root.appendChild(lockdata);
        }
    }

    protected void addUnsupportedTags() {
        if (this.parser != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            for (String unsupportedString : this.parser.unsupportedElements) {
                try {
                    Document unsupported = factory.newDocumentBuilder().parse(new ByteArrayInputStream(unsupportedString.getBytes(StandardCharsets.UTF_8)));
                    this.root.appendChild(this.document.importNode(unsupported.getFirstChild(), true));
                }
                catch (Exception e) {
                    LOGGER.error("import unsupported tags: {}", (Object)e.getMessage());
                }
            }
        }
    }

    protected void addTinyMediaManagerTags() {
        this.root.appendChild(this.document.createComment("tinyMediaManager meta data"));
        this.addUserNote();
    }

    protected void addUserNote() {
        Element userNote = this.document.createElement("user_note");
        userNote.setTextContent(this.tvShowSeason.getNote());
        this.root.appendChild(userNote);
    }

    protected Element getSingleElementByTag(String tag) {
        NodeList nodeList = this.document.getElementsByTagName(tag);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    protected Transformer getTransformer() throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("doctype-public", "yes");
        try {
            transformer.setOutputProperty(ORACLE_IS_STANDALONE, "yes");
        }
        catch (Exception exception) {
            // empty catch block
        }
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        return transformer;
    }
}

