/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.entities;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.io.File;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.IMediaInformation;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.MediaSource;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tasks.MediaEntityImageFetcherTask;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskChain;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowEpisodeEdition;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowMediaFileComparator;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.connector.TvShowConnectors;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeGenericXmlConnector;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeToEmbyConnector;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeToJellyfinConnector;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeToKodiConnector;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeToXbmcConnector;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.core.tvshow.filenaming.TvShowEpisodeNfoNaming;
import org.tinymediamanager.core.tvshow.filenaming.TvShowEpisodeThumbNaming;
import org.tinymediamanager.core.tvshow.tasks.TvShowActorImageFetcherTask;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;
import org.tinymediamanager.scraper.entities.MediaEpisodeNumber;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.StrgUtils;

public class TvShowEpisode
extends MediaEntity
implements Comparable<TvShowEpisode>,
IMediaInformation {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisode.class);
    private static final Comparator<MediaFile> MEDIA_FILE_COMPARATOR = new TvShowMediaFileComparator();
    @JsonProperty
    private final List<MediaEpisodeNumber> episodeNumbers = new CopyOnWriteArrayList<MediaEpisodeNumber>();
    @JsonProperty
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private Date firstAired = null;
    @JsonProperty
    private boolean disc = false;
    @JsonProperty
    private boolean multiEpisode = false;
    @JsonProperty
    private boolean watched = false;
    @JsonProperty
    private int playcount = 0;
    @JsonProperty
    private UUID tvShowId = null;
    @JsonProperty
    private MediaSource mediaSource = MediaSource.UNKNOWN;
    @JsonProperty
    private TvShowEpisodeEdition edition = TvShowEpisodeEdition.NONE;
    @JsonProperty
    private boolean stacked = false;
    @JsonProperty
    private final List<Person> actors = new CopyOnWriteArrayList<Person>();
    @JsonProperty
    private final List<Person> directors = new CopyOnWriteArrayList<Person>();
    @JsonProperty
    private final List<Person> writers = new CopyOnWriteArrayList<Person>();
    private TvShow tvShow = null;
    private String titleSortable = "";
    private String otherIds = "";
    private Date lastWatched = null;
    private boolean dummy = false;
    private MediaEpisodeNumber mainEpisodeNumber = null;
    @JsonIgnore
    public Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public TvShowEpisode() {
    }

    public TvShowEpisode(@NotNull TvShowEpisode source) {
        this.tvShow = source.tvShow;
        this.tvShowId = source.tvShowId;
        for (MediaFile mf : source.getMediaFiles()) {
            this.addToMediaFiles(new MediaFile(mf));
        }
        this.path = source.path;
        this.title = source.title;
        this.originalTitle = source.originalTitle;
        this.year = source.year;
        this.plot = source.plot;
        this.artworkUrlMap.putAll(source.artworkUrlMap);
        this.dateAdded = new Date(source.dateAdded.getTime());
        this.ids.putAll(source.ids);
        this.mediaSource = source.mediaSource;
        this.edition = source.edition;
        this.episodeNumbers.addAll(source.episodeNumbers);
        if (source.firstAired != null) {
            this.firstAired = new Date(source.firstAired.getTime());
        }
        this.disc = source.disc;
        this.stacked = source.stacked;
        this.multiEpisode = source.multiEpisode;
        this.titleSortable = source.titleSortable;
        this.otherIds = source.otherIds;
        this.lastWatched = source.lastWatched;
        this.watched = source.watched;
        this.playcount = source.playcount;
        for (Person actor : source.getActors()) {
            this.actors.add(new Person(actor));
        }
        for (Person director : source.getDirectors()) {
            this.directors.add(new Person(director));
        }
        for (Person writer : source.getWriters()) {
            this.writers.add(new Person(writer));
        }
        for (MediaRating mediaRating : source.getRatings().values()) {
            this.ratings.put(mediaRating.getId(), new MediaRating(mediaRating));
        }
        this.tags.addAll(source.tags);
        this.originalFilename = source.originalFilename;
        this.productionCompany = source.productionCompany;
        this.dummy = source.dummy;
        this.note = source.note;
    }

    @Override
    public void setId(String key, Object value) {
        super.setId(key, value);
        this.otherIds = "";
        this.firePropertyChange("otherIds", null, key + ":" + value);
    }

    public String getOtherIds() {
        if (StringUtils.isNotBlank((CharSequence)this.otherIds)) {
            return this.otherIds;
        }
        block12: for (Map.Entry<String, Object> entry : this.getIds().entrySet()) {
            switch (entry.getKey()) {
                case "tvdb": 
                case "imdb": 
                case "tmdb": 
                case "trakt": {
                    continue block12;
                }
                case "imdbId": 
                case "tvShowSeason": {
                    continue block12;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)this.otherIds)) {
                this.otherIds = this.otherIds + "; ";
            }
            this.otherIds = this.otherIds + entry.getKey() + ": " + entry.getValue();
        }
        return this.otherIds;
    }

    public void merge(TvShowEpisode other) {
        this.merge(other, false);
    }

    public void forceMerge(TvShowEpisode other) {
        this.merge(other, true);
    }

    void merge(TvShowEpisode other, boolean force) {
        if (this.locked || other == null) {
            return;
        }
        super.merge(other, force);
        this.setFirstAired(this.firstAired == null || force ? other.firstAired : this.firstAired);
        this.setWatched(!this.watched || force ? other.watched : this.watched);
        this.setPlaycount(this.playcount == 0 || force ? other.playcount : this.playcount);
        this.setMediaSource(this.mediaSource == MediaSource.UNKNOWN || force ? other.mediaSource : this.mediaSource);
        this.setEdition(this.edition == TvShowEpisodeEdition.NONE || force ? other.edition : this.edition);
        if (force) {
            this.actors.clear();
            this.directors.clear();
            this.writers.clear();
        }
        this.setActors(other.actors);
        this.setDirectors(other.directors);
        this.setWriters(other.writers);
        this.episodeNumbers.clear();
        this.episodeNumbers.addAll(other.episodeNumbers);
    }

    @Override
    protected Comparator<MediaFile> getMediaFileComparator() {
        return MEDIA_FILE_COMPARATOR;
    }

    @Override
    public boolean isLocked() {
        return this.getTvShow() == null || this.getTvShow().isLocked();
    }

    public void replacePathForRenamedTvShowRoot(Path oldPath, Path newPath) {
        Path newPathToSet;
        if (oldPath == null || newPath == null) {
            return;
        }
        if (oldPath.equals(this.getPathNIO())) {
            newPathToSet = newPath;
        } else {
            Path subPath = oldPath.relativize(this.getPathNIO());
            newPathToSet = newPath.resolve(subPath);
        }
        LOGGER.trace("EP replace: ({}, {}) -> {} results in {}", new Object[]{oldPath, newPath, this.getPath(), newPathToSet});
        this.setPath(newPathToSet.toAbsolutePath().toString());
    }

    public String getTitleSortable() {
        if (StringUtils.isBlank((CharSequence)this.titleSortable)) {
            this.titleSortable = Utils.getSortableName(this.getTitle());
        }
        return this.titleSortable;
    }

    public void clearTitleSortable() {
        this.titleSortable = "";
    }

    public Date getFirstAired() {
        return this.firstAired;
    }

    @JsonIgnore
    public void setFirstAired(Date newValue) {
        Date oldValue = this.firstAired;
        this.firstAired = newValue;
        this.firePropertyChange("firstAired", oldValue, newValue);
        this.firePropertyChange("firstAiredAsString", oldValue, newValue);
        if (this.firstAired != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.firstAired);
            this.setYear(calendar.get(1));
        }
    }

    @Override
    public Date getReleaseDate() {
        return this.getFirstAired();
    }

    public TvShowSeason getTvShowSeason() {
        if (this.tvShow == null) {
            return null;
        }
        return this.tvShow.getSeasonForEpisode(this);
    }

    public void setTvShowSeason() {
    }

    public boolean isDisc() {
        return this.disc;
    }

    public void setDisc(boolean disc) {
        this.disc = disc;
    }

    public boolean isMultiEpisode() {
        return this.multiEpisode;
    }

    public void setMultiEpisode(boolean multiEpisode) {
        this.multiEpisode = multiEpisode;
    }

    public String getFirstAiredFormatted() {
        if (this.firstAired == null) {
            return "";
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(this.firstAired);
    }

    public String getFirstAiredAsString() {
        if (this.firstAired == null) {
            return "";
        }
        return TmmDateFormat.MEDIUM_DATE_FORMAT.format(this.firstAired);
    }

    public void setFirstAired(String aired) {
        try {
            this.setFirstAired(StrgUtils.parseDate(aired));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public TvShow getTvShow() {
        return this.tvShow;
    }

    public void setTvShow(TvShow newValue) {
        TvShow oldValue = this.tvShow;
        this.tvShow = newValue;
        this.tvShowId = this.tvShow.getDbId();
        this.firePropertyChange("tvShow", oldValue, newValue);
    }

    public UUID getTvShowDbId() {
        return this.tvShowId;
    }

    @Override
    public String getDataSource() {
        return this.tvShow.getDataSource();
    }

    public List<MediaEpisodeNumber> getEpisodeNumbers() {
        return Collections.unmodifiableList(this.episodeNumbers);
    }

    public void setEpisodeNumbers(Map<MediaEpisodeGroup, MediaEpisodeNumber> newValues) {
        this.episodeNumbers.clear();
        this.mainEpisodeNumber = null;
        if (newValues != null) {
            MediaEpisodeGroup tvShowEpisodeGroup = this.tvShow != null ? this.tvShow.getEpisodeGroup() : null;
            for (MediaEpisodeGroup.EpisodeGroupType eg : MediaEpisodeGroup.EpisodeGroupType.values()) {
                MediaEpisodeNumber episodeNumber2;
                ArrayList<MediaEpisodeNumber> episodeNumbersForType = new ArrayList<MediaEpisodeNumber>();
                if (tvShowEpisodeGroup != null && tvShowEpisodeGroup.getEpisodeGroupType() == eg && (episodeNumber2 = newValues.get(tvShowEpisodeGroup)) != null) {
                    episodeNumbersForType.add(episodeNumber2);
                }
                newValues.forEach((group, episodeNumber) -> {
                    if (group.getEpisodeGroupType() == eg && !episodeNumbersForType.contains(episodeNumber)) {
                        episodeNumbersForType.add((MediaEpisodeNumber)episodeNumber);
                    }
                });
                episodeNumbersForType.forEach(this::setEpisode);
            }
        }
    }

    public MediaEpisodeGroup getEpisodeGroup() {
        if (this.getTvShow() != null) {
            return this.getTvShow().getEpisodeGroup();
        }
        return MediaEpisodeGroup.DEFAULT_AIRED;
    }

    public MediaEpisodeNumber getEpisodeNumber() {
        if (this.mainEpisodeNumber == null) {
            this.mainEpisodeNumber = this.getEpisodeNumber(this.getEpisodeGroup());
        }
        return this.mainEpisodeNumber;
    }

    public MediaEpisodeNumber getEpisodeNumber(@NotNull MediaEpisodeGroup episodeGroup) {
        MediaEpisodeNumber episodeNumber;
        block3: {
            block4: {
                episodeNumber = null;
                for (MediaEpisodeNumber mediaEpisodeNumber : this.episodeNumbers) {
                    if (!mediaEpisodeNumber.episodeGroup().equals(episodeGroup)) continue;
                    episodeNumber = mediaEpisodeNumber;
                    break;
                }
                if (episodeNumber != null || episodeGroup.getEpisodeGroupType() != MediaEpisodeGroup.EpisodeGroupType.AIRED) break block4;
                for (MediaEpisodeNumber mediaEpisodeNumber : this.episodeNumbers) {
                    if (mediaEpisodeNumber.episodeGroup().getEpisodeGroupType() != MediaEpisodeGroup.EpisodeGroupType.AIRED) continue;
                    episodeNumber = mediaEpisodeNumber;
                    break block3;
                }
                break block3;
            }
            if (episodeNumber != null || episodeGroup.getEpisodeGroupType() != MediaEpisodeGroup.EpisodeGroupType.ABSOLUTE) break block3;
            for (MediaEpisodeNumber mediaEpisodeNumber : this.episodeNumbers) {
                if (mediaEpisodeNumber.episodeGroup().getEpisodeGroupType() != MediaEpisodeGroup.EpisodeGroupType.ABSOLUTE) continue;
                episodeNumber = mediaEpisodeNumber;
                break;
            }
        }
        return episodeNumber;
    }

    private MediaEpisodeNumber getEpisodeNumber(@NotNull MediaEpisodeGroup.EpisodeGroupType episodeGroupType) {
        for (MediaEpisodeNumber mediaEpisodeNumber : this.episodeNumbers) {
            if (mediaEpisodeNumber.episodeGroup().getEpisodeGroupType() != episodeGroupType) continue;
            return mediaEpisodeNumber;
        }
        return null;
    }

    public int getEpisode(MediaEpisodeGroup.EpisodeGroupType episodeGroupType) {
        MediaEpisodeNumber episodeNumber = this.getEpisodeNumber(episodeGroupType);
        if (episodeNumber != null) {
            return episodeNumber.episode();
        }
        return -1;
    }

    public int getEpisode(MediaEpisodeGroup mediaEpisodeGroup) {
        MediaEpisodeNumber episodeNumber = this.getEpisodeNumber(mediaEpisodeGroup);
        if (episodeNumber != null) {
            return episodeNumber.episode();
        }
        return -1;
    }

    public int getEpisode() {
        return this.getEpisode(this.getEpisodeGroup());
    }

    public int getSeason() {
        return this.getSeason(this.getEpisodeGroup());
    }

    public void setEpisode(@NotNull MediaEpisodeNumber episode) {
        if (!episode.containsAnyNumber()) {
            ArrayList<MediaEpisodeNumber> toRemove = new ArrayList<MediaEpisodeNumber>();
            for (MediaEpisodeNumber mediaEpisodeNumber : this.episodeNumbers) {
                if (!mediaEpisodeNumber.episodeGroup().equals(episode.episodeGroup())) continue;
                toRemove.add(mediaEpisodeNumber);
            }
            if (!toRemove.isEmpty()) {
                this.episodeNumbers.removeAll(toRemove);
                this.firePropertyChange("episode", 0, -1);
                this.firePropertyChange("season", 0, -1);
                this.firePropertyChange("titleForUi", -1, episode.episode());
                return;
            }
        }
        MediaEpisodeNumber existingEpisodeNumber = null;
        for (MediaEpisodeNumber mediaEpisodeNumber : this.episodeNumbers) {
            if (!mediaEpisodeNumber.episodeGroup().equals(episode.episodeGroup())) continue;
            existingEpisodeNumber = mediaEpisodeNumber;
            break;
        }
        if (existingEpisodeNumber == episode) {
            return;
        }
        if (existingEpisodeNumber != null) {
            int index = this.episodeNumbers.indexOf(existingEpisodeNumber);
            this.episodeNumbers.remove(existingEpisodeNumber);
            if (index >= 0) {
                this.episodeNumbers.add(index, episode);
            } else {
                this.episodeNumbers.add(episode);
            }
        } else {
            this.episodeNumbers.add(episode);
        }
        if (existingEpisodeNumber != null) {
            this.firePropertyChange("episode", existingEpisodeNumber.episode(), episode.episode());
            this.firePropertyChange("season", existingEpisodeNumber.season(), episode.season());
            this.firePropertyChange("titleForUi", existingEpisodeNumber.episode(), episode.episode());
        } else {
            this.firePropertyChange("episode", -1, episode.episode());
            this.firePropertyChange("season", -1, episode.season());
            this.firePropertyChange("titleForUi", -1, episode.episode());
        }
    }

    public int getAiredEpisode() {
        return this.getEpisode(MediaEpisodeGroup.EpisodeGroupType.AIRED);
    }

    @Override
    public void setTitle(String newValue) {
        String oldValue = this.title;
        super.setTitle(newValue);
        this.firePropertyChange("titleForUi", oldValue, newValue);
        oldValue = this.titleSortable;
        this.titleSortable = "";
        this.firePropertyChange("titleSortable", oldValue, this.titleSortable);
    }

    public int getSeason(MediaEpisodeGroup.EpisodeGroupType episodeGroupType) {
        MediaEpisodeNumber episodeNumber = this.getEpisodeNumber(episodeGroupType);
        if (episodeNumber != null) {
            return episodeNumber.season();
        }
        return -1;
    }

    public int getSeason(MediaEpisodeGroup mediaEpisodeGroup) {
        MediaEpisodeNumber episodeNumber = this.getEpisodeNumber(mediaEpisodeGroup);
        if (episodeNumber != null) {
            return episodeNumber.season();
        }
        return -1;
    }

    public int getTraktTvId() {
        return this.getIdAsInt("trakt");
    }

    public String getImdbId() {
        return this.getIdAsString("imdb");
    }

    public String getTmdbId() {
        return this.getIdAsString("tmdb");
    }

    public int getAiredSeason() {
        return this.getSeason(MediaEpisodeGroup.EpisodeGroupType.AIRED);
    }

    @Override
    public MediaRating getRating() {
        MediaRating mediaRating = null;
        for (String ratingSource : TvShowModuleManager.getInstance().getSettings().getRatingSources()) {
            if (!StringUtils.isBlank((CharSequence)ratingSource) && (mediaRating = (MediaRating)this.ratings.get(ratingSource)) != null) break;
        }
        if (mediaRating == null) {
            mediaRating = MediaMetadata.EMPTY_RATING;
        }
        return mediaRating;
    }

    public String getTitleForUi() {
        StringBuilder titleForUi = new StringBuilder();
        int episode = this.getEpisode();
        int season = this.getSeason();
        if (episode > 0 && season > 0) {
            titleForUi.append(String.format("S%02dE%02d - ", season, episode));
        }
        titleForUi.append(this.title);
        return titleForUi.toString();
    }

    public void downloadArtwork(MediaFileType type) {
        this.downloadArtwork(type, true);
    }

    public void downloadArtwork(MediaFileType type, boolean async) {
        switch (type) {
            case THUMB: {
                this.writeThumbImage(async);
                break;
            }
        }
    }

    private void writeThumbImage(boolean async) {
        String thumbUrl = this.getArtworkUrl(MediaFileType.THUMB);
        if (StringUtils.isNotBlank((CharSequence)thumbUrl)) {
            MediaFile mf = this.getMediaFiles(MediaFileType.VIDEO).get(0);
            String basename = FilenameUtils.getBaseName((String)mf.getFilename());
            ArrayList<String> filenames = new ArrayList<String>();
            for (TvShowEpisodeThumbNaming thumbNaming : TvShowModuleManager.getInstance().getSettings().getEpisodeThumbFilenames()) {
                Object filename = thumbNaming.getFilename(basename, Utils.getArtworkExtensionFromUrl(thumbUrl));
                if (StringUtils.isBlank((CharSequence)filename)) continue;
                if (this.isDisc()) {
                    filename = "thumb." + FilenameUtils.getExtension((String)thumbUrl);
                }
                filenames.add((String)filename);
            }
            if (!filenames.isEmpty()) {
                MediaEntityImageFetcherTask task = new MediaEntityImageFetcherTask(this, thumbUrl, MediaArtwork.MediaArtworkType.THUMB, filenames);
                if (async) {
                    TmmTaskManager.getInstance().addImageDownloadTask(task);
                } else {
                    task.run();
                }
            }
        }
        if (thumbUrl.startsWith("file:")) {
            this.removeArtworkUrl(MediaFileType.THUMB);
        }
    }

    public void setMetadata(MediaMetadata metadata, List<TvShowEpisodeScraperMetadataConfig> config, boolean overwriteExistingItems) {
        if (this.locked) {
            LOGGER.debug("episode locked, but setMetadata has been called!");
            return;
        }
        if (metadata == null) {
            LOGGER.error("metadata was null");
            return;
        }
        boolean matchFound = false;
        for (Map.Entry<String, Object> entry : metadata.getIds().entrySet()) {
            if (entry.getValue() == null || !entry.getValue().equals(this.getId(entry.getKey()))) continue;
            matchFound = true;
            break;
        }
        boolean newEntity = false;
        if (this.ids.isEmpty()) {
            matchFound = true;
            newEntity = true;
        }
        if (!matchFound && overwriteExistingItems) {
            this.ids.clear();
        }
        if (overwriteExistingItems) {
            this.setIds(metadata.getIds());
        } else {
            for (Map.Entry entry : metadata.getIds().entrySet()) {
                if (this.ids.containsKey(entry.getKey())) continue;
                this.setId((String)entry.getKey(), entry.getValue());
            }
        }
        if (config.contains(TvShowEpisodeScraperMetadataConfig.TITLE) && StringUtils.isNotBlank((CharSequence)metadata.getTitle()) && (overwriteExistingItems || newEntity || StringUtils.isBlank((CharSequence)this.getTitle()))) {
            if (TvShowModuleManager.getInstance().getSettings().getCapitalWordsInTitles()) {
                this.setTitle(StrgUtils.capitalize(metadata.getTitle()));
            } else {
                this.setTitle(metadata.getTitle());
            }
        }
        if (config.contains(TvShowEpisodeScraperMetadataConfig.ORIGINAL_TITLE) && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getOriginalTitle()))) {
            if (TvShowModuleManager.getInstance().getSettings().getCapitalWordsInTitles()) {
                this.setOriginalTitle(StrgUtils.capitalize(metadata.getOriginalTitle()));
            } else {
                this.setOriginalTitle(metadata.getOriginalTitle());
            }
        }
        if (config.contains(TvShowEpisodeScraperMetadataConfig.PLOT) && (overwriteExistingItems || StringUtils.isBlank((CharSequence)this.getPlot()))) {
            this.setPlot(metadata.getPlot());
        }
        if (config.contains(TvShowEpisodeScraperMetadataConfig.SEASON_EPISODE) && (overwriteExistingItems || this.getEpisodeNumbers().isEmpty())) {
            HashMap<MediaEpisodeGroup, MediaEpisodeNumber> newEpisodeNumbers = new HashMap<MediaEpisodeGroup, MediaEpisodeNumber>();
            for (Map.Entry<MediaEpisodeGroup, MediaEpisodeNumber> entry : metadata.getEpisodeNumbers().entrySet()) {
                if (!this.tvShow.getEpisodeGroups().contains(entry.getKey())) {
                    if (entry.getKey().getEpisodeGroupType() == MediaEpisodeGroup.EpisodeGroupType.AIRED) continue;
                    this.tvShow.addEpisodeGroup(entry.getKey());
                }
                newEpisodeNumbers.put(entry.getKey(), entry.getValue());
            }
            if (newEpisodeNumbers.isEmpty()) {
                for (Map.Entry<MediaEpisodeGroup, MediaEpisodeNumber> entry : metadata.getEpisodeNumbers().entrySet()) {
                    if (entry.getKey().getEpisodeGroupType() != MediaEpisodeGroup.EpisodeGroupType.AIRED) continue;
                    MediaEpisodeGroup aired = null;
                    for (MediaEpisodeGroup episodeGroup : this.tvShow.getEpisodeGroups()) {
                        if (episodeGroup.getEpisodeGroupType() != MediaEpisodeGroup.EpisodeGroupType.AIRED) continue;
                        aired = episodeGroup;
                        break;
                    }
                    if (aired == null) continue;
                    newEpisodeNumbers.put(aired, entry.getValue());
                }
            }
            this.setEpisodeNumbers(newEpisodeNumbers);
        }
        if (config.contains(TvShowEpisodeScraperMetadataConfig.AIRED) && (overwriteExistingItems || this.getFirstAired() == null)) {
            this.setFirstAired(metadata.getReleaseDate());
        }
        if (config.contains(TvShowEpisodeScraperMetadataConfig.RATING)) {
            HashMap<String, MediaRating> newRatings = new HashMap<String, MediaRating>();
            if (matchFound || !overwriteExistingItems) {
                newRatings.putAll(this.getRatings());
            }
            for (MediaRating mediaRating : metadata.getRatings()) {
                if (overwriteExistingItems) {
                    newRatings.put(mediaRating.getId(), mediaRating);
                    continue;
                }
                newRatings.putIfAbsent(mediaRating.getId(), mediaRating);
            }
            this.setRatings(newRatings);
        }
        if (config.contains(TvShowEpisodeScraperMetadataConfig.TAGS)) {
            if (!matchFound || overwriteExistingItems) {
                this.removeAllTags();
            }
            this.addToTags(metadata.getTags());
        }
        if (config.contains(TvShowEpisodeScraperMetadataConfig.ACTORS)) {
            if (!matchFound || overwriteExistingItems) {
                this.actors.clear();
            }
            this.setActors(metadata.getCastMembers(Person.Type.ACTOR));
        }
        if (config.contains(TvShowEpisodeScraperMetadataConfig.DIRECTORS)) {
            if (!matchFound || overwriteExistingItems) {
                this.directors.clear();
            }
            this.setDirectors(metadata.getCastMembers(Person.Type.DIRECTOR));
        }
        if (config.contains(TvShowEpisodeScraperMetadataConfig.WRITERS)) {
            if (!matchFound || overwriteExistingItems) {
                this.writers.clear();
            }
            this.setWriters(metadata.getCastMembers(Person.Type.WRITER));
        }
        this.writeNFO();
        this.saveToDb();
        this.postProcess(config, overwriteExistingItems);
    }

    public void writeNFO() {
        List<TvShowEpisodeNfoNaming> nfoNamings = TvShowModuleManager.getInstance().getSettings().getEpisodeNfoFilenames();
        if (nfoNamings.isEmpty()) {
            LOGGER.info("Not writing any NFO file, because NFO filename preferences were empty...");
            return;
        }
        ArrayList<TvShowEpisode> episodesInNfo = new ArrayList<TvShowEpisode>(1);
        LOGGER.debug("write nfo: " + this.getTvShow().getTitle() + " S" + this.getSeason() + "E" + this.getEpisode());
        for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
            ArrayList<TvShowEpisode> eps = new ArrayList<TvShowEpisode>(TvShowList.getTvEpisodesByFile(this.tvShow, mf.getFile()));
            for (TvShowEpisode ep : eps) {
                if (episodesInNfo.contains(ep)) continue;
                episodesInNfo.add(ep);
            }
        }
        TvShowEpisodeGenericXmlConnector connector = switch (TvShowModuleManager.getInstance().getSettings().getTvShowConnector()) {
            case TvShowConnectors.XBMC -> new TvShowEpisodeToXbmcConnector(episodesInNfo);
            case TvShowConnectors.EMBY -> new TvShowEpisodeToEmbyConnector(episodesInNfo);
            case TvShowConnectors.JELLYFIN -> new TvShowEpisodeToJellyfinConnector(episodesInNfo);
            default -> new TvShowEpisodeToKodiConnector(episodesInNfo);
        };
        try {
            connector.write(Collections.singletonList(TvShowEpisodeNfoNaming.FILENAME));
            this.firePropertyChange("hasNfoFile", false, true);
        }
        catch (Exception e) {
            LOGGER.error("could not write NFO file - '{}'", (Object)e.getMessage());
        }
    }

    public void addToActors(Collection<Person> newActors) {
        LinkedHashSet<Person> newItems = new LinkedHashSet<Person>();
        for (Person person : ListUtils.nullSafe(newActors)) {
            if (person == null || this.actors.contains(person)) continue;
            if (person.getType() != Person.Type.ACTOR && person.getType() != Person.Type.GUEST) {
                return;
            }
            newItems.add(person);
        }
        if (newItems.isEmpty()) {
            return;
        }
        this.actors.addAll(newItems);
        this.firePropertyChange("actors", null, this.actors);
        this.firePropertyChange("actorsAsString", null, this.getActorsAsString());
    }

    public void removeActors() {
        this.actors.clear();
        this.firePropertyChange("actors", null, this.getActors());
        this.firePropertyChange("actorsAsString", null, this.getActorsAsString());
    }

    public List<Person> getActors() {
        return this.actors;
    }

    public String getActorsAsString() {
        ArrayList<String> actorNames = new ArrayList<String>();
        for (Person actor : this.actors) {
            actorNames.add(actor.getName());
        }
        return StringUtils.join(actorNames, (String)", ");
    }

    @JsonSetter
    public void setActors(List<Person> newActors) {
        this.mergePersons(this.actors, newActors);
        this.firePropertyChange("actors", null, this.getActors());
        this.firePropertyChange("actorsAsString", null, this.getActorsAsString());
    }

    public void addToDirectors(Collection<Person> newDirectors) {
        LinkedHashSet<Person> newItems = new LinkedHashSet<Person>();
        for (Person person : ListUtils.nullSafe(newDirectors)) {
            if (person == null || this.directors.contains(person)) continue;
            if (person.getType() != Person.Type.DIRECTOR) {
                return;
            }
            newItems.add(person);
        }
        if (newItems.isEmpty()) {
            return;
        }
        this.directors.addAll(newItems);
        this.firePropertyChange("directors", null, this.directors);
        this.firePropertyChange("directorsAsString", null, this.getDirectorsAsString());
    }

    public void removeDirectors() {
        this.directors.clear();
        this.firePropertyChange("directors", null, this.getDirectors());
        this.firePropertyChange("directorsAsString", null, this.getDirectorsAsString());
    }

    @JsonSetter
    public void setDirectors(List<Person> newDirectors) {
        this.mergePersons(this.directors, newDirectors);
        this.firePropertyChange("directors", null, this.getDirectors());
        this.firePropertyChange("directorsAsString", null, this.getDirectorsAsString());
    }

    public List<Person> getDirectors() {
        return this.directors;
    }

    public String getDirectorsAsString() {
        ArrayList<String> directorNames = new ArrayList<String>();
        for (Person director : this.directors) {
            directorNames.add(director.getName());
        }
        return StringUtils.join(directorNames, (String)", ");
    }

    public void addToWriters(Collection<Person> newWriters) {
        LinkedHashSet<Person> newItems = new LinkedHashSet<Person>();
        for (Person person : ListUtils.nullSafe(newWriters)) {
            if (person == null || this.writers.contains(person)) continue;
            if (person.getType() != Person.Type.WRITER) {
                return;
            }
            newItems.add(person);
        }
        if (newItems.isEmpty()) {
            return;
        }
        this.writers.addAll(newItems);
        this.firePropertyChange("writers", null, this.getWriters());
        this.firePropertyChange("writersAsString", null, this.getWritersAsString());
    }

    public void removeWriters() {
        this.writers.clear();
        this.firePropertyChange("writers", null, this.getWriters());
        this.firePropertyChange("writersAsString", null, this.getWritersAsString());
    }

    @JsonSetter
    public void setWriters(List<Person> newWriters) {
        this.mergePersons(this.writers, newWriters);
        this.firePropertyChange("writers", null, this.getWriters());
        this.firePropertyChange("writersAsString", null, this.getWritersAsString());
    }

    public List<Person> getWriters() {
        return this.writers;
    }

    public String getWritersAsString() {
        ArrayList<String> writerNames = new ArrayList<String>();
        for (Person writer : this.writers) {
            writerNames.add(writer.getName());
        }
        return StringUtils.join(writerNames, (String)", ");
    }

    public boolean isWatched() {
        return this.watched;
    }

    public void setWatched(boolean newValue) {
        boolean oldValue = this.watched;
        this.watched = newValue;
        this.firePropertyChange("watched", oldValue, newValue);
    }

    public int getPlaycount() {
        return this.playcount;
    }

    public void setPlaycount(int newValue) {
        int oldValue = this.playcount;
        this.playcount = newValue;
        this.firePropertyChange("playcount", oldValue, newValue);
    }

    public Date getLastWatched() {
        return this.lastWatched;
    }

    public void setLastWatched(Date lastWatched) {
        this.lastWatched = lastWatched;
    }

    public String getCRC32() {
        return this.getMainVideoFile().getCRC32();
    }

    public String getMediaInfoAudioCodecAndChannels() {
        List<MediaFile> videos = this.getMediaFiles(MediaFileType.VIDEO);
        if (!videos.isEmpty()) {
            MediaFile mediaFile = videos.get(0);
            return mediaFile.getAudioCodec() + "_" + mediaFile.getAudioChannels();
        }
        return "";
    }

    public List<MediaFile> getVideoFiles() {
        return this.getMediaFiles(MediaFileType.VIDEO);
    }

    @Override
    public List<MediaFile> getImagesToCache() {
        return this.getMediaFiles().stream().filter(MediaFile::isGraphic).toList();
    }

    @Override
    public int compareTo(@NotNull TvShowEpisode otherTvShowEpisode) {
        if (this.getTvShow() != otherTvShowEpisode.getTvShow()) {
            return this.getTvShow().getTitle().compareTo(otherTvShowEpisode.getTvShow().getTitle());
        }
        if (this.getSeason() != otherTvShowEpisode.getSeason()) {
            return this.getSeason() - otherTvShowEpisode.getSeason();
        }
        if (this.getEpisode() != otherTvShowEpisode.getEpisode()) {
            return this.getEpisode() - otherTvShowEpisode.getEpisode();
        }
        String filename1 = "";
        try {
            filename1 = this.getMediaFiles(MediaFileType.VIDEO).get(0).getFilename();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String filename2 = "";
        try {
            filename2 = otherTvShowEpisode.getMediaFiles(MediaFileType.VIDEO).get(0).getFilename();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return filename1.compareTo(filename2);
    }

    public List<MediaFile> getMediaFilesContainingAudioStreams() {
        ArrayList<MediaFile> mediaFilesWithAudioStreams = new ArrayList<MediaFile>(1);
        List<MediaFile> videoFiles = this.getMediaFiles(MediaFileType.VIDEO);
        if (!videoFiles.isEmpty()) {
            MediaFile videoFile = videoFiles.get(0);
            mediaFilesWithAudioStreams.add(videoFile);
        }
        mediaFilesWithAudioStreams.addAll(this.getMediaFiles(MediaFileType.AUDIO));
        return mediaFilesWithAudioStreams;
    }

    public List<MediaFile> getMediaFilesContainingSubtitles() {
        ArrayList<MediaFile> mediaFilesWithSubtitles = new ArrayList<MediaFile>(1);
        for (MediaFile mediaFile : this.getMediaFiles(MediaFileType.VIDEO, MediaFileType.AUDIO, MediaFileType.SUBTITLE)) {
            if (!mediaFile.hasSubtitles()) continue;
            mediaFilesWithSubtitles.add(mediaFile);
        }
        return mediaFilesWithSubtitles;
    }

    public boolean getHasSubtitles() {
        if (!this.getMediaFiles(MediaFileType.SUBTITLE).isEmpty()) {
            return true;
        }
        for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO, MediaFileType.AUDIO)) {
            if (!mf.hasSubtitles()) continue;
            return true;
        }
        return false;
    }

    public int getRuntimeFromMediaFiles() {
        List<TvShowEpisode> eps;
        int runtime = 0;
        for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
            runtime += mf.getDuration();
        }
        if (this.isMultiEpisode() && !(eps = TvShowList.getTvEpisodesByFile(this.tvShow, this.getMainVideoFile().getFile())).isEmpty()) {
            runtime = (int)((float)runtime / (float)eps.size());
        }
        return runtime;
    }

    public int getRuntimeFromMediaFilesInMinutes() {
        return this.getRuntimeFromMediaFiles() / 60;
    }

    @Override
    public synchronized void callbackForWrittenArtwork(MediaArtwork.MediaArtworkType type) {
    }

    @Override
    public void callbackForGatheredMediainformation(MediaFile mediaFile) {
        boolean dirty = false;
        if (this.getMediaSource() == MediaSource.BLURAY && this.getMainVideoFile().getVideoDefinitionCategory().equals("UHD")) {
            this.setMediaSource(MediaSource.UHD_BLURAY);
            dirty = true;
        }
        if (mediaFile.getType() == MediaFileType.VIDEO && TvShowModuleManager.getInstance().getSettings().isUseMediainfoMetadata() && this.getMediaFiles(MediaFileType.NFO).isEmpty() && !mediaFile.getExtraData().isEmpty()) {
            String plot;
            String originalTitle;
            String title;
            String s;
            String e;
            if ((this.getAiredEpisode() == -1 || this.getAiredSeason() == -1) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{e = mediaFile.getExtraData().get("episode"), s = mediaFile.getExtraData().get("season")})) {
                try {
                    this.setEpisode(new MediaEpisodeNumber(MediaEpisodeGroup.DEFAULT_AIRED, Integer.parseInt(s), Integer.parseInt(e)));
                    dirty = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(title = mediaFile.getExtraData().get("title")))) {
                this.setTitle(title);
                dirty = true;
            }
            if (StringUtils.isNotBlank((CharSequence)(originalTitle = mediaFile.getExtraData().get("originalTitle")))) {
                this.setOriginalTitle(originalTitle);
                dirty = true;
            }
            if (StringUtils.isNotBlank((CharSequence)(plot = mediaFile.getExtraData().get("plot")))) {
                this.setPlot(plot);
                dirty = true;
            }
        }
        if (dirty) {
            this.saveToDb();
        }
    }

    @Override
    public void saveToDb() {
        TvShowModuleManager.getInstance().getTvShowList().persistEpisode(this);
    }

    void setSeasonArtworkChanged(MediaArtwork.MediaArtworkType type) {
        switch (type) {
            case SEASON_POSTER: {
                this.firePropertyChange("seasonPoster", null, "");
                break;
            }
            case SEASON_BANNER: {
                this.firePropertyChange("seasonBanner", null, "");
                break;
            }
            case SEASON_THUMB: {
                this.firePropertyChange("seasonThumb", null, "");
                break;
            }
        }
    }

    @Override
    protected float calculateScrapeScore() {
        float score = super.calculateScrapeScore();
        score += (float)Utils.returnOneWhenFilled(this.plot);
        score += (float)Utils.returnOneWhenFilled(this.originalTitle);
        score += (float)Utils.returnOneWhenFilled(this.ratings);
        score += (float)(2 * Utils.returnOneWhenFilled(this.firstAired));
        score += (float)(2 * Utils.returnOneWhenFilled(this.actors));
        score += (float)Utils.returnOneWhenFilled(this.directors);
        score += (float)Utils.returnOneWhenFilled(this.writers);
        return score += (float)Utils.returnOneWhenFilled(this.artworkUrlMap);
    }

    public String getTvdbId() {
        Object obj = this.ids.get("tvdb");
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    public int getDvdSeason() {
        return this.getSeason(MediaEpisodeGroup.EpisodeGroupType.DVD);
    }

    public int getDvdEpisode() {
        return this.getEpisode(MediaEpisodeGroup.EpisodeGroupType.DVD);
    }

    public int getDisplaySeason() {
        return this.getSeason(MediaEpisodeGroup.EpisodeGroupType.DISPLAY);
    }

    public int getDisplayEpisode() {
        return this.getEpisode(MediaEpisodeGroup.EpisodeGroupType.DISPLAY);
    }

    public int getAbsoluteNumber() {
        return this.getEpisode(MediaEpisodeGroup.EpisodeGroupType.ABSOLUTE);
    }

    public MediaSource getMediaSource() {
        return this.mediaSource;
    }

    public void setMediaSource(MediaSource newValue) {
        MediaSource oldValue = this.mediaSource;
        this.mediaSource = newValue;
        this.firePropertyChange("mediaSource", oldValue, newValue);
    }

    public TvShowEpisodeEdition getEdition() {
        return this.edition;
    }

    public String getEditionAsString() {
        return this.edition.toString();
    }

    public void setEdition(TvShowEpisodeEdition newValue) {
        TvShowEpisodeEdition oldValue = this.edition;
        this.edition = newValue;
        this.firePropertyChange("edition", oldValue, newValue);
        this.firePropertyChange("editionAsString", oldValue, newValue);
    }

    public String getVideoBasenameWithoutStacking() {
        MediaFile mf = this.getMediaFiles(MediaFileType.VIDEO).get(0);
        return FilenameUtils.getBaseName((String)mf.getFilenameWithoutStacking());
    }

    public boolean deleteFilesSafely() {
        boolean result = true;
        List<MediaFile> mediaFiles = this.getMediaFiles();
        for (MediaFile mf : mediaFiles) {
            if (mf.deleteSafely(this.tvShow.getDataSource())) continue;
            result = false;
        }
        return result;
    }

    @Override
    public MediaCertification getCertification() {
        return null;
    }

    @Override
    public MediaFile getMainVideoFile() {
        MediaFile vid = null;
        vid = this.stacked ? this.getMediaFiles(MediaFileType.VIDEO).stream().min(Comparator.comparingInt(MediaFile::getStacking)).orElse(MediaFile.EMPTY_MEDIAFILE) : this.getBiggestMediaFile(MediaFileType.VIDEO);
        if (vid != null) {
            return vid;
        }
        return MediaFile.EMPTY_MEDIAFILE;
    }

    @Override
    public MediaFile getMainFile() {
        return this.getMainVideoFile();
    }

    @Override
    public String getMediaInfoVideoResolution() {
        return this.getMainVideoFile().getVideoResolution();
    }

    @Override
    public String getMediaInfoVideoFormat() {
        return this.getMainVideoFile().getVideoFormat();
    }

    @Override
    public String getMediaInfoVideoCodec() {
        return this.getMainVideoFile().getVideoCodec();
    }

    @Override
    public float getMediaInfoAspectRatio() {
        return this.getMainVideoFile().getAspectRatio().floatValue();
    }

    public String getMediaInfoAspectRatioAsString() {
        DecimalFormat df = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
        return df.format(this.getMainVideoFile().getAspectRatio()).replace(".", "");
    }

    @Override
    public Float getMediaInfoAspectRatio2() {
        return this.getMainVideoFile().getAspectRatio2();
    }

    public String getMediaInfoAspectRatio2AsString() {
        Float aspectRatio2 = this.getMainVideoFile().getAspectRatio2();
        String formatedValue = "";
        if (aspectRatio2 != null) {
            DecimalFormat df = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
            formatedValue = df.format(aspectRatio2).replace(".", "");
        }
        return formatedValue;
    }

    @Override
    public String getMediaInfoAudioCodec() {
        return this.getMainVideoFile().getAudioCodec();
    }

    @Override
    public List<String> getMediaInfoAudioCodecList() {
        ArrayList<String> lang = new ArrayList<String>(this.getMainVideoFile().getAudioCodecList());
        for (MediaFile mf : this.getMediaFiles(MediaFileType.AUDIO)) {
            lang.addAll(mf.getAudioCodecList());
        }
        return lang;
    }

    @Override
    public double getMediaInfoFrameRate() {
        return this.getMainVideoFile().getFrameRate();
    }

    @Override
    public String getMediaInfoAudioChannels() {
        return this.getMainVideoFile().getAudioChannels();
    }

    @Override
    public List<String> getMediaInfoAudioChannelList() {
        ArrayList<String> lang = new ArrayList<String>(this.getMainVideoFile().getAudioChannelsList());
        for (MediaFile mf : this.getMediaFiles(MediaFileType.AUDIO)) {
            lang.addAll(mf.getAudioChannelsList());
        }
        return lang;
    }

    @Override
    public String getMediaInfoAudioChannelsDot() {
        return this.getMainVideoFile().getAudioChannelsDot();
    }

    @Override
    public List<String> getMediaInfoAudioChannelDotList() {
        ArrayList<String> lang = new ArrayList<String>(this.getMainVideoFile().getAudioChannelsDotList());
        for (MediaFile mf : this.getMediaFiles(MediaFileType.AUDIO)) {
            lang.addAll(mf.getAudioChannelsDotList());
        }
        return lang;
    }

    @Override
    public String getMediaInfoAudioLanguage() {
        return this.getMainVideoFile().getAudioLanguage();
    }

    @Override
    public int getMediaInfoVideoBitDepth() {
        return this.getMainVideoFile().getBitDepth();
    }

    public int getMediaInfoVideoBitrate() {
        return this.getMainVideoFile().getVideoBitRate();
    }

    @Override
    public List<String> getMediaInfoAudioLanguageList() {
        ArrayList<String> lang = new ArrayList<String>(this.getMainVideoFile().getAudioLanguagesList());
        for (MediaFile mf : this.getMediaFiles(MediaFileType.AUDIO)) {
            lang.addAll(mf.getAudioLanguagesList());
        }
        return lang;
    }

    @Override
    public List<String> getMediaInfoSubtitleLanguageList() {
        ArrayList<String> lang = new ArrayList<String>(this.getMainVideoFile().getSubtitleLanguagesList());
        for (MediaFile mf : this.getMediaFiles(MediaFileType.AUDIO, MediaFileType.SUBTITLE)) {
            lang.addAll(mf.getSubtitleLanguagesList());
        }
        return lang;
    }

    @Override
    public List<String> getMediaInfoSubtitleCodecList() {
        ArrayList<String> codecs = new ArrayList<String>(this.getMainVideoFile().getSubtitleCodecList());
        for (MediaFile mf : this.getMediaFiles(MediaFileType.AUDIO, MediaFileType.SUBTITLE)) {
            codecs.addAll(mf.getSubtitleCodecList());
        }
        return codecs;
    }

    @Override
    public String getMediaInfoContainerFormat() {
        List<MediaFile> videos = this.getMediaFiles(MediaFileType.VIDEO);
        if (!videos.isEmpty()) {
            MediaFile mediaFile = videos.get(0);
            return mediaFile.getContainerFormat();
        }
        return "";
    }

    @Override
    public MediaSource getMediaInfoSource() {
        return this.getMediaSource();
    }

    @Override
    public String getVideoHDRFormat() {
        return this.getMainVideoFile().getHdrFormat();
    }

    public Boolean isVideoInHDR() {
        return StringUtils.isNotEmpty((CharSequence)this.getMainVideoFile().getHdrFormat());
    }

    public String getVideoHDR() {
        return this.isVideoInHDR() != false ? "HDR" : "";
    }

    @Override
    public boolean isVideoIn3D() {
        String video3DFormat = "";
        List<MediaFile> videos = this.getMediaFiles(MediaFileType.VIDEO);
        if (!videos.isEmpty()) {
            MediaFile mediaFile = videos.get(0);
            video3DFormat = mediaFile.getVideo3DFormat();
        }
        return StringUtils.isNotBlank((CharSequence)video3DFormat);
    }

    @Override
    public long getVideoFilesize() {
        long filesize = 0L;
        for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
            filesize += mf.getFilesize();
        }
        return filesize;
    }

    public boolean isDummy() {
        return this.dummy || !this.hasMediaFiles();
    }

    public void setDummy(boolean dummy) {
        this.dummy = dummy;
    }

    public String getNfoFilename(TvShowEpisodeNfoNaming nfoNaming) {
        MediaFile mainVideoFile = this.getMainVideoFile();
        String baseName = this.isDisc() ? FilenameUtils.removeExtension((String)this.findDiscMainFile()) : mainVideoFile.getBasename();
        String filename = nfoNaming.getFilename(baseName, "nfo");
        LOGGER.trace("getNfoFilename: '{}' -> '{}'", (Object)mainVideoFile.getFilename(), (Object)filename);
        return filename;
    }

    public String findDiscMainFile() {
        MediaFile mainVideoFile = this.getMainVideoFile();
        Object filename = "";
        if (mainVideoFile.isBlurayFile()) {
            filename = "index.bdmv";
        }
        if (mainVideoFile.isDVDFile()) {
            filename = "VIDEO_TS.ifo";
        }
        if (mainVideoFile.isHDDVDFile()) {
            filename = "HVDVD_TS.ifo";
        }
        if (StringUtils.isNotBlank((CharSequence)filename) && mainVideoFile.getFile().toFile().isDirectory()) {
            filename = mainVideoFile.getFilename() + File.separator + (String)filename;
        }
        return filename;
    }

    public boolean isStacked() {
        return this.stacked;
    }

    public void setStacked(boolean stacked) {
        this.stacked = stacked;
    }

    public int getRuntime() {
        return this.tvShow.getRuntime();
    }

    @Override
    public String getProductionCompany() {
        if (StringUtils.isNotBlank((CharSequence)this.productionCompany)) {
            return this.productionCompany;
        }
        if (this.tvShow != null) {
            return this.tvShow.getProductionCompany();
        }
        return "";
    }

    public void writeActorImages(boolean overwriteExistingItems) {
        TvShowActorImageFetcherTask task = new TvShowActorImageFetcherTask(this);
        task.setOverwriteExistingItems(overwriteExistingItems);
        TmmTaskManager.getInstance().addImageDownloadTask(task);
    }

    public void reEvaluateDiscfolder() {
        boolean disc = false;
        for (MediaFile mf : this.getMediaFiles()) {
            if (!mf.isDiscFile()) continue;
            disc = true;
        }
        this.setDisc(disc);
    }

    public void reEvaluateStacking() {
        List<MediaFile> mfs = this.getMediaFiles(MediaFileType.VIDEO);
        if (mfs.size() > 1 && !this.isDisc()) {
            this.setStacked(true);
            for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO, MediaFileType.AUDIO, MediaFileType.SUBTITLE)) {
                mf.detectStackingInformation();
            }
        } else {
            this.setStacked(false);
            for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO, MediaFileType.AUDIO, MediaFileType.SUBTITLE)) {
                mf.removeStackingInformation();
            }
        }
    }

    @Override
    protected void fireAddedEventForMediaFile(MediaFile mediaFile) {
        super.fireAddedEventForMediaFile(mediaFile);
        if (mediaFile.getType() == MediaFileType.SUBTITLE) {
            this.firePropertyChange("hasSubtitle", false, true);
        }
    }

    @Override
    protected void fireRemoveEventForMediaFile(MediaFile mediaFile) {
        super.fireRemoveEventForMediaFile(mediaFile);
        if (mediaFile.getType() == MediaFileType.SUBTITLE) {
            this.firePropertyChange("hasSubtitle", true, false);
        }
    }

    public boolean isUncategorized() {
        return this.episodeNumbers.isEmpty();
    }

    public boolean getHasNote() {
        return StringUtils.isNotBlank((CharSequence)this.note);
    }

    public Object getValueForMetadata(TvShowEpisodeScraperMetadataConfig metadataConfig) {
        switch (metadataConfig) {
            case SEASON_EPISODE: {
                return this.getEpisodeNumbers();
            }
            case TITLE: {
                return this.getTitle();
            }
            case ORIGINAL_TITLE: {
                return this.getOriginalTitle();
            }
            case PLOT: {
                return this.getPlot();
            }
            case AIRED: {
                return this.getFirstAired();
            }
            case RATING: {
                return this.getRatings();
            }
            case TAGS: {
                return this.getTags();
            }
            case ACTORS: {
                return this.getActors();
            }
            case DIRECTORS: {
                return this.getDirectors();
            }
            case WRITERS: {
                return this.getWriters();
            }
            case THUMB: {
                return this.getMediaFiles(MediaFileType.THUMB);
            }
        }
        return null;
    }

    protected void postProcess(List<TvShowEpisodeScraperMetadataConfig> config, final boolean overwriteExistingItems) {
        TmmTaskChain taskChain = TmmTaskChain.getInstance(this.tvShow != null ? this.tvShow : this);
        if (ScraperMetadataConfig.containsAnyCast(config) && TvShowModuleManager.getInstance().getSettings().isWriteActorImages()) {
            taskChain.add(new TmmTask(TmmResourceBundle.getString("tvshow.downloadactorimages"), 1, TmmTaskHandle.TaskType.BACKGROUND_TASK){

                @Override
                protected void doInBackground() {
                    TvShowEpisode.this.writeActorImages(overwriteExistingItems);
                }
            });
        }
    }
}

