/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tasks.ARDetectorTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;

public class TvShowARDetectorTask
extends ARDetectorTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowARDetectorTask.class);
    private final List<TvShowEpisode> episodes;

    public TvShowARDetectorTask(List<TvShowEpisode> episodes) {
        super(TmmTaskHandle.TaskType.MAIN_TASK);
        this.episodes = episodes;
    }

    @Override
    protected void doInBackground() {
        if (!this.canRun()) {
            return;
        }
        int filesTotal = this.episodes.stream().map(episode -> episode.getMediaFiles(MediaFileType.VIDEO).size()).reduce(Integer::sum).orElse(0);
        if (filesTotal > 0) {
            this.setWorkUnits(filesTotal * 100);
        }
        int idx = 0;
        for (TvShowEpisode episode2 : this.episodes) {
            for (MediaFile mediaFile : episode2.getMediaFiles(MediaFileType.VIDEO)) {
                if (this.cancel) break;
                this.analyze(mediaFile, idx++);
            }
            if (this.cancel) {
                LOGGER.info("Abort queue");
                break;
            }
            episode2.saveToDb();
            episode2.writeNFO();
        }
    }
}

