/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.TvShowArtworkHelper;
import org.tinymediamanager.core.tvshow.TvShowEpisodeScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowArtworkProvider;

public class TvShowMissingArtworkDownloadTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowMissingArtworkDownloadTask.class);
    private final List<TvShow> tvShows;
    private final List<TvShowSeason> seasons;
    private final List<TvShowEpisode> episodes;
    private final TvShowSearchAndScrapeOptions scrapeOptions;
    private final List<TvShowScraperMetadataConfig> tvShowScraperMetadataConfig;
    private final List<TvShowEpisodeScraperMetadataConfig> episodeScraperMetadataConfig;

    public TvShowMissingArtworkDownloadTask(Collection<TvShow> tvShows, Collection<TvShowSeason> seasons, Collection<TvShowEpisode> episodes, TvShowSearchAndScrapeOptions scrapeOptions, List<TvShowScraperMetadataConfig> tvShowScraperMetadataConfig, List<TvShowEpisodeScraperMetadataConfig> episodeScraperMetadataConfig) {
        super(TmmResourceBundle.getString("task.missingartwork"));
        this.tvShows = new ArrayList<TvShow>(tvShows);
        this.seasons = new ArrayList<TvShowSeason>(seasons);
        this.episodes = new ArrayList<TvShowEpisode>(episodes);
        this.scrapeOptions = scrapeOptions;
        this.tvShowScraperMetadataConfig = tvShowScraperMetadataConfig;
        this.episodeScraperMetadataConfig = episodeScraperMetadataConfig;
        for (TvShow show : this.tvShows) {
            for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(show.getEpisodes())) {
                if (this.episodes.contains(episode)) continue;
                this.episodes.add(episode);
            }
        }
    }

    @Override
    protected void doInBackground() {
        LOGGER.info("Getting missing artwork");
        this.initThreadPool(3, "scrapeMissingTvShowArtwork");
        this.start();
        List<TvShowSeason> reducedSeasons = new ArrayList<TvShowSeason>(this.seasons);
        for (TvShow show : this.tvShows) {
            if (this.cancel) break;
            if (TvShowArtworkHelper.hasMissingArtwork(show, this.tvShowScraperMetadataConfig)) {
                this.submitTask(new TvShowWorker(show, this.scrapeOptions));
            }
            reducedSeasons = reducedSeasons.stream().filter(season -> season.getTvShow() != show).toList();
        }
        Map<TvShow, List<TvShowSeason>> seasonMap = reducedSeasons.stream().collect(Collectors.groupingBy(TvShowSeason::getTvShow));
        for (Map.Entry<TvShow, List<TvShowSeason>> entry : seasonMap.entrySet()) {
            if (this.cancel) break;
            boolean hasMissingArtwork = false;
            for (TvShowSeason season2 : entry.getValue()) {
                if (!TvShowArtworkHelper.hasMissingArtwork(season2, this.tvShowScraperMetadataConfig)) continue;
                hasMissingArtwork = true;
                break;
            }
            if (!hasMissingArtwork) continue;
            this.submitTask(new TvShowSeasonWorker(entry.getKey(), entry.getValue(), this.scrapeOptions));
        }
        for (TvShowEpisode episode : this.episodes) {
            if (this.cancel) break;
            if (!TvShowArtworkHelper.hasMissingArtwork(episode, this.episodeScraperMetadataConfig)) continue;
            this.submitTask(new TvShowEpisodeWorker(episode, this.scrapeOptions));
        }
        this.waitForCompletionOrCancel();
        LOGGER.info("Done getting missing artwork");
    }

    @Override
    public void callback(Object obj) {
        this.publishState((String)obj, this.progressDone);
    }

    private static class TvShowWorker
    implements Runnable {
        private final TvShow tvShow;
        private final ArtworkSearchAndScrapeOptions options;

        private TvShowWorker(TvShow tvShow, MediaSearchAndScrapeOptions scrapeOptions) {
            this.tvShow = tvShow;
            this.options = new ArtworkSearchAndScrapeOptions(MediaType.TV_SHOW);
            this.options.setDataFromOtherOptions(scrapeOptions);
            this.options.setIds(Collections.emptyMap());
            this.options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
            this.options.setLanguage(TvShowModuleManager.getInstance().getSettings().getScraperLanguage());
            this.options.setFanartSize(TvShowModuleManager.getInstance().getSettings().getImageFanartSize());
            this.options.setPosterSize(TvShowModuleManager.getInstance().getSettings().getImagePosterSize());
            this.options.setThumbSize(TvShowModuleManager.getInstance().getSettings().getImageThumbSize());
            this.options.addIds(tvShow.getIds());
        }

        @Override
        public void run() {
            try {
                ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
                ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
                this.options.getArtworkScrapers().parallelStream().forEach(artworkScraper -> {
                    ITvShowArtworkProvider artworkProvider = (ITvShowArtworkProvider)artworkScraper.getMediaProvider();
                    try {
                        lock.writeLock().lock();
                        artwork.addAll(artworkProvider.getArtwork(this.options));
                        lock.writeLock().unlock();
                    }
                    catch (MissingIdException ignored) {
                        LOGGER.debug("no id found for scraper {}", (Object)artworkProvider.getProviderInfo());
                    }
                    catch (NothingFoundException e) {
                        LOGGER.debug("did not find artwork for '{}'", (Object)this.tvShow.getTitle());
                    }
                    catch (ScrapeException e) {
                        LOGGER.error("getArtwork", (Throwable)e);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.tvShow, "message.scrape.tvshowartworkfailed", new String[]{":", e.getLocalizedMessage()}));
                    }
                });
                if (!artwork.isEmpty()) {
                    TvShowArtworkHelper.downloadMissingArtwork(this.tvShow, artwork);
                }
            }
            catch (Exception e) {
                LOGGER.error("Thread crashed", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"TvShowMissingArtwork", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
            }
        }
    }

    private static class TvShowSeasonWorker
    implements Runnable {
        private final TvShow tvShow;
        private final List<TvShowSeason> seasons;
        private final ArtworkSearchAndScrapeOptions options;

        private TvShowSeasonWorker(TvShow tvShow, List<TvShowSeason> seasons, MediaSearchAndScrapeOptions scrapeOptions) {
            this.tvShow = tvShow;
            this.seasons = seasons;
            this.options = new ArtworkSearchAndScrapeOptions(MediaType.TV_SHOW);
            this.options.setDataFromOtherOptions(scrapeOptions);
            this.options.setIds(Collections.emptyMap());
            this.options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
            this.options.setLanguage(TvShowModuleManager.getInstance().getSettings().getScraperLanguage());
            this.options.setFanartSize(TvShowModuleManager.getInstance().getSettings().getImageFanartSize());
            this.options.setPosterSize(TvShowModuleManager.getInstance().getSettings().getImagePosterSize());
            this.options.setThumbSize(TvShowModuleManager.getInstance().getSettings().getImageThumbSize());
            this.options.addIds(tvShow.getIds());
        }

        @Override
        public void run() {
            try {
                ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
                ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
                this.options.getArtworkScrapers().parallelStream().forEach(artworkScraper -> {
                    ITvShowArtworkProvider artworkProvider = (ITvShowArtworkProvider)artworkScraper.getMediaProvider();
                    try {
                        lock.writeLock().lock();
                        artwork.addAll(artworkProvider.getArtwork(this.options));
                        lock.writeLock().unlock();
                    }
                    catch (MissingIdException ignored) {
                        LOGGER.debug("no id found for scraper {}", (Object)artworkProvider.getProviderInfo());
                    }
                    catch (NothingFoundException e) {
                        LOGGER.debug("did not find artwork for '{}'", (Object)this.tvShow.getTitle());
                    }
                    catch (ScrapeException e) {
                        LOGGER.error("getArtwork", (Throwable)e);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.tvShow, "message.scrape.tvshowartworkfailed", new String[]{":", e.getLocalizedMessage()}));
                    }
                });
                if (!artwork.isEmpty()) {
                    for (TvShowSeason season : this.seasons) {
                        TvShowArtworkHelper.downloadMissingArtwork(season, artwork);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Thread crashed", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"TvShowMissingArtwork", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
            }
        }
    }

    private static class TvShowEpisodeWorker
    implements Runnable {
        private final TvShowEpisode episode;
        private final ArtworkSearchAndScrapeOptions options;

        private TvShowEpisodeWorker(TvShowEpisode episode, MediaSearchAndScrapeOptions scrapeOptions) {
            this.episode = episode;
            this.options = new ArtworkSearchAndScrapeOptions(MediaType.TV_EPISODE);
            this.options.setDataFromOtherOptions(scrapeOptions);
            this.options.setIds(Collections.emptyMap());
            this.options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
            this.options.setLanguage(TvShowModuleManager.getInstance().getSettings().getScraperLanguage());
            this.options.setFanartSize(TvShowModuleManager.getInstance().getSettings().getImageFanartSize());
            this.options.setPosterSize(TvShowModuleManager.getInstance().getSettings().getImagePosterSize());
            this.options.setThumbSize(TvShowModuleManager.getInstance().getSettings().getImageThumbSize());
            this.options.setId("tvShowIds", episode.getTvShow().getIds());
            this.options.setId("mediaFile", episode.getMainFile());
            this.options.setEpisodeGroup(episode.getEpisodeGroup());
            this.options.addIds(episode.getIds());
            this.options.setId("episodeNr", episode.getEpisodeNumbers());
            this.options.setArtworkType(MediaArtwork.MediaArtworkType.THUMB);
        }

        @Override
        public void run() {
            try {
                int preferredSizeOrder;
                List<MediaArtwork.ImageSizeAndUrl> sortedThumbs;
                ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
                for (MediaScraper artworkScraper : this.options.getArtworkScrapers()) {
                    ITvShowArtworkProvider artworkProvider = (ITvShowArtworkProvider)artworkScraper.getMediaProvider();
                    try {
                        artwork.addAll(artworkProvider.getArtwork(this.options));
                        if (artwork.isEmpty()) continue;
                        break;
                    }
                    catch (MissingIdException ignored) {
                        LOGGER.debug("no id found for scraper {}", (Object)artworkProvider.getProviderInfo());
                    }
                    catch (NothingFoundException e) {
                        LOGGER.debug("did not find artwork for '{}' - S{}/E{}", new Object[]{this.episode.getTvShow().getTitle(), this.episode.getSeason(), this.episode.getEpisode()});
                    }
                    catch (ScrapeException e) {
                        LOGGER.error("getArtwork", (Throwable)e);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.episode, "message.scrape.tvshowartworkfailed", new String[]{":", e.getLocalizedMessage()}));
                    }
                }
                if (!(sortedThumbs = TvShowArtworkHelper.sortArtworkUrls(artwork, MediaArtwork.MediaArtworkType.THUMB, preferredSizeOrder = TvShowModuleManager.getInstance().getSettings().getImageThumbSize().getOrder())).isEmpty()) {
                    this.episode.setArtworkUrl(sortedThumbs.get(0).getUrl(), MediaFileType.THUMB);
                    this.episode.downloadArtwork(MediaFileType.THUMB);
                    this.episode.saveToDb();
                    this.episode.writeNFO();
                }
            }
            catch (Exception e) {
                LOGGER.error("Thread crashed", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"TvShowMissingArtwork", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
            }
        }
    }
}

