/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.entities;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum CountryCode {
    AE("United Arab Emirates", "ARE", 784),
    AM("Armenia", "ARM", 51),
    AR("Argentina", "ARG", 32),
    AT("Austria", "AUT", 40),
    AU("Australia", "AUS", 36),
    BB("Barbados", "BRB", 52),
    BD("Bangladesh", "BGD", 50),
    BE("Belgium", "BEL", 56),
    BG("Bulgaria", "BGR", 100),
    BR("Brazil", "BRA", 76),
    BS("Bahamas", "BHS", 44),
    CA("Canada", "CAN", 124),
    CH("Switzerland", "CHE", 756),
    CK("Cook Islands", "COK", 184),
    CL("Chile", "CHL", 152),
    CN("China", "CHN", 156),
    CO("Colombia", "COL", 170),
    CR("Costa Rica", "CRI", 188),
    CY("Cyprus", "CYP", 196),
    CZ("Czech Republic", "CZE", 203),
    DE("Germany", "DEU", 276),
    DK("Denmark", "DNK", 208),
    EC("Ecuador", "ECU", 218),
    EE("Estonia", "EST", 233),
    EG("Egypt", "EGY", 818),
    ES("Spain", "ESP", 724),
    FI("Finland", "FIN", 246),
    FJ("Fiji", "FJI", 242),
    FR("France", "FRA", 250),
    GB("United Kingdom", "GBR", 826),
    GH("Ghana", "GHA", 288),
    GR("Greece", "GRC", 300),
    HK("Hong Kong", "HKG", 344),
    HR("Croatia", "HRV", 191),
    HU("Hungary", "HUN", 348),
    ID("Indonesia", "IDN", 360),
    IE("Ireland", "IRL", 372),
    IL("Israel", "ISR", 376),
    IN("India", "IND", 356),
    IO("British Indian Ocean Territory", "IOT", 86),
    IQ("Iraq", "IRQ", 368),
    IS("Iceland", "ISL", 352),
    IT("Italy", "ITA", 380),
    JM("Jamaica", "JAM", 388),
    JP("Japan", "JPN", 392),
    KE("Kenya", "KEN", 404),
    KH("Cambodia", "KHM", 116),
    KR("Republic of Korea", "KOR", 410),
    KW("Kuwait", "KWT", 414),
    KZ("Kazakhstan", "KAZ", 398),
    LB("Lebanon", "LBN", 422),
    LT("Lithuania", "LTU", 440),
    LV("Latvia", "LVA", 428),
    MA("Morocco", "MAR", 504),
    MK("The former Yugoslav Republic of Macedonia", "MKD", 807),
    MT("Malta", "MLT", 470),
    MU("Mauritius", "MUS", 480),
    MV("Maldives", "MDV", 462),
    MX("Mexico", "MEX", 484),
    MY("Malaysia", "MYS", 458),
    NG("Nigeria", "NGA", 566),
    NL("Netherlands", "NLD", 528),
    NO("Norway", "NOR", 578),
    NZ("New Zealand", "NZL", 554),
    PE("Peru", "PER", 604),
    PH("Philippines", "PHL", 608),
    PL("Poland", "POL", 616),
    PT("Portugal", "PRT", 620),
    RO("Romania", "ROU", 642),
    RU("Russian Federation", "RUS", 643),
    SA("Saudi Arabia", "SAU", 682),
    SE("Sweden", "SWE", 752),
    SG("Singapore", "SGP", 702),
    SI("Slovenia", "SVN", 705),
    SK("Slovakia", "SVK", 703),
    SV("El Salvador", "SLV", 222),
    TH("Thailand", "THA", 764),
    TR("Turkey", "TUR", 792),
    TW("Taiwan, Province of China", "TWN", 158),
    UA("Ukraine", "UKR", 804),
    US("United States", "USA", 840),
    VE("Bolivarian Republic of Venezuela", "VEN", 862),
    VN("Viet Nam", "VNM", 704),
    ZA("South Africa", "ZAF", 710);

    private static final Map<String, CountryCode> alpha3Map;
    private static final Map<Integer, CountryCode> numericMap;
    private final String name;
    private final String alpha3;
    private final int numeric;
    private final Locale locale;

    private CountryCode(String name, String alpha3, int numeric) {
        this.name = name;
        this.alpha3 = alpha3;
        this.numeric = numeric;
        this.locale = new Locale("", this.name());
    }

    public String getName() {
        return this.name;
    }

    public String getAlpha2() {
        return this.name();
    }

    public String getAlpha3() {
        return this.alpha3;
    }

    public int getNumeric() {
        return this.numeric;
    }

    public static CountryCode getByCode(String code) {
        if (code == null) {
            return null;
        }
        switch (code.length()) {
            case 2: {
                return CountryCode.getByAlpha2Code(code);
            }
            case 3: {
                return CountryCode.getByAlpha3Code(code);
            }
        }
        return null;
    }

    private static CountryCode getByAlpha2Code(String code) {
        try {
            return Enum.valueOf(CountryCode.class, code);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static CountryCode getByAlpha3Code(String code) {
        return alpha3Map.get(code);
    }

    public static CountryCode getByCode(int code) {
        return numericMap.get(code);
    }

    public static CountryCode getDefault() {
        Locale defaultLocale = Locale.getDefault();
        CountryCode countryCode = CountryCode.getByCode(defaultLocale.getCountry());
        if (countryCode == null) {
            countryCode = US;
        }
        return countryCode;
    }

    public String toString() {
        return this.name() + " - " + this.locale.getDisplayCountry();
    }

    static {
        alpha3Map = new HashMap<String, CountryCode>();
        numericMap = new HashMap<Integer, CountryCode>();
        for (CountryCode cc : CountryCode.values()) {
            alpha3Map.put(cc.getAlpha3(), cc);
            numericMap.put(cc.getNumeric(), cc);
        }
    }
}

