/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.hdtrailersnet;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.core.entities.MediaTrailer;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.TrailerSearchAndScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.hdtrailersnet.entities.YahooMediaObject;
import org.tinymediamanager.scraper.hdtrailersnet.entities.YahooStream;
import org.tinymediamanager.scraper.http.InMemoryCachedUrl;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.scraper.interfaces.IMovieTrailerProvider;
import org.tinymediamanager.scraper.util.JsonUtils;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.scraper.util.UrlUtil;

public class HdTrailersNetMovieTrailerProvider
implements IMovieTrailerProvider {
    private static final String ID = "hd-trailers";
    private static final Logger LOGGER = LoggerFactory.getLogger(HdTrailersNetMovieTrailerProvider.class);
    public static final String YAHOO_API = "https://video.media.yql.yahoo.com/v1/video/sapi";
    private final MediaProviderInfo providerInfo;
    private ObjectMapper mapper = new ObjectMapper();

    public HdTrailersNetMovieTrailerProvider() {
        this.providerInfo = this.createMediaProviderInfo();
    }

    private MediaProviderInfo createMediaProviderInfo() {
        return new MediaProviderInfo(ID, "movie_trailer", "hd-trailers.net", "<html><h3>hd-trailers.net</h3>Scraper for hd-trailers.net which is able to scrape trailers</html>", HdTrailersNetMovieTrailerProvider.class.getResource("/org/tinymediamanager/scraper/hd-trailers_net.png"));
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled() && this.isApiKeyAvailable(null);
    }

    @Override
    public List<MediaTrailer> getTrailers(TrailerSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getTrailers() - {}", (Object)options);
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        ArrayList<MediaTrailer> trailers = new ArrayList<MediaTrailer>();
        MediaMetadata md = options.getMetadata();
        if (md == null) {
            LOGGER.warn("no originalTitle served");
            throw new MissingIdException(new String[]{"originalTitle"});
        }
        String ot = md.getOriginalTitle();
        if (ot.isEmpty() && options.getLanguage() == MediaLanguages.en) {
            ot = md.getTitle();
        }
        if (ot.isEmpty()) {
            LOGGER.warn("no originalTitle served");
            throw new MissingIdException(new String[]{"originalTitle"});
        }
        try {
            String search = this.getApiKey() + ot.replaceAll("[^a-zA-Z0-9]", "-").replace("--", "-").toLowerCase(Locale.ROOT) + "/";
            LOGGER.debug("Guessed HD-Trailers Url: {}", (Object)search);
            Document doc = UrlUtil.parseDocumentFromUrl(search);
            Elements tr = doc.getElementsByAttributeValue("itemprop", "trailer");
            for (Element t : tr) {
                try {
                    String date = t.select("td.bottomTableDate").first().text();
                    String title = t.select("td.bottomTableName > span").first().text();
                    Elements links = t.getElementsByClass("bottomTableResolution");
                    for (Element link : links) {
                        if (link.html().isEmpty()) continue;
                        MediaTrailer trailer = new MediaTrailer();
                        trailer.setName(title + " (" + date + ")");
                        trailer.setDate(date);
                        trailer.setQuality(link.text());
                        String url = link.selectFirst("a").attr("href");
                        if (url.contains("yahoo-redir")) {
                            String id = StrgUtils.substr(url, "id=(.*?)&");
                            url = this.parseYahooUrl(id, link.text());
                        }
                        trailer.setUrl(url);
                        trailer.setProvider(HdTrailersNetMovieTrailerProvider.getProviderFromUrl(url));
                        if ("Apple".equalsIgnoreCase(trailer.getProvider())) continue;
                        trailer.setScrapedBy(this.providerInfo.getId());
                        if (trailer.getUrl().isEmpty() || trailer.getName().isEmpty()) continue;
                        LOGGER.trace("found trailer: {}", (Object)trailer);
                        trailers.add(trailer);
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("Error parsing HD-Trailers line. {}", (Object)e.getMessage());
                }
            }
        }
        catch (InterruptedIOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (HttpException e) {
            LOGGER.debug("could not find a trailer on hd-trailers.net");
        }
        catch (Exception e) {
            LOGGER.debug("cannot parse HD-Trailers movie: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        return trailers;
    }

    private static String getProviderFromUrl(String url) {
        url = url.toLowerCase(Locale.ROOT);
        String source = "unknown";
        if (url.contains("youtube.com") || url.contains("youtu.be")) {
            source = "youtube";
        } else if (url.contains("apple.com")) {
            source = "apple";
        } else if (url.contains("aol.com")) {
            source = "aol";
        } else if (url.contains("yahoo.com") || url.contains("yahoo.net")) {
            source = "yahoo";
        } else if (url.contains("hd-trailers.net")) {
            source = "hdtrailers";
        } else if (url.contains("moviefone.com")) {
            source = "moviefone";
        } else if (url.contains("mtv.com")) {
            source = "mtv";
        } else if (url.contains("ign.com")) {
            source = "ign";
        } else if (url.contains("5min.com")) {
            source = "5min";
        }
        return source;
    }

    private String parseYahooUrl(String id, String quality) {
        String q = quality.replace("p", "").replace("480", "540");
        try {
            String url = "https://video.media.yql.yahoo.com/v1/video/sapi/streams/" + id + "?cprotocol=http&format=mp4";
            InMemoryCachedUrl u = new InMemoryCachedUrl(url);
            JsonNode node = this.mapper.readTree(((Url)u).getInputStream());
            JsonNode mediaObj = node.at("/query/results/mediaObj");
            YahooMediaObject media = JsonUtils.parseObject(this.mapper, mediaObj.get(0), YahooMediaObject.class);
            YahooStream strm = media.streams.stream().filter(stream -> q.equals(Integer.toString(stream.height))).findAny().orElse(null);
            if (strm != null) {
                return strm.host + strm.path;
            }
        }
        catch (Exception e) {
            LOGGER.error("could not fetch trailer url: {}", (Object)e.getMessage());
        }
        return "";
    }
}

