/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.moviemeter;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.bind.DateTypeAdapter;
import java.io.IOException;
import java.util.Date;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.moviemeter.services.FilmService;
import org.tinymediamanager.scraper.moviemeter.services.SearchService;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

class MovieMeter {
    public static final String API_URL = "http://www.moviemeter.nl/api/";
    public static final String PARAM_API_KEY = "api_key";
    private Retrofit restAdapter;
    private boolean isDebug;
    private String apiKey = "";

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public MovieMeter setIsDebug(boolean isDebug) {
        this.isDebug = isDebug;
        return this;
    }

    protected Retrofit.Builder newRestAdapterBuilder() {
        return new Retrofit.Builder();
    }

    protected Retrofit getRestAdapter() {
        if (this.restAdapter == null) {
            Retrofit.Builder builder = this.newRestAdapterBuilder();
            builder.baseUrl(API_URL);
            builder.addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.getGsonBuilder().create()));
            builder.client(TmmHttpClient.newBuilder().addInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Request request = chain.request();
                    HttpUrl url = request.url().newBuilder().addQueryParameter(MovieMeter.PARAM_API_KEY, MovieMeter.this.apiKey).build();
                    request = request.newBuilder().url(url).build();
                    return chain.proceed(request);
                }
            }).build());
            this.restAdapter = builder.build();
        }
        return this.restAdapter;
    }

    protected GsonBuilder getGsonBuilder() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Integer.class, (json, typeOfT, context) -> {
            try {
                return json.getAsInt();
            }
            catch (NumberFormatException e) {
                return 0;
            }
        });
        builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter());
        builder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        return builder;
    }

    public FilmService getFilmService() {
        return (FilmService)this.getRestAdapter().create(FilmService.class);
    }

    public SearchService getSearchService() {
        return (SearchService)this.getRestAdapter().create(SearchService.class);
    }

    static class ErrorResponse {
        @SerializedName(value="message")
        String msg;

        ErrorResponse() {
        }

        public String toString() {
            return this.msg;
        }
    }
}

