/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.mpdbtv;

import java.util.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.mpdbtv.MpdbMovieMetadataProvider;
import org.tinymediamanager.scraper.mpdbtv.services.Controller;

abstract class MpdbMetadataProvider
implements IMediaProvider {
    static final String ID = "mpdbtv";
    static final String FORMAT = "json";
    private final MediaProviderInfo providerInfo = this.createMediaProviderInfo();
    protected Controller controller;

    MpdbMetadataProvider() {
    }

    protected abstract String getSubId();

    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = new MediaProviderInfo(ID, this.getSubId(), "mpdb.tv", "<html><h3>MPDb.TV</h3><br />MPDb.TV is a private meta data provider for French speaking users - you may need to become a member there to use this service (more infos at http://www.mpdb.tv/)<br /><br />Available languages: FR</html>", MpdbMovieMetadataProvider.class.getResource("/org/tinymediamanager/scraper/mpdbtv.png"), -10);
        info.getConfig().addText("aboKey", "", false);
        info.getConfig().addText("username", "", false);
        info.getConfig().load();
        return info;
    }

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled() && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.getAboKey(), this.getUserName()}) && this.isApiKeyAvailable(null);
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    protected synchronized void initAPI() throws ScrapeException {
        if (this.controller == null) {
            if (!this.isActive()) {
                throw new ScrapeException(new FeatureNotEnabledException(this));
            }
            this.controller = new Controller();
        }
        try {
            this.controller.setApiKey(this.getApiKey());
        }
        catch (Exception e) {
            throw new ScrapeException(e);
        }
    }

    String getAboKey() {
        return this.providerInfo.getConfig().getValue("aboKey");
    }

    String getUserName() {
        return this.providerInfo.getConfig().getValue("username");
    }

    String getEncodedUserName() {
        return Base64.getUrlEncoder().encodeToString(this.getUserName().getBytes());
    }

    String getSubscriptionKey() throws Exception {
        return DigestUtils.sha1Hex((String)(this.getUserName() + this.getApiKey() + this.getAboKey()));
    }
}

