/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.omdb;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.rating.RatingProvider;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.ParserUtils;

abstract class OmdbMetadataProvider
implements IMediaProvider {
    private static final String ID = "omdbapi";
    private final MediaProviderInfo providerInfo = this.createMediaProviderInfo();

    OmdbMetadataProvider() {
    }

    protected abstract String getSubId();

    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = new MediaProviderInfo(ID, this.getSubId(), "omdbapi.com", "<html><h3>Omdbapi.com</h3><br />The OMDb API is a RESTful web service to obtain movie information. All content and images on the site are contributed and maintained by our users. <br /><br />TinyMediaManager offers a limited access to OMDb (10 calls per 15 seconds). If you want to use OMDb with more than this restricted access, you should become a patron of OMDb (https://www.patreon.com/join/omdb)<br /><br />Available languages: EN</html>", OmdbMetadataProvider.class.getResource("/org/tinymediamanager/scraper/omdbapi.svg"), 10);
        info.getConfig().addText("apiKey", "", true);
        info.getConfig().load();
        return info;
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled() && this.isApiKeyAvailable(this.providerInfo.getUserApiKey());
    }

    public String getApiKey() {
        String userApiKey = this.providerInfo.getUserApiKey();
        if (StringUtils.isNotBlank((CharSequence)userApiKey)) {
            return userApiKey;
        }
        return IMediaProvider.super.getApiKey();
    }

    protected abstract Logger getLogger();

    protected List<MediaSearchResult> parseSearchResults(Document document, MediaType mediaType) {
        Elements results = document.getElementsByTag("result");
        if (results.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MediaSearchResult> searchResults = new ArrayList<MediaSearchResult>();
        for (Element result : results) {
            MediaSearchResult searchResult = new MediaSearchResult(this.getId(), mediaType);
            if (MediaIdUtil.isValidImdbId(result.attr("imdbID"))) {
                searchResult.setId("imdb", result.attr("imdbID"));
            }
            searchResult.setTitle(result.attr("title"));
            searchResult.setYear(MetadataUtil.parseInt(result.attr("year"), 0));
            if (searchResult.getYear() <= 0 && result.attr("year").length() >= 4) {
                searchResult.setYear(MetadataUtil.parseInt(result.attr("year").substring(0, 4)));
            }
            if (StringUtils.isNotBlank((CharSequence)result.attr("poster"))) {
                searchResult.setPosterUrl(result.attr("poster"));
            }
            searchResults.add(searchResult);
        }
        return searchResults;
    }

    protected MediaMetadata parseDetail(Document document, String baseElement) {
        MediaRating rating2;
        String[] actors;
        String[] writers;
        String[] directors;
        String[] genres;
        MediaCertification certification;
        Elements movies = document.getElementsByTag(baseElement);
        if (movies.isEmpty()) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("d MMMM yyyy", Locale.ENGLISH);
        MediaMetadata md = new MediaMetadata(this.getId());
        Element movie = movies.first();
        if (MediaIdUtil.isValidImdbId(movie.attr("imdbID"))) {
            md.setId("imdb", movie.attr("imdbID"));
        }
        md.setTitle(movie.attr("title"));
        md.setPlot(movie.attr("plot"));
        md.setYear(MetadataUtil.parseInt(movie.attr("year"), 0));
        if (md.getYear() <= 0 && movie.attr("year").length() >= 4) {
            md.setYear(MetadataUtil.parseInt(movie.attr("year").substring(0, 4)));
        }
        if ((certification = MediaCertification.findCertification(movie.attr("rated"))) != MediaCertification.UNKNOWN) {
            md.addCertification(certification);
        }
        try {
            md.setReleaseDate(format.parse(movie.attr("released")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Pattern p = Pattern.compile("\\d+");
        Matcher m = p.matcher(movie.attr("runtime"));
        while (m.find()) {
            try {
                md.setRuntime(Integer.parseInt(m.group()));
                break;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        for (String genre : genres = movie.attr("genre").split(",")) {
            genre = genre.strip();
            MediaGenres mediaGenres = MediaGenres.getGenre(genre);
            md.addGenre(mediaGenres);
        }
        for (String d : directors = movie.attr("director").split(",")) {
            Person director = new Person(Person.Type.DIRECTOR);
            director.setName(d.strip());
            md.addCastMember(director);
        }
        for (String w : writers = movie.attr("writer").split(",")) {
            Person writer = new Person(Person.Type.WRITER);
            writer.setName(w.strip());
            md.addCastMember(writer);
        }
        for (String a : actors = movie.attr("actors").split(",")) {
            Person actor = new Person(Person.Type.ACTOR);
            actor.setName(a.strip());
            md.addCastMember(actor);
        }
        md.setSpokenLanguages(ParserUtils.split(movie.attr("language")));
        md.setCountries(ParserUtils.split(movie.attr("country")));
        try {
            rating2 = new MediaRating("imdb");
            rating2.setRating(Float.parseFloat(movie.attr("imdbRating")));
            rating2.setVotes(MetadataUtil.parseInt(movie.attr("imdbVotes")));
            rating2.setMaxValue(10);
            md.addRating(rating2);
        }
        catch (NumberFormatException e) {
            this.getLogger().trace("could not parse IMDB rating/vote count: {}", (Object)e.getMessage());
        }
        try {
            rating2 = new MediaRating("metacritic");
            rating2.setRating(Float.parseFloat(movie.attr("metascore")));
            rating2.setMaxValue(100);
            md.addRating(rating2);
        }
        catch (NumberFormatException e) {
            this.getLogger().trace("could not parse metacritic rating/vote count: {}", (Object)e.getMessage());
        }
        try {
            rating2 = new MediaRating("tomatometerallcritics");
            rating2.setRating(Float.parseFloat(movie.attr("tomatoMeter")));
            rating2.setVotes(MetadataUtil.parseInt(movie.attr("tomatoReviews")));
            rating2.setMaxValue(100);
            md.addRating(rating2);
        }
        catch (NumberFormatException e) {
            this.getLogger().trace("could not parse tomatometerallcritics rating/vote count: {}", (Object)e.getMessage());
        }
        try {
            rating2 = new MediaRating("tomatometerallaudience");
            rating2.setRating(Float.parseFloat(movie.attr("tomatoUserMeter")));
            rating2.setVotes(MetadataUtil.parseInt(movie.attr("tomatoUserReviews")));
            rating2.setMaxValue(100);
            md.addRating(rating2);
        }
        catch (NumberFormatException e) {
            this.getLogger().trace("could not parse tomatometerallaudience rating/vote count: {}", (Object)e.getMessage());
        }
        try {
            rating2 = new MediaRating("tomatometeravgcritics");
            rating2.setRating(Float.parseFloat(movie.attr("tomatoRating")));
            rating2.setVotes(MetadataUtil.parseInt(movie.attr("tomatoReviews")));
            rating2.setMaxValue(10);
            md.addRating(rating2);
        }
        catch (NumberFormatException e) {
            this.getLogger().trace("could not parse tomatometeravgcritics rating/vote count: {}", (Object)e.getMessage());
        }
        try {
            rating2 = new MediaRating("tomatometeravgaudience");
            rating2.setRating(Float.parseFloat(movie.attr("tomatoUserRating")));
            rating2.setVotes(MetadataUtil.parseInt(movie.attr("tomatoUserReviews")));
            rating2.setMaxValue(5);
            md.addRating(rating2);
        }
        catch (NumberFormatException e) {
            this.getLogger().trace("could not parse tomatometeravgaudience rating/vote count: {}", (Object)e.getMessage());
        }
        if (md.getId("imdb") instanceof String) {
            MediaRating omdbRating = md.getRatings().stream().filter(rating -> "imdb".equals(rating.getId())).findFirst().orElse(null);
            MediaRating imdbRating = RatingProvider.getImdbRating((String)md.getId("imdb"));
            if (imdbRating != null && (omdbRating == null || imdbRating.getVotes() > omdbRating.getVotes())) {
                md.getRatings().remove(omdbRating);
                md.addRating(imdbRating);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)movie.attr("poster"))) {
            MediaArtwork artwork = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.POSTER);
            artwork.setOriginalUrl(movie.attr("poster"));
            artwork.addImageSize(300, 445, movie.attr("poster"), MediaArtwork.PosterSizes.getSizeOrder(300));
            md.addMediaArt(artwork);
        }
        return md;
    }

    protected String getImdbId(MediaSearchAndScrapeOptions options) {
        String imdbId = options.getImdbId();
        if (!MediaIdUtil.isValidImdbId(imdbId)) {
            imdbId = options.getIdAsString(this.getProviderInfo().getId());
        }
        if (!MediaIdUtil.isValidImdbId(imdbId) && options.getIdAsIntOrDefault("tvdb", 0) > 0) {
            int tvdbId = options.getIdAsInt("tvdb");
            imdbId = MediaIdUtil.getImdbIdFromTvdbId(String.valueOf(tvdbId));
        }
        if (!MediaIdUtil.isValidImdbId(imdbId) && options.getTmdbId() > 0) {
            imdbId = MediaIdUtil.getTvShowImdbIdViaTmdbId(options.getTmdbId());
        }
        return imdbId;
    }
}

