/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.rating;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.rating.entities.MdbListRatingEntity;
import org.tinymediamanager.scraper.rating.entities.MdbListRatings;
import org.tinymediamanager.scraper.rating.services.MdbListController;
import org.tinymediamanager.scraper.util.ListUtils;
import retrofit2.Response;

class MdbListRating {
    public static final Logger LOGGER = LoggerFactory.getLogger(MdbListRating.class);
    private final MdbListController controller = new MdbListController();

    MdbListRating() {
    }

    public List<MediaRating> getRatings(MediaType mediaType, Map<String, Object> ids) {
        ArrayList<MediaRating> mediaRatingList = new ArrayList<MediaRating>();
        String apiKey = Settings.getInstance().getMdbListApiKey();
        if (apiKey.isBlank()) {
            LOGGER.debug("No API KEY entered for MDBList.com - skipping");
            return mediaRatingList;
        }
        if (mediaType == MediaType.TV_EPISODE) {
            return mediaRatingList;
        }
        block22: for (Map.Entry<String, Object> entry : ids.entrySet()) {
            try {
                Response<MdbListRatingEntity> response;
                switch (entry.getKey()) {
                    case "imdb": {
                        response = this.controller.getRatingsByImdbId(apiKey, entry.getValue().toString(), mediaType);
                        break;
                    }
                    case "trakt": {
                        response = this.controller.getRatingsByTraktId(apiKey, entry.getValue().toString(), mediaType);
                        break;
                    }
                    case "tmdb": {
                        response = this.controller.getRatingsByTmdbId(apiKey, entry.getValue().toString(), mediaType);
                        break;
                    }
                    case "tvdb": {
                        response = this.controller.getRatingsByTvdbId(apiKey, entry.getValue().toString(), mediaType);
                        break;
                    }
                    default: {
                        continue block22;
                    }
                }
                if (response == null) {
                    throw new NothingFoundException();
                }
                if (!response.isSuccessful()) {
                    throw new HttpException(response.code(), response.message());
                }
                MdbListRatingEntity ratingEntity = (MdbListRatingEntity)response.body();
                for (MdbListRatings ratings : ListUtils.nullSafe(ratingEntity.ratings)) {
                    if (ratings.source == null || ratings.value == null || ratings.value.floatValue() == 0.0f && !ratings.source.equals("rogerebert")) continue;
                    MediaRating mediaRating = new MediaRating(ratings.source, ratings.value.floatValue(), ratings.votes);
                    switch (ratings.source) {
                        case "letterboxd": {
                            mediaRating.setMaxValue(5);
                            break;
                        }
                        case "rogerebert": {
                            mediaRating.setMaxValue(4);
                        }
                    }
                    mediaRatingList.add(mediaRating);
                }
                break;
            }
            catch (Exception e) {
                LOGGER.debug("Could not fetch ratings - '{}'", (Object)e.getMessage());
                break;
            }
        }
        return mediaRatingList;
    }
}

