/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.rating.services;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.bind.DateTypeAdapter;
import java.io.IOException;
import java.util.Date;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.rating.entities.MdbListRatingEntity;
import org.tinymediamanager.scraper.rating.services.MdbListService;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class MdbListController {
    private final Retrofit retrofit;

    public MdbListController() {
        OkHttpClient.Builder builder = TmmHttpClient.newBuilder();
        builder.addInterceptor(chain -> {
            Request request = chain.request();
            Response response = chain.proceed(request);
            return response;
        });
        this.retrofit = this.buildRetrofitInstance(builder.build());
    }

    private GsonBuilder getGsonBuilder() {
        GsonBuilder builder = new GsonBuilder().setLenient();
        builder.registerTypeAdapter(Integer.class, (json, typeOfT, context) -> {
            try {
                return json.getAsInt();
            }
            catch (NumberFormatException e) {
                return 0;
            }
        });
        builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter());
        return builder;
    }

    private Retrofit buildRetrofitInstance(OkHttpClient client) {
        return new Retrofit.Builder().client(client).baseUrl("https://mdblist.com/").addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.getGsonBuilder().create())).build();
    }

    private MdbListService getService() {
        return (MdbListService)this.retrofit.create(MdbListService.class);
    }

    private String getMediaTypeForQuery(MediaType mediaType) {
        String mt = "movie";
        if (mediaType == MediaType.TV_SHOW || mediaType == MediaType.TV_EPISODE) {
            mt = "show";
        }
        return mt;
    }

    public retrofit2.Response<MdbListRatingEntity> getRatingsByImdbId(String apikey, String imdbId, MediaType mediaType) throws IOException {
        return this.getService().getRatingsByImdbId(apikey, imdbId, this.getMediaTypeForQuery(mediaType)).execute();
    }

    public retrofit2.Response<MdbListRatingEntity> getRatingsByTraktId(String apikey, String traktId, MediaType mediaType) throws IOException {
        return this.getService().getRatingsByTraktId(apikey, traktId, this.getMediaTypeForQuery(mediaType)).execute();
    }

    public retrofit2.Response<MdbListRatingEntity> getRatingsByTmdbId(String apikey, String tmdbId, MediaType mediaType) throws IOException {
        return this.getService().getRatingsByTmdbId(apikey, tmdbId, this.getMediaTypeForQuery(mediaType)).execute();
    }

    public retrofit2.Response<MdbListRatingEntity> getRatingsByTvdbId(String apikey, String tvdbId, MediaType mediaType) throws IOException {
        return this.getService().getRatingsByTvdbId(apikey, tvdbId, this.getMediaTypeForQuery(mediaType)).execute();
    }
}

