/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.thetvdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.scraper.thetvdb.TheTvDbController;
import org.tinymediamanager.scraper.thetvdb.entities.ArtworkBaseRecord;
import org.tinymediamanager.scraper.thetvdb.entities.ArtworkTypeRecord;
import org.tinymediamanager.scraper.thetvdb.entities.ArtworkTypeResponse;
import org.tinymediamanager.scraper.thetvdb.entities.Character;
import org.tinymediamanager.scraper.thetvdb.entities.RemoteID;
import org.tinymediamanager.scraper.thetvdb.entities.SearchResultResponse;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;
import retrofit2.Response;

abstract class TheTvDbMetadataProvider
implements IMediaProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TheTvDbMetadataProvider.class);
    private static final String ID = "tvdb";
    protected static final String FALLBACK_LANGUAGE = "fallbackLanguage";
    protected static final Pattern ID_PATTERN = Pattern.compile("\\d{3,}");
    private final MediaProviderInfo providerInfo;
    private final Map<Integer, ArtworkTypeRecord> artworkTypes = new HashMap<Integer, ArtworkTypeRecord>();
    protected TheTvDbController tvdb;

    TheTvDbMetadataProvider() {
        this.providerInfo = this.createMediaProviderInfo();
    }

    protected abstract Logger getLogger();

    protected abstract String getSubId();

    protected MediaProviderInfo createMediaProviderInfo() {
        return new MediaProviderInfo(ID, this.getSubId(), "thetvdb.com", "<html><h3>The TVDB</h3><br />An open database for television fans. This scraper is able to scrape TV series metadata and artwork</html>", TheTvDbMetadataProvider.class.getResource("/org/tinymediamanager/scraper/thetvdb_com.svg"), 30);
    }

    @Override
    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    @Override
    public boolean isActive() {
        return this.isFeatureEnabled() && this.isApiKeyAvailable(this.providerInfo.getUserApiKey());
    }

    String getAuthToken() throws Exception {
        String userApiKey = this.providerInfo.getUserApiKey();
        String userPin = this.providerInfo.getConfig().getValue("pin");
        if (StringUtils.isNotBlank((CharSequence)userApiKey)) {
            this.tvdb.setUserApiKey(userApiKey);
            this.tvdb.setUserPin(userPin);
            try {
                return TheTvDbController.login(userApiKey, userPin);
            }
            catch (Exception e) {
                LOGGER.debug("Could not get auth token for user key/pin - '{}", (Object)e.getMessage());
            }
        }
        return this.getApiKey();
    }

    protected synchronized void initAPI() throws ScrapeException {
        block10: {
            if (this.tvdb != null) {
                String userApiKey = this.providerInfo.getUserApiKey();
                String userPin = this.providerInfo.getConfig().getValue("pin");
                if (!(!StringUtils.isNotBlank((CharSequence)userApiKey) || userApiKey.equals(this.tvdb.getUserApiKey()) && userPin.equals(this.tvdb.getUserPin()))) {
                    this.tvdb = null;
                } else if (StringUtils.isBlank((CharSequence)userApiKey) && StringUtils.isNotBlank((CharSequence)this.tvdb.getUserApiKey())) {
                    this.tvdb = null;
                }
            }
            if (this.tvdb == null) {
                if (!this.isActive()) {
                    throw new ScrapeException(new FeatureNotEnabledException(this));
                }
                try {
                    this.tvdb = new TheTvDbController();
                    this.tvdb.setAuthToken(this.getAuthToken());
                    this.artworkTypes.clear();
                    Response response = this.tvdb.getConfigService().getArtworkTypes().execute();
                    if (response.isSuccessful()) {
                        for (ArtworkTypeRecord artworkTypeRecord : ((ArtworkTypeResponse)response.body()).data) {
                            if (artworkTypeRecord.width <= 0 || artworkTypeRecord.height <= 0) continue;
                            this.artworkTypes.put(artworkTypeRecord.id, artworkTypeRecord);
                        }
                        break block10;
                    }
                    String msg = response.message().isBlank() ? response.errorBody().string() : response.message();
                    throw new HttpException(response.code(), msg);
                }
                catch (Exception e) {
                    this.getLogger().warn("could not initialize API: {}", (Object)e.getMessage());
                    this.tvdb = null;
                    throw new ScrapeException(e);
                }
            }
        }
    }

    protected String clearYearFromTitle(String title, int year) {
        return title.replaceAll("\\(" + year + "\\)$", "").strip();
    }

    protected ArtworkTypeRecord getArtworkType(Integer id) {
        if (id == null) {
            return null;
        }
        return this.artworkTypes.get(id);
    }

    protected String parseLocalizedText(MediaLanguages desiredLanguage, Map<String, String> localizedTexts) {
        String text;
        if (localizedTexts == null) {
            return "";
        }
        String iso3LanguageTag = LanguageUtils.getIso3Language(desiredLanguage.toLocale());
        if ("pob".equals(iso3LanguageTag)) {
            iso3LanguageTag = "pt";
        }
        if (StringUtils.isNotBlank((CharSequence)(text = localizedTexts.get(iso3LanguageTag)))) {
            return text;
        }
        return "";
    }

    protected List<Person> parseCastMembers(List<Character> characters) {
        if (characters == null) {
            return Collections.emptyList();
        }
        characters.sort(Comparator.comparingInt(o -> o.sort));
        ArrayList<Person> members = new ArrayList<Person>();
        block7: for (Character character : characters) {
            Person member;
            switch (character.type) {
                case 1: {
                    member = new Person(Person.Type.DIRECTOR);
                    break;
                }
                case 2: {
                    member = new Person(Person.Type.WRITER);
                    break;
                }
                case 3: {
                    member = new Person(Person.Type.ACTOR);
                    member.setRole(character.name);
                    break;
                }
                case 4: {
                    member = new Person(Person.Type.GUEST);
                    member.setRole(character.name);
                    break;
                }
                case 7: {
                    member = new Person(Person.Type.PRODUCER);
                    break;
                }
                default: {
                    continue block7;
                }
            }
            member.setId(this.getId(), character.peopleId);
            member.setName(character.personName);
            if (StringUtils.isNotBlank((CharSequence)character.image)) {
                member.setThumbUrl(character.image);
            }
            if (StringUtils.isNotBlank((CharSequence)character.url)) {
                Object profileUrl = character.url;
                if (!((String)profileUrl).startsWith("http")) {
                    profileUrl = "https://thetvdb.com/people/" + (String)profileUrl;
                }
                member.setProfileUrl((String)profileUrl);
            }
            members.add(member);
        }
        return members;
    }

    protected Map<String, Object> parseRemoteIDs(List<RemoteID> ids) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (RemoteID remote : ListUtils.nullSafe(ids)) {
            switch (remote.type) {
                case 1: {
                    break;
                }
                case 2: {
                    if (!MediaIdUtil.isValidImdbId(remote.id)) break;
                    ret.put("imdb", remote.id);
                    break;
                }
                case 3: {
                    ret.put("zap2it", remote.id);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 12: {
                    int tid = MetadataUtil.parseInt(remote.id, -1);
                    if (tid <= 0) break;
                    ret.put("tmdb", tid);
                    break;
                }
                case 13: {
                    ret.put("eidr", remote.id);
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    break;
                }
                case 18: {
                    ret.put("wikidata", remote.id);
                    break;
                }
                case 19: {
                    int mid = MetadataUtil.parseInt(remote.id, -1);
                    if (mid <= 0) break;
                    ret.put("tvmaze", mid);
                    break;
                }
            }
        }
        return ret;
    }

    protected MediaArtwork parseArtwork(ArtworkBaseRecord image) {
        if (image.id == null) {
            return null;
        }
        MediaArtwork ma = null;
        switch (image.type) {
            case 1: 
            case 16: {
                ma = new MediaArtwork(this.getProviderInfo().getId(), MediaArtwork.MediaArtworkType.BANNER);
                break;
            }
            case 2: 
            case 14: {
                ma = new MediaArtwork(this.getProviderInfo().getId(), MediaArtwork.MediaArtworkType.POSTER);
                break;
            }
            case 3: 
            case 15: {
                ma = new MediaArtwork(this.getProviderInfo().getId(), MediaArtwork.MediaArtworkType.BACKGROUND);
                break;
            }
            case 6: {
                ma = new MediaArtwork(this.getProviderInfo().getId(), MediaArtwork.MediaArtworkType.SEASON_BANNER);
                break;
            }
            case 7: {
                ma = new MediaArtwork(this.getProviderInfo().getId(), MediaArtwork.MediaArtworkType.SEASON_POSTER);
                break;
            }
            case 8: {
                ma = new MediaArtwork(this.getProviderInfo().getId(), MediaArtwork.MediaArtworkType.SEASON_THUMB);
                break;
            }
            case 11: 
            case 12: {
                ma = new MediaArtwork(this.getProviderInfo().getId(), MediaArtwork.MediaArtworkType.THUMB);
                break;
            }
            default: {
                return null;
            }
        }
        ArtworkTypeRecord artworkType = this.getArtworkType(image.type);
        if (artworkType != null) {
            int width = artworkType.width;
            int height = artworkType.height;
            int sizeOrder = this.getSizeOrder(ma.getType(), width);
            ma.addImageSize(width, height, image.image, sizeOrder);
        }
        ma.setOriginalUrl(image.image);
        if (StringUtils.isNotBlank((CharSequence)image.thumbnail)) {
            ma.setPreviewUrl(image.thumbnail);
        } else {
            ma.setPreviewUrl(ma.getOriginalUrl());
        }
        if (StringUtils.isBlank((CharSequence)image.language)) {
            ma.setLanguage("");
        } else {
            ma.setLanguage(LanguageUtils.getIso2LanguageFromLocalizedString(image.language));
        }
        if (image.score >= 100000) {
            ma.setLikes(image.score - 100000);
        } else {
            ma.setLikes(image.score);
        }
        if ((ma.getType() == MediaArtwork.MediaArtworkType.SEASON_BANNER || ma.getType() == MediaArtwork.MediaArtworkType.SEASON_POSTER || ma.getType() == MediaArtwork.MediaArtworkType.SEASON_THUMB) && image.season != null) {
            ma.setSeason(image.season);
        }
        return ma;
    }

    protected MediaSearchResult morphMediaMetadataToSearchResult(MediaMetadata md, MediaType type) {
        MediaSearchResult searchResult = new MediaSearchResult(this.getId(), type);
        searchResult.setTitle(md.getTitle());
        searchResult.setYear(md.getYear());
        searchResult.setIds(md.getIds());
        searchResult.setMetadata(md);
        for (MediaArtwork artwork : md.getMediaArt()) {
            if (artwork.getType() != MediaArtwork.MediaArtworkType.POSTER) continue;
            searchResult.setPosterUrl(artwork.getPreviewUrl());
            break;
        }
        searchResult.setScore(1.0f);
        return searchResult;
    }

    protected int getTvdbIdViaImdbId(String imdbId) {
        try {
            Response httpResponse = this.tvdb.getSearchService().getSearch(imdbId, imdbId).execute();
            if (httpResponse.isSuccessful() && httpResponse.body() != null) {
                return Integer.parseInt(((SearchResultResponse)httpResponse.body()).data.get((int)0).tvdbId);
            }
        }
        catch (Exception e) {
            this.getLogger().debug("could not fetch TVDB via IMDB - '{}'", (Object)e.getMessage());
        }
        return 0;
    }

    protected int getSizeOrder(MediaArtwork.MediaArtworkType type, int width) {
        int sizeOrder = 0;
        switch (type) {
            case POSTER: {
                if (width >= 1000) {
                    sizeOrder = MediaArtwork.PosterSizes.LARGE.getOrder();
                    break;
                }
                if (width >= 500) {
                    sizeOrder = MediaArtwork.PosterSizes.BIG.getOrder();
                    break;
                }
                if (width >= 342) {
                    sizeOrder = MediaArtwork.PosterSizes.MEDIUM.getOrder();
                    break;
                }
                sizeOrder = MediaArtwork.PosterSizes.SMALL.getOrder();
                break;
            }
            case BACKGROUND: {
                if (width >= 3840) {
                    sizeOrder = MediaArtwork.FanartSizes.XLARGE.getOrder();
                    break;
                }
                if (width >= 1920) {
                    sizeOrder = MediaArtwork.FanartSizes.LARGE.getOrder();
                    break;
                }
                if (width >= 1280) {
                    sizeOrder = MediaArtwork.FanartSizes.MEDIUM.getOrder();
                    break;
                }
                sizeOrder = MediaArtwork.FanartSizes.SMALL.getOrder();
                break;
            }
            case THUMB: {
                if (width >= 3840) {
                    sizeOrder = MediaArtwork.ThumbSizes.XLARGE.getOrder();
                    break;
                }
                if (width >= 1920) {
                    sizeOrder = MediaArtwork.ThumbSizes.LARGE.getOrder();
                    break;
                }
                if (width >= 1280) {
                    sizeOrder = MediaArtwork.ThumbSizes.BIG.getOrder();
                    break;
                }
                if (width >= 960) {
                    sizeOrder = MediaArtwork.ThumbSizes.MEDIUM.getOrder();
                    break;
                }
                sizeOrder = MediaArtwork.ThumbSizes.SMALL.getOrder();
                break;
            }
        }
        if (type == MediaArtwork.MediaArtworkType.SEASON_BANNER || type == MediaArtwork.MediaArtworkType.SEASON_POSTER) {
            sizeOrder = MediaArtwork.FanartSizes.LARGE.getOrder();
        } else if (type == MediaArtwork.MediaArtworkType.BANNER) {
            sizeOrder = MediaArtwork.FanartSizes.MEDIUM.getOrder();
        }
        return sizeOrder;
    }
}

