/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.thetvdb;

import java.text.ParseException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaAiredStatus;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;
import org.tinymediamanager.scraper.entities.MediaEpisodeNumber;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMediaIdProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowTvdbMetadataProvider;
import org.tinymediamanager.scraper.thetvdb.TheTvDbMetadataProvider;
import org.tinymediamanager.scraper.thetvdb.entities.ArtworkBaseRecord;
import org.tinymediamanager.scraper.thetvdb.entities.ArtworkTypeRecord;
import org.tinymediamanager.scraper.thetvdb.entities.CompanyBaseRecord;
import org.tinymediamanager.scraper.thetvdb.entities.ContentRating;
import org.tinymediamanager.scraper.thetvdb.entities.EpisodeBaseRecord;
import org.tinymediamanager.scraper.thetvdb.entities.EpisodeExtendedRecord;
import org.tinymediamanager.scraper.thetvdb.entities.EpisodeExtendedResponse;
import org.tinymediamanager.scraper.thetvdb.entities.GenreBaseRecord;
import org.tinymediamanager.scraper.thetvdb.entities.SearchResultRecord;
import org.tinymediamanager.scraper.thetvdb.entities.SearchResultResponse;
import org.tinymediamanager.scraper.thetvdb.entities.SearchType;
import org.tinymediamanager.scraper.thetvdb.entities.SeasonBaseRecord;
import org.tinymediamanager.scraper.thetvdb.entities.SeasonType;
import org.tinymediamanager.scraper.thetvdb.entities.SeasonTypeRecord;
import org.tinymediamanager.scraper.thetvdb.entities.SeriesEpisodesRecord;
import org.tinymediamanager.scraper.thetvdb.entities.SeriesEpisodesResponse;
import org.tinymediamanager.scraper.thetvdb.entities.SeriesExtendedRecord;
import org.tinymediamanager.scraper.thetvdb.entities.SeriesExtendedResponse;
import org.tinymediamanager.scraper.thetvdb.entities.Translation;
import org.tinymediamanager.scraper.thetvdb.entities.TranslationResponse;
import org.tinymediamanager.scraper.util.CacheMap;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.StrgUtils;
import retrofit2.Response;

public class TheTvDbTvShowMetadataProvider
extends TheTvDbMetadataProvider
implements ITvShowMetadataProvider,
ITvShowTvdbMetadataProvider,
IMediaIdProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TheTvDbTvShowMetadataProvider.class);
    private static final CacheMap<String, List<MediaMetadata>> EPISODE_LIST_CACHE_MAP = new CacheMap(600L, 5L);
    private static final CacheMap<String, MediaMetadata> EPISODE_CACHE_MAP = new CacheMap(600L, 5L);

    @Override
    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = super.createMediaProviderInfo();
        info.getConfig().addText("apiKey", "", true);
        info.getConfig().addText("pin", "", true);
        info.getConfig().addBoolean("scrapeLanguageNames", true);
        ArrayList<String> fallbackLanguages = new ArrayList<String>();
        for (MediaLanguages mediaLanguages : MediaLanguages.valuesSorted()) {
            fallbackLanguages.add(mediaLanguages.toString());
        }
        info.getConfig().addSelect("fallbackLanguage", fallbackLanguages.toArray(new String[0]), MediaLanguages.en.toString());
        info.getConfig().load();
        return info;
    }

    @Override
    protected String getSubId() {
        return "tvshow";
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public MediaMetadata getMetadata(@NotNull TvShowSearchAndScrapeOptions options) throws ScrapeException {
        SeriesExtendedRecord show;
        this.initAPI();
        LOGGER.debug("getMetadata(): {}", (Object)options);
        MediaMetadata md = new MediaMetadata(this.getId());
        md.setScrapeOptions(options);
        int id = options.getIdAsInt(this.getId());
        if (id == 0 && MediaIdUtil.isValidImdbId(options.getImdbId())) {
            id = this.getTvdbIdViaImdbId(options.getImdbId());
        }
        if (id == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{this.getId()});
        }
        Translation baseTranslation = null;
        Translation fallbackTranslation = null;
        String baseLanguage = LanguageUtils.getIso3Language(options.getLanguage().toLocale());
        String fallbackLanguage = LanguageUtils.getIso3Language(MediaLanguages.get(this.getProviderInfo().getConfig().getValue("fallbackLanguage")).toLocale());
        if ("pob".equals(baseLanguage)) {
            baseLanguage = "pt";
        }
        if ("pob".equals(fallbackLanguage)) {
            fallbackLanguage = "pt";
        }
        try {
            Response translationResponse;
            Response httpResponse = this.tvdb.getSeriesService().getSeriesExtended(id).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            show = ((SeriesExtendedResponse)httpResponse.body()).data;
            if ((show.nameTranslations.contains(baseLanguage) || show.overviewTranslations.contains(baseLanguage)) && (translationResponse = this.tvdb.getSeriesService().getSeriesTranslation(id, baseLanguage).execute()).isSuccessful()) {
                baseTranslation = ((TranslationResponse)translationResponse.body()).data;
            }
            if ((baseTranslation == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{baseTranslation.name, baseTranslation.overview})) && (show.nameTranslations.contains(fallbackLanguage) || show.overviewTranslations.contains(fallbackLanguage)) && (translationResponse = this.tvdb.getSeriesService().getSeriesTranslation(id, fallbackLanguage).execute()).isSuccessful()) {
                fallbackTranslation = ((TranslationResponse)translationResponse.body()).data;
            }
        }
        catch (Exception e) {
            LOGGER.error("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        md.setId(this.getId(), show.id);
        this.parseRemoteIDs(show.remoteIds).forEach(md::setId);
        if (baseTranslation != null && StringUtils.isNotBlank((CharSequence)baseTranslation.name)) {
            md.setTitle(baseTranslation.name);
        } else if (fallbackTranslation != null && StringUtils.isNotBlank((CharSequence)fallbackTranslation.overview)) {
            md.setTitle(fallbackTranslation.name);
        } else {
            md.setTitle(show.name);
        }
        md.setOriginalTitle(show.name);
        if (baseTranslation != null && StringUtils.isNotBlank((CharSequence)baseTranslation.overview)) {
            md.setPlot(baseTranslation.overview);
        } else if (fallbackTranslation != null && StringUtils.isNotBlank((CharSequence)fallbackTranslation.overview)) {
            md.setPlot(fallbackTranslation.overview);
        }
        try {
            md.setReleaseDate(StrgUtils.parseDate(show.firstAired));
        }
        catch (ParseException e) {
            LOGGER.debug("could not parse date: {}", (Object)e.getMessage());
        }
        try {
            Date date = StrgUtils.parseDate(show.firstAired);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int y = calendar.get(1);
            md.setYear(y);
            if (y != 0 && md.getTitle().contains(String.valueOf(y))) {
                LOGGER.debug("Weird TVDB entry - removing date {} from title", (Object)y);
                md.setTitle(this.clearYearFromTitle(md.getTitle(), y));
            }
        }
        catch (Exception e) {
            LOGGER.debug("could not parse date: {}", (Object)e.getMessage());
        }
        if (show.status != null && show.status.id != null) {
            if (show.status.id == 1) {
                md.setStatus(MediaAiredStatus.CONTINUING);
            } else if (show.status.id == 2) {
                md.setStatus(MediaAiredStatus.ENDED);
            }
        }
        md.setRuntime(MetadataUtil.unboxInteger(show.averageRuntime, 0));
        if (show.originalCountry != null) {
            if (Boolean.TRUE.equals(this.getProviderInfo().getConfig().getValueAsBool("scrapeLanguageNames"))) {
                md.addCountry(LanguageUtils.getLocalizedCountryForLanguage(options.getLanguage().toLocale(), show.originalCountry));
            } else {
                md.addCountry(show.originalCountry);
            }
        }
        if (show.originalLanguage != null) {
            if (Boolean.TRUE.equals(this.getProviderInfo().getConfig().getValueAsBool("scrapeLanguageNames"))) {
                md.setOriginalLanguage(LanguageUtils.getLocalizedLanguageNameFromLocalizedString(options.getLanguage().toLocale(), show.originalLanguage));
            } else {
                md.setOriginalLanguage(show.originalLanguage);
            }
        }
        if (show.originalNetwork != null) {
            md.addProductionCompany(show.originalNetwork.name);
        }
        if (show.latestNetwork != null) {
            md.addProductionCompany(show.latestNetwork.name);
        }
        for (CompanyBaseRecord company : ListUtils.nullSafe(show.companies)) {
            md.addProductionCompany(company.name);
        }
        if (show.characters != null) {
            for (Person member : this.parseCastMembers(show.characters.stream().filter(character -> character.episodeId == null).collect(Collectors.toList()))) {
                md.addCastMember(member);
            }
        }
        for (GenreBaseRecord genreBaseRecord : ListUtils.nullSafe(show.genres)) {
            md.addGenre(MediaGenres.getGenre(genreBaseRecord.name));
        }
        for (ContentRating contentRating : ListUtils.nullSafe(show.contentRatings)) {
            MediaCertification mediaCertification;
            if (!options.getCertificationCountry().getAlpha3().equalsIgnoreCase(contentRating.country) || (mediaCertification = MediaCertification.findCertification(contentRating.name)) == MediaCertification.UNKNOWN) continue;
            md.addCertification(mediaCertification);
        }
        for (SeasonBaseRecord seasonBaseRecord : ListUtils.nullSafe(show.seasons)) {
            MediaEpisodeGroup.EpisodeGroupType episodeGroupType = this.mapEpisodeGroup(seasonBaseRecord.type.type);
            if (episodeGroupType == null) continue;
            MediaEpisodeGroup mediaEpisodeGroup = new MediaEpisodeGroup(episodeGroupType, seasonBaseRecord.type.name);
            md.addEpisodeGroup(mediaEpisodeGroup);
            baseTranslation = null;
            fallbackTranslation = null;
            try {
                Response translationResponse = null;
                if ((this.fakeListToList(seasonBaseRecord.nameTranslations).contains(baseLanguage) || this.fakeListToList(seasonBaseRecord.overviewTranslations).contains(baseLanguage)) && (translationResponse = this.tvdb.getSeasonsService().getSeasonTranslation(seasonBaseRecord.id.intValue(), baseLanguage).execute()).isSuccessful()) {
                    baseTranslation = ((TranslationResponse)translationResponse.body()).data;
                }
                if ((baseTranslation == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{baseTranslation.name, baseTranslation.overview})) && (this.fakeListToList(seasonBaseRecord.nameTranslations).contains(fallbackLanguage) || this.fakeListToList(seasonBaseRecord.overviewTranslations).contains(fallbackLanguage)) && (translationResponse = this.tvdb.getSeasonsService().getSeasonTranslation(seasonBaseRecord.id.intValue(), fallbackLanguage).execute()).isSuccessful()) {
                    fallbackTranslation = ((TranslationResponse)translationResponse.body()).data;
                }
                if (baseTranslation != null && StringUtils.isNotBlank((CharSequence)baseTranslation.name)) {
                    md.addSeasonName(mediaEpisodeGroup, seasonBaseRecord.number, baseTranslation.name);
                } else if (fallbackTranslation != null && StringUtils.isNotBlank((CharSequence)fallbackTranslation.name)) {
                    md.addSeasonName(mediaEpisodeGroup, seasonBaseRecord.number, fallbackTranslation.name);
                }
                if (baseTranslation != null && StringUtils.isNotBlank((CharSequence)baseTranslation.overview)) {
                    md.addSeasonOverview(mediaEpisodeGroup, seasonBaseRecord.number, baseTranslation.overview);
                    continue;
                }
                if (fallbackTranslation == null || !StringUtils.isNotBlank((CharSequence)fallbackTranslation.overview)) continue;
                md.addSeasonOverview(mediaEpisodeGroup, seasonBaseRecord.number, fallbackTranslation.overview);
            }
            catch (Exception e) {
                LOGGER.error("failed to get season meta data: {}", (Object)e.getMessage());
                throw new ScrapeException(e);
            }
        }
        for (ArtworkBaseRecord artworkBaseRecord : ListUtils.nullSafe(show.artworks)) {
            MediaArtwork mediaArtwork = this.parseArtwork(artworkBaseRecord);
            if (mediaArtwork == null) continue;
            md.addMediaArt(mediaArtwork);
        }
        return md;
    }

    private List<String> fakeListToList(List<String> entries) {
        ArrayList<String> ret = new ArrayList<String>();
        if (entries == null) {
            return ret;
        }
        for (String entry : entries) {
            ret.addAll(Stream.of(entry.split(",", -1)).toList());
        }
        return ret;
    }

    @Override
    public MediaMetadata getMetadata(@NotNull TvShowEpisodeSearchAndScrapeOptions options) throws ScrapeException {
        EpisodeExtendedRecord episode;
        this.initAPI();
        LOGGER.debug("getMetadata(): {}", (Object)options);
        int showId = options.createTvShowSearchAndScrapeOptions().getIdAsIntOrDefault(this.getId(), 0);
        if (showId == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{this.getId()});
        }
        int episodeTvdbId = options.getIdAsIntOrDefault("tvdb", 0);
        MediaEpisodeGroup episodeGroup = options.getEpisodeGroup();
        int seasonNr = -1;
        int episodeNr = -1;
        Iterator iterator = options.getIds().get("episodeNr");
        if (iterator instanceof List) {
            List episodeNumbers = (List)((Object)iterator);
            for (Object obj : episodeNumbers) {
                Iterator<MediaMetadata> episodeNumber;
                if (!(obj instanceof MediaEpisodeNumber) || !((MediaEpisodeNumber)((Object)(episodeNumber = (MediaEpisodeNumber)obj))).episodeGroup().equals(episodeGroup)) continue;
                episodeNr = ((MediaEpisodeNumber)((Object)episodeNumber)).episode();
                seasonNr = ((MediaEpisodeNumber)((Object)episodeNumber)).season();
                break;
            }
        }
        if (seasonNr == -1 && episodeNr == -1) {
            seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
            episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
        }
        LocalDate releaseDate = null;
        if (options.getMetadata() != null && options.getMetadata().getReleaseDate() != null) {
            releaseDate = LocalDate.ofInstant(options.getMetadata().getReleaseDate().toInstant(), ZoneId.systemDefault());
        }
        if (releaseDate == null && (seasonNr == -1 || episodeNr == -1) && episodeTvdbId == 0) {
            LOGGER.warn("no aired date/season number/episode number found");
            throw new MissingIdException(new String[]{"episodeNr"});
        }
        List<MediaMetadata> episodes = this.getEpisodeList(options.createTvShowSearchAndScrapeOptions());
        MediaMetadata foundEpisode = null;
        if (episodeTvdbId > 0) {
            for (MediaMetadata episode2 : episodes) {
                if (episodeTvdbId != episode2.getIdAsIntOrDefault("tvdb", 0)) continue;
                foundEpisode = episode2;
                break;
            }
        }
        if (foundEpisode == null) {
            for (MediaMetadata episode2 : episodes) {
                MediaEpisodeNumber episodeNumber = episode2.getEpisodeNumber(episodeGroup);
                if (episodeNumber == null && episodeGroup.getEpisodeGroupType().equals((Object)MediaEpisodeGroup.EpisodeGroupType.AIRED)) {
                    episodeNumber = episode2.getEpisodeNumber(MediaEpisodeGroup.EpisodeGroupType.AIRED);
                }
                if (episodeNumber == null || episodeNumber.season() != seasonNr || episodeNumber.episode() != episodeNr) continue;
                foundEpisode = episode2;
                break;
            }
        }
        if (foundEpisode == null && releaseDate != null) {
            for (MediaMetadata episode2 : episodes) {
                LocalDate epdate;
                if (episode2.getReleaseDate() == null || !(epdate = LocalDate.ofInstant(episode2.getReleaseDate().toInstant(), ZoneId.systemDefault())).equals(releaseDate)) continue;
                foundEpisode = episode2;
                break;
            }
        }
        if (foundEpisode == null) {
            throw new NothingFoundException();
        }
        try {
            MediaMetadata cachedEpisode = EPISODE_CACHE_MAP.get(foundEpisode.getId(this.getId()) + "_" + options.getLanguage().getLanguage());
            if (cachedEpisode != null) {
                return cachedEpisode;
            }
        }
        catch (Exception cachedEpisode) {
            // empty catch block
        }
        try {
            int id = (Integer)foundEpisode.getId(this.getId());
            Response httpResponse = this.tvdb.getEpisodesService().getEpisodeExtended(id).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            episode = ((EpisodeExtendedResponse)httpResponse.body()).data;
        }
        catch (Exception e) {
            LOGGER.error("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        MediaMetadata md = new MediaMetadata(this.getId());
        md.setScrapeOptions(options);
        md.setId(this.getId(), episode.id);
        this.parseRemoteIDs(episode.remoteIDs).forEach(md::setId);
        md.setEpisodeNumbers(foundEpisode.getEpisodeNumbers());
        if (MetadataUtil.unboxInteger(episode.airsBeforeSeason, -1) > -1 || MetadataUtil.unboxInteger(episode.airsBeforeEpisode, -1) > -1) {
            md.setEpisodeNumber(MediaEpisodeGroup.DEFAULT_DISPLAY, MetadataUtil.unboxInteger(episode.airsBeforeSeason), MetadataUtil.unboxInteger(episode.airsBeforeEpisode));
        }
        if (MetadataUtil.unboxInteger(episode.airsAfterSeason, -1) > -1) {
            md.setEpisodeNumber(MediaEpisodeGroup.DEFAULT_DISPLAY, MetadataUtil.unboxInteger(episode.airsAfterSeason), 4096);
        }
        md.setTitle(foundEpisode.getTitle());
        md.setOriginalTitle(foundEpisode.getOriginalTitle());
        md.setPlot(foundEpisode.getPlot());
        if (episode.runtime != null) {
            md.setRuntime((int)episode.runtime);
        }
        try {
            md.setReleaseDate(StrgUtils.parseDate(episode.aired));
        }
        catch (Exception e) {
            LOGGER.debug("could not parse date: {}", (Object)e.getMessage());
        }
        for (Person member : this.parseCastMembers(episode.characters)) {
            md.addCastMember(member);
        }
        for (ContentRating contentRating : ListUtils.nullSafe(episode.contentRatings)) {
            MediaCertification mediaCertification = MediaCertification.findCertification(contentRating.name);
            if (mediaCertification == MediaCertification.UNKNOWN) continue;
            md.addCertification(mediaCertification);
        }
        if (StringUtils.isNotBlank((CharSequence)episode.image)) {
            MediaArtwork ma = new MediaArtwork(this.getProviderInfo().getId(), MediaArtwork.MediaArtworkType.THUMB);
            ma.setPreviewUrl(episode.image);
            ma.setOriginalUrl(episode.image);
            ArtworkTypeRecord artworkTypeRecord = this.getArtworkType(episode.imageType);
            if (artworkTypeRecord != null) {
                int sizeOrder = this.getSizeOrder(ma.getType(), artworkTypeRecord.width);
                ma.addImageSize(artworkTypeRecord.width, artworkTypeRecord.height, episode.image, sizeOrder);
            } else {
                ma.addImageSize(0, 0, episode.image, 0);
            }
            md.addMediaArt(ma);
        }
        EPISODE_CACHE_MAP.put(foundEpisode.getId(this.getId()) + "_" + options.getLanguage().getLanguage(), md);
        return md;
    }

    @Override
    public SortedSet<MediaSearchResult> search(@NotNull TvShowSearchAndScrapeOptions options) throws ScrapeException {
        List<SearchResultRecord> searchResults;
        TreeSet<MediaSearchResult> results;
        block28: {
            int tvdbId;
            this.initAPI();
            LOGGER.debug("search() {}", (Object)options);
            results = new TreeSet<MediaSearchResult>();
            String searchString = "";
            if (StringUtils.isNotBlank((CharSequence)options.getSearchQuery())) {
                searchString = options.getSearchQuery();
            }
            if ((tvdbId = options.getIdAsInt(this.getId())) != 0) {
                LOGGER.debug("found TvDb ID {} - getting direct", (Object)tvdbId);
                try {
                    MediaMetadata md = this.getMetadata(options);
                    if (md != null) {
                        results.add(this.morphMediaMetadataToSearchResult(md, MediaType.TV_SHOW));
                        return results;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("problem getting data vom tvdb via ID: {}", (Object)e.getMessage());
                }
            }
            searchResults = null;
            if (StringUtils.isNotBlank((CharSequence)searchString)) {
                try {
                    Response httpResponse = this.tvdb.getSearchService().getSearch(searchString, SearchType.SERIES).execute();
                    if (!httpResponse.isSuccessful()) {
                        throw new HttpException(httpResponse.code(), httpResponse.message());
                    }
                    searchResults = ((SearchResultResponse)httpResponse.body()).data;
                    if (!ListUtils.isEmpty(searchResults) || !ID_PATTERN.matcher(searchString).matches()) break block28;
                    LOGGER.debug("nothing found, but search term '{}' looks like a TvDb ID - getting direct", (Object)searchString);
                    try {
                        MediaMetadata md = this.getMetadata(options);
                        if (md != null) {
                            results.add(this.morphMediaMetadataToSearchResult(md, MediaType.TV_SHOW));
                            return results;
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("problem getting data vom tvdb via ID: {}", (Object)e.getMessage());
                    }
                }
                catch (Exception e) {
                    LOGGER.error("problem getting data vom tvdb: {}", (Object)e.getMessage());
                    throw new ScrapeException(e);
                }
            }
        }
        if (ListUtils.isEmpty(searchResults)) {
            return results;
        }
        HashMap<String, MediaSearchResult> resultMap = new HashMap<String, MediaSearchResult>();
        for (SearchResultRecord searchResultRecord : searchResults) {
            String title;
            MediaSearchResult result = new MediaSearchResult(this.getId(), options.getMediaType());
            String id = "";
            if (StringUtils.isNotBlank((CharSequence)searchResultRecord.tvdbId)) {
                id = searchResultRecord.tvdbId;
            } else if (StringUtils.isNotBlank((CharSequence)searchResultRecord.id)) {
                id = searchResultRecord.id.replace("series-", "");
            }
            if (StringUtils.isBlank((CharSequence)id)) continue;
            result.setId(id);
            MediaLanguages baseLanguage = options.getLanguage();
            MediaLanguages fallbackLanguage = null;
            if (StringUtils.isNotBlank((CharSequence)this.getProviderInfo().getConfig().getValue("fallbackLanguage"))) {
                fallbackLanguage = MediaLanguages.get(this.getProviderInfo().getConfig().getValue("fallbackLanguage"));
            }
            if (StringUtils.isNotBlank((CharSequence)(title = this.parseLocalizedText(baseLanguage, searchResultRecord.translations)))) {
                result.setTitle(title);
            } else {
                title = this.parseLocalizedText(fallbackLanguage, searchResultRecord.translations);
                if (StringUtils.isNotBlank((CharSequence)title)) {
                    result.setTitle(title);
                } else {
                    result.setTitle(searchResultRecord.name);
                }
            }
            String overview = this.parseLocalizedText(baseLanguage, searchResultRecord.overviews);
            if (StringUtils.isNotBlank((CharSequence)overview)) {
                result.setOverview(overview);
            } else {
                overview = this.parseLocalizedText(fallbackLanguage, searchResultRecord.overviews);
                if (StringUtils.isNotBlank((CharSequence)overview)) {
                    result.setOverview(overview);
                } else {
                    result.setOverview(searchResultRecord.overview);
                }
            }
            int year = MetadataUtil.parseInt(searchResultRecord.year, 0);
            result.setYear(year);
            if (year > 0 && result.getTitle().contains(String.valueOf(year))) {
                LOGGER.debug("Weird TVDB entry - removing date {} from title", (Object)year);
                result.setTitle(this.clearYearFromTitle(result.getTitle(), year));
            }
            if ((year = options.getSearchYear()) > 0 && result.getTitle().contains(String.valueOf(year))) {
                LOGGER.debug("Weird TVDB entry - removing date {} from title", (Object)year);
                result.setTitle(this.clearYearFromTitle(result.getTitle(), year));
            }
            result.setPosterUrl(searchResultRecord.imageUrl);
            result.calculateScore(options);
            resultMap.put(id, result);
        }
        results.addAll(resultMap.values());
        return results;
    }

    @Override
    public List<MediaMetadata> getEpisodeList(@NotNull TvShowSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getEpisodeList(): {}", (Object)options);
        this.initAPI();
        Integer showId = options.getIdAsInteger(this.getProviderInfo().getId());
        if (showId == null || showId == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{this.getProviderInfo().getId()});
        }
        List<MediaMetadata> episodes = EPISODE_LIST_CACHE_MAP.get(showId + "_" + options.getLanguage().getLanguage());
        if (ListUtils.isNotEmpty(episodes)) {
            return episodes;
        }
        HashMap<MediaEpisodeGroup, List> eps = new HashMap<MediaEpisodeGroup, List>();
        int pageSize = 500;
        try {
            Response httpResponse = this.tvdb.getSeriesService().getSeriesExtended(showId.intValue()).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            SeriesExtendedRecord show = ((SeriesExtendedResponse)httpResponse.body()).data;
            block4: for (SeasonTypeRecord seasonTypeRecord : ListUtils.nullSafe(show.seasonTypes)) {
                SeriesEpisodesRecord seriesEpisodesRecord;
                int counter = 0;
                while ((seriesEpisodesRecord = this.getSeriesEpisodesRecord(showId, seasonTypeRecord.type, counter)) != null && !ListUtils.isEmpty(seriesEpisodesRecord.episodes)) {
                    if (ListUtils.isNotEmpty(seriesEpisodesRecord.episodes)) {
                        this.injectEpisodeTranslations(options, showId, counter, seriesEpisodesRecord);
                        MediaEpisodeGroup episodeGroup = new MediaEpisodeGroup(this.mapEpisodeGroup(seasonTypeRecord.type), seasonTypeRecord.name);
                        eps.computeIfAbsent(episodeGroup, type -> new ArrayList()).addAll(seriesEpisodesRecord.episodes);
                    }
                    if (seriesEpisodesRecord.episodes.size() < pageSize) continue block4;
                    ++counter;
                }
            }
            HashMap<Integer, MediaMetadata> episodeMap = new HashMap<Integer, MediaMetadata>();
            for (Map.Entry entry : eps.entrySet()) {
                MediaEpisodeGroup episodeGroup = (MediaEpisodeGroup)entry.getKey();
                for (EpisodeBaseRecord ep : (List)entry.getValue()) {
                    MediaMetadata fromMap = (MediaMetadata)episodeMap.get(ep.id);
                    if (fromMap == null) {
                        MediaMetadata episode = new MediaMetadata(this.getProviderInfo().getId());
                        episode.setScrapeOptions(options);
                        episode.setId(this.getProviderInfo().getId(), ep.id);
                        episode.setEpisodeNumber(episodeGroup, ep.seasonNumber, ep.episodeNumber);
                        episode.setTitle(ep.name);
                        episode.setPlot(ep.overview);
                        episode.setRuntime(ep.runtime);
                        try {
                            episode.setReleaseDate(StrgUtils.parseDate(ep.aired));
                        }
                        catch (Exception ignored) {
                            LOGGER.trace("Could not parse date: {}", (Object)ep.aired);
                        }
                        episodeMap.put(MetadataUtil.unboxInteger(ep.id), episode);
                        continue;
                    }
                    fromMap.setEpisodeNumber(episodeGroup, ep.seasonNumber, ep.episodeNumber);
                }
            }
            episodes = new ArrayList(episodeMap.values());
            episodes.sort((o1, o2) -> {
                MediaEpisodeNumber m1 = o1.getEpisodeNumber(MediaEpisodeGroup.EpisodeGroupType.AIRED);
                MediaEpisodeNumber m2 = o2.getEpisodeNumber(MediaEpisodeGroup.EpisodeGroupType.AIRED);
                if (m1 == null && m2 == null) {
                    return 0;
                }
                if (m1 == null) {
                    return -1;
                }
                if (m2 == null) {
                    return 1;
                }
                return m1.compareTo(m2);
            });
        }
        catch (Exception e) {
            LOGGER.debug("failed to get episode list: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (!episodes.isEmpty()) {
            EPISODE_LIST_CACHE_MAP.put(showId + "_" + options.getLanguage().getLanguage(), episodes);
        }
        return episodes;
    }

    @Override
    public Map<String, Object> getMediaIds(Map<String, Object> ids, MediaType mediaType) throws ScrapeException {
        SeriesExtendedRecord show;
        if (mediaType != MediaType.TV_SHOW) {
            return Collections.emptyMap();
        }
        this.initAPI();
        LOGGER.debug("getMediaIds(): {}", ids);
        int id = MediaIdUtil.getIdAsInt(ids, this.getId());
        if (id == 0 && MediaIdUtil.isValidImdbId(MediaIdUtil.getIdAsString(ids, "imdb"))) {
            id = this.getTvdbIdViaImdbId(MediaIdUtil.getIdAsString(ids, "imdb"));
        }
        if (id == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{this.getId()});
        }
        try {
            Response httpResponse = this.tvdb.getSeriesService().getSeriesExtended(id).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            show = ((SeriesExtendedResponse)httpResponse.body()).data;
        }
        catch (Exception e) {
            LOGGER.error("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (show == null) {
            throw new NothingFoundException();
        }
        HashMap<String, Object> showIds = new HashMap<String, Object>();
        showIds.put(this.getId(), show.id);
        this.parseRemoteIDs(show.remoteIds).forEach((k, v) -> showIds.put((String)k, v));
        return showIds;
    }

    private SeriesEpisodesRecord getSeriesEpisodesRecord(int showId, SeasonType seasonType, int counter) {
        try {
            Response httpResponse = this.tvdb.getSeriesService().getSeriesEpisodes(showId, seasonType, counter).execute();
            if (httpResponse.isSuccessful()) {
                SeriesEpisodesResponse response = (SeriesEpisodesResponse)httpResponse.body();
                if (response != null) {
                    return response.data;
                }
            } else if (counter == 0) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
        }
        catch (Exception e) {
            LOGGER.debug("Could not get episode listing for season type '{}' - '{}'  ", (Object)seasonType, (Object)e.getMessage());
        }
        return null;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void injectEpisodeTranslations(TvShowSearchAndScrapeOptions options, int showId, int counter, SeriesEpisodesRecord seriesEpisodesRecord) {
        titleMap = new HashMap<EpisodeBaseRecord, String>();
        overviewMap = new HashMap<EpisodeBaseRecord, String>();
        for (Object toInject : ListUtils.nullSafe(seriesEpisodesRecord.episodes)) {
            titleMap.put((EpisodeBaseRecord)toInject, toInject.name);
            overviewMap.put((EpisodeBaseRecord)toInject, toInject.overview);
            toInject.originalName = toInject.name;
            toInject.name = null;
            toInject.overview = null;
        }
        language = LanguageUtils.getIso3Language(options.getLanguage().toLocale());
        if ("pob".equals(language)) {
            language = "pt";
        }
        if (StringUtils.isNotBlank((CharSequence)language)) {
            if (language.equals(seriesEpisodesRecord.series.originalLanguage)) {
                for (EpisodeBaseRecord toInject : ListUtils.nullSafe(seriesEpisodesRecord.episodes)) {
                    toInject.name = toInject.originalName;
                    toInject.overview = (String)overviewMap.get(toInject);
                }
            } else {
                try {
                    httpResponse = this.tvdb.getSeriesService().getSeriesEpisodes(showId, SeasonType.DEFAULT, language, counter).execute();
                    if (!httpResponse.isSuccessful() || (response = (SeriesEpisodesResponse)httpResponse.body()) == null || response.data == null) ** GOTO lbl39
                    block6: for (EpisodeBaseRecord toInject : ListUtils.nullSafe(seriesEpisodesRecord.episodes)) {
                        for (EpisodeBaseRecord translation : ListUtils.nullSafe(response.data.episodes)) {
                            if (!Objects.equals(toInject.id, translation.id)) continue;
                            if (language.equals(seriesEpisodesRecord.series.originalLanguage)) {
                                toInject.originalName = translation.name;
                            }
                            if (StringUtils.isNotBlank((CharSequence)translation.name)) {
                                toInject.name = translation.name;
                            }
                            if (!StringUtils.isNotBlank((CharSequence)translation.overview)) continue block6;
                            toInject.overview = translation.overview;
                            continue block6;
                        }
                    }
                }
                catch (Exception e) {
                    TheTvDbTvShowMetadataProvider.LOGGER.debug("Could not get episode translations - '{}'  ", (Object)e.getMessage());
                }
            }
        }
lbl39:
        // 6 sources

        if ("pob".equals(fallbackLanguage = LanguageUtils.getIso3Language(MediaLanguages.get(this.getProviderInfo().getConfig().getValue("fallbackLanguage")).toLocale()))) {
            fallbackLanguage = "pt";
        }
        if (StringUtils.isNotBlank((CharSequence)fallbackLanguage) && !fallbackLanguage.equals(language)) {
            if (fallbackLanguage.equals(seriesEpisodesRecord.series.originalLanguage)) {
                for (EpisodeBaseRecord toInject : ListUtils.nullSafe(seriesEpisodesRecord.episodes)) {
                    if (StringUtils.isBlank((CharSequence)toInject.name)) {
                        toInject.name = toInject.originalName;
                    }
                    if (!StringUtils.isBlank((CharSequence)toInject.overview)) continue;
                    toInject.overview = (String)overviewMap.get(toInject);
                }
            } else {
                try {
                    httpResponse = this.tvdb.getSeriesService().getSeriesEpisodes(showId, SeasonType.DEFAULT, fallbackLanguage, counter).execute();
                    if (!httpResponse.isSuccessful() || (response = (SeriesEpisodesResponse)httpResponse.body()) == null || response.data == null) ** GOTO lbl65
                    block9: for (EpisodeBaseRecord toInject : ListUtils.nullSafe(seriesEpisodesRecord.episodes)) {
                        for (EpisodeBaseRecord translation : ListUtils.nullSafe(response.data.episodes)) {
                            if (!Objects.equals(toInject.id, translation.id)) continue;
                            if (StringUtils.isBlank((CharSequence)toInject.name) && StringUtils.isNotBlank((CharSequence)translation.name)) {
                                toInject.name = translation.name;
                            }
                            if (!StringUtils.isBlank((CharSequence)toInject.overview) || !StringUtils.isNotBlank((CharSequence)translation.overview)) continue block9;
                            toInject.overview = translation.overview;
                            continue block9;
                        }
                    }
                }
                catch (Exception e) {
                    TheTvDbTvShowMetadataProvider.LOGGER.debug("Could not get episode translations - '{}'  ", (Object)e.getMessage());
                }
            }
        }
lbl65:
        // 8 sources

        for (EpisodeBaseRecord toInject : ListUtils.nullSafe(seriesEpisodesRecord.episodes)) {
            if (StringUtils.isBlank((CharSequence)toInject.name)) {
                toInject.name = (String)titleMap.get(toInject);
            }
            if (StringUtils.isBlank((CharSequence)toInject.name)) {
                toInject.name = "Episode " + toInject.episodeNumber;
            }
            if (!StringUtils.isBlank((CharSequence)toInject.originalName)) continue;
            toInject.originalName = "Episode " + toInject.episodeNumber;
        }
    }

    private MediaEpisodeGroup.EpisodeGroupType mapEpisodeGroup(SeasonType type) {
        if (type == null) {
            return null;
        }
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case SeasonType.DEFAULT, SeasonType.OFFICIAL -> MediaEpisodeGroup.EpisodeGroupType.AIRED;
            case SeasonType.ABSOLUTE -> MediaEpisodeGroup.EpisodeGroupType.ABSOLUTE;
            case SeasonType.DVD -> MediaEpisodeGroup.EpisodeGroupType.DVD;
            case SeasonType.ALTERNATE, SeasonType.REGIONAL -> MediaEpisodeGroup.EpisodeGroupType.ALTERNATE;
        };
    }
}

