/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.tmdb.TmdbController;
import org.tinymediamanager.scraper.tmdb.TmdbUtils;
import org.tinymediamanager.scraper.tmdb.entities.AppendToResponse;
import org.tinymediamanager.scraper.tmdb.entities.Image;
import org.tinymediamanager.scraper.tmdb.entities.Images;
import org.tinymediamanager.scraper.tmdb.entities.TvShow;
import org.tinymediamanager.scraper.tmdb.enumerations.AppendToResponseItem;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;

class TmdbArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmdbArtworkProvider.class);
    private final TmdbController api;
    private final String baseUrl;

    public TmdbArtworkProvider(TmdbController api, String baseUrl) {
        this.api = api;
        this.baseUrl = baseUrl;
    }

    List<MediaArtwork> getArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getArtwork(): {}", (Object)options);
        MediaArtwork.MediaArtworkType artworkType = options.getArtworkType();
        int tmdbId = options.getTmdbId();
        String imdbId = options.getImdbId();
        if (options.getMediaType() == MediaType.MOVIE_SET && options.getIdAsInt("tmdbSet") > 0) {
            tmdbId = options.getIdAsInt("tmdbSet");
        }
        if (tmdbId == 0 && StringUtils.isNotEmpty((CharSequence)imdbId)) {
            try {
                tmdbId = TmdbUtils.getTmdbIdFromImdbId(this.api, options.getMediaType(), imdbId);
            }
            catch (Exception e) {
                LOGGER.debug("could not get tmdb from imdb - '{}'", (Object)e.getMessage());
            }
        }
        if (tmdbId == 0) {
            LOGGER.warn("Cannot get artwork - neither imdb/tmdb set");
            throw new MissingIdException("tmdb", "imdb");
        }
        List<MediaArtwork> artwork = null;
        try {
            switch (options.getMediaType()) {
                case MOVIE: {
                    artwork = this.prepareArtwork((Images)this.api.moviesService().images(tmdbId, null).execute().body(), artworkType, tmdbId, options);
                    break;
                }
                case MOVIE_SET: {
                    artwork = this.prepareArtwork((Images)this.api.collectionService().images(tmdbId, null).execute().body(), artworkType, tmdbId, options);
                    break;
                }
                case TV_SHOW: {
                    if (artworkType == MediaArtwork.MediaArtworkType.ALL || artworkType == MediaArtwork.MediaArtworkType.SEASON_POSTER) {
                        TvShow tvShow = (TvShow)this.api.tvService().tv(tmdbId, null, new AppendToResponse(AppendToResponseItem.IMAGES)).execute().body();
                        if (tvShow != null) {
                            artwork = this.prepareArtwork(tvShow.images, artworkType, tmdbId, options);
                            for (int i = 0; i <= MetadataUtil.unboxInteger(tvShow.number_of_seasons); ++i) {
                                try {
                                    artwork.addAll(this.prepareArtwork((Images)this.api.tvSeasonsService().images(tmdbId, i, null).execute().body(), artworkType, tmdbId, i, options));
                                    continue;
                                }
                                catch (Exception e) {
                                    LOGGER.debug("could not net season artwork: '{}'", (Object)e.getMessage());
                                }
                            }
                        }
                        break;
                    }
                    artwork = this.prepareArtwork((Images)this.api.tvService().images(tmdbId, null).execute().body(), artworkType, tmdbId, options);
                    break;
                }
                case TV_EPISODE: {
                    int seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
                    int episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
                    if (seasonNr <= -1 || episodeNr <= -1) break;
                    artwork = this.prepareArtwork((Images)this.api.tvEpisodesService().images(tmdbId, seasonNr, episodeNr).execute().body(), artworkType, tmdbId, options);
                }
            }
        }
        catch (InterruptedIOException e) {
            return Collections.emptyList();
        }
        catch (Exception e) {
            LOGGER.debug("failed to get artwork: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (ListUtils.isEmpty(artwork)) {
            return Collections.emptyList();
        }
        MediaMetadata md = options.getMetadata();
        if (md != null) {
            md.addMediaArt(artwork);
        }
        return artwork;
    }

    private List<MediaArtwork> prepareArtwork(Images tmdbArtwork, MediaArtwork.MediaArtworkType artworkType, int tmdbId, ArtworkSearchAndScrapeOptions options) {
        return this.prepareArtwork(tmdbArtwork, artworkType, tmdbId, -1, options);
    }

    private List<MediaArtwork> prepareArtwork(Images tmdbArtwork, MediaArtwork.MediaArtworkType artworkType, int tmdbId, int season, ArtworkSearchAndScrapeOptions options) {
        MediaArtwork ma;
        ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
        if (tmdbArtwork == null) {
            return artwork;
        }
        if (tmdbArtwork.posters != null) {
            tmdbArtwork.posters.sort(new ImageComparator(options.getLanguage().toLocale()));
        }
        if (tmdbArtwork.backdrops != null) {
            tmdbArtwork.backdrops.sort(new ImageComparator(options.getLanguage().toLocale()));
        }
        if (tmdbArtwork.stills != null) {
            tmdbArtwork.stills.sort(new ImageComparator(options.getLanguage().toLocale()));
        }
        if (tmdbArtwork.logos != null) {
            tmdbArtwork.logos.sort(new ImageComparator(options.getLanguage().toLocale()));
        }
        if (artworkType == MediaArtwork.MediaArtworkType.POSTER || artworkType == MediaArtwork.MediaArtworkType.SEASON_POSTER || artworkType == MediaArtwork.MediaArtworkType.ALL) {
            for (Image image : ListUtils.nullSafe(tmdbArtwork.posters)) {
                ma = season < 0 ? new MediaArtwork("tmdb", MediaArtwork.MediaArtworkType.POSTER) : new MediaArtwork("tmdb", MediaArtwork.MediaArtworkType.SEASON_POSTER);
                ma.setPreviewUrl(this.baseUrl + "w342" + image.file_path);
                ma.setOriginalUrl(this.baseUrl + "original" + image.file_path);
                if (StringUtils.isBlank((CharSequence)image.iso_639_1)) {
                    ma.setLanguage("");
                } else {
                    ma.setLanguage(image.iso_639_1);
                }
                ma.setLikes(image.vote_count);
                ma.setTmdbId(tmdbId);
                if (season > -1) {
                    ma.setSeason(season);
                }
                ma.addImageSize(image.width, image.height, this.baseUrl + "original" + image.file_path, MediaArtwork.PosterSizes.getSizeOrder(image.width));
                if (780 < image.width) {
                    ma.addImageSize(780, Math.round((float)image.height.intValue() * 780.0f / (float)image.width.intValue()), this.baseUrl + "w780" + image.file_path, MediaArtwork.PosterSizes.getSizeOrder(780));
                }
                if (500 < image.width) {
                    ma.addImageSize(500, Math.round((float)image.height.intValue() * 500.0f / (float)image.width.intValue()), this.baseUrl + "w500" + image.file_path, MediaArtwork.PosterSizes.getSizeOrder(500));
                }
                if (342 < image.width) {
                    ma.addImageSize(342, Math.round((float)image.height.intValue() * 342.0f / (float)image.width.intValue()), this.baseUrl + "w342" + image.file_path, MediaArtwork.PosterSizes.getSizeOrder(342));
                }
                if (185 < image.width) {
                    ma.addImageSize(185, Math.round((float)image.height.intValue() * 185.0f / (float)image.width.intValue()), this.baseUrl + "w185" + image.file_path, MediaArtwork.PosterSizes.getSizeOrder(185));
                }
                artwork.add(ma);
            }
        }
        if (artworkType == MediaArtwork.MediaArtworkType.BACKGROUND || artworkType == MediaArtwork.MediaArtworkType.ALL) {
            for (Image image : ListUtils.nullSafe(tmdbArtwork.backdrops)) {
                ma = new MediaArtwork("tmdb", MediaArtwork.MediaArtworkType.BACKGROUND);
                ma.setPreviewUrl(this.baseUrl + "w1280" + image.file_path);
                ma.setOriginalUrl(this.baseUrl + "original" + image.file_path);
                ma.setLanguage(image.iso_639_1);
                ma.setTmdbId(tmdbId);
                if (season > -1) {
                    ma.setSeason(season);
                }
                ma.addImageSize(image.width, image.height, this.baseUrl + "original" + image.file_path, MediaArtwork.FanartSizes.getSizeOrder(image.width));
                if (1280 < image.width) {
                    ma.addImageSize(1280, Math.round((float)image.height.intValue() * 1280.0f / (float)image.width.intValue()), this.baseUrl + "w1280" + image.file_path, MediaArtwork.FanartSizes.getSizeOrder(1280));
                }
                if (300 < image.width) {
                    ma.addImageSize(300, Math.round((float)image.height.intValue() * 300.0f / (float)image.width.intValue()), this.baseUrl + "w300" + image.file_path, MediaArtwork.FanartSizes.getSizeOrder(300));
                }
                artwork.add(ma);
            }
        }
        if (artworkType == MediaArtwork.MediaArtworkType.THUMB || artworkType == MediaArtwork.MediaArtworkType.ALL) {
            for (Image image : ListUtils.nullSafe(tmdbArtwork.stills)) {
                ma = new MediaArtwork("tmdb", MediaArtwork.MediaArtworkType.THUMB);
                ma.setPreviewUrl(this.baseUrl + "w300" + image.file_path);
                ma.setOriginalUrl(this.baseUrl + "original" + image.file_path);
                ma.setLanguage(image.iso_639_1);
                ma.setTmdbId(tmdbId);
                ma.addImageSize(image.width, image.height, this.baseUrl + "original" + image.file_path, MediaArtwork.ThumbSizes.getSizeOrder(image.width));
                if (300 < image.width) {
                    ma.addImageSize(300, Math.round((float)image.height.intValue() * 300.0f / (float)image.width.intValue()), this.baseUrl + "w300" + image.file_path, MediaArtwork.ThumbSizes.getSizeOrder(300));
                }
                artwork.add(ma);
            }
        }
        if (artworkType == MediaArtwork.MediaArtworkType.CLEARLOGO || artworkType == MediaArtwork.MediaArtworkType.ALL) {
            for (Image image : ListUtils.nullSafe(tmdbArtwork.logos)) {
                ma = new MediaArtwork("tmdb", MediaArtwork.MediaArtworkType.CLEARLOGO);
                ma.setPreviewUrl(this.baseUrl + "w500" + image.file_path);
                ma.setOriginalUrl(this.baseUrl + "original" + image.file_path);
                ma.setLanguage(image.iso_639_1);
                ma.setTmdbId(tmdbId);
                ma.addImageSize(image.width, image.height, this.baseUrl + "original" + image.file_path, 0);
                if (500 < image.width) {
                    ma.addImageSize(500, Math.round((float)image.height.intValue() * 500.0f / (float)image.width.intValue()), this.baseUrl + "w500" + image.file_path, 0);
                }
                if (300 < image.width) {
                    ma.addImageSize(300, Math.round((float)image.height.intValue() * 300.0f / (float)image.width.intValue()), this.baseUrl + "w300" + image.file_path, 0);
                }
                artwork.add(ma);
            }
        }
        return artwork;
    }

    private static class ImageComparator
    implements Comparator<Image> {
        private final String preferredLangu;

        private ImageComparator(Locale locale) {
            this.preferredLangu = locale == null ? null : locale.getLanguage();
        }

        @Override
        public int compare(Image arg0, Image arg1) {
            if (Objects.equals(this.preferredLangu, arg0.iso_639_1) && !Objects.equals(this.preferredLangu, arg1.iso_639_1)) {
                return -1;
            }
            if (!Objects.equals(this.preferredLangu, arg0.iso_639_1) && Objects.equals(this.preferredLangu, arg1.iso_639_1)) {
                return 1;
            }
            if ("en".equals(arg0.iso_639_1) && !"en".equals(arg1.iso_639_1)) {
                return -1;
            }
            if (!"en".equals(arg0.iso_639_1) && "en".equals(arg1.iso_639_1)) {
                return 1;
            }
            if (arg0.vote_average.equals(arg1.vote_average)) {
                return 0;
            }
            return arg0.vote_average > arg1.vote_average ? -1 : 1;
        }
    }
}

