/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.tmdb.TmdbInterceptor;
import org.tinymediamanager.scraper.tmdb.entities.BaseMovie;
import org.tinymediamanager.scraper.tmdb.entities.BasePerson;
import org.tinymediamanager.scraper.tmdb.entities.BaseTvShow;
import org.tinymediamanager.scraper.tmdb.entities.Media;
import org.tinymediamanager.scraper.tmdb.entities.PersonCastCredit;
import org.tinymediamanager.scraper.tmdb.entities.PersonCrewCredit;
import org.tinymediamanager.scraper.tmdb.enumerations.MediaType;
import org.tinymediamanager.scraper.tmdb.enumerations.Status;
import org.tinymediamanager.scraper.tmdb.enumerations.VideoType;
import org.tinymediamanager.scraper.tmdb.services.CollectionsService;
import org.tinymediamanager.scraper.tmdb.services.ConfigurationService;
import org.tinymediamanager.scraper.tmdb.services.FindService;
import org.tinymediamanager.scraper.tmdb.services.MoviesService;
import org.tinymediamanager.scraper.tmdb.services.SearchService;
import org.tinymediamanager.scraper.tmdb.services.TvEpisodeGroupsService;
import org.tinymediamanager.scraper.tmdb.services.TvEpisodesService;
import org.tinymediamanager.scraper.tmdb.services.TvSeasonsService;
import org.tinymediamanager.scraper.tmdb.services.TvService;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

class TmdbController {
    public static final String API_HOST = "api.themoviedb.org";
    public static final String ALTERNATE_API_HOST = "api.tmdb.org";
    public static final String API_VERSION = "3";
    public static final String PARAM_API_KEY = "api_key";
    private static final String TMDB_DATE_PATTERN = "yyyy-MM-dd";
    private final String apiUrl;
    private final SimpleDateFormat dateFormat;
    private final String apiKey;
    private final boolean alternateServer;
    private Retrofit retrofit;

    TmdbController(String apiKey, boolean alternateServer) {
        this.apiKey = apiKey;
        this.alternateServer = alternateServer;
        this.apiUrl = alternateServer ? "https://api.tmdb.org/3/" : "https://api.themoviedb.org/3/";
        this.dateFormat = new SimpleDateFormat(TMDB_DATE_PATTERN);
    }

    public String apiKey() {
        return this.apiKey;
    }

    public boolean isAlternateServer() {
        return this.alternateServer;
    }

    protected Retrofit getRetrofit() {
        if (this.retrofit == null) {
            this.retrofit = new Retrofit.Builder().baseUrl(this.apiUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.getGsonBuilder().create())).client(this.okHttpClient()).build();
        }
        return this.retrofit;
    }

    protected synchronized OkHttpClient okHttpClient() {
        OkHttpClient.Builder builder = TmmHttpClient.newBuilderWithForcedCache(15, TimeUnit.MINUTES);
        builder.connectTimeout(30L, TimeUnit.SECONDS);
        builder.writeTimeout(30L, TimeUnit.SECONDS);
        builder.readTimeout(30L, TimeUnit.SECONDS);
        builder.addInterceptor((Interceptor)new TmdbInterceptor(this));
        return builder.build();
    }

    protected GsonBuilder getGsonBuilder() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Integer.class, (json, typeOfT, context) -> json.getAsInt());
        builder.registerTypeAdapter(MediaType.class, (json, typeOfT, context) -> MediaType.get(json.getAsString()));
        builder.registerTypeAdapter(VideoType.class, (json, typeOfT, context) -> VideoType.get(json.getAsString()));
        builder.registerTypeAdapter(Media.class, (jsonElement, type, jsonDeserializationContext) -> {
            Media media = new Media();
            if (jsonElement.getAsJsonObject().get("media_type") != null) {
                media.media_type = (MediaType)((Object)((Object)jsonDeserializationContext.deserialize(jsonElement.getAsJsonObject().get("media_type"), MediaType.class)));
            } else if (jsonElement.getAsJsonObject().get("first_air_date") != null) {
                media.media_type = MediaType.TV;
            } else if (jsonElement.getAsJsonObject().get("name") != null) {
                media.media_type = MediaType.PERSON;
            } else if (jsonElement.getAsJsonObject().get("title") != null) {
                media.media_type = MediaType.MOVIE;
            }
            switch (media.media_type) {
                case MOVIE: {
                    media.movie = (BaseMovie)jsonDeserializationContext.deserialize(jsonElement, BaseMovie.class);
                    break;
                }
                case TV: {
                    media.tvShow = (BaseTvShow)jsonDeserializationContext.deserialize(jsonElement, BaseTvShow.class);
                    break;
                }
                case PERSON: {
                    media.person = (BasePerson)jsonDeserializationContext.deserialize(jsonElement, BasePerson.class);
                }
            }
            return media;
        });
        builder.registerTypeAdapter(PersonCastCredit.class, (jsonElement, type, jsonDeserializationContext) -> {
            JsonElement creditId;
            PersonCastCredit personCastCredit = new PersonCastCredit();
            personCastCredit.media = (Media)jsonDeserializationContext.deserialize(jsonElement, Media.class);
            JsonElement character = jsonElement.getAsJsonObject().get("character");
            if (character != null) {
                personCastCredit.character = character.getAsString();
            }
            if ((creditId = jsonElement.getAsJsonObject().get("credit_id")) != null) {
                personCastCredit.credit_id = creditId.getAsString();
            }
            if (personCastCredit.media.media_type == MediaType.TV) {
                personCastCredit.episode_count = jsonElement.getAsJsonObject().get("episode_count").getAsInt();
            }
            return personCastCredit;
        });
        builder.registerTypeAdapter(PersonCrewCredit.class, (jsonElement, type, jsonDeserializationContext) -> {
            PersonCrewCredit personCrewCredit = new PersonCrewCredit();
            personCrewCredit.media = (Media)jsonDeserializationContext.deserialize(jsonElement, Media.class);
            personCrewCredit.department = jsonElement.getAsJsonObject().get("department").getAsString();
            personCrewCredit.job = jsonElement.getAsJsonObject().get("job").getAsString();
            personCrewCredit.credit_id = jsonElement.getAsJsonObject().get("credit_id").getAsString();
            if (personCrewCredit.media.media_type == MediaType.TV && jsonElement.getAsJsonObject().get("episode_count") != null) {
                personCrewCredit.episode_count = jsonElement.getAsJsonObject().get("episode_count").getAsInt();
            }
            return personCrewCredit;
        });
        builder.registerTypeAdapter(Date.class, (json, typeOfT, context) -> {
            try {
                return this.dateFormat.parse(json.getAsString());
            }
            catch (ParseException e) {
                return null;
            }
        });
        builder.registerTypeAdapter(Status.class, (jsonElement, type, jsonDeserializationContext) -> {
            String value = jsonElement.getAsString();
            if (value != null) {
                return Status.fromValue(value);
            }
            return null;
        });
        return builder;
    }

    CollectionsService collectionService() {
        return (CollectionsService)this.getRetrofit().create(CollectionsService.class);
    }

    ConfigurationService configurationService() {
        return (ConfigurationService)this.getRetrofit().create(ConfigurationService.class);
    }

    FindService findService() {
        return (FindService)this.getRetrofit().create(FindService.class);
    }

    MoviesService moviesService() {
        return (MoviesService)this.getRetrofit().create(MoviesService.class);
    }

    SearchService searchService() {
        return (SearchService)this.getRetrofit().create(SearchService.class);
    }

    TvService tvService() {
        return (TvService)this.getRetrofit().create(TvService.class);
    }

    TvSeasonsService tvSeasonsService() {
        return (TvSeasonsService)this.getRetrofit().create(TvSeasonsService.class);
    }

    TvEpisodesService tvEpisodesService() {
        return (TvEpisodesService)this.getRetrofit().create(TvEpisodesService.class);
    }

    TvEpisodeGroupsService tvEpisodeGroupsService() {
        return (TvEpisodeGroupsService)this.getRetrofit().create(TvEpisodeGroupsService.class);
    }
}

