/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.trakt;

import com.uwetrottmann.trakt5.entities.CastMember;
import com.uwetrottmann.trakt5.entities.Credits;
import com.uwetrottmann.trakt5.entities.CrewMember;
import com.uwetrottmann.trakt5.entities.Episode;
import com.uwetrottmann.trakt5.entities.SearchResult;
import com.uwetrottmann.trakt5.entities.Season;
import com.uwetrottmann.trakt5.entities.Show;
import com.uwetrottmann.trakt5.entities.Translation;
import com.uwetrottmann.trakt5.enums.Extended;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMediaIdProvider;
import org.tinymediamanager.scraper.interfaces.IRatingProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowImdbMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.tmdb.TmdbTvShowArtworkProvider;
import org.tinymediamanager.scraper.trakt.TraktMetadataProvider;
import org.tinymediamanager.scraper.trakt.TraktUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.TvUtils;

public class TraktTvShowMetadataProvider
extends TraktMetadataProvider
implements ITvShowMetadataProvider,
ITvShowImdbMetadataProvider,
IRatingProvider,
IMediaIdProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraktTvShowMetadataProvider.class);

    @Override
    protected String getSubId() {
        return "tvshow";
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public SortedSet<MediaSearchResult> search(@NotNull TvShowSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("search() - {}", (Object)options);
        this.initAPI();
        String searchString = "";
        if (StringUtils.isNotEmpty((CharSequence)options.getSearchQuery())) {
            searchString = options.getSearchQuery();
        }
        TreeSet<MediaSearchResult> results = new TreeSet<MediaSearchResult>();
        List searchResults = null;
        String id = options.getIdAsString("trakt");
        if (id != null) {
            try {
                MediaMetadata md = this.getMetadata(options);
                MediaSearchResult msr = new MediaSearchResult(id, options.getMediaType());
                msr.mergeFrom(md);
                results.add(msr);
                return results;
            }
            catch (Exception e) {
                LOGGER.error("Problem scraping for {} - {}", (Object)searchString, (Object)e.getMessage());
            }
        }
        try {
            searchResults = (List)this.executeCall(this.api.search().textQueryShow(searchString, null, null, null, null, null, null, null, null, null, Extended.FULL, Integer.valueOf(1), Integer.valueOf(25)));
        }
        catch (Exception e) {
            LOGGER.debug("failed to search: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (searchResults == null || searchResults.isEmpty()) {
            LOGGER.info("nothing found");
            return results;
        }
        for (SearchResult result : searchResults) {
            MediaSearchResult m = TraktUtils.morphTraktResultToTmmResult(options, result);
            if (StringUtils.isNotBlank((CharSequence)options.getImdbId()) && options.getImdbId().equals(m.getIMDBId()) || String.valueOf(options.getTmdbId()).equals(m.getId()) || id != null && id.equals(m.getId())) {
                LOGGER.debug("perfect match by ID - set score to 1");
                m.setScore(1.0f);
            } else {
                m.calculateScore(options);
            }
            results.add(m);
        }
        return results;
    }

    @Override
    public List<MediaMetadata> getEpisodeList(@NotNull TvShowSearchAndScrapeOptions options) throws ScrapeException {
        List seasons;
        LOGGER.debug("getEpisodeList(): {}", (Object)options);
        this.initAPI();
        ArrayList<MediaMetadata> episodes = new ArrayList<MediaMetadata>();
        String id = options.getIdAsString(this.getId());
        if (StringUtils.isBlank((CharSequence)id)) {
            id = options.getIdAsString("imdb");
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            LOGGER.warn("no id available");
            throw new MissingIdException("imdb", this.getId());
        }
        try {
            seasons = (List)this.executeCall(this.api.seasons().summary(id, Extended.FULLEPISODES));
        }
        catch (Exception e) {
            LOGGER.debug("failed to get episode list: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        for (Season season : ListUtils.nullSafe(seasons)) {
            for (Episode episode : ListUtils.nullSafe(season.episodes)) {
                MediaMetadata ep = new MediaMetadata(this.getId());
                ep.setScrapeOptions(options);
                ep.setEpisodeNumber(MediaEpisodeGroup.DEFAULT_AIRED, TvUtils.getSeasonNumber(episode.season), TvUtils.getEpisodeNumber(episode.number));
                ep.setTitle(episode.title);
                if (episode.rating != null && episode.votes != null) {
                    MediaRating rating = new MediaRating(this.getId());
                    rating.setRating((double)Math.round(episode.rating * 10.0) / 10.0);
                    rating.setVotes(episode.votes);
                    rating.setMaxValue(10);
                    ep.addRating(rating);
                }
                if (episode.first_aired != null) {
                    ep.setReleaseDate(TraktUtils.toDate(episode.first_aired));
                }
                if (episode.ids != null) {
                    ep.setId(this.getId(), episode.ids.trakt);
                    if (episode.ids.tvdb != null && episode.ids.tvdb > 0) {
                        ep.setId("tvdb", episode.ids.tvdb);
                    }
                    if (episode.ids.tmdb != null && episode.ids.tmdb > 0) {
                        ep.setId("tmdb", episode.ids.tmdb);
                    }
                    if (episode.ids.tvrage != null && episode.ids.tvrage > 0) {
                        ep.setId("tvrage", episode.ids.tvrage);
                    }
                    if (StringUtils.isNotBlank((CharSequence)episode.ids.imdb)) {
                        ep.setId("imdb", episode.ids.imdb);
                    }
                }
                episodes.add(ep);
            }
        }
        return episodes;
    }

    @Override
    public MediaMetadata getMetadata(@NotNull TvShowSearchAndScrapeOptions options) throws ScrapeException {
        TmdbTvShowArtworkProvider tmdb;
        Translation trans;
        Credits credits;
        Show show;
        LOGGER.debug("getMetadata(): {}", (Object)options);
        this.initAPI();
        MediaMetadata md = new MediaMetadata(this.getId());
        md.setScrapeOptions(options);
        String id = options.getIdAsString(this.getId());
        if (StringUtils.isBlank((CharSequence)id)) {
            id = options.getIdAsString("imdb");
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            LOGGER.warn("no id available");
            throw new MissingIdException("imdb", this.getId());
        }
        String lang = options.getLanguage().getLanguage();
        List translations = null;
        try {
            show = (Show)this.executeCall(this.api.shows().summary(id, Extended.FULL));
            if (!"en".equals(lang)) {
                translations = (List)this.api.shows().translation(id, lang).execute().body();
            }
            credits = (Credits)this.api.shows().people(id).execute().body();
        }
        catch (Exception e) {
            LOGGER.debug("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (show == null) {
            LOGGER.warn("nothing found");
            throw new NothingFoundException();
        }
        if (show.ids != null) {
            md.setId(this.getId(), show.ids.trakt);
            if (show.ids.tvdb != null && show.ids.tvdb > 0) {
                md.setId("tvdb", show.ids.tvdb);
            }
            if (show.ids.tmdb != null && show.ids.tmdb > 0) {
                md.setId("tmdb", show.ids.tmdb);
            }
            if (show.ids.tvrage != null && show.ids.tvrage > 0) {
                md.setId("tvrage", show.ids.tvrage);
            }
            if (MediaIdUtil.isValidImdbId(show.ids.imdb)) {
                md.setId("imdb", show.ids.imdb);
            }
        }
        md.addEpisodeGroup(MediaEpisodeGroup.DEFAULT_AIRED);
        Translation translation = trans = translations == null || translations.isEmpty() ? null : (Translation)translations.get(0);
        if (trans != null) {
            md.setTitle(StringUtils.isBlank((CharSequence)trans.title) ? show.title : trans.title);
            md.setPlot(StringUtils.isBlank((CharSequence)trans.overview) ? show.overview : trans.overview);
        } else {
            md.setTitle(show.title);
            md.setPlot(show.overview);
        }
        md.setYear(show.year);
        if (show.rating != null && show.votes != null) {
            Iterator<CastMember> rating = new MediaRating("trakt");
            ((MediaRating)((Object)rating)).setRating(show.rating);
            ((MediaRating)((Object)rating)).setVotes(show.votes);
            ((MediaRating)((Object)rating)).setMaxValue(10);
            md.addRating((MediaRating)((Object)rating));
        }
        md.addCertification(MediaCertification.findCertification(show.certification));
        md.addCountry(show.country);
        md.setReleaseDate(TraktUtils.toDate(show.first_aired));
        if (show.status != null) {
            md.setStatus(show.status.toString());
        }
        md.setRuntime(show.runtime);
        md.addProductionCompany(show.network);
        for (String genreAsString : ListUtils.nullSafe(show.genres)) {
            md.addGenre(MediaGenres.getGenre(genreAsString));
        }
        if (credits != null) {
            for (CastMember cast : ListUtils.nullSafe(credits.cast)) {
                md.addCastMember(TraktUtils.toTmmCast(cast, Person.Type.ACTOR));
            }
            if (credits.crew != null) {
                for (CrewMember crew : ListUtils.nullSafe(credits.crew.directing)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, Person.Type.DIRECTOR));
                }
                for (CrewMember crew : ListUtils.nullSafe(credits.crew.production)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, Person.Type.PRODUCER));
                }
                for (CrewMember crew : ListUtils.nullSafe(credits.crew.writing)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, Person.Type.WRITER));
                }
            }
        }
        if ((tmdb = new TmdbTvShowArtworkProvider()).isActive() && (MediaIdUtil.isValidImdbId(show.ids.imdb) || show.ids.tmdb > 0)) {
            try {
                ArtworkSearchAndScrapeOptions tmdbOptions = new ArtworkSearchAndScrapeOptions(options.getMediaType());
                tmdbOptions.setImdbId(show.ids.imdb);
                tmdbOptions.setTmdbId(show.ids.tmdb);
                tmdbOptions.setLanguage(options.getLanguage());
                tmdbOptions.setArtworkType(MediaArtwork.MediaArtworkType.POSTER);
                List<MediaArtwork> artworks = tmdb.getArtwork(tmdbOptions);
                if (ListUtils.isNotEmpty(artworks)) {
                    md.addMediaArt(artworks.get(0));
                }
            }
            catch (Exception e) {
                LOGGER.warn("Could not get artwork from tmdb - {}", (Object)e.getMessage());
            }
        }
        return md;
    }

    @Override
    public MediaMetadata getMetadata(TvShowEpisodeSearchAndScrapeOptions options) throws ScrapeException {
        List seasons;
        LOGGER.debug("getMetadata(): {}", (Object)options);
        this.initAPI();
        MediaMetadata md = new MediaMetadata(this.getId());
        md.setScrapeOptions(options);
        TvShowSearchAndScrapeOptions tvShowSearchAndScrapeOptions = options.createTvShowSearchAndScrapeOptions();
        String showId = tvShowSearchAndScrapeOptions.getIdAsString(this.getId());
        if (StringUtils.isBlank((CharSequence)showId)) {
            showId = tvShowSearchAndScrapeOptions.getIdAsString("imdb");
        }
        if (StringUtils.isBlank((CharSequence)showId)) {
            LOGGER.warn("no id available");
            throw new MissingIdException("imdb", this.getId());
        }
        String episodeImdbId = options.getIdAsString("imdb");
        if (!MediaIdUtil.isValidImdbId(episodeImdbId)) {
            episodeImdbId = "";
        }
        int episodeTmdbId = options.getIdAsIntOrDefault("tmdb", 0);
        int episodeTvdbId = options.getIdAsIntOrDefault("tvdb", 0);
        int episodeTraktId = options.getIdAsIntOrDefault(this.getId(), 0);
        int seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
        int episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
        String aired = "";
        if (options.getMetadata() != null && options.getMetadata().getReleaseDate() != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            aired = formatter.format((Object)options.getMetadata().getReleaseDate());
        }
        if (aired.isEmpty() && (seasonNr == -1 || episodeNr == -1) && StringUtils.isBlank((CharSequence)episodeImdbId) && episodeTmdbId == 0 && episodeTvdbId == 0 && episodeTraktId == 0) {
            throw new MissingIdException("seasonNr", "episodeNr");
        }
        Episode episode = null;
        try {
            seasons = (List)this.executeCall(this.api.seasons().summary(showId, Extended.FULLEPISODES));
        }
        catch (Exception e) {
            LOGGER.debug("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        block2: for (Season season : ListUtils.nullSafe(seasons)) {
            for (Episode ep : ListUtils.nullSafe(season.episodes)) {
                if (ep.ids != null) {
                    if (StringUtils.isNotBlank((CharSequence)episodeImdbId) && episodeImdbId.equals(ep.ids.imdb)) {
                        episode = ep;
                        continue block2;
                    }
                    if (episodeTraktId != 0 && episodeTraktId == MetadataUtil.unboxInteger(ep.ids.trakt)) {
                        episode = ep;
                        continue block2;
                    }
                    if (episodeTmdbId != 0 && episodeTmdbId == MetadataUtil.unboxInteger(ep.ids.tmdb)) {
                        episode = ep;
                        continue block2;
                    }
                    if (episodeTvdbId != 0 && episodeTvdbId == MetadataUtil.unboxInteger(ep.ids.tvdb)) {
                        episode = ep;
                        continue block2;
                    }
                }
                if (MetadataUtil.unboxInteger(ep.season, -1) != seasonNr || MetadataUtil.unboxInteger(ep.number, -1) != episodeNr) continue;
                episode = ep;
                continue block2;
            }
        }
        if (episode == null && !aired.isEmpty()) {
            block4: for (Season season : ListUtils.nullSafe(seasons)) {
                for (Episode ep : ListUtils.nullSafe(season.episodes)) {
                    SimpleDateFormat formatter;
                    String epAired;
                    if (ep.first_aired == null || !(epAired = (formatter = new SimpleDateFormat("yyyy-MM-dd")).format((Object)TraktUtils.toDate(ep.first_aired))).equals(aired)) continue;
                    episode = ep;
                    continue block4;
                }
            }
        }
        if (episode == null) {
            LOGGER.warn("nothing found");
            throw new NothingFoundException();
        }
        md.setEpisodeNumber(MediaEpisodeGroup.DEFAULT_AIRED, TvUtils.getSeasonNumber(episode.season), TvUtils.getEpisodeNumber(episode.number));
        md.setEpisodeNumber(MediaEpisodeGroup.DEFAULT_ABSOLUTE, 1, TvUtils.getEpisodeNumber(episode.number_abs));
        if (episode.ids != null) {
            md.setId("trakt", episode.ids.trakt);
            if (episode.ids.tvdb != null && episode.ids.tvdb > 0) {
                md.setId("tvdb", episode.ids.tvdb);
            }
            if (episode.ids.tmdb != null && episode.ids.tmdb > 0) {
                md.setId("tmdb", episode.ids.tmdb);
            }
            if (MediaIdUtil.isValidImdbId(episode.ids.imdb)) {
                md.setId("imdb", episode.ids.imdb);
            }
            if (episode.ids.tvrage != null && episode.ids.tvrage > 0) {
                md.setId("tvrage", episode.ids.tvrage);
            }
        }
        md.setTitle(episode.title);
        md.setPlot(episode.overview);
        if (episode.rating != null && episode.votes != null) {
            MediaRating rating = new MediaRating("trakt");
            rating.setRating(episode.rating);
            rating.setVotes(episode.votes);
            rating.setMaxValue(10);
            md.addRating(rating);
        }
        md.setReleaseDate(TraktUtils.toDate(episode.first_aired));
        return md;
    }

    private Episode findEpisodeById(Map<String, Object> ids) throws ScrapeException {
        List seasons;
        HashMap<String, Object> showIds = new HashMap<String, Object>();
        String showId = "";
        try {
            showIds.putAll((Map)ids.get("tvShowIds"));
            showId = MediaIdUtil.getIdAsString(showIds, this.getId());
            if (StringUtils.isBlank((CharSequence)showId)) {
                showId = MediaIdUtil.getIdAsString(showIds, "imdb");
            }
        }
        catch (Exception e) {
            LOGGER.debug("could not get TV show ids - '{}'", (Object)e.getMessage());
        }
        if (StringUtils.isBlank((CharSequence)showId)) {
            LOGGER.debug("no show id available");
            throw new MissingIdException("imdb", this.getId());
        }
        String episodeImdbId = MediaIdUtil.getIdAsString(ids, "imdb");
        if (!MediaIdUtil.isValidImdbId(episodeImdbId)) {
            episodeImdbId = "";
        }
        int episodeTmdbId = MediaIdUtil.getIdAsInt(ids, "tmdb");
        int episodeTvdbId = MediaIdUtil.getIdAsInt(ids, "tvdb");
        int episodeTraktId = MediaIdUtil.getIdAsInt(ids, this.getId());
        int seasonNr = MediaIdUtil.getIdAsIntOrDefault(ids, "seasonNr", -1);
        int episodeNr = MediaIdUtil.getIdAsIntOrDefault(ids, "episodeNr", -1);
        Episode episode = null;
        try {
            seasons = (List)this.executeCall(this.api.seasons().summary(showId, Extended.FULLEPISODES));
        }
        catch (Exception e) {
            LOGGER.debug("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        for (Season season : ListUtils.nullSafe(seasons)) {
            for (Episode ep : ListUtils.nullSafe(season.episodes)) {
                if (ep.ids != null) {
                    if (StringUtils.isNotBlank((CharSequence)episodeImdbId) && episodeImdbId.equals(ep.ids.imdb)) {
                        episode = ep;
                        break;
                    }
                    if (episodeTraktId != 0 && episodeTraktId == MetadataUtil.unboxInteger(ep.ids.trakt)) {
                        episode = ep;
                        break;
                    }
                    if (episodeTmdbId != 0 && episodeTmdbId == MetadataUtil.unboxInteger(ep.ids.tmdb)) {
                        episode = ep;
                        break;
                    }
                    if (episodeTvdbId != 0 && episodeTvdbId == MetadataUtil.unboxInteger(ep.ids.tvdb)) {
                        episode = ep;
                        break;
                    }
                }
                if (MetadataUtil.unboxInteger(ep.season, -1) != seasonNr || MetadataUtil.unboxInteger(ep.number, -1) != episodeNr) continue;
                episode = ep;
                break;
            }
            if (episode == null) continue;
            break;
        }
        return episode;
    }

    @Override
    public List<MediaRating> getRatings(Map<String, Object> ids, MediaType mediaType) throws ScrapeException {
        if (mediaType == MediaType.TV_SHOW) {
            return this.getTvShowRatings(ids);
        }
        if (mediaType == MediaType.TV_EPISODE) {
            return this.getEpisodeRatings(ids);
        }
        return Collections.emptyList();
    }

    private List<MediaRating> getTvShowRatings(Map<String, Object> ids) throws ScrapeException {
        Show show;
        LOGGER.debug("getRatings(): {}", ids);
        this.initAPI();
        String id = MediaIdUtil.getIdAsString(ids, this.getId());
        if (StringUtils.isBlank((CharSequence)id)) {
            id = MediaIdUtil.getIdAsString(ids, "imdb");
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            LOGGER.debug("no id available");
            throw new MissingIdException("imdb", this.getId());
        }
        try {
            show = (Show)this.executeCall(this.api.shows().summary(id, Extended.FULL));
        }
        catch (Exception e) {
            LOGGER.debug("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (show == null) {
            LOGGER.debug("nothing found");
            throw new NothingFoundException();
        }
        if (show.rating != null && show.votes != null) {
            MediaRating rating = new MediaRating(this.getId());
            rating.setRating(show.rating);
            rating.setVotes(show.votes);
            rating.setMaxValue(10);
            return Collections.singletonList(rating);
        }
        return Collections.emptyList();
    }

    private List<MediaRating> getEpisodeRatings(Map<String, Object> ids) throws ScrapeException {
        LOGGER.debug("getRatings(): {}", ids);
        this.initAPI();
        Episode episode = this.findEpisodeById(ids);
        if (episode == null) {
            LOGGER.warn("nothing found");
            throw new NothingFoundException();
        }
        if (episode.rating != null && episode.votes != null) {
            MediaRating rating = new MediaRating(this.getId());
            rating.setRating(episode.rating);
            rating.setVotes(episode.votes);
            rating.setMaxValue(10);
            return Collections.singletonList(rating);
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, Object> getMediaIds(Map<String, Object> ids, MediaType mediaType) throws ScrapeException {
        if (mediaType == MediaType.TV_SHOW) {
            return this.getTvShowIds(ids);
        }
        if (mediaType == MediaType.TV_EPISODE) {
            return this.getEpisodeIds(ids);
        }
        return Collections.emptyMap();
    }

    private Map<String, Object> getTvShowIds(Map<String, Object> ids) throws ScrapeException {
        Show show;
        LOGGER.debug("getTvShowIds(): {}", ids);
        this.initAPI();
        String id = MediaIdUtil.getIdAsString(ids, this.getId());
        if (StringUtils.isBlank((CharSequence)id)) {
            id = MediaIdUtil.getIdAsString(ids, "imdb");
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            LOGGER.debug("no id available");
            throw new MissingIdException("imdb", this.getId());
        }
        try {
            show = (Show)this.executeCall(this.api.shows().summary(id, Extended.FULL));
        }
        catch (Exception e) {
            LOGGER.debug("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (show == null) {
            LOGGER.debug("nothing found");
            throw new NothingFoundException();
        }
        HashMap<String, Object> scrapedIds = new HashMap<String, Object>();
        if (show.ids != null) {
            scrapedIds.put("trakt", show.ids.trakt);
            if (show.ids.tvdb != null && show.ids.tvdb > 0) {
                scrapedIds.put("tvdb", show.ids.tvdb);
            }
            if (show.ids.tmdb != null && show.ids.tmdb > 0) {
                scrapedIds.put("tmdb", show.ids.tmdb);
            }
            if (show.ids.tvrage != null && show.ids.tvrage > 0) {
                scrapedIds.put("tvrage", show.ids.tvrage);
            }
            if (MediaIdUtil.isValidImdbId(show.ids.imdb)) {
                scrapedIds.put("imdb", show.ids.imdb);
            }
        }
        return scrapedIds;
    }

    private Map<String, Object> getEpisodeIds(Map<String, Object> ids) throws ScrapeException {
        LOGGER.debug("getRatings(): {}", ids);
        this.initAPI();
        Episode episode = this.findEpisodeById(ids);
        if (episode == null) {
            LOGGER.warn("nothing found");
            throw new NothingFoundException();
        }
        HashMap<String, Object> scrapedIds = new HashMap<String, Object>();
        if (episode.ids != null) {
            scrapedIds.put(this.getId(), episode.ids.trakt);
            if (episode.ids.tvdb != null && episode.ids.tvdb > 0) {
                scrapedIds.put("tvdb", episode.ids.tvdb);
            }
            if (episode.ids.tmdb != null && episode.ids.tmdb > 0) {
                scrapedIds.put("tmdb", episode.ids.tmdb);
            }
            if (MediaIdUtil.isValidImdbId(episode.ids.imdb)) {
                scrapedIds.put("imdb", episode.ids.imdb);
            }
            if (episode.ids.tvrage != null && episode.ids.tvrage > 0) {
                scrapedIds.put("tvrage", episode.ids.tvrage);
            }
        }
        return scrapedIds;
    }
}

