/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tvmaze.service;

import java.io.IOException;
import javax.annotation.Nonnull;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.tinymediamanager.scraper.tvmaze.service.Controller;

public class TvMazeInterceptor
implements Interceptor {
    private final Controller controller;

    public TvMazeInterceptor(Controller tmdbController) {
        this.controller = tmdbController;
    }

    public Response intercept(@Nonnull Interceptor.Chain chain) throws IOException {
        return TvMazeInterceptor.handleIntercept(chain, this.controller);
    }

    public static Response handleIntercept(Interceptor.Chain chain, Controller controller) throws IOException {
        String retryHeader;
        Request request = chain.request();
        Response response = chain.proceed(request);
        if (!response.isSuccessful() && (retryHeader = response.header("Retry-After")) != null) {
            try {
                int retry = Integer.parseInt(retryHeader);
                Thread.sleep((int)(((double)retry + 0.5) * 1000.0));
                if (response.body() != null) {
                    response.body().close();
                }
                return TvMazeInterceptor.handleIntercept(chain, controller);
            }
            catch (InterruptedException | NumberFormatException exception) {
                // empty catch block
            }
        }
        return response;
    }
}

