/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.Pair;
import org.tinymediamanager.scraper.util.StrgUtils;

public class ParserUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParserUtils.class);
    private static final String DELIMITER = "[\\[\\](){} _,.-]";
    protected static final String[] HARD_STOPWORDS = new String[]{"1080", "1080i", "1080p", "2160p", "2160i", "3d", "480i", "480p", "576i", "576p", "360p", "10bit", "12bit", "360i", "720", "720i", "720p", "8bit", "ac3", "ac3ld", "ac3d", "ac3md", "amzn", "aoe", "atmos", "avc", "bd5", "bdrip", "bdrip", "blueray", "bluray", "brrip", "cam", "cd1", "cd2", "cd3", "cd4", "cd5", "cd6", "cd7", "cd8", "cd9", "dd20", "dd51", "disc1", "disc2", "disc3", "disc4", "disc5", "disc6", "disc7", "disc8", "disc9", "divx", "divx5", "dl", "dsr", "dsrip", "dts", "dtv", "dubbed", "dvd", "dvd1", "dvd2", "dvd3", "dvd4", "dvd5", "dvd6", "dvd7", "dvd8", "dvd9", "dvdivx", "dvdrip", "dvdscr", "dvdscreener", "emule", "etm", "fs", "fps", "h264", "h265", "hd", "hddvd", "hdr", "hdr10", "hdr10+", "hdrip", "hdtv", "hdtvrip", "hevc", "hrhd", "hrhdtv", "ind", "ituneshd", "ld", "md", "microhd", "multisubs", "mp3", "netflixhd", "nfo", "nfofix", "ntg", "ntsc", "ogg", "ogm", "pal", "pdtv", "pso", "r3", "r5", "remastered", "repack", "rerip", "remux", "roor", "rs", "rsvcd", "screener", "sd", "subbed", "subs", "svcd", "tc", "telecine", "telesync", "ts", "truehd", "uhd", "uncut", "unrated", "vcf", "vhs", "vhsrip", "webdl", "webrip", "workprint", "ws", "x264", "x265", "xf", "xvid", "xvidvd", "4k"};
    protected static final String[] SOFT_STOPWORDS = new String[]{"complete", "custom", "dc", "docu", "doku", "extended", "fragment", "internal", "limited", "local", "ma", "multi", "pal", "proper", "read", "retail", "se", "www", "xxx"};
    protected static final String[] CLEANWORDS = new String[]{"24\\.000", "23\\.976", "23\\.98", "24\\.00", "web\\-dl", "web\\-rip", "blue\\-ray", "blu\\-ray", "dvd\\-rip"};
    protected static final Pattern TMDB_ID_PATTERN = Pattern.compile("(tmdbid|tmdb)[ ._-]?(\\d+)", 2);
    protected static final Pattern TVDB_ID_PATTERN = Pattern.compile("(tvdbid|tvdb)[ ._-]?(\\d+)", 2);

    private ParserUtils() {
        throw new IllegalAccessError();
    }

    public static String[] detectCleanTitleAndYear(String filename, List<String> badWords) {
        int start;
        String[] s;
        String[] ret = new String[]{"", ""};
        LOGGER.trace("Parse filename for title: \"{}\"", (Object)filename);
        if (filename == null || filename.isEmpty()) {
            LOGGER.warn("Filename empty?!");
            return ret;
        }
        String fname = filename.replaceFirst("\\.\\w{2,4}$", "");
        fname = fname.replaceFirst("(?i)([\\[\\](){} _,.-])\\d{3,4}x\\d{3,4}([\\[\\](){} _,.-]|$)", "$1");
        for (String cw : CLEANWORDS) {
            fname = fname.replaceFirst("(?i)([\\[\\](){} _,.-])" + cw, "$1");
        }
        LOGGER.trace("--------------------");
        LOGGER.trace("IN: {} ", (Object)fname);
        String savedFname = fname;
        for (String badword : badWords) {
            fname = fname.replaceAll("(?i)" + badword, "");
        }
        if (StringUtils.isBlank((CharSequence)fname)) {
            fname = savedFname;
        }
        ArrayList<String> opt = new ArrayList<String>();
        Pattern p = Pattern.compile("\\[(.*?)\\]");
        Matcher m = p.matcher(fname);
        while (m.find()) {
            LOGGER.trace("OPT: {}", (Object)m.group(1));
            String[] o = StringUtils.split((String)m.group(1), (String)DELIMITER);
            opt.addAll(Arrays.asList(o));
            fname = fname.replace(m.group(), "");
        }
        LOGGER.trace("ARR: {}", opt);
        p = Pattern.compile(".*?(_\\d{2}\\.\\d{2}\\.\\d{2}[_ ]+\\d{2}\\-\\d{2}\\_).*");
        m = p.matcher(fname);
        if (m.matches() && m.start(1) > 10) {
            LOGGER.trace("OTR: {}", (Object)m.group(1));
            fname = fname.substring(0, m.start(1));
        }
        if ((s = StringUtils.split((String)fname, (String)DELIMITER)).length == 0) {
            s = opt.toArray(new String[opt.size()]);
        }
        int firstFoundStopwordPosition = s.length;
        for (int i = 0; i < s.length; ++i) {
            for (String stop : HARD_STOPWORDS) {
                if (!s[i].equalsIgnoreCase(stop)) continue;
                s[i] = "";
                if (i >= firstFoundStopwordPosition || i < 2) continue;
                firstFoundStopwordPosition = i;
            }
            if (!MediaIdUtil.isValidImdbId(s[i])) continue;
            s[i] = "";
        }
        int yearPosition = -1;
        int currentYear = Calendar.getInstance().get(1);
        String year = "";
        for (int i = s.length - 1; i > 0; --i) {
            int parsedYear;
            if (!s[i].matches("\\d{4}") || (parsedYear = Integer.parseInt(s[i])) <= 1800 || parsedYear >= currentYear + 5) continue;
            LOGGER.trace("removed token '{}'- seems to be year", (Object)s[i]);
            year = s[i];
            s[i] = "";
            yearPosition = i;
            break;
        }
        if (year.isEmpty()) {
            for (String o : opt) {
                int parsedYear;
                if (!o.matches("\\d{4}") || (parsedYear = Integer.parseInt(o)) <= 1800 || parsedYear >= currentYear + 5) continue;
                year = String.valueOf(parsedYear);
                LOGGER.trace("found possible year: {}", (Object)o);
            }
        }
        for (int i = start = yearPosition > 0 ? yearPosition : 0; i < s.length; ++i) {
            for (String stop : SOFT_STOPWORDS) {
                if (!s[i].equalsIgnoreCase(stop)) continue;
                s[i] = "";
                if (i >= firstFoundStopwordPosition || i < 2) continue;
                firstFoundStopwordPosition = i;
            }
            if (!MediaIdUtil.isValidImdbId(s[i])) continue;
            s[i] = "";
        }
        StringBuilder name = new StringBuilder();
        int end = firstFoundStopwordPosition;
        if (yearPosition > 0) {
            end = Math.min(firstFoundStopwordPosition, yearPosition);
        }
        block24: for (int i = 0; i < end; ++i) {
            if (s[i].isEmpty()) continue;
            String lc = s[i].toLowerCase(Locale.ROOT);
            for (String badword : badWords) {
                if (!lc.matches(badword)) continue;
            }
            String word = s[i];
            switch (word.toUpperCase(Locale.ROOT)) {
                case "I": 
                case "II": 
                case "III": 
                case "IV": 
                case "V": 
                case "VI": 
                case "VII": 
                case "VIII": 
                case "IX": 
                case "X": {
                    name.append(word.toUpperCase(Locale.ROOT)).append(" ");
                    continue block24;
                }
                default: {
                    name.append(word).append(" ");
                }
            }
        }
        ret[0] = name.length() == 0 ? fname : name.toString().strip();
        ret[1] = year.strip();
        LOGGER.trace("Movie title should be: \"{}\", from {}", (Object)ret[0], (Object)ret[1]);
        return ret;
    }

    public static String detectImdbId(String text) {
        Object imdb = "";
        if (StringUtils.isNotBlank((CharSequence)text) && ((String)(imdb = StrgUtils.substr(text, "(tt\\d{6,})"))).isEmpty() && !((String)(imdb = StrgUtils.substr(text, "imdb\\.com\\/Title\\?(\\d{6,})"))).isEmpty()) {
            imdb = "tt" + (String)imdb;
        }
        return imdb;
    }

    public static int detectTmdbId(String text) {
        int tmdbId = 0;
        if (StringUtils.isNotBlank((CharSequence)text)) {
            Matcher matcher = TMDB_ID_PATTERN.matcher(text);
            if (matcher.find() && matcher.groupCount() >= 2) {
                try {
                    tmdbId = Integer.parseInt(matcher.group(2));
                }
                catch (Exception e) {
                    LOGGER.trace("Could not parse TMDB id - '{}'", (Object)e.getMessage());
                }
            } else {
                tmdbId = MetadataUtil.parseInt(StrgUtils.substr(text, "themoviedb\\.org\\/(?:movie|tv)\\/(\\d+)"), 0);
            }
        }
        return tmdbId;
    }

    public static String detectTvdbId(String text) {
        String tvdbId = "";
        if (StringUtils.isNotBlank((CharSequence)text)) {
            Matcher matcher = TVDB_ID_PATTERN.matcher(text);
            tvdbId = matcher.find() && matcher.groupCount() >= 2 ? matcher.group(2) : StrgUtils.substr(text, "thetvdb\\.com\\/(?:movies|series)\\/(\\d+)");
        }
        return tvdbId;
    }

    public static String removeStopwordsAndBadwordsFromTvEpisodeName(String filename) {
        String before;
        String extension = FilenameUtils.getExtension((String)filename);
        String basename = before = filename.replaceFirst("(?i)\\." + Pattern.quote(extension) + "$", "");
        basename = basename.replaceFirst("(?i)([\\[\\](){} _,.-])\\d{3,4}x\\d{3,4}([\\[\\](){} _,.-]|$)", "$1");
        for (String s : HARD_STOPWORDS) {
            basename = basename.replaceAll("(?i)([\\[\\](){} _,.-])" + s + "([\\[\\](){} _,.-]|$)", "$1");
            if (!LOGGER.isTraceEnabled() || basename.length() == before.length()) continue;
            LOGGER.trace("Removed some TV stopword (" + s + "): " + before + " -> " + basename);
            before = basename;
        }
        for (String s : TvShowModuleManager.getInstance().getSettings().getBadWord()) {
            basename = basename.replaceAll("(?i)([\\[\\](){} _,.-])" + s + "([\\[\\](){} _,.-]|$)", "$1");
            if (!LOGGER.isTraceEnabled() || basename.length() == before.length()) continue;
            LOGGER.trace("Removed some TV bad word (" + s + "): " + before + " -> " + basename);
            before = basename;
        }
        return basename + (String)(extension.isBlank() ? "" : "." + extension);
    }

    public static String[] parseTitle(String title) {
        String[] v = new String[]{"", ""};
        if (title == null) {
            return v;
        }
        Pattern p = Pattern.compile("(.*)\\s+\\(?([0-9]{4})\\)?", 2);
        Matcher m = p.matcher(title);
        if (m.find()) {
            v[0] = m.group(1);
            v[1] = m.group(2);
        } else {
            v[0] = title;
        }
        return v;
    }

    public static Pair<String, String> parseTitleAndDateInBrackets(String title) {
        if (title == null) {
            return new Pair<Object, Object>(null, null);
        }
        Pattern p = Pattern.compile("(.*)\\s+\\(?([0-9]{4})\\)?", 2);
        Matcher m = p.matcher(title);
        if (m.find()) {
            return new Pair<String, String>(m.group(1), m.group(2));
        }
        return new Pair<String, Object>(title, null);
    }

    public static ParserInfo getCleanerString(List<String> badWords, String ... names) {
        ArrayList<ParserInfo> info = new ArrayList<ParserInfo>(1);
        ParserInfo ret = null;
        int rate = -10000;
        for (String s : names) {
            info.add(new ParserInfo(s, badWords));
        }
        for (ParserInfo i : info) {
            int tmp = ParserUtils.rateCleanness(i);
            if (tmp <= rate) continue;
            ret = i;
            rate = tmp;
        }
        return ret;
    }

    public static int rateCleanness(ParserInfo info) {
        if (info.clean.isEmpty()) {
            return -1;
        }
        int words = info.clean.split(" ").length;
        int seps = info.clean.split("[_.-]").length - 1;
        int uc = info.clean.replaceAll("[^A-Z]", "").length();
        int lc = info.clean.replaceAll("[A-Z]", "").length();
        double cleaned = 100.0f - (float)info.clean.length() * 100.0f / (float)info.name.length();
        int cc = 0;
        Pattern pattern = Pattern.compile("[A-Z][a-z]");
        Matcher matcher = pattern.matcher(info.clean);
        while (matcher.find()) {
            ++cc;
        }
        int rate = cc * 20 + (10 - words * 2) * 2 + seps * -20 - info.clean.length() * 2 + (int)cleaned;
        if (!info.year.isEmpty()) {
            rate += 20;
        }
        LOGGER.trace(info + " - Rate:" + rate + "    PERC:" + cleaned + " LEN:" + info.clean.length() + " WRD:" + words + " UC:" + uc + " LC:" + lc + " CC:" + cc + " SEP:" + seps);
        return rate;
    }

    public static List<String> split(String source) {
        ArrayList<String> result = new ArrayList<String>();
        for (String string : source.split("[;,\\/|]")) {
            if (!StringUtils.isNotBlank((CharSequence)(string = string.strip()))) continue;
            result.add(string);
        }
        return result;
    }

    public static List<String> splitByPunctuation(String source) {
        ArrayList<String> result = new ArrayList<String>();
        for (String string : source.split("\\p{Punct}")) {
            if (!StringUtils.isNotBlank((CharSequence)(string = string.strip()))) continue;
            result.add(string);
        }
        return result;
    }

    public static class ParserInfo {
        public String name = "";
        public String year = "";
        public String clean = "";

        ParserInfo(String name, List<String> badWords) {
            this.name = name.strip();
            String[] ty = ParserUtils.detectCleanTitleAndYear(this.name, badWords);
            this.clean = ty[0];
            this.year = ty[1];
        }

        public String toString() {
            return this.clean + " (" + this.year + ")";
        }
    }
}

