/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.trakttv;

import com.uwetrottmann.trakt5.TraktV2;
import com.uwetrottmann.trakt5.TraktV2Interceptor;
import com.uwetrottmann.trakt5.entities.AccessToken;
import com.uwetrottmann.trakt5.entities.ListEntry;
import com.uwetrottmann.trakt5.entities.SyncErrors;
import com.uwetrottmann.trakt5.entities.SyncResponse;
import com.uwetrottmann.trakt5.entities.SyncStats;
import com.uwetrottmann.trakt5.entities.TraktError;
import com.uwetrottmann.trakt5.entities.TraktList;
import com.uwetrottmann.trakt5.entities.UserSlug;
import com.uwetrottmann.trakt5.enums.Audio;
import com.uwetrottmann.trakt5.enums.AudioChannels;
import com.uwetrottmann.trakt5.enums.Extended;
import com.uwetrottmann.trakt5.enums.Hdr;
import com.uwetrottmann.trakt5.enums.MediaType;
import com.uwetrottmann.trakt5.enums.Resolution;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaSource;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.license.TmmFeature;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.thirdparty.trakttv.TraktTvMovie;
import org.tinymediamanager.thirdparty.trakttv.TraktTvTvShow;
import retrofit2.Call;
import retrofit2.Response;

public class TraktTv
implements TmmFeature {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraktTv.class);
    private static TraktTv instance;
    private TraktV2 api;

    protected synchronized void initAPI() throws ScrapeException {
        if (this.api == null) {
            try {
                String[] keys = this.getApiKeys();
                this.api = new TraktV2(keys[0], keys[1], "urn:ietf:wg:oauth:2.0:oob"){

                    protected synchronized OkHttpClient okHttpClient() {
                        OkHttpClient.Builder builder = TmmHttpClient.newBuilder(true);
                        builder.addInterceptor((Interceptor)new TraktV2Interceptor((TraktV2)this));
                        return builder.build();
                    }
                };
            }
            catch (Exception e) {
                LOGGER.error("could not initialize the API: {}", (Object)e.getMessage());
                this.api = null;
                throw new ScrapeException(e);
            }
        }
    }

    public static synchronized TraktTv getInstance() {
        if (instance == null) {
            instance = new TraktTv();
        }
        return instance;
    }

    private TraktTv() {
    }

    public Map<String, String> authenticateViaPin(String pin) throws Exception {
        String refreshToken;
        String accessToken;
        this.initAPI();
        HashMap<String, String> result = new HashMap<String, String>();
        Response response = this.api.exchangeCodeForAccessToken(pin);
        if (response.isSuccessful() && response.body() != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken = ((AccessToken)response.body()).access_token, refreshToken = ((AccessToken)response.body()).refresh_token})) {
            result.put("accessToken", accessToken);
            result.put("refreshToken", refreshToken);
        }
        return result;
    }

    public void refreshAccessToken() throws Exception {
        if (StringUtils.isBlank((CharSequence)Settings.getInstance().getTraktRefreshToken())) {
            throw new IOException("no trakt.tv refresh token found");
        }
        this.initAPI();
        Response response = this.api.refreshToken(Settings.getInstance().getTraktRefreshToken()).refreshAccessToken(Settings.getInstance().getTraktRefreshToken());
        if (response.isSuccessful() && response.body() != null) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{((AccessToken)response.body()).access_token, ((AccessToken)response.body()).refresh_token})) {
                Settings.getInstance().setTraktAccessToken(((AccessToken)response.body()).access_token);
                Settings.getInstance().setTraktRefreshToken(((AccessToken)response.body()).refresh_token);
                this.api.accessToken(Settings.getInstance().getTraktAccessToken());
            }
        } else {
            throw new IOException("could not get trakt.tv refresh token (HTTP " + response.code() + " - " + response.message() + ")");
        }
    }

    private boolean isEnabled() {
        if (!this.isFeatureEnabled()) {
            LOGGER.warn("Trakt.tv feature not enabled!");
            return false;
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{Settings.getInstance().getTraktAccessToken(), Settings.getInstance().getTraktRefreshToken()})) {
            this.api.accessToken(Settings.getInstance().getTraktAccessToken());
            return true;
        }
        LOGGER.warn("Trakt.tv connection tokens empty - try reauthenticate in settings!");
        return false;
    }

    TraktV2 getApi() {
        return this.api;
    }

    private <T> T executeCall(Call<T> call) throws IOException {
        Response response = call.execute();
        if (!response.isSuccessful() && response.code() == 401) {
            this.api.refreshToken();
            response = call.execute();
        }
        if (!response.isSuccessful()) {
            String message = "Request failed: " + response.code() + " " + response.message();
            TraktError error = this.api.checkForTraktError(response);
            if (error != null && error.message != null) {
                message = message + " message: " + error.message;
            }
            throw new HttpException(response.code(), message);
        }
        Object body = response.body();
        if (body != null) {
            return (T)body;
        }
        throw new IOException("Body should not be null for successful response");
    }

    public void getPersonalLists() throws ScrapeException {
        this.initAPI();
        if (!this.isEnabled()) {
            return;
        }
        try {
            List lists = (List)this.executeCall(this.api.users().lists(UserSlug.ME));
            for (TraktList list : lists) {
                System.out.println(list.name);
                List details = (List)this.executeCall(this.api.users().listItems(UserSlug.ME, Integer.toString(list.ids.trakt), Extended.METADATA));
                for (ListEntry detail : details) {
                    System.out.println(detail.id);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("failed gettinguser lists: {}", (Object)e.getMessage());
            return;
        }
    }

    public void syncTraktMovieCollection(List<Movie> moviesInTmm) throws ScrapeException {
        this.initAPI();
        if (!this.isEnabled()) {
            return;
        }
        new TraktTvMovie(this).syncTraktMovieCollection(moviesInTmm);
    }

    public void syncTraktMovieWatched(List<Movie> moviesInTmm) throws ScrapeException {
        this.initAPI();
        if (!this.isEnabled()) {
            return;
        }
        new TraktTvMovie(this).syncTraktMovieWatched(moviesInTmm);
    }

    public void syncTraktMovieRating(List<Movie> moviesInTmm) throws ScrapeException {
        this.initAPI();
        if (!this.isEnabled()) {
            return;
        }
        new TraktTvMovie(this).syncTraktMovieRating(moviesInTmm);
    }

    public void removeFromTraktMovieCollection(List<Movie> moviesInTmm) throws ScrapeException {
        this.initAPI();
        if (!this.isEnabled()) {
            return;
        }
        new TraktTvMovie(this).removeFromTraktCollection(moviesInTmm);
    }

    public void removeFromTraktMovieWatched(List<Movie> moviesInTmm) throws ScrapeException {
        this.initAPI();
        if (!this.isEnabled()) {
            return;
        }
        new TraktTvMovie(this).removeFromTraktWatchedHistory(moviesInTmm);
    }

    void clearTraktMovies() throws Exception {
        this.initAPI();
        if (!this.isEnabled()) {
            return;
        }
        new TraktTvMovie(this).clearTraktMovies();
    }

    public void syncTraktTvShowCollection(List<TvShow> tvShowsInTmm) throws Exception {
        this.initAPI();
        if (!this.isEnabled()) {
            return;
        }
        new TraktTvTvShow(this).syncTraktTvShowCollection(tvShowsInTmm);
    }

    public void syncTraktTvShowWatched(List<TvShow> tvShowsInTmm) throws Exception {
        this.initAPI();
        if (!this.isEnabled()) {
            return;
        }
        new TraktTvTvShow(this).syncTraktTvShowWatched(tvShowsInTmm);
    }

    public void syncTraktTvShowRating(List<TvShow> tvShowsInTmm) throws Exception {
        this.initAPI();
        if (!this.isEnabled()) {
            return;
        }
        new TraktTvTvShow(this).syncTraktTvShowRating(tvShowsInTmm);
    }

    public void removeFromTraktTvShowCollection(List<TvShow> tvShowsInTmm) throws Exception {
        this.initAPI();
        if (!this.isEnabled()) {
            return;
        }
        new TraktTvTvShow(this).removeFromTraktCollection(tvShowsInTmm);
    }

    public void removeFromTraktTvShowWatched(List<TvShow> tvShowsInTmm) throws Exception {
        this.initAPI();
        if (!this.isEnabled()) {
            return;
        }
        new TraktTvTvShow(this).removeFromTraktWatched(tvShowsInTmm);
    }

    public void clearTraktTvShows() throws Exception {
        this.initAPI();
        if (!this.isEnabled()) {
            return;
        }
        new TraktTvTvShow(this).clearTraktTvShows();
    }

    static MediaType getMediaType(MediaSource mediaSource) {
        if (mediaSource == MediaSource.BLURAY || mediaSource == MediaSource.UHD_BLURAY) {
            return MediaType.BLURAY;
        }
        if (mediaSource == MediaSource.DVD || mediaSource == MediaSource.DVDSCR) {
            return MediaType.DVD;
        }
        if (mediaSource == MediaSource.HDDVD) {
            return MediaType.HDDVD;
        }
        if (mediaSource == MediaSource.VHS || mediaSource == MediaSource.D_VHS) {
            return MediaType.VHS;
        }
        if (mediaSource == MediaSource.LASERDISC) {
            return MediaType.LASERDISC;
        }
        return MediaType.DIGITAL;
    }

    static Resolution getResolution(MediaFile mediaFile) {
        switch (mediaFile.getVideoFormat()) {
            case "4320p": 
            case "2160p": {
                return Resolution.UHD_4K;
            }
            case "1440p": 
            case "1080p": {
                return Resolution.HD_1080P;
            }
            case "720p": {
                return Resolution.HD_720P;
            }
            case "576p": 
            case "540p": {
                return Resolution.SD_576P;
            }
            case "480p": 
            case "360p": {
                return Resolution.SD_480P;
            }
        }
        return null;
    }

    static Hdr getHdr(String hdr) {
        if ("hdr10+".equalsIgnoreCase(hdr)) {
            return Hdr.HDR10_PLUS;
        }
        if ("hdr10".equalsIgnoreCase(hdr) || "hdr".equalsIgnoreCase(hdr)) {
            return Hdr.HDR10;
        }
        if ("dolby vision".equalsIgnoreCase(hdr)) {
            return Hdr.DOLBY_VISION;
        }
        if ("hlg".equalsIgnoreCase(hdr)) {
            return Hdr.HLG;
        }
        return null;
    }

    static Audio getAudio(String audioCodec) {
        if ("DTSHD-MA".equalsIgnoreCase(audioCodec)) {
            return Audio.DTS_MA;
        }
        if ("DTSHD-HRA".equalsIgnoreCase(audioCodec)) {
            return Audio.DTS_HR;
        }
        if ("DTS-X".equalsIgnoreCase(audioCodec)) {
            return Audio.DTS_X;
        }
        if ("TrueHD/Atmos".equalsIgnoreCase(audioCodec) || "Atmos".equalsIgnoreCase(audioCodec)) {
            return Audio.DOLBY_ATMOS;
        }
        if ("DTS".equalsIgnoreCase(audioCodec)) {
            return Audio.DTS;
        }
        if ("DTS-ES".equalsIgnoreCase(audioCodec)) {
            return Audio.DTS;
        }
        if ("TrueHD".equalsIgnoreCase(audioCodec)) {
            return Audio.DOLBY_TRUEHD;
        }
        if ("EAC3".equalsIgnoreCase(audioCodec)) {
            return Audio.DOLBY_DIGITAL_PLUS;
        }
        if ("EAC3/Atmos".equalsIgnoreCase(audioCodec)) {
            return Audio.DOLBY_DIGITAL_PLUS_ATMOS;
        }
        if ("AC3".equalsIgnoreCase(audioCodec)) {
            return Audio.DOLBY_DIGITAL;
        }
        if ("MP2".equalsIgnoreCase(audioCodec)) {
            return Audio.MP2;
        }
        if ("MP3".equalsIgnoreCase(audioCodec)) {
            return Audio.MP3;
        }
        if ("OGG".equalsIgnoreCase(audioCodec)) {
            return Audio.OGG;
        }
        if ("WMA".equalsIgnoreCase(audioCodec)) {
            return Audio.WMA;
        }
        if ("AAC".equalsIgnoreCase(audioCodec)) {
            return Audio.AAC;
        }
        if ("FLAC".equalsIgnoreCase(audioCodec)) {
            return Audio.FLAC;
        }
        return null;
    }

    static AudioChannels getAudioChannels(int audioChannelCount) {
        switch (audioChannelCount) {
            case 1: {
                return AudioChannels.CH1_0;
            }
            case 2: {
                return AudioChannels.CH2_0;
            }
            case 3: {
                return AudioChannels.CH2_1;
            }
            case 4: {
                return AudioChannels.CH3_1;
            }
            case 5: {
                return AudioChannels.CH4_1;
            }
            case 6: {
                return AudioChannels.CH5_1;
            }
            case 7: {
                return AudioChannels.CH6_1;
            }
            case 8: {
                return AudioChannels.CH7_1;
            }
            case 10: {
                return AudioChannels.CH9_1;
            }
            case 11: {
                return AudioChannels.CH10_1;
            }
        }
        return null;
    }

    static void printStatus(SyncResponse resp) {
        if (resp != null) {
            String info = TraktTv.getStatusString(resp.added);
            if (!info.isEmpty()) {
                LOGGER.debug("Added       : {}", (Object)info);
            }
            if (!(info = TraktTv.getStatusString(resp.existing)).isEmpty()) {
                LOGGER.debug("Existing    : {}", (Object)info);
            }
            if (!(info = TraktTv.getStatusString(resp.deleted)).isEmpty()) {
                LOGGER.debug("Deleted     : {}", (Object)info);
            }
            if (!(info = TraktTv.getErrorString(resp.not_found)).isEmpty()) {
                LOGGER.debug("Errors      : {}", (Object)info);
            }
        }
    }

    static String getStatusString(SyncStats ss) {
        if (ss == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(50);
        if (ss.movies != null && ss.movies > 0) {
            sb.append(ss.movies).append(" Movies ");
        }
        if (ss.shows != null && ss.shows > 0) {
            sb.append(ss.shows).append(" Shows ");
        }
        if (ss.seasons != null && ss.seasons > 0) {
            sb.append(ss.seasons).append(" Seasons ");
        }
        if (ss.episodes != null && ss.episodes > 0) {
            sb.append(ss.episodes).append(" Episodes");
        }
        return sb.toString();
    }

    static String getErrorString(SyncErrors se) {
        if (se == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(50);
        if (se.movies != null && !se.movies.isEmpty()) {
            sb.append("\n").append(se.movies.size()).append(" Movies: ");
            se.movies.forEach(movie -> sb.append(movie.ids).append(","));
        }
        if (se.shows != null && !se.shows.isEmpty()) {
            sb.append("\n").append(se.shows.size()).append(" Shows: ");
            se.shows.forEach(show -> sb.append(show.ids).append(","));
        }
        if (se.seasons != null && !se.seasons.isEmpty()) {
            sb.append("\n").append(se.seasons.size()).append(" Seasons: ");
            se.seasons.forEach(season -> sb.append(season.number).append(","));
        }
        if (se.episodes != null && !se.episodes.isEmpty()) {
            sb.append("\n").append(se.episodes.size()).append(" Episodes: ");
            se.episodes.forEach(episode -> sb.append(episode.ids).append(","));
        }
        return sb.toString();
    }

    static enum SyncType {
        COLLECTION,
        WATCHED,
        RATING;

    }
}

