/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.trakttv;

import com.uwetrottmann.trakt5.TraktV2;
import com.uwetrottmann.trakt5.entities.BaseMovie;
import com.uwetrottmann.trakt5.entities.Metadata;
import com.uwetrottmann.trakt5.entities.Movie;
import com.uwetrottmann.trakt5.entities.MovieIds;
import com.uwetrottmann.trakt5.entities.RatedMovie;
import com.uwetrottmann.trakt5.entities.SyncItems;
import com.uwetrottmann.trakt5.entities.SyncMovie;
import com.uwetrottmann.trakt5.entities.SyncResponse;
import com.uwetrottmann.trakt5.entities.TraktError;
import com.uwetrottmann.trakt5.enums.Extended;
import com.uwetrottmann.trakt5.enums.Rating;
import com.uwetrottmann.trakt5.enums.RatingsFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.DateTimeUtils;
import org.threeten.bp.Instant;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.thirdparty.trakttv.TraktTv;
import retrofit2.Call;
import retrofit2.Response;

class TraktTvMovie {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraktTvMovie.class);
    private final TraktV2 api;

    TraktTvMovie(TraktTv traktTv) {
        this.api = traktTv.getApi();
    }

    private <T> T executeCall(Call<T> call) throws IOException {
        Response response = call.execute();
        if (!response.isSuccessful() && response.code() == 401) {
            this.api.refreshAccessToken(Objects.requireNonNull(this.api.refreshToken()));
            response = call.clone().execute();
        }
        if (!response.isSuccessful()) {
            String message = "Request failed: " + response.code() + " " + response.message();
            TraktError error = this.api.checkForTraktError(response);
            if (error != null && error.message != null) {
                message = message + " message: " + error.message;
            }
            throw new HttpException(response.code(), message);
        }
        Object body = response.body();
        if (body != null) {
            return (T)body;
        }
        throw new IOException("Body should not be null for successful response");
    }

    void syncTraktMovieCollection(List<org.tinymediamanager.core.movie.entities.Movie> moviesInTmm) {
        List traktMovies;
        LOGGER.debug("got up to {} movies for Trakt.tv collection sync", (Object)moviesInTmm.size());
        try {
            traktMovies = (List)this.executeCall(this.api.sync().collectionMovies(Extended.METADATA));
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: {}", (Object)e.getMessage());
            return;
        }
        LOGGER.info("You have {} movies in your Trakt.tv collection", (Object)traktMovies.size());
        ArrayList<org.tinymediamanager.core.movie.entities.Movie> tmmMovies = new ArrayList<org.tinymediamanager.core.movie.entities.Movie>(moviesInTmm);
        for (BaseMovie traktMovie : traktMovies) {
            List<org.tinymediamanager.core.movie.entities.Movie> matchingTmmMovies = this.getTmmMoviesForTraktMovie(tmmMovies, traktMovie.movie);
            boolean metadataFound = false;
            Iterator<org.tinymediamanager.core.movie.entities.Movie> iterator = matchingTmmMovies.iterator();
            while (iterator.hasNext()) {
                org.tinymediamanager.core.movie.entities.Movie tmmMovie = iterator.next();
                if (!tmmMovie.isLocked()) {
                    boolean dirty = this.updateIDs(tmmMovie, traktMovie.movie);
                    if (traktMovie.collected_at != null) {
                        Date collectedAt = DateTimeUtils.toDate((Instant)traktMovie.collected_at.toInstant());
                        if (!collectedAt.equals(tmmMovie.getDateAdded())) {
                            LOGGER.trace("Marking movie '{}' as collected on {} (was {})", new Object[]{tmmMovie.getTitle(), collectedAt, tmmMovie.getDateAddedAsString()});
                        }
                        tmmMovie.setDateAdded(collectedAt);
                        dirty = true;
                    }
                    if (dirty) {
                        tmmMovie.writeNFO();
                        tmmMovie.saveToDb();
                    }
                } else {
                    LOGGER.trace("Skipping movie '{}' from Trak.tv collection sync, because it is locked!", (Object)tmmMovie.getTitle());
                }
                if (TraktTvMovie.matchesMetadata(traktMovie.metadata, tmmMovie)) {
                    metadataFound = true;
                }
                tmmMovies.remove(tmmMovie);
            }
            if (metadataFound || matchingTmmMovies.isEmpty()) continue;
            tmmMovies.add((org.tinymediamanager.core.movie.entities.Movie)matchingTmmMovies.get(0));
        }
        if (tmmMovies.isEmpty()) {
            LOGGER.debug("Already up-to-date - no need to add anything :)");
            return;
        }
        LOGGER.debug("prepare {} movies for Trakt.tv collection sync", (Object)tmmMovies.size());
        ArrayList<SyncMovie> movies = new ArrayList<SyncMovie>();
        int nosync = 0;
        for (org.tinymediamanager.core.movie.entities.Movie tmmMovie : tmmMovies) {
            if (tmmMovie.getIdAsInt("trakt") > 0 || MediaIdUtil.isValidImdbId(tmmMovie.getImdbId()) || tmmMovie.getTmdbId() > 0) {
                movies.add(this.toSyncMovie(tmmMovie, TraktTv.SyncType.COLLECTION));
                continue;
            }
            ++nosync;
        }
        if (nosync > 0) {
            LOGGER.debug("skipping {} movies, because they have not been scraped yet!", (Object)nosync);
        }
        if (movies.isEmpty()) {
            LOGGER.info("no new movies for Trakt.tv collection sync found.");
            return;
        }
        try {
            LOGGER.info("Adding {} movies to Trakt.tv collection", (Object)movies.size());
            SyncItems items = new SyncItems().movies(movies);
            SyncResponse response = (SyncResponse)this.executeCall(this.api.sync().addItemsToCollection(items));
            LOGGER.debug("Trakt add-to-library status:");
            TraktTv.printStatus(response);
        }
        catch (Exception e) {
            LOGGER.error("failed syncing Trakt.tv: {}", (Object)e.getMessage());
        }
    }

    void syncTraktMovieWatched(List<org.tinymediamanager.core.movie.entities.Movie> moviesInTmm) {
        List traktMovies;
        ArrayList<org.tinymediamanager.core.movie.entities.Movie> tmmMovies = new ArrayList<org.tinymediamanager.core.movie.entities.Movie>(moviesInTmm);
        try {
            traktMovies = (List)this.executeCall(this.api.sync().watchedMovies(null));
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt.tv: {}", (Object)e.getMessage());
            return;
        }
        LOGGER.info("You have {} movies marked as 'watched' in your Trakt.tv collection", (Object)traktMovies.size());
        for (Object traktWatched : traktMovies) {
            List<org.tinymediamanager.core.movie.entities.Movie> matchingTmmMovies = this.getTmmMoviesForTraktMovie(tmmMovies, ((BaseMovie)traktWatched).movie);
            for (org.tinymediamanager.core.movie.entities.Movie tmmMovie : matchingTmmMovies) {
                if (!tmmMovie.isLocked()) {
                    Date lastWatchedAt;
                    boolean dirty = this.updateIDs(tmmMovie, ((BaseMovie)traktWatched).movie);
                    if (!tmmMovie.isWatched()) {
                        LOGGER.trace("Marking movie '{}' as watched", (Object)tmmMovie.getTitle());
                        tmmMovie.setWatched(true);
                        dirty = true;
                    }
                    if (tmmMovie.getPlaycount() != ((BaseMovie)traktWatched).plays) {
                        tmmMovie.setPlaycount(((BaseMovie)traktWatched).plays);
                        dirty = true;
                    }
                    if (((BaseMovie)traktWatched).last_watched_at != null && !(lastWatchedAt = DateTimeUtils.toDate((Instant)((BaseMovie)traktWatched).last_watched_at.toInstant())).equals(tmmMovie.getLastWatched())) {
                        LOGGER.trace("Marking movie '{}' as watched on {} (was {})", new Object[]{tmmMovie.getTitle(), lastWatchedAt, tmmMovie.getLastWatched()});
                        tmmMovie.setLastWatched(lastWatchedAt);
                        dirty = true;
                    }
                    if (!dirty) continue;
                    tmmMovie.writeNFO();
                    tmmMovie.setLastWatched(null);
                    tmmMovie.saveToDb();
                    continue;
                }
                LOGGER.trace("Skipping movie '{}' from Trak.tv watched sync, because it is locked!", (Object)tmmMovie.getTitle());
            }
        }
        List tmmWatchedMovies = moviesInTmm.stream().filter(org.tinymediamanager.core.movie.entities.Movie::isWatched).collect(Collectors.toList());
        LOGGER.info("You have now {} movies marked as 'watched' in your TMM database", (Object)tmmWatchedMovies.size());
        for (BaseMovie traktWatched : traktMovies) {
            tmmWatchedMovies.removeAll(this.getTmmMoviesForTraktMovie(tmmMovies, traktWatched.movie));
        }
        if (tmmWatchedMovies.isEmpty()) {
            LOGGER.debug("no new watched movies for Trakt.tv sync found.");
            return;
        }
        LOGGER.debug("prepare {} movies for Trakt.tv sync", (Object)tmmWatchedMovies.size());
        ArrayList<SyncMovie> movies = new ArrayList<SyncMovie>();
        int nosync = 0;
        for (org.tinymediamanager.core.movie.entities.Movie tmmMovie : tmmWatchedMovies) {
            if (tmmMovie.getIdAsInt("trakt") > 0 || MediaIdUtil.isValidImdbId(tmmMovie.getImdbId()) || tmmMovie.getTmdbId() > 0) {
                movies.add(this.toSyncMovie(tmmMovie, TraktTv.SyncType.WATCHED));
                continue;
            }
            ++nosync;
        }
        if (nosync > 0) {
            LOGGER.debug("skipping {} movies, because they have not been scraped yet!", (Object)nosync);
        }
        if (movies.isEmpty()) {
            LOGGER.debug("no new watched movies for Trakt.tv sync found.");
            return;
        }
        try {
            LOGGER.info("Marking {} movies as 'watched' to Trakt.tv collection", (Object)movies.size());
            SyncItems items = new SyncItems().movies(movies);
            SyncResponse response = (SyncResponse)this.executeCall(this.api.sync().addItemsToWatchedHistory(items));
            LOGGER.debug("Trakt mark-as-watched status:");
            TraktTv.printStatus(response);
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: {}", (Object)e.getMessage());
        }
    }

    void syncTraktMovieRating(List<org.tinymediamanager.core.movie.entities.Movie> moviesInTmm) {
        List traktMovies;
        ArrayList<org.tinymediamanager.core.movie.entities.Movie> tmmMovies = new ArrayList<org.tinymediamanager.core.movie.entities.Movie>(moviesInTmm);
        try {
            traktMovies = (List)this.executeCall(this.api.sync().ratingsMovies(RatingsFilter.ALL, null, null, null));
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt.tv: {}", (Object)e.getMessage());
            return;
        }
        LOGGER.info("You have {} rated movies in your Trakt.tv collection", (Object)traktMovies.size());
        for (Object traktRated : traktMovies) {
            if (((RatedMovie)traktRated).movie == null || ((RatedMovie)traktRated).rating == null) continue;
            List<org.tinymediamanager.core.movie.entities.Movie> matchingTmmMovies = this.getTmmMoviesForTraktMovie(tmmMovies, ((RatedMovie)traktRated).movie);
            for (org.tinymediamanager.core.movie.entities.Movie tmmMovie : matchingTmmMovies) {
                if (!tmmMovie.isLocked()) {
                    boolean dirty = this.updateIDs(tmmMovie, ((RatedMovie)traktRated).movie);
                    MediaRating userRating = tmmMovie.getUserRating();
                    if (userRating == MediaMetadata.EMPTY_RATING) {
                        tmmMovie.setRating(new MediaRating("user", ((RatedMovie)traktRated).rating.value, 1, 10));
                        dirty = true;
                    }
                    if (!dirty) continue;
                    tmmMovie.writeNFO();
                    tmmMovie.saveToDb();
                    continue;
                }
                LOGGER.trace("Skipping movie '{}' from Trak.tv ratings sync, because it is locked!", (Object)tmmMovie.getTitle());
            }
        }
        List tmmRatedMovies = moviesInTmm.stream().filter(movie -> movie.getUserRating() != MediaMetadata.EMPTY_RATING).collect(Collectors.toList());
        LOGGER.info("You have now {} movies with user rating in your TMM database", (Object)tmmRatedMovies.size());
        for (RatedMovie traktRated : traktMovies) {
            if (traktRated.rating == null) continue;
            List<org.tinymediamanager.core.movie.entities.Movie> tmmMoviesForTraktMovie = this.getTmmMoviesForTraktMovie(tmmMovies, traktRated.movie);
            boolean matchFound = false;
            Iterator<org.tinymediamanager.core.movie.entities.Movie> iterator = tmmMoviesForTraktMovie.iterator();
            while (iterator.hasNext()) {
                org.tinymediamanager.core.movie.entities.Movie movie2 = iterator.next();
                if (Math.round(movie2.getUserRating().getRating()) != traktRated.rating.value) continue;
                matchFound = true;
                break;
            }
            if (!matchFound) continue;
            tmmRatedMovies.removeAll(tmmMoviesForTraktMovie);
        }
        if (tmmRatedMovies.isEmpty()) {
            LOGGER.debug("no movie ratings for Trakt.tv sync found.");
            return;
        }
        LOGGER.debug("prepare {} movies for Trakt.tv sync", (Object)tmmRatedMovies.size());
        ArrayList<SyncMovie> movies = new ArrayList<SyncMovie>();
        int nosync = 0;
        for (org.tinymediamanager.core.movie.entities.Movie tmmMovie : tmmRatedMovies) {
            if (tmmMovie.getIdAsInt("trakt") > 0 || MediaIdUtil.isValidImdbId(tmmMovie.getImdbId()) || tmmMovie.getTmdbId() > 0) {
                movies.add(this.toSyncMovie(tmmMovie, TraktTv.SyncType.RATING));
                continue;
            }
            ++nosync;
        }
        if (nosync > 0) {
            LOGGER.debug("skipping {} movies, because they have not been scraped yet!", (Object)nosync);
        }
        if (movies.isEmpty()) {
            LOGGER.debug("no new movie ratings for Trakt.tv sync found.");
            return;
        }
        try {
            LOGGER.info("Syncing {} movie ratings to Trakt.tv collection", (Object)movies.size());
            SyncItems items = new SyncItems().movies(movies);
            SyncResponse response = (SyncResponse)this.executeCall(this.api.sync().addRatings(items));
            LOGGER.debug("Trakt personal-rating status:");
            TraktTv.printStatus(response);
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: {}", (Object)e.getMessage());
        }
    }

    void removeFromTraktCollection(org.tinymediamanager.core.movie.entities.Movie tmmMovie) {
        this.removeFromTraktCollection(Collections.singletonList(tmmMovie));
    }

    void removeFromTraktCollection(List<org.tinymediamanager.core.movie.entities.Movie> tmmMovies) {
        ArrayList<SyncMovie> syncMovies = new ArrayList<SyncMovie>();
        for (org.tinymediamanager.core.movie.entities.Movie tmmMovie : tmmMovies) {
            LOGGER.debug("Going to remove from your Trakt.tv collection: {}", (Object)tmmMovie.getTitle());
            SyncMovie sync = this.toSyncMovie(tmmMovie, TraktTv.SyncType.COLLECTION);
            syncMovies.add(sync);
        }
        try {
            SyncItems items = new SyncItems().movies(syncMovies);
            SyncResponse response = (SyncResponse)this.executeCall(this.api.sync().deleteItemsFromCollection(items));
            TraktTv.printStatus(response);
        }
        catch (Exception e) {
            LOGGER.error("Failed removing from Trakt.tv collection: {}", (Object)e.getMessage());
        }
    }

    void removeFromTraktWatchedHistory(org.tinymediamanager.core.movie.entities.Movie tmmMovie) {
        this.removeFromTraktWatchedHistory(Collections.singletonList(tmmMovie));
    }

    void removeFromTraktWatchedHistory(List<org.tinymediamanager.core.movie.entities.Movie> tmmMovies) {
        ArrayList<SyncMovie> syncMovies = new ArrayList<SyncMovie>();
        for (org.tinymediamanager.core.movie.entities.Movie tmmMovie : tmmMovies) {
            LOGGER.debug("Going to remove from your Trakt.tv collection: {}", (Object)tmmMovie.getTitle());
            SyncMovie sync = this.toSyncMovie(tmmMovie, TraktTv.SyncType.WATCHED);
            syncMovies.add(sync);
        }
        try {
            SyncItems items = new SyncItems().movies(syncMovies);
            SyncResponse response = (SyncResponse)this.executeCall(this.api.sync().deleteItemsFromWatchedHistory(items));
            TraktTv.printStatus(response);
        }
        catch (Exception e) {
            LOGGER.error("Failed removing from Trakt.tv collection: {}", (Object)e.getMessage());
        }
    }

    void clearTraktMovies() {
        SyncResponse response;
        SyncItems items;
        List traktWatched;
        List traktCollection;
        try {
            traktCollection = (List)this.executeCall(this.api.sync().collectionMovies(null));
            traktWatched = (List)this.executeCall(this.api.sync().watchedMovies(null));
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: {}", (Object)e.getMessage());
            return;
        }
        LOGGER.info("You have {} movies in your Trakt.tv collection", (Object)traktCollection.size());
        LOGGER.info("You have {} movies watched", (Object)traktWatched.size());
        ArrayList<SyncMovie> moviesToRemove = new ArrayList<SyncMovie>();
        for (BaseMovie traktMovie : traktCollection) {
            moviesToRemove.add(this.toSyncMovie(traktMovie));
        }
        if (!moviesToRemove.isEmpty()) {
            try {
                items = new SyncItems().movies(moviesToRemove);
                response = (SyncResponse)this.executeCall(this.api.sync().deleteItemsFromCollection(items));
                LOGGER.debug("Trakt delete-items-from-collection status:");
                TraktTv.printStatus(response);
            }
            catch (Exception e) {
                LOGGER.error("failed syncing trakt: {}", (Object)e.getMessage());
                return;
            }
        }
        moviesToRemove.clear();
        for (BaseMovie traktMovie : traktWatched) {
            moviesToRemove.add(this.toSyncMovie(traktMovie));
        }
        if (!moviesToRemove.isEmpty()) {
            try {
                items = new SyncItems().movies(moviesToRemove);
                response = (SyncResponse)this.executeCall(this.api.sync().deleteItemsFromWatchedHistory(items));
                LOGGER.debug("Trakt delete-items-from-watched-history status:");
                TraktTv.printStatus(response);
            }
            catch (Exception e) {
                LOGGER.error("failed syncing trakt: {}", (Object)e.getMessage());
            }
        }
    }

    private List<org.tinymediamanager.core.movie.entities.Movie> getTmmMoviesForTraktMovie(List<org.tinymediamanager.core.movie.entities.Movie> tmmMovies, Movie traktMovie) {
        return tmmMovies.stream().filter(movie -> this.matches((org.tinymediamanager.core.movie.entities.Movie)movie, traktMovie)).collect(Collectors.toList());
    }

    private boolean matches(org.tinymediamanager.core.movie.entities.Movie tmmMovie, Movie traktMovie) {
        if (traktMovie == null || traktMovie.ids == null) {
            return false;
        }
        MovieIds ids = traktMovie.ids;
        int traktId = MetadataUtil.unboxInteger(ids.trakt);
        if (traktId > 0 && traktId == tmmMovie.getIdAsInt("trakt")) {
            return true;
        }
        if (StringUtils.isNotEmpty((CharSequence)ids.imdb) && ids.imdb.equals(tmmMovie.getImdbId())) {
            return true;
        }
        int tmdbId = MetadataUtil.unboxInteger(ids.tmdb);
        return tmdbId > 0 && tmdbId == tmmMovie.getTmdbId();
    }

    private static boolean matchesMetadata(Metadata metadata, org.tinymediamanager.core.movie.entities.Movie movie) {
        if (metadata == null) {
            return false;
        }
        if (metadata.is3d == null || metadata.is3d.booleanValue() != movie.isVideoIn3D()) {
            return false;
        }
        if (metadata.audio != TraktTv.getAudio(movie.getMediaInfoAudioCodec())) {
            return false;
        }
        if (metadata.media_type != TraktTv.getMediaType(movie.getMediaInfoSource())) {
            return false;
        }
        if (metadata.resolution != TraktTv.getResolution(movie.getMainVideoFile())) {
            return false;
        }
        if (metadata.audio_channels == TraktTv.getAudioChannels(movie.getMainVideoFile().getAudioChannelCount())) {
            return false;
        }
        return metadata.hdr == TraktTv.getHdr(movie.getVideoHDRFormat());
    }

    private boolean updateIDs(org.tinymediamanager.core.movie.entities.Movie tmmMovie, Movie traktMovie) {
        boolean dirty = false;
        if (traktMovie == null || traktMovie.ids == null) {
            return dirty;
        }
        MovieIds ids = traktMovie.ids;
        if (tmmMovie.getIdAsString("imdb").isEmpty() && !StringUtils.isEmpty((CharSequence)ids.imdb)) {
            tmmMovie.setId("imdb", ids.imdb);
            dirty = true;
        }
        if (tmmMovie.getIdAsInt("tmdb") == 0 && MetadataUtil.unboxInteger(ids.tmdb) > 0) {
            tmmMovie.setId("tmdb", ids.tmdb);
            dirty = true;
        }
        if (tmmMovie.getIdAsInt("trakt") == 0 && MetadataUtil.unboxInteger(ids.trakt) > 0) {
            tmmMovie.setId("trakt", ids.trakt);
            dirty = true;
        }
        return dirty;
    }

    private SyncMovie toSyncMovie(org.tinymediamanager.core.movie.entities.Movie tmmMovie, TraktTv.SyncType syncType) {
        boolean hasId = false;
        SyncMovie movie = null;
        MovieIds ids = new MovieIds();
        if (MediaIdUtil.isValidImdbId(tmmMovie.getImdbId())) {
            ids.imdb = tmmMovie.getImdbId();
            hasId = true;
        }
        if (tmmMovie.getTmdbId() > 0) {
            ids.tmdb = tmmMovie.getTmdbId();
            hasId = true;
        }
        if (tmmMovie.getIdAsInt("trakt") > 0) {
            ids.trakt = tmmMovie.getIdAsInt("trakt");
            hasId = true;
        }
        if (!hasId) {
            return movie;
        }
        movie = new SyncMovie();
        movie.id(ids);
        switch (syncType) {
            case COLLECTION: {
                movie.collectedAt(OffsetDateTime.ofInstant((Instant)DateTimeUtils.toInstant((Date)this.getDateField(tmmMovie)), (ZoneId)ZoneOffset.UTC));
                break;
            }
            case WATCHED: {
                if (!tmmMovie.isWatched()) break;
                movie.watchedAt(OffsetDateTime.ofInstant((Instant)DateTimeUtils.toInstant((Date)new Date()), (ZoneId)ZoneOffset.UTC));
                break;
            }
            case RATING: {
                MediaRating userRating = tmmMovie.getUserRating();
                if (userRating == MediaMetadata.EMPTY_RATING) break;
                movie.rating = Rating.fromValue((int)Math.round(userRating.getRating()));
                movie.ratedAt(OffsetDateTime.ofInstant((Instant)DateTimeUtils.toInstant((Date)new Date()), (ZoneId)ZoneOffset.UTC));
            }
        }
        movie.mediaType(TraktTv.getMediaType(tmmMovie.getMediaInfoSource()));
        movie.resolution(TraktTv.getResolution(tmmMovie.getMainVideoFile()));
        movie.hdr(TraktTv.getHdr(tmmMovie.getVideoHDRFormat()));
        movie.audio(TraktTv.getAudio(tmmMovie.getMediaInfoAudioCodec()));
        movie.audioChannels(TraktTv.getAudioChannels(tmmMovie.getMainVideoFile().getAudioChannelCount()));
        movie.is3d(Boolean.valueOf(tmmMovie.isVideoIn3D()));
        return movie;
    }

    private SyncMovie toSyncMovie(BaseMovie baseMovie) {
        return new SyncMovie().id(baseMovie.movie.ids).collectedAt(baseMovie.collected_at).watchedAt(baseMovie.last_watched_at);
    }

    private Date getDateField(org.tinymediamanager.core.movie.entities.Movie movie) {
        Date now;
        Date collectedAt = null;
        switch (Settings.getInstance().getTraktDateField()) {
            case DATE_ADDED: {
                collectedAt = movie.getDateAdded();
                break;
            }
            case FILE_CREATION_DATE: {
                collectedAt = movie.getMainVideoFile().getDateCreated();
                break;
            }
            case FILE_LAST_MODIFIED_DATE: {
                collectedAt = movie.getMainVideoFile().getDateLastModified();
                break;
            }
            case RELEASE_DATE: {
                collectedAt = movie.getReleaseDate();
            }
        }
        if (collectedAt == null) {
            collectedAt = movie.getDateAddedForUi();
        }
        if ((now = new Date()).before(collectedAt)) {
            collectedAt = movie.getDateAdded();
        }
        return collectedAt;
    }
}

