/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.trakttv;

import com.uwetrottmann.trakt5.TraktV2;
import com.uwetrottmann.trakt5.entities.BaseEpisode;
import com.uwetrottmann.trakt5.entities.BaseSeason;
import com.uwetrottmann.trakt5.entities.BaseShow;
import com.uwetrottmann.trakt5.entities.EpisodeIds;
import com.uwetrottmann.trakt5.entities.Metadata;
import com.uwetrottmann.trakt5.entities.RatedEpisode;
import com.uwetrottmann.trakt5.entities.RatedShow;
import com.uwetrottmann.trakt5.entities.Show;
import com.uwetrottmann.trakt5.entities.ShowIds;
import com.uwetrottmann.trakt5.entities.SyncEpisode;
import com.uwetrottmann.trakt5.entities.SyncItems;
import com.uwetrottmann.trakt5.entities.SyncResponse;
import com.uwetrottmann.trakt5.entities.SyncSeason;
import com.uwetrottmann.trakt5.entities.SyncShow;
import com.uwetrottmann.trakt5.entities.TraktError;
import com.uwetrottmann.trakt5.enums.Extended;
import com.uwetrottmann.trakt5.enums.Rating;
import com.uwetrottmann.trakt5.enums.RatingsFilter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.DateTimeUtils;
import org.threeten.bp.Instant;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.thirdparty.trakttv.TraktTv;
import retrofit2.Call;
import retrofit2.Response;

class TraktTvTvShow {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraktTvTvShow.class);
    private final TraktV2 api;

    public TraktTvTvShow(TraktTv traktTv) {
        this.api = traktTv.getApi();
    }

    private <T> T executeCall(Call<T> call) throws IOException {
        Response response = call.execute();
        if (!response.isSuccessful() && response.code() == 401) {
            this.api.refreshAccessToken(Objects.requireNonNull(this.api.refreshToken()));
            response = call.clone().execute();
        }
        if (!response.isSuccessful()) {
            String message = "Request failed: " + response.code() + " " + response.message();
            TraktError error = this.api.checkForTraktError(response);
            if (error != null && error.message != null) {
                message = message + " message: " + error.message;
            }
            throw new HttpException(response.code(), message);
        }
        Object body = response.body();
        if (body != null) {
            return (T)body;
        }
        throw new IOException("Body should not be null for successful response");
    }

    void syncTraktTvShowCollection(List<TvShow> tvShowsInTmm) {
        List traktShows;
        ArrayList<TvShow> tvShows = new ArrayList<TvShow>(tvShowsInTmm);
        try {
            traktShows = (List)this.executeCall(this.api.sync().collectionShows(Extended.METADATA));
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: {}", (Object)e.getMessage());
            return;
        }
        LOGGER.info("You have {} TvShows in your Trakt.tv collection", (Object)traktShows.size());
        for (BaseShow traktShow : traktShows) {
            List<TvShow> matchingTmmTvShows = this.getTmmTvShowForTraktShow(tvShows, traktShow.show);
            for (TvShow tmmShow : matchingTmmTvShows) {
                if (!tmmShow.isLocked()) {
                    Date collectedAt;
                    boolean showDirty = this.updateIDs(tmmShow, traktShow.show);
                    if (traktShow.last_collected_at != null && !(collectedAt = DateTimeUtils.toDate((Instant)traktShow.last_collected_at.toInstant())).equals(tmmShow.getDateAdded())) {
                        LOGGER.trace("Marking TvShow '{}' as collected on {} (was {})", new Object[]{tmmShow.getTitle(), collectedAt, tmmShow.getDateAddedAsString()});
                        tmmShow.setDateAdded(collectedAt);
                        showDirty = true;
                    }
                    for (BaseSeason bs : ListUtils.nullSafe(traktShow.seasons)) {
                        for (BaseEpisode be : ListUtils.nullSafe(bs.episodes)) {
                            List<TvShowEpisode> matchingEpisodes = tmmShow.getEpisode(MetadataUtil.unboxInteger(bs.number, -1), MetadataUtil.unboxInteger(be.number, -1));
                            for (TvShowEpisode tmmEp : matchingEpisodes) {
                                Date collectedAt2;
                                if (be.collected_at == null || (collectedAt2 = DateTimeUtils.toDate((Instant)be.collected_at.toInstant())).equals(tmmEp.getDateAdded())) continue;
                                tmmEp.setDateAdded(collectedAt2);
                                tmmEp.writeNFO();
                                tmmEp.saveToDb();
                            }
                        }
                    }
                    if (!showDirty) continue;
                    tmmShow.writeNFO();
                    tmmShow.saveToDb();
                    continue;
                }
                LOGGER.trace("Skipping show '{}' from Trak.tv collection sync, because it is locked!", (Object)tmmShow.getTitle());
            }
        }
        LOGGER.debug("Adding up to {} TV shows to Trakt.tv collection", (Object)tvShows.size());
        for (TvShow tmmShow : tvShows) {
            SyncShow syncShow = this.toSyncShow(tmmShow, false, traktShows);
            if (syncShow == null) continue;
            try {
                SyncItems items = this.prepareSyncItems(syncShow);
                SyncResponse response = (SyncResponse)this.executeCall(this.api.sync().addItemsToCollection(items));
                LOGGER.debug("Trakt add-to-library status: {}", (Object)tmmShow.getTitle());
                TraktTv.printStatus(response);
            }
            catch (Exception e) {
                LOGGER.error("failed syncing trakt: {}", (Object)e.getMessage());
                return;
            }
        }
    }

    void syncTraktTvShowWatched(List<TvShow> tvShowsInTmm) {
        List traktShows;
        ArrayList<TvShow> tvShows = new ArrayList<TvShow>(tvShowsInTmm);
        try {
            traktShows = (List)this.executeCall(this.api.sync().watchedShows(null));
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: {}", (Object)e.getMessage());
            return;
        }
        LOGGER.info("You have {} TvShows marked as watched on Trakt.tv", (Object)traktShows.size());
        for (BaseShow traktShow : traktShows) {
            List<TvShow> matchingTmmTvShows = this.getTmmTvShowForTraktShow(tvShows, traktShow.show);
            for (TvShow tmmShow : matchingTmmTvShows) {
                if (!tmmShow.isLocked()) {
                    boolean showDirty = this.updateIDs(tmmShow, traktShow.show);
                    for (BaseSeason bs : ListUtils.nullSafe(traktShow.seasons)) {
                        for (BaseEpisode be : ListUtils.nullSafe(bs.episodes)) {
                            List<TvShowEpisode> matchingEpisodes = tmmShow.getEpisode(MetadataUtil.unboxInteger(bs.number, -1), MetadataUtil.unboxInteger(be.number, -1));
                            for (TvShowEpisode tmmEp : matchingEpisodes) {
                                Date lastWatchedAt;
                                boolean epDirty = false;
                                if (!tmmEp.isWatched()) {
                                    LOGGER.trace("Marking episode '{}' as watched", (Object)tmmEp.getTitle());
                                    tmmEp.setWatched(true);
                                    epDirty = true;
                                }
                                if (tmmEp.getPlaycount() != MetadataUtil.unboxInteger(be.plays)) {
                                    tmmEp.setPlaycount(MetadataUtil.unboxInteger(be.plays));
                                    epDirty = true;
                                }
                                if (be.last_watched_at != null && !(lastWatchedAt = DateTimeUtils.toDate((Instant)be.last_watched_at.toInstant())).equals(tmmEp.getLastWatched())) {
                                    tmmEp.setLastWatched(lastWatchedAt);
                                    epDirty = true;
                                }
                                if (!epDirty) continue;
                                tmmEp.writeNFO();
                                tmmEp.setLastWatched(null);
                                tmmEp.saveToDb();
                            }
                        }
                    }
                    if (!showDirty) continue;
                    tmmShow.writeNFO();
                    tmmShow.saveToDb();
                    continue;
                }
                LOGGER.trace("Skipping show '{}' from Trak.tv watched sync, because it is locked!", (Object)tmmShow.getTitle());
            }
        }
        LOGGER.debug("Adding up to {} TV shows as watched on Trakt.tv", (Object)tvShows.size());
        for (TvShow tmmShow : tvShows) {
            SyncShow syncShow = this.toSyncShow(tmmShow, true, traktShows);
            if (syncShow == null) continue;
            try {
                SyncItems items = this.prepareSyncItems(syncShow);
                SyncResponse response = (SyncResponse)this.executeCall(this.api.sync().addItemsToWatchedHistory(items));
                LOGGER.debug("Trakt add-to-watched status: {}", (Object)tmmShow.getTitle());
                TraktTv.printStatus(response);
            }
            catch (Exception e) {
                LOGGER.error("failed syncing trakt: {}", (Object)e.getMessage());
                return;
            }
        }
    }

    private SyncItems prepareSyncItems(SyncShow syncShow) {
        SyncItems syncItems = new SyncItems();
        ArrayList<SyncEpisode> syncEpisodes = new ArrayList<SyncEpisode>();
        for (SyncSeason season2 : ListUtils.nullSafe(syncShow.seasons)) {
            for (SyncEpisode episode : ListUtils.nullSafe(season2.episodes)) {
                if (episode.ids == null) continue;
                syncEpisodes.add(episode);
            }
            if (season2.episodes == null) continue;
            season2.episodes.removeAll(syncEpisodes);
        }
        if (syncShow.seasons != null) {
            syncShow.seasons.removeAll(syncShow.seasons.stream().filter(season -> season.episodes == null || season.episodes.isEmpty()).collect(Collectors.toList()));
        }
        if (syncShow.seasons != null && !syncShow.seasons.isEmpty()) {
            syncItems.shows(syncShow);
        }
        if (!syncEpisodes.isEmpty()) {
            syncItems.episodes(syncEpisodes);
        }
        return syncItems;
    }

    void syncTraktTvShowRating(List<TvShow> tvShowsInTmm) {
        List<TvShow> matchingTmmTvShows;
        List traktEpisodes;
        List traktShows;
        ArrayList<TvShow> tvShows = new ArrayList<TvShow>(tvShowsInTmm);
        try {
            traktShows = (List)this.executeCall(this.api.sync().ratingsShows(RatingsFilter.ALL, null, null, null));
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: {}", (Object)e.getMessage());
            return;
        }
        try {
            traktEpisodes = (List)this.executeCall(this.api.sync().ratingsEpisodes(RatingsFilter.ALL, null, null, null));
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: {}", (Object)e.getMessage());
            return;
        }
        LOGGER.info("You have {} rated TV shows in your Trakt.tv collection", (Object)traktShows.size());
        LOGGER.info("You have {} rated episodes in your Trakt.tv collection", (Object)traktEpisodes.size());
        for (RatedShow traktShow : traktShows) {
            if (traktShow.show == null || traktShow.rating == null) continue;
            matchingTmmTvShows = this.getTmmTvShowForTraktShow(tvShows, traktShow.show);
            for (TvShow tmmShow : matchingTmmTvShows) {
                if (!tmmShow.isLocked()) {
                    boolean dirty = this.updateIDs(tmmShow, traktShow.show);
                    MediaRating userRating = tmmShow.getUserRating();
                    if (userRating == MediaMetadata.EMPTY_RATING) {
                        tmmShow.setRating(new MediaRating("user", traktShow.rating.value, 1, 10));
                        dirty = true;
                    }
                    if (!dirty) continue;
                    tmmShow.writeNFO();
                    tmmShow.saveToDb();
                    continue;
                }
                LOGGER.trace("Skipping show '{}' from Trak.tv ratings sync, because it is locked!", (Object)tmmShow.getTitle());
            }
        }
        for (RatedEpisode traktEpisode : traktEpisodes) {
            if (traktEpisode.show == null || traktEpisode.episode == null || traktEpisode.rating == null) continue;
            matchingTmmTvShows = this.getTmmTvShowForTraktShow(tvShows, traktEpisode.show);
            for (TvShow tmmShow : matchingTmmTvShows) {
                List<TvShowEpisode> matchingEpisodes = tmmShow.getEpisode(MetadataUtil.unboxInteger(traktEpisode.episode.number, -1), MetadataUtil.unboxInteger(traktEpisode.episode.season, -1));
                for (TvShowEpisode tmmEpisode : matchingEpisodes) {
                    if (!tmmEpisode.isLocked()) {
                        boolean dirty = false;
                        MediaRating userRating = tmmEpisode.getUserRating();
                        if (userRating == MediaMetadata.EMPTY_RATING) {
                            tmmEpisode.setRating(new MediaRating("user", traktEpisode.rating.value, 1, 10));
                            dirty = true;
                        }
                        if (!dirty) continue;
                        tmmEpisode.writeNFO();
                        tmmEpisode.saveToDb();
                        continue;
                    }
                    LOGGER.trace("Skipping episode '{}' from Trak.tv ratings sync, because it is locked!", (Object)tmmEpisode.getTitle());
                }
            }
        }
        LOGGER.debug("Adding up to {} TV shows with personal rating on Trakt.tv", (Object)tvShows.size());
        for (TvShow tmmShow : tvShows) {
            SyncShow syncShow = this.toSyncShow(tmmShow, traktShows, traktEpisodes);
            if (syncShow == null) continue;
            try {
                SyncItems items = this.prepareSyncItems(syncShow);
                SyncResponse response = (SyncResponse)this.executeCall(this.api.sync().addRatings(items));
                LOGGER.debug("Trakt add-ratings status: {}", (Object)tmmShow.getTitle());
                TraktTv.printStatus(response);
            }
            catch (Exception e) {
                LOGGER.error("failed syncing trakt: {}", (Object)e.getMessage());
                return;
            }
        }
    }

    void removeFromTraktCollection(TvShow tmmShow) {
        this.removeFromTraktCollection(Collections.singletonList(tmmShow));
    }

    void removeFromTraktCollection(List<TvShow> tmmShows) {
        ArrayList<SyncShow> syncShows = new ArrayList<SyncShow>();
        for (TvShow tmmShow : tmmShows) {
            LOGGER.debug("Going to remove from your Trakt.tv collection: {}", (Object)tmmShow.getTitle());
            SyncShow sync = this.toSyncShow(tmmShow, false, Collections.emptyList());
            syncShows.add(sync);
        }
        try {
            SyncItems items = new SyncItems().shows(syncShows);
            SyncResponse response = (SyncResponse)this.executeCall(this.api.sync().deleteItemsFromCollection(items));
            TraktTv.printStatus(response);
        }
        catch (Exception e) {
            LOGGER.error("Failed removing from Trakt.tv collection: {}", (Object)e.getMessage());
        }
    }

    void removeFromTraktWatched(TvShow tmmShow) {
        this.removeFromTraktWatched(Collections.singletonList(tmmShow));
    }

    void removeFromTraktWatched(List<TvShow> tmmShows) {
        ArrayList<SyncShow> syncShows = new ArrayList<SyncShow>();
        for (TvShow tmmShow : tmmShows) {
            LOGGER.debug("Going to remove from your Trakt.tv collection: {}", (Object)tmmShow.getTitle());
            SyncShow sync = this.toSyncShow(tmmShow, true, Collections.emptyList());
            syncShows.add(sync);
        }
        try {
            SyncItems items = new SyncItems().shows(syncShows);
            SyncResponse response = (SyncResponse)this.executeCall(this.api.sync().deleteItemsFromWatchedHistory(items));
            TraktTv.printStatus(response);
        }
        catch (Exception e) {
            LOGGER.error("Failed removing from Trakt.tv collection: {}", (Object)e.getMessage());
        }
    }

    void clearTraktTvShows() {
        SyncResponse response;
        SyncItems items;
        List traktWatched;
        List traktCollection;
        try {
            traktCollection = (List)this.executeCall(this.api.sync().collectionShows(null));
            traktWatched = (List)this.executeCall(this.api.sync().watchedShows(null));
        }
        catch (Exception e) {
            LOGGER.error("failed syncing trakt: {}", (Object)e.getMessage());
            return;
        }
        LOGGER.info("You have {} shows in your Trakt.tv collection", (Object)traktCollection.size());
        LOGGER.info("You have {} shows watched", (Object)traktWatched.size());
        ArrayList<SyncShow> showToRemove = new ArrayList<SyncShow>();
        for (BaseShow traktShow : traktCollection) {
            showToRemove.add(this.toSyncItems(traktShow));
        }
        if (!showToRemove.isEmpty()) {
            try {
                items = new SyncItems().shows(showToRemove);
                response = (SyncResponse)this.executeCall(this.api.sync().deleteItemsFromCollection(items));
                LOGGER.debug("Trakt delete-items-from-collection status:");
                TraktTv.printStatus(response);
            }
            catch (Exception e) {
                LOGGER.error("failed syncing trakt: {}", (Object)e.getMessage());
                return;
            }
        }
        showToRemove.clear();
        for (BaseShow traktShow : traktWatched) {
            showToRemove.add(this.toSyncItems(traktShow));
        }
        if (!showToRemove.isEmpty()) {
            try {
                items = new SyncItems().shows(showToRemove);
                response = (SyncResponse)this.executeCall(this.api.sync().deleteItemsFromWatchedHistory(items));
                LOGGER.debug("Trakt delete-items-from-watched-history status:");
                TraktTv.printStatus(response);
            }
            catch (Exception e) {
                LOGGER.error("failed syncing trakt: {}", (Object)e.getMessage());
            }
        }
    }

    private List<TvShow> getTmmTvShowForTraktShow(List<TvShow> tmmTvShows, Show traktShow) {
        return tmmTvShows.stream().filter(tvShow -> this.matches((TvShow)tvShow, traktShow)).collect(Collectors.toList());
    }

    private boolean matches(TvShow tmmShow, Show traktShow) {
        if (traktShow == null || traktShow.ids == null) {
            return false;
        }
        ShowIds ids = traktShow.ids;
        int traktId = MetadataUtil.unboxInteger(ids.trakt);
        if (traktId > 0 && traktId == tmmShow.getIdAsInt("trakt")) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)ids.imdb) && ids.imdb.equals(tmmShow.getImdbId())) {
            return true;
        }
        int tmdbId = MetadataUtil.unboxInteger(ids.tmdb);
        if (tmdbId > 0 && tmdbId == tmmShow.getTmdbId()) {
            return true;
        }
        int tvdbId = MetadataUtil.unboxInteger(ids.tvdb);
        if (tvdbId > 0 && tvdbId == tmmShow.getIdAsInt("tvdb")) {
            return true;
        }
        int tvrageId = MetadataUtil.unboxInteger(ids.tvrage);
        return tvrageId > 0 && tvrageId == tmmShow.getIdAsInt("tvrage");
    }

    private boolean updateIDs(TvShow tmmShow, Show traktShow) {
        boolean dirty = false;
        if (traktShow == null || traktShow.ids == null) {
            return dirty;
        }
        ShowIds ids = traktShow.ids;
        if (StringUtils.isBlank((CharSequence)tmmShow.getIdAsString("imdb")) && !StringUtils.isBlank((CharSequence)ids.imdb)) {
            tmmShow.setId("imdb", ids.imdb);
            dirty = true;
        }
        if (tmmShow.getIdAsInt("tmdb") == 0 && MetadataUtil.unboxInteger(ids.tmdb) > 0) {
            tmmShow.setId("tmdb", ids.tmdb);
            dirty = true;
        }
        if (tmmShow.getIdAsInt("trakt") == 0 && MetadataUtil.unboxInteger(ids.trakt) > 0) {
            tmmShow.setId("trakt", ids.trakt);
            dirty = true;
        }
        if (tmmShow.getIdAsInt("tvdb") == 0 && MetadataUtil.unboxInteger(ids.tvdb) > 0) {
            tmmShow.setId("tvdb", ids.tvdb);
            dirty = true;
        }
        if (tmmShow.getIdAsInt("tvrage") == 0 && MetadataUtil.unboxInteger(ids.tvrage) > 0) {
            tmmShow.setId("tvrage", ids.tvrage);
            dirty = true;
        }
        return dirty;
    }

    private SyncShow toSyncShow(TvShow tmmShow, boolean watched, List<BaseShow> showsInTrakt) {
        boolean hasId = false;
        ShowIds ids = new ShowIds();
        if (MediaIdUtil.isValidImdbId(tmmShow.getImdbId())) {
            ids.imdb = tmmShow.getImdbId();
            hasId = true;
        }
        if (tmmShow.getTmdbId() > 0) {
            ids.tmdb = tmmShow.getTmdbId();
            hasId = true;
        }
        if (tmmShow.getIdAsInt("tvdb") > 0) {
            ids.tvdb = tmmShow.getIdAsInt("tvdb");
            hasId = true;
        }
        if (tmmShow.getIdAsInt("trakt") > 0) {
            ids.trakt = tmmShow.getIdAsInt("trakt");
            hasId = true;
        }
        if (tmmShow.getIdAsInt("tvrage") > 0) {
            ids.tvrage = tmmShow.getIdAsInt("tvrage");
            hasId = true;
        }
        if (!hasId) {
            return null;
        }
        ArrayList<SyncSeason> syncSeasons = new ArrayList<SyncSeason>();
        for (TvShowSeason tvShowSeason : tmmShow.getSeasons()) {
            if (tvShowSeason.getSeason() < 0) continue;
            HashMap<CallSite, SyncEpisode> syncEpisodeMap = new HashMap<CallSite, SyncEpisode>();
            for (TvShowEpisode tmmEp : tvShowSeason.getEpisodes()) {
                if (tmmEp.getEpisode() < 0 || tmmEp.getSeason() < 0) continue;
                String episodeTag = "S" + tmmEp.getSeason() + "E" + tmmEp.getEpisode();
                if (watched) {
                    if (syncEpisodeMap.containsKey(episodeTag) || !tmmEp.isWatched()) continue;
                    OffsetDateTime watchedAt = OffsetDateTime.ofInstant((Instant)DateTimeUtils.toInstant((Date)new Date()), (ZoneId)ZoneOffset.UTC);
                    syncEpisodeMap.put((CallSite)((Object)episodeTag), this.toSyncEpisode(tmmEp).watchedAt(watchedAt));
                    continue;
                }
                if (syncEpisodeMap.containsKey(episodeTag)) continue;
                OffsetDateTime collectedAt = OffsetDateTime.ofInstant((Instant)DateTimeUtils.toInstant((Date)this.getDateField(tmmEp)), (ZoneId)ZoneOffset.UTC);
                syncEpisodeMap.put((CallSite)((Object)episodeTag), this.toSyncEpisode(tmmEp).collectedAt(collectedAt));
            }
            if (syncEpisodeMap.isEmpty()) continue;
            syncSeasons.add(new SyncSeason().number(tvShowSeason.getSeason()).episodes(new ArrayList(syncEpisodeMap.values())));
        }
        if (syncSeasons.isEmpty()) {
            return null;
        }
        BaseShow showInTrakt = null;
        for (BaseShow show : showsInTrakt) {
            if (!this.matches(tmmShow, show.show)) continue;
            showInTrakt = show;
            break;
        }
        if (showInTrakt == null) {
            return new SyncShow().id(ids).seasons(syncSeasons);
        }
        ArrayList<SyncSeason> arrayList = new ArrayList<SyncSeason>();
        for (SyncSeason syncSeason : syncSeasons) {
            ArrayList<SyncEpisode> syncEpisodesDelta = new ArrayList<SyncEpisode>();
            for (SyncEpisode syncEpisode : ListUtils.nullSafe(syncSeason.episodes)) {
                if (this.containsEpisode(showInTrakt, syncEpisode, watched)) continue;
                syncEpisodesDelta.add(syncEpisode);
            }
            if (syncEpisodesDelta.isEmpty()) continue;
            arrayList.add(new SyncSeason().number(syncSeason.number.intValue()).episodes(syncEpisodesDelta));
        }
        if (!arrayList.isEmpty()) {
            return new SyncShow().id(ids).seasons(arrayList);
        }
        return null;
    }

    private boolean containsEpisode(BaseShow show, SyncEpisode syncEpisode, boolean watched) {
        int seasonNumber = MetadataUtil.unboxInteger(syncEpisode.season);
        int episodeNumber = MetadataUtil.unboxInteger(syncEpisode.number);
        for (BaseSeason season : ListUtils.nullSafe(show.seasons)) {
            if (seasonNumber != MetadataUtil.unboxInteger(season.number, -1)) continue;
            for (BaseEpisode episode : ListUtils.nullSafe(season.episodes)) {
                if (episodeNumber != MetadataUtil.unboxInteger(episode.number, -1)) continue;
                if (watched) {
                    return true;
                }
                if (!TraktTvTvShow.matchesMetadata(episode.metadata, syncEpisode)) continue;
                return true;
            }
        }
        return false;
    }

    private SyncShow toSyncShow(TvShow tmmShow, List<RatedShow> showsInTrakt, List<RatedEpisode> episodesInTrakt) {
        boolean hasId = false;
        ShowIds ids = new ShowIds();
        if (MediaIdUtil.isValidImdbId(tmmShow.getImdbId())) {
            ids.imdb = tmmShow.getImdbId();
            hasId = true;
        }
        if (tmmShow.getTmdbId() > 0) {
            ids.tmdb = tmmShow.getTmdbId();
            hasId = true;
        }
        if (tmmShow.getIdAsInt("tvdb") > 0) {
            ids.tvdb = tmmShow.getIdAsInt("tvdb");
            hasId = true;
        }
        if (tmmShow.getIdAsInt("trakt") > 0) {
            ids.trakt = tmmShow.getIdAsInt("trakt");
            hasId = true;
        }
        if (tmmShow.getIdAsInt("tvrage") > 0) {
            ids.tvrage = tmmShow.getIdAsInt("tvrage");
            hasId = true;
        }
        if (!hasId) {
            return null;
        }
        ArrayList<SyncSeason> syncSeasons = new ArrayList<SyncSeason>();
        for (TvShowSeason tvShowSeason : tmmShow.getSeasons()) {
            HashMap<CallSite, SyncEpisode> syncEpisodeMap = new HashMap<CallSite, SyncEpisode>();
            for (TvShowEpisode tmmEp : tvShowSeason.getEpisodes()) {
                if (tmmEp.getEpisode() < 0 || tmmEp.getSeason() < 0) continue;
                String episodeTag = "S" + tmmEp.getSeason() + "E" + tmmEp.getEpisode();
                MediaRating userRating = tmmEp.getUserRating();
                if (syncEpisodeMap.containsKey(episodeTag) || userRating == MediaMetadata.EMPTY_RATING) continue;
                syncEpisodeMap.put((CallSite)((Object)episodeTag), this.toSyncEpisode(tmmEp).rating(Rating.fromValue((int)Math.round(userRating.getRating()))).ratedAt(OffsetDateTime.ofInstant((Instant)DateTimeUtils.toInstant((Date)new Date()), (ZoneId)ZoneOffset.UTC)));
            }
            syncSeasons.add(new SyncSeason().number(tvShowSeason.getSeason()).episodes(new ArrayList(syncEpisodeMap.values())));
        }
        HashMap<CallSite, RatedEpisode> episodesForShow = new HashMap<CallSite, RatedEpisode>();
        for (RatedEpisode ratedEpisode : episodesInTrakt) {
            if (ratedEpisode.episode == null || !this.matches(tmmShow, ratedEpisode.show)) continue;
            String key = "S" + ratedEpisode.episode.season + "E" + ratedEpisode.episode.number;
            episodesForShow.put((CallSite)((Object)key), ratedEpisode);
        }
        ArrayList<SyncSeason> arrayList = new ArrayList<SyncSeason>();
        for (SyncSeason syncSeason : syncSeasons) {
            ArrayList<SyncEpisode> syncEpisodesDelta = new ArrayList<SyncEpisode>();
            for (SyncEpisode syncEpisode : ListUtils.nullSafe(syncSeason.episodes)) {
                String key = "S" + syncEpisode.season + "E" + syncEpisode.number;
                RatedEpisode ratedEpisode = (RatedEpisode)episodesForShow.get(key);
                if (ratedEpisode != null && ratedEpisode.rating != null && ratedEpisode.rating.value == syncEpisode.rating.value) continue;
                syncEpisodesDelta.add(syncEpisode);
            }
            if (syncEpisodesDelta.isEmpty()) continue;
            arrayList.add(new SyncSeason().number(syncSeason.number.intValue()).episodes(syncEpisodesDelta));
        }
        if (!arrayList.isEmpty()) {
            return new SyncShow().id(ids).seasons(syncSeasons);
        }
        return null;
    }

    private SyncShow toSyncItems(BaseShow baseShow) {
        ArrayList<SyncSeason> ss = new ArrayList<SyncSeason>();
        for (BaseSeason baseSeason : baseShow.seasons) {
            ArrayList<SyncEpisode> se = new ArrayList<SyncEpisode>();
            for (BaseEpisode baseEp : baseSeason.episodes) {
                se.add(new SyncEpisode().number(baseEp.number.intValue()).collectedAt(baseEp.collected_at).watchedAt(baseEp.collected_at));
            }
            ss.add(new SyncSeason().number(baseSeason.number.intValue()).episodes(se));
        }
        return new SyncShow().id(baseShow.show.ids).collectedAt(baseShow.last_collected_at).watchedAt(baseShow.last_watched_at).seasons(ss);
    }

    private SyncEpisode toSyncEpisode(TvShowEpisode episode) {
        String imdbId;
        int traktId;
        int tvdbId;
        SyncEpisode syncEpisode = new SyncEpisode();
        EpisodeIds ids = new EpisodeIds();
        int tmdbId = MediaIdUtil.getIdAsIntOrDefault(episode.getIds(), "tmdb", 0);
        if (tmdbId > 0) {
            ids.tmdb = tmdbId;
        }
        if ((tvdbId = MediaIdUtil.getIdAsIntOrDefault(episode.getIds(), "tvdb", 0)) > 0) {
            ids.tvdb = tvdbId;
        }
        if ((traktId = MediaIdUtil.getIdAsIntOrDefault(episode.getIds(), "trakt", 0)) > 0) {
            ids.trakt = traktId;
        }
        if (MediaIdUtil.isValidImdbId(imdbId = MediaIdUtil.getIdAsString(episode.getIds(), "imdb"))) {
            ids.imdb = imdbId;
        }
        if (ids.tmdb != null || ids.tvdb != null || ids.trakt != null || ids.imdb != null) {
            syncEpisode.id(ids);
        }
        syncEpisode.number(episode.getEpisode());
        syncEpisode.season(episode.getSeason());
        syncEpisode.mediaType(TraktTv.getMediaType(episode.getMediaInfoSource()));
        syncEpisode.resolution(TraktTv.getResolution(episode.getMainVideoFile()));
        syncEpisode.hdr(TraktTv.getHdr(episode.getVideoHDRFormat()));
        syncEpisode.audio(TraktTv.getAudio(episode.getMediaInfoAudioCodec()));
        syncEpisode.audioChannels(TraktTv.getAudioChannels(episode.getMainVideoFile().getAudioChannelCount()));
        syncEpisode.is3d(Boolean.valueOf(episode.isVideoIn3D()));
        return syncEpisode;
    }

    static boolean matchesMetadata(Metadata metadata, SyncEpisode episode) {
        if (metadata == null) {
            return false;
        }
        if (metadata.is3d == null || !metadata.is3d.equals(episode.is3d)) {
            return false;
        }
        if (metadata.audio != episode.audio) {
            return false;
        }
        if (metadata.media_type != episode.media_type) {
            return false;
        }
        if (metadata.resolution != episode.resolution) {
            return false;
        }
        if (metadata.audio_channels != episode.audio_channels) {
            return false;
        }
        return metadata.hdr == episode.hdr;
    }

    private Date getDateField(TvShowEpisode episode) {
        Date now;
        Date collectedAt = null;
        switch (Settings.getInstance().getTraktDateField()) {
            case DATE_ADDED: {
                collectedAt = episode.getDateAdded();
                break;
            }
            case FILE_CREATION_DATE: {
                collectedAt = episode.getMainVideoFile().getDateCreated();
                break;
            }
            case FILE_LAST_MODIFIED_DATE: {
                collectedAt = episode.getMainVideoFile().getDateLastModified();
                break;
            }
            case RELEASE_DATE: {
                collectedAt = episode.getReleaseDate();
            }
        }
        if (collectedAt == null) {
            collectedAt = episode.getDateAddedForUi();
        }
        if ((now = new Date()).before(collectedAt)) {
            collectedAt = episode.getDateAdded();
        }
        return collectedAt;
    }
}

