/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.actions;

import java.awt.event.ActionEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.ui.actions.TmmAction;

public class ClearImageCacheAction
extends TmmAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClearImageCacheAction.class);

    public ClearImageCacheAction() {
        this.putValue("Name", TmmResourceBundle.getString("tmm.clearimagecache"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tmm.clearimagecache"));
    }

    @Override
    protected void processAction(ActionEvent arg0) {
        Path cache = ImageCache.getCacheDir();
        if (Files.exists(cache, new LinkOption[0])) {
            try {
                Utils.deleteDirectoryRecursive(cache);
                ImageCache.createSubdirs();
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage());
            }
        }
    }
}

