/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.table.TmmEditorTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.panels.IModalPopupPanelProvider;
import org.tinymediamanager.ui.panels.ModalPopupPanel;
import org.tinymediamanager.ui.panels.RatingEditorPanel;

public class MediaRatingTable
extends TmmEditorTable {
    private final EventList<Rating> ratingList;

    public MediaRatingTable(EventList<Rating> ratings) {
        this.ratingList = ratings;
        this.setModel((TableModel)((Object)new TmmTableModel<Rating>(this.ratingList, new MediaRatingTableFormat())));
        this.adjustColumnPreferredWidths(3);
    }

    public static EventList<Rating> convertRatingMapToEventList(Map<String, MediaRating> idMap, boolean withUserRating) {
        BasicEventList idList = new BasicEventList();
        for (Map.Entry<String, MediaRating> entry : idMap.entrySet()) {
            if ("user".equals(entry.getKey()) && !withUserRating) continue;
            Rating id = new Rating(entry.getKey());
            MediaRating mediaRating = entry.getValue();
            id.value = mediaRating.getRating();
            id.votes = mediaRating.getVotes();
            id.maxValue = mediaRating.getMaxValue();
            idList.add((Object)id);
        }
        return idList;
    }

    public static EventList<Rating> convertRatingMapToEventList(List<MediaRating> ratings) {
        BasicEventList idList = new BasicEventList();
        for (MediaRating rating : ratings) {
            Rating id = new Rating(rating.getId());
            id.value = rating.getRating();
            id.votes = rating.getVotes();
            id.maxValue = rating.getMaxValue();
            idList.add((Object)id);
        }
        return idList;
    }

    @Override
    protected void editButtonClicked(int row) {
        IModalPopupPanelProvider iModalPopupPanelProvider = IModalPopupPanelProvider.findModalProvider(this);
        if (iModalPopupPanelProvider == null) {
            return;
        }
        int index = this.convertRowIndexToModel(row);
        Rating rating = (Rating)this.ratingList.get(index);
        ModalPopupPanel popupPanel = iModalPopupPanelProvider.createModalPopupPanel();
        popupPanel.setTitle(TmmResourceBundle.getString("rating.edit"));
        RatingEditorPanel ratingEditorPanel = new RatingEditorPanel(rating);
        popupPanel.setContent(ratingEditorPanel);
        iModalPopupPanelProvider.showModalPopupPanel(popupPanel);
    }

    private static class MediaRatingTableFormat
    extends TmmTableFormat<Rating> {
        private MediaRatingTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.rating.source"), "source", rating -> rating.key, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.rating"), "rating", rating -> Float.valueOf(rating.value), Float.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.rating.maxvalue"), "maxvalue", rating -> rating.maxValue, Integer.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.rating.votes"), "votes", rating -> rating.votes, Integer.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("Button.edit"), "edit", person -> IconManager.EDIT, ImageIcon.class);
            col.setColumnResizeable(false);
            col.setHeaderIcon(IconManager.EDIT_HEADER);
            this.addColumn(col);
        }
    }

    public static class Rating {
        public String key;
        public float value;
        public int maxValue;
        public int votes;

        public Rating(String key) {
            this.key = key;
        }

        public int hashCode() {
            return new HashCodeBuilder(13, 31).append((Object)this.key).toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Rating)) {
                return false;
            }
            Rating other = (Rating)obj;
            if (obj == this) {
                return true;
            }
            return StringUtils.equals((CharSequence)this.key, (CharSequence)other.key);
        }
    }
}

