/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.table.TmmEditorTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.dialogs.ImagePreviewDialog;
import org.tinymediamanager.ui.panels.IModalPopupPanelProvider;
import org.tinymediamanager.ui.panels.ModalPopupPanel;
import org.tinymediamanager.ui.panels.PersonEditorPanel;

public class PersonTable
extends TmmEditorTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersonTable.class);
    private final EventList<Person> personEventList;
    private String addTitle = "";
    private String editTitle = "";

    public PersonTable(EventList<Person> personEventList) {
        this.personEventList = personEventList;
        this.setModel((TableModel)((Object)new TmmTableModel<Person>((EventList<Person>)GlazedListsSwing.swingThreadProxyList(personEventList), new PersonTableFormat())));
        this.adjustColumnPreferredWidths(3);
    }

    private Person getPerson(int row) {
        int index = this.convertRowIndexToModel(row);
        return (Person)this.personEventList.get(index);
    }

    @Override
    protected void editButtonClicked(int row) {
        IModalPopupPanelProvider iModalPopupPanelProvider = IModalPopupPanelProvider.findModalProvider(this);
        if (iModalPopupPanelProvider == null) {
            return;
        }
        Person person = this.getPerson(row);
        ModalPopupPanel popupPanel = iModalPopupPanelProvider.createModalPopupPanel();
        popupPanel.setTitle(this.getEditTitle());
        popupPanel.setOnCloseHandler(() -> this.onPersonChanged(person));
        PersonEditorPanel personEditorPanel = new PersonEditorPanel(person);
        popupPanel.setContent(personEditorPanel);
        iModalPopupPanelProvider.showModalPopupPanel(popupPanel);
    }

    private String getEditTitle() {
        if (StringUtils.isNotBlank((CharSequence)this.editTitle)) {
            return this.editTitle;
        }
        return TmmResourceBundle.getString("cast.edit");
    }

    public void onPersonChanged(Person person) {
    }

    @Override
    protected boolean isLinkCell(int row, int column) {
        return this.isEditorColumn(column) || this.isProfileColumn(column) && this.isProfileAvailable(row) || this.isImageColumn(column) && this.isImageAvailable(row);
    }

    private boolean isProfileColumn(int column) {
        if (column < 0) {
            return false;
        }
        return "profileUrl".equals(this.getColumnModel().getColumn(column).getIdentifier());
    }

    private boolean isProfileAvailable(int row) {
        return StringUtils.isNotBlank((CharSequence)this.getPerson(row).getProfileUrl());
    }

    private boolean isImageColumn(int column) {
        if (column < 0) {
            return false;
        }
        return "imageUrl".equals(this.getColumnModel().getColumn(column).getIdentifier());
    }

    private boolean isImageAvailable(int row) {
        return StringUtils.isNotBlank((CharSequence)this.getPerson(row).getThumbUrl());
    }

    @Override
    protected void linkClicked(int row, int column) {
        Person person = this.getPerson(row);
        if (person != null) {
            if (this.isProfileColumn(column) && StringUtils.isNotBlank((CharSequence)person.getProfileUrl())) {
                try {
                    TmmUIHelper.browseUrl(person.getProfileUrl());
                }
                catch (Exception e1) {
                    LOGGER.error("Opening actor profile", (Throwable)e1);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)person.getProfileUrl(), "message.erroropenurl", new String[]{":", e1.getLocalizedMessage()}));
                }
            } else if (this.isImageColumn(column) && StringUtils.isNotBlank((CharSequence)person.getThumbUrl())) {
                ImagePreviewDialog dialog = new ImagePreviewDialog(person.getThumbUrl());
                dialog.setVisible(true);
            }
        }
    }

    public void setAddTitle(String addTitle) {
        this.addTitle = addTitle;
    }

    private String getAddTitle() {
        if (StringUtils.isNotBlank((CharSequence)this.addTitle)) {
            return this.addTitle;
        }
        return TmmResourceBundle.getString("cast.add");
    }

    public void setEditTitle(String editTitle) {
        this.editTitle = editTitle;
    }

    public List<Person> getSelectedPersons() {
        ArrayList<Person> selectedPersons = new ArrayList<Person>();
        for (int i : this.getSelectedRows()) {
            Person person = this.getPerson(i);
            if (person == null) continue;
            selectedPersons.add(person);
        }
        return selectedPersons;
    }

    public void addPerson(Person.Type personType) {
        String defaultName;
        IModalPopupPanelProvider iModalPopupPanelProvider = IModalPopupPanelProvider.findModalProvider(this);
        if (iModalPopupPanelProvider == null) {
            return;
        }
        String defaultRole = switch (personType) {
            case Person.Type.ACTOR -> {
                defaultName = TmmResourceBundle.getString("cast.actor.unknown");
                yield TmmResourceBundle.getString("cast.role.unknown");
            }
            case Person.Type.GUEST -> {
                defaultName = TmmResourceBundle.getString("cast.actor.unknown");
                yield TmmResourceBundle.getString("cast.role.unknown");
            }
            case Person.Type.DIRECTOR -> {
                defaultName = TmmResourceBundle.getString("director.name.unknown");
                yield "Director";
            }
            case Person.Type.WRITER -> {
                defaultName = TmmResourceBundle.getString("writer.name.unknown");
                yield "Writer";
            }
            case Person.Type.PRODUCER -> {
                defaultName = TmmResourceBundle.getString("producer.name.unknown");
                yield TmmResourceBundle.getString("producer.role.unknown");
            }
            default -> {
                defaultName = "";
                yield "";
            }
        };
        Person person = new Person(personType, defaultName, defaultRole);
        ModalPopupPanel popupPanel = iModalPopupPanelProvider.createModalPopupPanel();
        popupPanel.setTitle(this.getAddTitle());
        popupPanel.setOnCloseHandler(() -> {
            if (StringUtils.isNotBlank((CharSequence)person.getName()) && !person.getName().equals(defaultName)) {
                if (person.getRole().equals(defaultRole)) {
                    person.setRole("");
                }
                this.personEventList.add(0, (Object)person);
            }
        });
        PersonEditorPanel personEditorPanel = new PersonEditorPanel(person);
        popupPanel.setContent(personEditorPanel);
        iModalPopupPanelProvider.showModalPopupPanel(popupPanel);
    }

    private static class PersonTableFormat
    extends TmmTableFormat<Person> {
        private PersonTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.name"), "name", Person::getName, String.class);
            col.setColumnResizeable(true);
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("metatag.role"), "role", Person::getRole, String.class);
            col.setColumnResizeable(true);
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("image.url"), "imageUrl", person -> {
                if (StringUtils.isNotBlank((CharSequence)person.getThumbUrl())) {
                    return IconManager.TABLE_OK;
                }
                return IconManager.TABLE_NOT_OK;
            }, ImageIcon.class);
            col.setColumnResizeable(false);
            col.setHeaderIcon(IconManager.IMAGES);
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("profile.url"), "profileUrl", person -> {
                if (StringUtils.isNotBlank((CharSequence)person.getProfileUrl())) {
                    return IconManager.TABLE_OK;
                }
                return IconManager.TABLE_NOT_OK;
            }, ImageIcon.class);
            col.setColumnResizeable(false);
            col.setHeaderIcon(IconManager.IDCARD);
            this.addColumn(col);
            col = new TmmTableFormat.Column(TmmResourceBundle.getString("Button.edit"), "edit", person -> IconManager.EDIT, ImageIcon.class);
            col.setColumnResizeable(false);
            col.setHeaderIcon(IconManager.EDIT_HEADER);
            this.addColumn(col);
        }
    }
}

