/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.Graphics;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.SwingWorker;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.ui.components.ImageLabel;

public class ProducerImageLabel
extends ImageLabel {
    private SwingWorker<Void, Void> producerWorker = null;
    private Person producer = null;

    public void setProducer(MediaEntity mediaEntity, Person producer) {
        this.clearImage();
        if (mediaEntity != null && producer != null && producer != this.producer) {
            if (this.producerWorker != null && !this.producerWorker.isDone()) {
                this.producerWorker.cancel(true);
            }
            this.producer = producer;
            this.producerWorker = new ProducerImageLoader(producer, mediaEntity);
            this.producerWorker.execute();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isShowing() && !this.isLoading() && this.scaledImage == null) {
            if (StringUtils.isNotBlank((CharSequence)this.imagePath)) {
                if (this.worker != null && !this.worker.isDone()) {
                    this.worker.cancel(true);
                }
                this.worker = new ImageLabel.ImageLoader(this, this.imagePath, this.getSize());
                this.worker.execute();
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)this.imageUrl)) {
                this.worker = new ImageLabel.ImageFetcher(this, this.imageUrl, this.getSize());
                this.worker.execute();
                return;
            }
        }
        super.paintComponent(g);
    }

    @Override
    protected boolean isLoading() {
        return this.worker != null && !this.worker.isDone() || this.producerWorker != null && !this.producerWorker.isDone();
    }

    protected class ProducerImageLoader
    extends SwingWorker<Void, Void> {
        private final Person producer;
        private final MediaEntity mediaEntity;
        private Path imagePath = null;

        private ProducerImageLoader(Person producer, MediaEntity mediaEntity) {
            this.producer = producer;
            this.mediaEntity = mediaEntity;
        }

        @Override
        protected Void doInBackground() {
            Path p;
            String producerImageFilename = this.producer.getNameForStorage();
            if (StringUtils.isNotBlank((CharSequence)producerImageFilename)) {
                Path file = null;
                if (ProducerImageLabel.this.preferCache) {
                    file = ImageCache.getCachedFile(Paths.get(this.mediaEntity.getPath(), ".producers", producerImageFilename));
                }
                if (file == null) {
                    file = Paths.get(this.mediaEntity.getPath(), ".producers", producerImageFilename);
                }
                if (!(file != null && Files.exists(file, new LinkOption[0]) || ProducerImageLabel.this.preferCache)) {
                    file = ImageCache.getCachedFile(Paths.get(this.mediaEntity.getPath(), ".producers", producerImageFilename));
                }
                if (file != null && Files.exists(file, new LinkOption[0])) {
                    this.imagePath = file;
                    return null;
                }
            }
            if (ProducerImageLabel.this.isShowing() && (p = ImageCache.getCachedFile(this.producer.getThumbUrl())) != null) {
                this.imagePath = p;
            }
            return null;
        }

        @Override
        protected void done() {
            if (this.isCancelled()) {
                return;
            }
            if (this.imagePath != null) {
                ProducerImageLabel.this.setImagePath(this.imagePath.toString());
            } else {
                ProducerImageLabel.this.clearImage();
            }
        }
    }
}

