/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.combobox;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import javax.swing.JComboBox;
import org.tinymediamanager.ui.components.combobox.AutoCompleteSupport;

public class AutocompleteComboBox<E>
extends JComboBox<E> {
    private final EventList<E> items;
    private AutoCompleteSupport<E> autoCompleteSupport;

    public AutocompleteComboBox(Collection<E> items) {
        this.items = new BasicEventList();
        this.items.addAll(items);
        this.init();
    }

    public AutocompleteComboBox(E[] items) {
        this.items = GlazedLists.eventListOf((Object[])items);
        this.init();
    }

    private void init() {
        this.setEditable(true);
        this.items.sort((o1, o2) -> o1.toString().compareToIgnoreCase(o2.toString()));
        this.autoCompleteSupport = AutoCompleteSupport.install(this, this.items);
        this.getEditor().getEditorComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                AutocompleteComboBox.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    public AutoCompleteSupport<E> getAutoCompleteSupport() {
        return this.autoCompleteSupport;
    }
}

