/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.table;

import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.impl.gui.SortingStrategy;
import ca.odell.glazedlists.swing.SortableRenderer;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.FlatButton;
import org.tinymediamanager.ui.components.table.MouseKeyboardSortingStrategy;
import org.tinymediamanager.ui.components.table.TmmTableColumnModel;
import org.tinymediamanager.ui.components.table.TmmTableColumnSelectionPopup;
import org.tinymediamanager.ui.components.table.TmmTableComparatorChooser;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.components.table.TmmViewport;

public class TmmTable
extends JTable {
    private TmmTableComparatorChooser<?> tableComparatorChooser;

    public TmmTable() {
        this.init();
    }

    public TmmTable(TableModel dm) {
        this.setModel(dm);
        this.init();
    }

    @Override
    protected TableColumnModel createDefaultColumnModel() {
        return new TmmTableColumnModel();
    }

    @Override
    public void addColumn(TableColumn aColumn) {
        if (aColumn.getIdentifier() == null && this.getModel() instanceof TmmTableModel) {
            aColumn.setHeaderRenderer(new SortableIconHeaderRenderer());
            TmmTableModel tableModel = (TmmTableModel)((Object)this.getModel());
            tableModel.setUpColumn(aColumn);
        }
        super.addColumn(aColumn);
    }

    private void init() {
        this.getInputMap(1).put(KeyStroke.getKeyStroke("ENTER"), "none");
        this.getTableHeader().setReorderingAllowed(false);
        this.setOpaque(false);
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                TmmTable.this.adjustColumnPreferredWidths(3);
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
                TmmTable.this.adjustColumnPreferredWidths(3);
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
    }

    public void installComparatorChooser(SortedList<?> sortedList) {
        this.installComparatorChooser(sortedList, new MouseKeyboardSortingStrategy());
    }

    public void installComparatorChooser(SortedList<?> sortedList, SortingStrategy sortingStrategy) {
        this.tableComparatorChooser = TmmTableComparatorChooser.install(this, sortedList, sortingStrategy);
    }

    public TmmTableComparatorChooser<?> getTableComparatorChooser() {
        return this.tableComparatorChooser;
    }

    public List<String> getHiddenColumns() {
        ArrayList<String> hiddenColumns = new ArrayList<String>();
        TableColumnModel tableColumnModel = this.getColumnModel();
        if (tableColumnModel instanceof TmmTableColumnModel) {
            TmmTableColumnModel tableColumnModel2 = (TmmTableColumnModel)tableColumnModel;
            List<TableColumn> cols = tableColumnModel2.getHiddenColumns();
            for (TableColumn col : cols) {
                String identifier;
                Object object = col.getIdentifier();
                if (!(object instanceof String) || !StringUtils.isNotBlank((CharSequence)(identifier = (String)object))) continue;
                hiddenColumns.add(identifier);
            }
        }
        return hiddenColumns;
    }

    public void readHiddenColumns(List<String> hiddenColumns) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        if (tableColumnModel instanceof TmmTableColumnModel) {
            TmmTableColumnModel tmmTableColumnModel = (TmmTableColumnModel)tableColumnModel;
            tmmTableColumnModel.setHiddenColumns(hiddenColumns);
        }
    }

    public void setDefaultHiddenColumns() {
        TableModel tableModel;
        if (this.getColumnModel() instanceof TmmTableColumnModel && (tableModel = this.getModel()) instanceof TmmTableModel) {
            TmmTableModel tableModel2 = (TmmTableModel)((Object)tableModel);
            TmmTableFormat tableFormat = (TmmTableFormat)tableModel2.getTableFormat();
            ArrayList<String> hiddenColumns = new ArrayList<String>();
            for (int i = 0; i < tableFormat.getColumnCount(); ++i) {
                if (!tableFormat.isColumnDefaultHidden(i)) continue;
                hiddenColumns.add(tableFormat.getColumnIdentifier(i));
            }
            this.readHiddenColumns(hiddenColumns);
        }
    }

    public void adjustColumnPreferredWidths(int margin) {
        TableColumnModel columnModel = this.getColumnModel();
        for (int col = 0; col < this.getColumnCount(); ++col) {
            TableColumn column;
            int maxWidth = 0;
            int minWidth = columnModel.getColumn(col).getMinWidth();
            TableCellRenderer rend = columnModel.getColumn(col).getHeaderRenderer();
            Object value = columnModel.getColumn(col).getHeaderValue();
            if (rend == null) {
                rend = this.getTableHeader().getDefaultRenderer();
            }
            Component comp = rend.getTableCellRendererComponent(this, value, false, false, -1, col);
            maxWidth = Math.max(comp.getPreferredSize().width + 2 * margin, maxWidth);
            for (int row = 0; row < this.getRowCount(); ++row) {
                rend = this.getCellRenderer(row, col);
                value = this.getValueAt(row, col);
                comp = rend.getTableCellRendererComponent(this, value, false, false, row, col);
                maxWidth = Math.max(comp.getPreferredSize().width + margin, maxWidth);
            }
            if (maxWidth < minWidth) {
                maxWidth = minWidth;
            }
            if (!(column = columnModel.getColumn(col)).getResizable()) {
                column.setMinWidth(minWidth);
                column.setMaxWidth(maxWidth);
            }
            column.setPreferredWidth(maxWidth);
        }
        this.resizeAndRepaint();
    }

    @Override
    protected void configureEnclosingScrollPane() {
        Container parent;
        super.configureEnclosingScrollPane();
        Container p = this.getParent();
        if (p instanceof JViewport && (parent = p.getParent()) instanceof JScrollPane) {
            final JScrollPane scrollPane = (JScrollPane)parent;
            scrollPane.setBorder(null);
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return;
            }
            if (scrollPane.getVerticalScrollBarPolicy() == 21) {
                scrollPane.getVerticalScrollBar().setEnabled(false);
            }
            scrollPane.setVerticalScrollBarPolicy(22);
            if (this.useColumnConfigurator()) {
                final FlatButton b = new FlatButton((Icon)IconManager.CONFIGURE){

                    @Override
                    public void updateUI() {
                        super.updateUI();
                        this.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 0, UIManager.getColor("TableHeader.bottomSeparatorColor")));
                    }
                };
                b.setContentAreaFilled(false);
                b.setToolTipText(TmmResourceBundle.getString("Button.selectvisiblecolumns"));
                b.updateUI();
                b.addActionListener(evt -> TmmTableColumnSelectionPopup.showColumnSelectionPopup(b, this));
                b.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        scrollPane.setCursor(Cursor.getPredefinedCursor(12));
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        scrollPane.setCursor(Cursor.getPredefinedCursor(0));
                    }

                    @Override
                    public void mouseClicked(MouseEvent me) {
                        TmmTableColumnSelectionPopup.showColumnSelectionPopup(b, TmmTable.this);
                    }
                });
                b.setFocusable(false);
                scrollPane.setCorner("UPPER_RIGHT_CORNER", b);
            }
        }
    }

    protected boolean useColumnConfigurator() {
        return this.getModel() instanceof TmmTableModel;
    }

    public void configureScrollPane(JScrollPane scrollPane) {
        int[] columnsWithoutRightVerticalGrid = new int[]{};
        this.configureScrollPane(scrollPane, columnsWithoutRightVerticalGrid);
    }

    public void configureScrollPane(JScrollPane scrollPane, int[] columnsWithoutRightVerticalGrid) {
        if (!(scrollPane.getViewport() instanceof TmmViewport)) {
            scrollPane.setViewport(new TmmViewport(this, columnsWithoutRightVerticalGrid));
            scrollPane.getViewport().setView(this);
        }
    }

    @Override
    public String getToolTipText(@NotNull MouseEvent e) {
        TableModel tableModel = this.getModel();
        if (!(tableModel instanceof TmmTableModel)) {
            return super.getToolTipText(e);
        }
        TmmTableModel tableModel2 = (TmmTableModel)((Object)tableModel);
        Point p = e.getPoint();
        int rowIndex = this.rowAtPoint(p);
        int colIndex = this.columnAtPoint(p);
        int realColumnIndex = this.convertColumnIndexToModel(colIndex);
        return tableModel2.getTooltipAt(rowIndex, realColumnIndex);
    }

    @Override
    public Point getToolTipLocation(MouseEvent e) {
        if (StringUtils.isBlank((CharSequence)this.getToolTipText(e))) {
            return null;
        }
        Point p = e.getPoint();
        int rowIndex = this.rowAtPoint(p);
        int colIndex = this.columnAtPoint(p);
        Rectangle r = this.getCellRect(rowIndex, colIndex, false);
        return new Point(r.x + 20, r.y + (int)(1.2 * (double)r.height));
    }

    protected static class SortableIconHeaderRenderer
    extends JPanel
    implements TableCellRenderer,
    SortableRenderer {
        private final TableCellRenderer delegate = new DefaultTableCellRenderer();
        private final JLabel labelLeft;
        private final JLabel labelRight;
        private Icon sortIcon;

        public SortableIconHeaderRenderer() {
            this.setLayout((LayoutManager)new MigLayout("insets 0, hidemode 3, center", "[]", "[grow]"));
            this.labelLeft = new JLabel();
            this.add((Component)this.labelLeft, "cell 0 0");
            this.labelRight = new JLabel();
            this.labelRight.setIconTextGap(0);
            this.add((Component)this.labelRight, "cell 0 0, gapx 1");
        }

        public void setSortIcon(Icon sortIcon) {
            this.sortIcon = sortIcon;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            Component c = this.delegate.getTableCellRendererComponent(table, value, selected, focused, row, column);
            if (!(c instanceof JLabel)) {
                return c;
            }
            JLabel label = (JLabel)c;
            this.setForeground(label.getForeground());
            this.setBackground(label.getBackground());
            this.setFont(label.getFont());
            this.labelLeft.setForeground(label.getForeground());
            this.labelLeft.setBackground(label.getBackground());
            this.labelLeft.setFont(label.getFont());
            this.labelRight.setForeground(label.getForeground());
            this.labelRight.setBackground(label.getBackground());
            this.labelRight.setFont(label.getFont());
            if (this.sortIcon == null) {
                this.labelRight.setVisible(false);
            } else {
                this.labelRight.setVisible(true);
                this.labelRight.setIcon(this.sortIcon);
            }
            if (value instanceof ImageIcon) {
                ImageIcon imageIcon = (ImageIcon)value;
                this.labelLeft.setIcon(imageIcon);
                this.labelLeft.setText("");
            } else {
                this.labelLeft.setText(value == null ? "" : value.toString());
                this.labelLeft.setIcon(null);
            }
            return this;
        }
    }

    protected static class IconHeaderRenderer
    extends DefaultTableCellRenderer {
        public IconHeaderRenderer() {
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            JTableHeader h;
            JTableHeader jTableHeader = h = table != null ? table.getTableHeader() : null;
            if (h != null) {
                this.setEnabled(h.isEnabled());
                this.setComponentOrientation(h.getComponentOrientation());
                this.setForeground(h.getForeground());
                this.setBackground(h.getBackground());
                this.setFont(h.getFont());
            } else {
                this.setEnabled(true);
                this.setComponentOrientation(ComponentOrientation.UNKNOWN);
                this.setForeground(UIManager.getColor("TableHeader.foreground"));
                this.setBackground(UIManager.getColor("TableHeader.background"));
                this.setFont(UIManager.getFont("TableHeader.font"));
            }
            if (value instanceof ImageIcon) {
                ImageIcon imageIcon = (ImageIcon)value;
                this.setIcon(imageIcon);
                this.setText("");
            } else {
                this.setText(value == null ? "" : value.toString());
                this.setIcon(null);
                this.setHorizontalAlignment(0);
            }
            return this;
        }
    }
}

