/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.table;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.ui.components.MenuScroller;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableColumnModel;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableCellRenderer;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableModel;

public class TmmTableColumnSelectionPopup {
    private TmmTableColumnSelectionPopup() {
        throw new IllegalAccessError();
    }

    static void showColumnSelectionPopup(Component c, TmmTable table) {
        ArrayList al;
        ArrayList<JCheckBoxMenuItem> checkBoxMenuItems = new ArrayList<JCheckBoxMenuItem>();
        ActionListener actionListener = e -> TmmTableColumnSelectionPopup.checkCheckBoxStates(checkBoxMenuItems);
        JPopupMenu popup = new JPopupMenu();
        TableColumnModel columnModel = table.getColumnModel();
        if (!(columnModel instanceof TmmTableColumnModel)) {
            return;
        }
        TmmTableColumnModel tmmTableColumnModel = (TmmTableColumnModel)columnModel;
        List<TableColumn> columns = tmmTableColumnModel.getAllColumns();
        HashMap<String, Serializable> displayNameToCheckBox = new HashMap<String, Serializable>();
        ArrayList<String> displayNames = new ArrayList<String>();
        TableModel tableModel = table.getModel();
        for (int i = 0; i < columns.size(); ++i) {
            Object tmmTreeTableModel;
            TmmTableModel tmmTableModel;
            TableColumn etc = columns.get(i);
            if ("Nodes".equals(tableModel.getColumnName(etc.getModelIndex())) && etc.getModelIndex() == 0) continue;
            String columnName = null;
            TableModel tableModel2 = table.getModel();
            if (tableModel2 instanceof TmmTableModel && StringUtils.isNotBlank((CharSequence)(tmmTableModel = (TmmTableModel)((Object)tableModel2)).getHeaderTooltip(etc.getModelIndex()))) {
                columnName = tmmTableModel.getHeaderTooltip(etc.getModelIndex());
            } else {
                tableModel2 = table.getModel();
                if (tableModel2 instanceof TmmTreeTableModel && StringUtils.isNotBlank((CharSequence)((TmmTreeTableModel)(tmmTreeTableModel = (TmmTreeTableModel)tableModel2)).getHeaderTooltip(etc.getModelIndex()))) {
                    columnName = ((TmmTreeTableModel)tmmTreeTableModel).getHeaderTooltip(etc.getModelIndex());
                }
            }
            if (StringUtils.isBlank(columnName)) {
                columnName = tableModel.getColumnName(etc.getModelIndex());
            }
            if (StringUtils.isBlank(columnName) && (tmmTreeTableModel = etc.getHeaderValue()) instanceof String) {
                String value;
                columnName = value = (String)tmmTreeTableModel;
            }
            if (StringUtils.isBlank((CharSequence)columnName) && etc.getIdentifier() != null) {
                columnName = etc.getIdentifier().toString();
            }
            JCheckBoxMenuItem checkBox = new JCheckBoxMenuItem();
            checkBox.setText(columnName);
            checkBox.setSelected(!tmmTableColumnModel.isColumnHidden(etc));
            checkBox.putClientProperty("CheckBoxMenuItem.doNotCloseOnMouseClick", true);
            checkBox.addActionListener(actionListener);
            if (etc.getCellRenderer() instanceof TmmTreeTableCellRenderer) {
                checkBox.setSelected(true);
                checkBox.setEnabled(false);
            }
            checkBoxMenuItems.add(checkBox);
            JCheckBoxMenuItem checkBoxMenuItem = checkBox;
            checkBox.addActionListener(evt -> tmmTableColumnModel.setColumnHidden(etc, !checkBoxMenuItem.isSelected()));
            if (!displayNames.contains(columnName)) {
                displayNameToCheckBox.put(columnName, checkBox);
            } else {
                al = null;
                Object theFirstOne = displayNameToCheckBox.get(columnName);
                if (theFirstOne instanceof JCheckBoxMenuItem) {
                    JCheckBoxMenuItem firstCheckBox = (JCheckBoxMenuItem)theFirstOne;
                    al = new ArrayList();
                    al.add(firstCheckBox);
                } else if (theFirstOne instanceof ArrayList) {
                    ArrayList arrayList = (ArrayList)theFirstOne;
                    al = (ArrayList)theFirstOne;
                } else {
                    throw new IllegalStateException("Wrong object theFirstOne is " + theFirstOne);
                }
                al.add(checkBox);
                displayNameToCheckBox.put(columnName, al);
            }
            displayNames.add(columnName);
        }
        int index = 0;
        for (String displayName : displayNames) {
            Object obj = displayNameToCheckBox.get(displayName);
            JCheckBoxMenuItem checkBox = null;
            if (obj instanceof JCheckBoxMenuItem) {
                checkBox = (JCheckBoxMenuItem)obj;
            } else if (obj instanceof ArrayList) {
                al = (ArrayList)obj;
                if (index >= al.size()) {
                    index = 0;
                }
                checkBox = (JCheckBoxMenuItem)al.get(index++);
            } else {
                throw new IllegalStateException("Wrong object obj is " + obj);
            }
            popup.add(checkBox);
        }
        if (c.getGraphicsConfiguration().getDevice().getDisplayMode().getHeight() < 800) {
            MenuScroller.setScrollerFor(popup, 25, 50);
        }
        popup.show(c, 8, 8);
    }

    private static void checkCheckBoxStates(List<JCheckBoxMenuItem> checkBoxMenuItems) {
        int selectedCount = 0;
        JMenuItem firstSelected = null;
        for (JCheckBoxMenuItem item : checkBoxMenuItems) {
            if (!item.isSelected()) continue;
            ++selectedCount;
            if (firstSelected != null) continue;
            firstSelected = item;
        }
        if (selectedCount == 1) {
            firstSelected.setEnabled(false);
        } else {
            for (JCheckBoxMenuItem item : checkBoxMenuItems) {
                item.setEnabled(true);
            }
        }
    }
}

