/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.time.LocalDate;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.license.License;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.actions.UnlockAction;
import org.tinymediamanager.ui.components.FlatButton;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.images.Logo;

public class AboutDialog
extends TmmDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(AboutDialog.class);

    public AboutDialog() {
        super(TmmResourceBundle.getString("tmm.about"), "aboutDialog");
        LocalDate validUntil = License.getInstance().validUntil();
        JPanel contentPanel = new JPanel();
        this.getContentPane().add((Component)contentPanel, "Center");
        contentPanel.setLayout((LayoutManager)new MigLayout("", "[][20lp:n][300lp,grow]", "[][10lp:n][][20lp:n][][][][10lp:n][][10lp:n][][][][][]"));
        JLabel lblLogo = new JLabel("");
        lblLogo.setIcon(new Logo(96));
        contentPanel.add((Component)lblLogo, "cell 0 0 1 8,alignx left,aligny top");
        JLabel lblTinymediamanager = new JLabel("tinyMediaManager");
        TmmFontHelper.changeFont(lblTinymediamanager, 1.5, 1);
        contentPanel.add((Component)lblTinymediamanager, "cell 2 0,alignx center");
        JLabel lblByManuel = new JLabel("\u00a9 2012 - 2024 by Manuel Laggner");
        contentPanel.add((Component)lblByManuel, "cell 2 2,alignx center");
        String version = TmmResourceBundle.getString("tmm.version") + ": " + ReleaseInfo.getRealVersion();
        if (validUntil != null) {
            version = version + " / " + License.getInstance().ref();
        }
        JLabel lblVersion = new JLabel(version);
        contentPanel.add((Component)lblVersion, "cell 2 4");
        JLabel lblBuild = new JLabel(TmmResourceBundle.getString("tmm.builddate") + ": " + ReleaseInfo.getRealBuildDate());
        contentPanel.add((Component)lblBuild, "cell 2 5");
        JLabel lblLicense = new JLabel("");
        TmmFontHelper.changeFont((JComponent)lblLicense, 1);
        contentPanel.add((Component)lblLicense, "cell 2 6");
        if (validUntil != null) {
            lblLicense.setText(TmmResourceBundle.getString("tmm.license.validuntil") + ": " + TmmDateFormat.MEDIUM_DATE_FORMAT.format(Date.valueOf(validUntil)));
            FlatButton btnLicenseInfo = new FlatButton("");
            btnLicenseInfo.setAction(new UnlockAction());
            btnLicenseInfo.setText(null);
            btnLicenseInfo.setIcon(IconManager.INFO);
            btnLicenseInfo.setToolTipText(TmmResourceBundle.getString("tmm.license.view"));
            contentPanel.add((Component)btnLicenseInfo, "cell 2 6");
        } else {
            lblLicense.setText(TmmResourceBundle.getString("tmm.license.unregistered"));
        }
        JLabel lblHomepage = new TmmLabel(TmmResourceBundle.getString("tmm.homepage"));
        contentPanel.add((Component)lblHomepage, "cell 0 8,alignx right");
        lblHomepage = new LinkLabel("https://www.tinymediamanager.org/");
        ((LinkLabel)lblHomepage).addActionListener(arg_0 -> AboutDialog.lambda$new$0((LinkLabel)lblHomepage, arg_0));
        contentPanel.add((Component)lblHomepage, "cell 2 8");
        TmmLabel lblThanksTo = new TmmLabel(TmmResourceBundle.getString("tmm.thanksto"));
        contentPanel.add((Component)lblThanksTo, "cell 0 10,alignx right");
        JLabel lblMyronForHelping = new JLabel("Myron for helping me with coding, scrapers, localization, setup, everything...");
        contentPanel.add((Component)lblMyronForHelping, "cell 2 10");
        JLabel lblJoostzilla = new JLabel("Joostzilla for the UI design");
        contentPanel.add((Component)lblJoostzilla, "cell 2 11");
        JLabel lblTranslators = new JLabel("All our translators");
        contentPanel.add((Component)lblTranslators, "cell 2 12");
        JLabel lblLibs = new JLabel("The creators of all libs we've used");
        contentPanel.add((Component)lblLibs, "cell 2 13");
        JLabel lblTester = new JLabel("Everyone who tested and provided feedback");
        contentPanel.add((Component)lblTester, "cell 2 14");
        JButton okButton = new JButton();
        CloseAction action = new CloseAction();
        okButton.setAction(action);
        this.addDefaultButton(okButton);
    }

    private static /* synthetic */ void lambda$new$0(LinkLabel lblHomepage, ActionEvent arg0) {
        try {
            TmmUIHelper.browseUrl(lblHomepage.getText());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)lblHomepage.getText(), "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
        }
    }

    private class CloseAction
    extends AbstractAction {
        CloseAction() {
            this.putValue("Name", TmmResourceBundle.getString("Button.close"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
            this.putValue("SwingLargeIconKey", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AboutDialog.this.setVisible(false);
        }
    }
}

